/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test;

import com.ftinc.si.assist.run.FakeEditorOnRun;
import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.run.TestCommander;
import com.ftinc.si.assist.run.VCentral;
import com.ftinc.si.assist.test.AnyConstructor;
import com.ftinc.si.assist.test.AssertRecord;
import com.ftinc.si.assist.test.ClassOutLine;
import com.ftinc.si.assist.test.CodeProcessor;
import com.ftinc.si.assist.test.DBService;
import com.ftinc.si.assist.test.FakeMethodRecord;
import com.ftinc.si.assist.test.Fson;
import com.ftinc.si.assist.test.Inspector;
import com.ftinc.si.assist.test.JSONRecord;
import com.ftinc.si.assist.test.ObjectRecord;
import com.ftinc.si.assist.test.TestCaseRecord;
import com.ftinc.si.assist.test.TestCommandRecord;
import com.ftinc.si.assist.test.TestLogger;
import com.ftinc.si.assist.test.gui.AssertStatusWindow;
import com.ftinc.si.assist.test.gui.EnvironmentData;
import com.ftinc.si.assist.test.gui.EnvironmentDialog;
import com.ftinc.si.assist.test.gui.Plugin;
import com.ftinc.si.assist.test.gui.plugins.CodeFairyPlugin;
import com.ftinc.si.assist.test.gui.plugins.DefaultPlugin;
import com.ftinc.si.assist.test.gui.plugins.DictionaryPlugin;
import com.ftinc.si.assist.test.gui.plugins.SnapshotPlugin;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Tool {
    public static HashMap<String, Object> instance_table;
    public static String fake_dir;
    private static volatile ClassPool c_pool;
    private static volatile DBService s_db;
    private static boolean editmode;
    public static boolean debug_mode;
    public static String curCase;
    public static int curID;
    private static String connect_str;
    private static String password;
    private static String user;
    public static String charset;
    public static String group_code;
    public static String version;
    private static AssertStatusWindow s_statuswin;
    public static boolean process_mode;
    public static boolean child_mode;
    private static volatile PrintStream log_stream;
    public static String logFolder;
    private static String logStack;
    private static PrintStream s_out;
    public static ArrayList<String> target_dirs;
    public static volatile ArrayList<Plugin> plugins;
    private static EnvironmentData cur_env;
    private static HashMap<String, String> aliasNames;
    private static TestCommander cur_commander;
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    private static URLClassLoader s_loader;
    public static String s_jarname;
    public static String s_userdir;
    private static String s_prevPath;
    private static Pattern s_globalpat1;
    private static Pattern s_globalpat2;

    static {
        s_db = null;
        editmode = true;
        debug_mode = false;
        connect_str = null;
        group_code = "";
        version = "";
        s_statuswin = null;
        process_mode = false;
        child_mode = false;
        log_stream = null;
        logFolder = null;
        logStack = null;
        s_out = null;
        target_dirs = null;
        plugins = null;
        cur_env = null;
        s_loader = null;
        s_jarname = null;
        s_userdir = null;
        s_prevPath = "";
        s_globalpat1 = Pattern.compile("//\\?\\s*\"?([^\"\\s]+?)\"?\\s*:\\s*([^\n]+)");
        s_globalpat2 = Pattern.compile("//\\?\\s*(\\w+?)\\s+\"?([^\"]+?)\"?\\s*:\\s*([^\n]+)");
    }

    public static void init(boolean b) {
        instance_table = new HashMap();
        editmode = b;
        try {
            s_out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            s_out = new PrintStream(System.out);
        }
        String str_resource = Tool.class.getPackage().getName().replace('.', '/');
        URL t_url = Tool.class.getClassLoader().getResource(str_resource);
        String str_path = t_url.getPath();
        Pattern t_pat = Pattern.compile("file:/+(.*?)/([^/]+)\\.jar!/.*$");
        Matcher t_m = t_pat.matcher(str_path);
        if (t_m.find()) {
            s_jarname = t_m.group(2);
            s_userdir = t_m.group(1).replace('/', '\\');
            s_userdir = Tool.replaceB(s_userdir, "%20", " ");
        } else {
            s_jarname = Messages.getString("Tool.53");
            s_userdir = System.getProperty("user.dir");
            File jfolder = new File(s_userdir);
            File[] f_list = jfolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    Pattern t_pat = Pattern.compile("^(" + Pattern.quote(s_jarname) + ".*)\\.jar");
                    Matcher t_m = t_pat.matcher(name);
                    return t_m.find();
                }
            });
            if (f_list != null && f_list.length > 0) {
                s_jarname = Tool.replaceB(f_list[0].getName(), ".jar", "");
            }
        }
    }

    private static String _libdir() {
        return String.valueOf(s_userdir) + "\\" + s_jarname + "_lib";
    }

    public static boolean editMode() {
        return editmode;
    }

    public static void setEditMode(boolean b) {
        editmode = b;
    }

    public static void setCurID(String caseName, int id) {
        curCase = caseName;
        curID = id;
    }

    public static void clearCase() {
        if (instance_table != null) {
            instance_table.clear();
        }
        VCentral.clear();
    }

    public static void destroy() {
        Tool.logIfDebug(null, "<ftmsg msg=\"deconstructing\"/>");
        Tool.clearCase();
        if (s_statuswin != null) {
            s_statuswin.setVisible(false);
            s_statuswin = null;
        }
        if (log_stream != null) {
            log_stream.append("</xml>");
            log_stream.flush();
            log_stream.close();
            log_stream = null;
        }
        if (s_db != null) {
            s_db.destroy();
            s_db = null;
        }
        if (plugins != null) {
            int i = 0;
            while (i < plugins.size()) {
                plugins.get(i).destroy();
                ++i;
            }
            plugins.clear();
            plugins = null;
        }
    }

    public static void curCommander(TestCommander tester) {
        cur_commander = tester;
    }

    public static DBService _db() {
        return s_db;
    }

    public static File _libfile(String fpath) {
        if (fpath == null) {
            return null;
        }
        File t_file = null;
        if (fpath.startsWith("$LIBDIR")) {
            String t_path;
            String t_path0 = t_path = Tool.replaceB(fpath, "$LIBDIR", Tool._libdir());
            final String fname = t_path.replaceFirst("^(.*)\\\\([^\\\\]+)$", "$2");
            String dirname = t_path.replaceFirst("^(.*)\\\\([^\\\\]+)$", "$1");
            File t_dir = new File(dirname);
            File[] t_files = t_dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String t_reg = fname;
                    t_reg = Tool.replaceB(t_reg, ".", "\\.");
                    return name.matches("^" + (t_reg = Tool.replaceB(t_reg, "*", ".*")) + "$");
                }
            });
            if (t_files != null && t_files.length == 0) {
                t_path = Tool.replaceB(fpath, "$LIBDIR", String.valueOf(s_userdir) + "\\_LIB");
                final String fname2 = t_path.replaceFirst("^(.*)\\\\([^\\\\]+)$", "$2");
                dirname = t_path.replaceFirst("^(.*)\\\\([^\\\\]+)$", "$1");
                t_dir = new File(dirname);
                t_files = t_dir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        String t_reg = fname2;
                        t_reg = Tool.replaceB(t_reg, ".", "\\.");
                        return name.matches("^" + (t_reg = Tool.replaceB(t_reg, "*", ".*")) + "$");
                    }
                });
            }
            if (t_files != null && t_files.length > 0) {
                t_file = t_files[0];
            } else {
                Tool.logIfDebug(null, String.valueOf(fpath) + Messages.getString("Tool.77"));
            }
            if (t_file == null && t_path0.indexOf("*") < 0) {
                t_file = new File(t_path0);
            }
        } else {
            t_file = new File(fpath);
        }
        return t_file;
    }

    public static EnvironmentData readEnvironment() {
        File t_env;
        if (s_userdir == null) {
            Tool.init(false);
        }
        if ((t_env = Tool._libfile("$LIBDIR\\tclenv*.json")) != null && t_env.exists()) {
            try {
                String t_line;
                FileReader t_r = new FileReader(t_env);
                String t_json = "";
                BufferedReader t_buf = new BufferedReader(t_r);
                while ((t_line = t_buf.readLine()) != null) {
                    t_json = String.valueOf(t_json) + t_line;
                }
                t_buf.close();
                t_r.close();
                if (t_json != null && t_json.length() > 0) {
                    cur_env = (EnvironmentData)Tool.getObjectfromJSON(EnvironmentData.class, t_json);
                }
            }
            catch (IOException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        } else {
            Tool.alertMSG(null, "$LIBDIR\\tclenv*.json not found.>>$LIBDIR=" + Tool._libdir());
            cur_env = new EnvironmentData();
        }
        Tool.setEnvironment(cur_env);
        return cur_env;
    }

    public static synchronized void setEnvironment(EnvironmentData env) {
        cur_env = env;
        if (env == null) {
            return;
        }
        process_mode = env.process_mode;
        group_code = env.groupCode;
        aliasNames = env.aliasNames;
        version = env.version;
        debug_mode = env.debug_mode;
        Tool.logIfDebug(null, "<ftmsg msg=\"starting setEnvironment@" + new Date() + "\"/>");
        if (env.logdir != null && env.logdir.length() > 0 && logFolder == null) {
            logFolder = Tool.convert2Alias("path", env.logdir);
            logFolder = logFolder.replaceFirst(String.valueOf(Pattern.quote("\\")) + "$", "");
        } else {
            logFolder = s_userdir;
        }
        connect_str = env.jdbcString();
        user = env.uID;
        password = env.pwd;
        charset = env.encode;
        target_dirs = env.rootDirs;
        fake_dir = env.fakedir;
        Fson.initDefaultParams();
        if (s_loader == null) {
            Tool.logIfDebug(null, "<ftmsg msg=\"setting classloader in setEnvironment\"/>");
            c_pool = ClassPool.getDefault();
            try {
                if (target_dirs != null) {
                    int i = 0;
                    while (i < target_dirs.size()) {
                        c_pool.appendClassPath(target_dirs.get(i));
                        Tool.logIfDebug(null, "<ftmsg msg=\"c_pool to append ClassPath =" + target_dirs.get(i) + " \"/>");
                        ++i;
                    }
                }
                if (fake_dir != null) {
                    c_pool.appendClassPath(fake_dir);
                }
            }
            catch (NotFoundException e) {
                e.printStackTrace();
            }
            try {
                Tool.createClassLoader(target_dirs);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                Tool.logIfDebug(e1, Messages.getString("Tool.0"));
                return;
            }
        }
        s_prevPath = env.prevPath;
        Tool.logIfDebug(null, "<ftmsg msg=\"setting database connection in setEnvironment\"/>");
        if (s_db == null) {
            s_db = new DBService(env.remote_db, false);
            if (!s_db.init(connect_str, user, password)) {
                s_db = null;
                return;
            }
        } else if (cur_env != null && cur_env.shouldReconnectDB(env)) {
            if (s_db != null) {
                s_db.destroy();
            }
            if (!(s_db = new DBService(env.remote_db, false)).init(connect_str, user, password)) {
                s_db = null;
                return;
            }
        }
        TestCaseRecord.s_unitSize = env.caseSize;
        Tool.logIfDebug(null, "<ftmsg msg=\"setting plugins in setEnvironment\"/>");
        plugins = new ArrayList();
        try {
            plugins.add((Plugin)Tool.newObject(DefaultPlugin.class, null, null));
            plugins.add((Plugin)Tool.newObject(CodeFairyPlugin.class, null, null));
            plugins.add((Plugin)Tool.newObject(DictionaryPlugin.class, null, null));
            plugins.add((Plugin)Tool.newObject(SnapshotPlugin.class, null, null));
            int j = 0;
            while (j < env.plugins.size()) {
                String c_name = env.plugins.get(j);
                Class<?> t_c = Tool.forName(c_name);
                Plugin t_plugin = (Plugin)Tool.newObject(t_c, null, null);
                plugins.add(t_plugin);
                if (env.plugins_properties != null && env.plugins_properties.containsKey(c_name)) {
                    t_plugin.initProperties(env.plugins_properties.get(c_name));
                }
                ++j;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
            Tool.logIfDebug(e1, Messages.getString("Tool.3"));
            return;
        }
    }

    public static void saveEnvironment(EnvironmentData env) {
        Tool.logIfDebug(null, "<ftmsg msg=\"saving Environment.\"/>");
        if (env != null) {
            env.prevPath = Tool.getPrevPath();
            String envJSON = Tool.getJSONfromObject(env);
            if (envJSON == null) {
                Tool.alertMSG(null, "<ftmsg msg=\"Failed to save environment settings.\"/>");
                Tool.destroy();
                return;
            }
            File t_env = new File(String.valueOf(Tool._libdir()) + "\\tclenv.json");
            if (envJSON != null) {
                try {
                    if (!t_env.exists()) {
                        t_env.createNewFile();
                    }
                }
                catch (IOException e1) {
                    Tool.alertMSG(null, e1.getMessage());
                }
                try {
                    FileWriter t_w = new FileWriter(t_env);
                    t_w.write(envJSON);
                    t_w.close();
                }
                catch (IOException e1) {
                    Tool.alertMSG(null, e1.getMessage());
                }
            }
        }
    }

    public static EnvironmentData openEnvironmentDialog(JFrame frame, EnvironmentData env) {
        EnvironmentDialog t_d = new EnvironmentDialog(frame, env);
        t_d.setVisible(true);
        if (t_d.is_ok) {
            EnvironmentData t_data = t_d.getEnvData();
            Tool.setEnvironment(t_data);
            return t_data;
        }
        return null;
    }

    public static String getPackageVersion(Class<?> c) {
        Package pkg = c.getPackage();
        return pkg.getSpecificationVersion();
    }

    private static void createClassLoader(ArrayList<String> alist) throws SecurityException, NoSuchMethodException, ClassNotFoundException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        URLClassLoader t_loader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Method add_method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        add_method.setAccessible(true);
        try {
            int i = 0;
            while (i < alist.size()) {
                add_method.invoke((Object)t_loader, new File(alist.get(i)).toURI().toURL());
                ++i;
            }
            if (fake_dir != null) {
                String t_dir = fake_dir;
                add_method.invoke((Object)t_loader, new File(t_dir).toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            Tool.alertMSG(null, String.valueOf(e.getMessage()) + Messages.getString("Tool.4"));
        }
        s_loader = t_loader;
    }

    public static Class<?> forName(String cname) throws ClassNotFoundException {
        if ("int".equals(cname)) {
            return Integer.TYPE;
        }
        if ("long".equals(cname)) {
            return Long.TYPE;
        }
        if ("float".equals(cname)) {
            return Float.TYPE;
        }
        if ("double".equals(cname)) {
            return Double.TYPE;
        }
        if ("boolean".equals(cname)) {
            return Boolean.TYPE;
        }
        if ("byte".equals(cname)) {
            return Byte.TYPE;
        }
        if ("char".equals(cname)) {
            return Character.TYPE;
        }
        if ("int[]".equals(cname)) {
            return int[].class;
        }
        if ("float[]".equals(cname)) {
            return float[].class;
        }
        if ("double[]".equals(cname)) {
            return double[].class;
        }
        if ("boolean[]".equals(cname)) {
            return boolean[].class;
        }
        if ("byte[]".equals(cname)) {
            return byte[].class;
        }
        if ("char[]".equals(cname)) {
            return char[].class;
        }
        if (cname.endsWith("[]")) {
            cname = cname.replaceFirst(Pattern.quote("[]"), "");
            Class<?> t_comp = Tool.forName(cname);
            Object t_array = Array.newInstance(t_comp, 0);
            return t_array.getClass();
        }
        try {
            if (s_loader != null) {
                return s_loader.loadClass(cname);
            }
            return Class.forName(cname);
        }
        catch (Error | Exception e) {
            throw new ClassNotFoundException(String.valueOf(Messages.getString("Tool.5")) + cname + " Error=" + e.getClass().getName());
        }
    }

    public static boolean hasDefaultConstructor(String c, boolean bAttr) {
        CtClass tc = null;
        try {
            if (c_pool == null) {
                c_pool = ClassPool.getDefault();
                Fson.initDefaultParams();
            }
            tc = c_pool.get(c);
        }
        catch (NotFoundException e) {
            Tool.alertMSG(null, String.valueOf(Messages.getString("Tool.6")) + e.getMessage());
        }
        if (tc != null) {
            return Tool.hasDefaultConstructor(tc, bAttr);
        }
        return false;
    }

    public static boolean hasDefaultConstructor(CtClass c, boolean bAttr) {
        if (Tool.isPrimitive2(c)) {
            return true;
        }
        if (Fson.s_defaultParams.get(c.getName()) != null) {
            return true;
        }
        if (Tool.hasDefaultConstructor(c)) {
            return true;
        }
        CtConstructor[] clist = c.getConstructors();
        if (!bAttr) {
            int i = 0;
            while (i < clist.length) {
                try {
                    if (clist[i].getParameterTypes().length == 0) {
                        return true;
                    }
                }
                catch (NotFoundException e1) {
                    Tool.alertMSG(null, String.valueOf(Messages.getString("Tool.7")) + e1.getMessage());
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean hasDefaultConstructor(CtClass c) {
        CtConstructor t_cons = null;
        try {
            t_cons = c.getConstructor("()V");
        }
        catch (NotFoundException e) {
            return false;
        }
        return t_cons != null;
    }

    public static Object tryDefaultConstructor(Class<?> c) {
        try {
            return c.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?> toClass(CtClass tc) throws CannotCompileException {
        return tc.toClass((ClassLoader)s_loader, Tool.class.getProtectionDomain());
    }

    public static Object newObject(Class<?> c, Class<?>[] ac, Object[] as) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> t_con = null;
        try {
            t_con = c.getConstructor(ac);
        }
        catch (NoSuchMethodException e) {
            if (ac == null || ac.length == 0) {
                try {
                    t_con = c.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException e1) {
                    try {
                        return c.newInstance();
                    }
                    catch (Exception e2) {
                        Tool.alertMSG(null, String.valueOf(Messages.getString("Tool.8")) + c.getName() + "=newInstance() msg =" + e2.getMessage() + " @Tool#newObject.");
                        throw new InstantiationException(String.valueOf(Messages.getString("Tool.10")) + c.getName());
                    }
                    catch (Error e2) {
                        Tool.alertMSG(null, String.valueOf(Messages.getString("Tool.11")) + c.getName() + "=newInstance() msg =" + e2.getMessage() + " @Tool#newObject.");
                        throw new InstantiationException(String.valueOf(Messages.getString("Tool.12")) + c.getName());
                    }
                }
            }
            Tool.alertMSG(null, String.valueOf(Messages.getString("Tool.13")) + c.getName() + "#getConstrutor(Class{}) msg =" + e.getMessage() + " @Tool#newObject.");
            throw e;
        }
        t_con.setAccessible(true);
        try {
            return t_con.newInstance(as);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            Throwable ecause = e.getCause();
            String t_msg = String.valueOf(Messages.getString("Tool.14")) + c.getName() + "\n";
            t_msg = String.valueOf(t_msg) + ">>Throwable=" + ecause.getClass().getName() + "\n";
            t_msg = String.valueOf(t_msg) + ">>msg=" + ecause.getMessage();
            Tool.alertMSG(null, String.valueOf(t_msg) + " @Tool#newObject.");
            if (ecause instanceof Error) {
                throw (Error)ecause;
            }
            if (ecause instanceof RuntimeException) {
                throw (RuntimeException)ecause;
            }
            throw new RuntimeException(ecause);
        }
        catch (Error e) {
            Tool.alertMSG(null, String.valueOf(Messages.getString("Tool.15")) + c.getName() + "\n>>msg =" + e.getMessage() + " @Tool#newObject.");
            throw new InstantiationException(String.valueOf(Messages.getString("Tool.16")) + c.getName() + " @Tool#newObject.");
        }
    }

    public static Object getTObject(int testID, String stack) throws SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException, CannotCompileException, IOException, NotFoundException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException, ParseException, Fson.NotSupportedClassException {
        if (stack == null || stack.equals("null")) {
            return null;
        }
        Object t_obj = null;
        ObjectRecord t_arg = null;
        ObjectRecord tempOR = new ObjectRecord(0);
        tempOR.testID = testID;
        tempOR.stack = stack;
        tempOR.id = String.valueOf(Integer.toString(testID)) + stack;
        tempOR.testCase = curCase;
        if (instance_table.containsKey(stack)) {
            t_obj = instance_table.get(stack);
            t_arg = s_db.getObjectRecord(tempOR);
            if (t_arg != null && t_arg.jSON != null && t_arg.jSON.length() > 0 && t_arg.isPOJO) {
                if (Tool.isPrimitive2(t_obj.getClass())) {
                    t_obj = Fson.fromJson(t_arg.jSON, t_obj.getClass());
                } else {
                    Fson.updateFromJson(t_obj, t_arg.jSON);
                }
            }
            if (t_arg != null && t_arg.jSON != null && t_arg.jSON.length() > 0) {
                HashMap<String, Object> _map = Tool.getCommentMapFromJson(true, t_arg.jSON);
                if (_map != null && _map.size() > 0) {
                    VCentral.prepare(_map);
                }
                HashMap<String, Object> _map2 = Tool.getCommentMapFromJson(false, t_arg.jSON);
                for (Map.Entry<String, Object> entry : _map2.entrySet()) {
                    Fson.updateByJsonPath(t_obj, entry.getKey(), entry.getValue().toString());
                }
            }
        } else {
            t_obj = Tool.getTObjectFromObjectRecord(tempOR);
        }
        return t_obj;
    }

    private static Object getTObjectFromObjectRecord(ObjectRecord tempOR) throws SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException, CannotCompileException, IOException, NotFoundException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException, ParseException, Fson.NotSupportedClassException {
        ObjectRecord t_arg = s_db.getObjectRecord(tempOR);
        Object t_obj = null;
        if (t_arg != null) {
            t_obj = Tool.deserializeObject(t_arg);
            Tool.addInstance(tempOR.id, t_obj);
        }
        if (t_arg != null && t_arg.jSON != null && t_arg.jSON.length() > 0) {
            HashMap<String, Object> _map = Tool.getCommentMapFromJson(true, t_arg.jSON);
            if (_map != null && _map.size() > 0) {
                VCentral.prepare(_map);
            }
            HashMap<String, Object> _map2 = Tool.getCommentMapFromJson(false, t_arg.jSON);
            for (Map.Entry<String, Object> entry : _map2.entrySet()) {
                Fson.updateByJsonPath(t_obj, entry.getKey(), entry.getValue().toString());
            }
        }
        return t_obj;
    }

    private static Object deserializeObject(ObjectRecord rec) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchFieldException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException, CannotCompileException, IOException, NotFoundException, ClassNotFoundException, ParseException, Fson.NotSupportedClassException {
        Object f_obj = null;
        String c_name = rec.className;
        String f_name = null;
        if (!rec.isPOJO) {
            File t_dir = new File(fake_dir);
            if (!t_dir.exists()) {
                Tool.alertAndExit(Messages.getString("Tool.17"), null, rec.testID);
                return null;
            }
            f_obj = instance_table.get(c_name);
            if (f_obj == null) {
                f_name = "test.fake." + c_name;
                try {
                    Class<?> t_c = Tool.forName(f_name);
                    f_obj = Tool.newObject(t_c, new Class[0], new Object[0]);
                }
                catch (ClassNotFoundException e) {
                    f_obj = Tool.createNewFakeClass(rec, true);
                }
                Fson.updateByJsonPath(f_obj, "$", rec.jSON);
                instance_table.put(c_name, f_obj);
            }
        } else if (rec.stack.endsWith(")")) {
            String t_key;
            Object t_obj;
            Pattern t_pat = Pattern.compile("([0-9]+\\$[_0-9])\\.(\\w+)\\(([\\w\\.,\\[\\]]*)\\)");
            Matcher t_m = t_pat.matcher(rec.stack);
            if (!t_m.find() && (t_obj = Tool.getInstance(t_key = t_m.group(1))) != null) {
                try {
                    Fson.setParameters(Fson.getFieldMapOfJson(rec.jSON));
                }
                catch (ClassNotFoundException e) {
                    Tool.alertAndExit(String.valueOf(Messages.getString("Tool.18")) + t_m.group(2) + Messages.getString("Tool.19") + rec.className + ".", null, rec.testID);
                }
                Class<?> t_cl = t_obj.getClass();
                Method t_md = t_cl.getMethod(t_m.group(2), Fson._c_list);
                if (t_md != null) {
                    f_obj = t_md.invoke(t_obj, Fson._o_list);
                }
            }
        } else {
            try {
                Class<?> t_cl = "java.lang.Class".equals(rec.className) ? null : Tool.forName(Tool.primitiveToFQN(rec.className));
                f_obj = Tool.getObjectfromJSON(t_cl, Tool.removeCommentFromJson(rec.jSON));
            }
            catch (ClassNotFoundException e) {
                Tool.alertAndExit(String.valueOf(Messages.getString("Tool.20")) + rec.className + ".", null, rec.testID);
                return null;
            }
        }
        return f_obj;
    }

    private static Object createNewFakeClass(ObjectRecord orec, boolean b_newobj) throws CannotCompileException, IOException, NotFoundException, InstantiationException, IllegalAccessException, SecurityException, NoSuchFieldException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        CtClass t_fake = c_pool.makeClass("test.fake." + orec.className);
        CtClass t_impl = c_pool.makeClass("test.impl." + orec.className);
        CtClass t_c = c_pool.get(orec.className);
        t_fake.stopPruning(true);
        t_impl.stopPruning(true);
        if (t_c.isInterface()) {
            t_fake.addInterface(t_c);
            t_impl.addInterface(t_c);
        } else {
            t_fake.setSuperclass(t_c);
            t_impl.setSuperclass(t_c);
        }
        t_fake.addField(CtField.make((String)("private " + t_impl.getName() + " _impl;"), (CtClass)t_fake));
        t_impl.addField(CtField.make((String)"private java.util.HashMap _table;", (CtClass)t_impl));
        HashMap<String, String> _fmap = new HashMap<String, String>();
        String t_msg = Tool.makeSkinOfMethods(t_impl, t_c, false, _fmap);
        if (t_msg != null && t_msg.length() > 0) {
            Tool.alertMSG(null, t_msg);
        }
        CtConstructor i_Con = CtNewConstructor.defaultConstructor((CtClass)t_impl);
        i_Con.setModifiers(1);
        t_impl.addConstructor(i_Con);
        String map_json = Fson.escape(Tool.getJSONfromObject(_fmap));
        String con_src = "_table=new java.util.HashMap();";
        con_src = String.valueOf(con_src) + "com.ftinc.si.assist.test.Fson.updateFromJson(_table,\"" + map_json + "\");";
        i_Con.setBody("{" + con_src + "}");
        CtMethod impl_tostr = null;
        try {
            impl_tostr = t_impl.getMethod("toString", "()Ljava/lang/String;");
            Tool.makeSkinOfMethod(t_impl, impl_tostr, "{return ($r)_table.toString();}", true, null);
        }
        catch (Exception e) {
            Tool.alertMSG(null, String.valueOf(Messages.getString("Tool.21")) + t_impl.getName());
        }
        t_impl.writeFile(fake_dir);
        CtConstructor f_Con = CtNewConstructor.defaultConstructor((CtClass)t_fake);
        f_Con.setModifiers(1);
        t_fake.addConstructor(f_Con);
        String fcon_src = "{_impl= new " + t_impl.getName() + "();}";
        f_Con.setBody(fcon_src);
        t_msg = Tool.makeSkinOfMethods(t_fake, t_c, true, null);
        if (t_msg != null && t_msg.length() > 0) {
            Tool.alertMSG(null, t_msg);
        }
        t_fake.writeFile(fake_dir);
        if (b_newobj) {
            Class<?> f_c = Tool.toClass(t_fake);
            Object f_obj = Tool.newObject(f_c, new Class[0], new Object[0]);
            return f_obj;
        }
        return t_impl;
    }

    private static String makeSkinOfMethods(CtClass declaring, CtClass original, boolean b_fake, HashMap<String, String> map) {
        CtMethod[] t_meths = original.getMethods();
        String t_msg = "";
        String t_msgsrc = "com.ftinc.si.assist.test.Tool#poppedFake();";
        int i = 0;
        while (i < t_meths.length) {
            block8: {
                if (!t_meths[i].getDeclaringClass().getName().equals("java.lang.Object")) {
                    String src = null;
                    try {
                        if (b_fake) {
                            src = Tool._defaultSource(original.getName(), t_meths[i].getName());
                        }
                        CtMethod t_mt = Tool.makeSkinOfMethod(declaring, t_meths[i], src, true, map);
                        if (b_fake) {
                            t_mt.insertAfter(t_msgsrc);
                        }
                    }
                    catch (Exception e) {
                        if (Modifier.isAbstract((int)t_meths[i].getModifiers())) {
                            t_msg = String.valueOf(t_msg) + Messages.getString("Tool.22") + t_meths[i].getName() + " msg=" + e.getMessage() + "\n";
                        }
                        if (Modifier.isFinal((int)t_meths[i].getModifiers())) {
                            t_msg = String.valueOf(t_msg) + Messages.getString("Tool.23") + t_meths[i].getName() + " msg=" + e.getMessage() + "\n";
                        }
                        if (!Modifier.isNative((int)t_meths[i].getModifiers())) break block8;
                        t_msg = String.valueOf(t_msg) + Messages.getString("Tool.24") + t_meths[i].getName() + " msg=" + e.getMessage() + "\n";
                    }
                }
            }
            ++i;
        }
        return t_msg;
    }

    public static CtMethod makeSkinOfMethod(CtClass declaring, CtMethod original, String src, boolean inherited, HashMap<String, String> map) throws CannotCompileException, NotFoundException {
        if (Modifier.isFinal((int)original.getModifiers()) || Modifier.isNative((int)original.getModifiers())) {
            return null;
        }
        CtClass t_super = original.getDeclaringClass();
        if (!inherited && Modifier.isAbstract((int)original.getModifiers())) {
            return null;
        }
        if (inherited && declaring.getClass().getName().equals(t_super.getName())) {
            return null;
        }
        CtMethod t_target = null;
        CtClass[] params = original.getParameterTypes();
        String method_name = original.getName();
        if (inherited) {
            if (!Modifier.isInterface((int)t_super.getModifiers())) {
                CtMethod temp_mt = null;
                try {
                    temp_mt = declaring.getDeclaredMethod(method_name, params);
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
                if (temp_mt == null) {
                    temp_mt = CtNewMethod.copy((CtMethod)original, (String)method_name, (CtClass)declaring, null);
                    declaring.addMethod(temp_mt);
                    if (Modifier.isAbstract((int)temp_mt.getModifiers())) {
                        t_target = temp_mt;
                    } else {
                        temp_mt.setName(String.valueOf(method_name) + "_$");
                    }
                } else {
                    temp_mt.setName(String.valueOf(method_name) + "_$");
                }
            }
        } else {
            original.setName(String.valueOf(method_name) + "_$");
        }
        CtClass r_type = original.getReturnType();
        CtClass[] exps = original.getExceptionTypes();
        if (t_target == null) {
            t_target = CtNewMethod.make((CtClass)r_type, (String)method_name, (CtClass[])params, (CtClass[])exps, null, (CtClass)declaring);
            declaring.addMethod(t_target);
            t_target.setModifiers(original.getModifiers());
        }
        if (src == null || src.length() == 0) {
            HashMap<String, String> t_map = null;
            if (Modifier.isPublic((int)t_target.getModifiers())) {
                t_map = map;
            }
            src = Tool._defaultSource4Abstract(method_name, r_type.getName(), params, t_map);
        }
        if ((src = map != null ? CodeProcessor.preProcessMain(declaring, (CtBehavior)t_target, src) : CodeProcessor.preProcessMain(declaring, (CtBehavior)t_target, src)) != null) {
            t_target.setBody(src);
        } else {
            Tool.alertMSG(null, Messages.getString("Tool.25"));
        }
        return t_target;
    }

    private static String _defaultSource4Abstract(String mname, String rtype, CtClass[] params, HashMap<String, String> map) {
        String t_src = "";
        String fname = Tool.getImplFieldName(mname);
        String ftype = rtype;
        if (map != null && fname != null) {
            if (rtype.equals("void")) {
                if (params.length == 1) {
                    String t_cast0 = "";
                    String t_type = params[0].getName();
                    t_src = "field " + t_type;
                    if (params[0].isPrimitive()) {
                        t_src = t_type = Tool.primitiveToFQN(t_type);
                        t_cast0 = "($w)";
                    }
                    ftype = t_type;
                    if (t_type.endsWith("[]")) {
                        t_src = "field java.lang.Object";
                    }
                    t_src = String.valueOf(t_src) + " " + fname + "=" + t_cast0 + "$1;";
                } else if (params.length == 2) {
                    String t_cast0 = "";
                    if (params[0].isPrimitive()) {
                        t_cast0 = "($w)";
                    }
                    String t_cast1 = "";
                    if (params[1].isPrimitive()) {
                        t_cast1 = "($w)";
                    }
                    ftype = "java.util.HashMap";
                    t_src = "java.util.HashMap _map=(java.util.HashMap)_table.get(\"" + fname + "\");";
                    t_src = String.valueOf(t_src) + "if(_map!=null){_map.put(" + t_cast0 + "$1, " + t_cast1 + "$2);}";
                }
            } else {
                Class<?> r_c = null;
                try {
                    r_c = Tool.forName(rtype);
                }
                catch (ClassNotFoundException t_cast1) {
                    // empty catch block
                }
                if (params.length == 0) {
                    t_src = "field " + rtype;
                    if (r_c.isArray()) {
                        ftype = "java.lang.Object";
                        t_src = "field java.lang.Object " + fname + ";";
                        t_src = String.valueOf(t_src) + "return (" + rtype + ")" + fname + ";";
                    } else if (r_c.isPrimitive()) {
                        ftype = Tool.primitiveToFQN(ftype);
                        t_src = "field " + ftype + " " + fname + ";";
                        t_src = String.valueOf(t_src) + Tool.returnSrc4Primitive(rtype, fname);
                    } else {
                        t_src = String.valueOf(t_src) + " " + fname + ";";
                        t_src = String.valueOf(t_src) + "return (" + rtype + ")" + fname + ";";
                    }
                } else if (params.length == 1) {
                    String t_cast0 = "";
                    if (params[0].isPrimitive()) {
                        t_cast0 = "($w)";
                    }
                    ftype = "java.util.HashMap";
                    t_src = "field java.util.HashMap " + fname + ";";
                    t_src = String.valueOf(t_src) + "if(" + fname + "!=null){" + Tool.returnSrc4Primitive(rtype, String.valueOf(fname) + ".get(" + t_cast0 + "$1)") + "}";
                    t_src = String.valueOf(t_src) + fname + "=new java.util.HashMap();";
                    t_src = String.valueOf(t_src) + "return " + Tool.primitiveDefaultValue(rtype) + ";";
                } else {
                    t_src = "return " + Tool.primitiveDefaultValue(rtype) + ";";
                }
            }
        }
        if (t_src.length() > 2 && fname != null && map != null && !map.containsKey(fname)) {
            map.put(fname, null);
            map.put(String.valueOf(fname) + "_class", ftype);
        }
        return "{" + t_src + "}";
    }

    private static String primitiveDefaultValue(String rtype) {
        String r_val = "null";
        if (rtype.matches("^(int|long|double|float|byte|char)$")) {
            r_val = "(" + rtype + ")-1";
        } else if (rtype.matches("^.*(Integer|Long|DecimalDouble|Float|Byte|Character)$")) {
            r_val = "(" + rtype + ")-1";
        } else if (rtype.matches("^.*(Boolean)$")) {
            r_val = "(" + rtype + ")false";
        } else if (rtype.matches("^.*(boolean|Boolean)$")) {
            r_val = "false";
        }
        return r_val;
    }

    private static String returnSrc4Primitive(String typeName, String fname) {
        if ("int".equals(typeName)) {
            return "return ((java.lang.Integer)(" + fname + ")).intValue();";
        }
        if ("long".equals(typeName)) {
            return "return ((java.lang.Long)(" + fname + ")).longValue();";
        }
        if ("float".equals(typeName)) {
            return "return ((java.lang.Float)(" + fname + ")).floatValue();";
        }
        if ("double".equals(typeName)) {
            return "return ((java.lang.Double)(" + fname + ")).doubleValue();";
        }
        if ("char".equals(typeName)) {
            return "return ((java.lang.Character)(" + fname + ")).charValue();";
        }
        if ("byte".equals(typeName)) {
            return "return ((java.lang.Byte)(" + fname + ")).byteValue();";
        }
        if ("boolean".equals(typeName)) {
            return "return ((java.lang.Boolean)(" + fname + ")).booleanValue();";
        }
        return "return (" + typeName + ")" + fname + ";";
    }

    private static String getImplFieldName(String mname) {
        String t_str;
        Pattern t_pat = Pattern.compile("^[gs]et([A-Z])(.*)$");
        Matcher t_m = t_pat.matcher(mname);
        if (t_m.find()) {
            return "m_" + t_m.group(1).toLowerCase() + t_m.group(2);
        }
        Pattern t_pat2 = Pattern.compile("^(find|lookup|search)(.*)$");
        t_m = t_pat2.matcher(mname);
        if (t_m.find() && (t_str = t_m.group(2)) != null && t_str.length() > 1) {
            return "m_" + t_m.group(2);
        }
        if (mname.equals("set") || mname.equals("lookup") || mname.equals("put") || mname.equals("get") || mname.equals("find")) {
            return "m_data";
        }
        return "m_" + mname;
    }

    private static String _defaultSource(String cname, String MethodName) {
        String s_delegate = "{";
        s_delegate = String.valueOf(s_delegate) + "com.ftinc.si.assist.test.Tool#pushedFake(\"" + cname + "\",\"" + MethodName + "\", $type, _impl, $args);";
        s_delegate = String.valueOf(s_delegate) + "return _impl." + MethodName + "($$);";
        s_delegate = String.valueOf(s_delegate) + "}";
        return s_delegate;
    }

    public static void addFieldObj(Object impl, String fname, Object o) {
        Class<?> c_obj = impl.getClass();
        try {
            Field t_f = Tool.getField(c_obj, "_table");
            t_f.setAccessible(true);
            HashMap t_h = (HashMap)t_f.get(impl);
            t_h.put(fname, o);
        }
        catch (SecurityException e) {
            Tool.alertMSG(null, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            Tool.alertMSG(null, e.getMessage());
        }
        catch (IllegalAccessException e) {
            Tool.alertMSG(null, e.getMessage());
        }
    }

    public static void pushedFake(String cname, String mname, Class<?> vtype, Object subj, Object[] objs) {
        String e_msg;
        int testId;
        String t_mstr;
        block23: {
            t_mstr = String.valueOf(cname) + "#" + mname + "(" + Tool.getJSONfromObject(objs) + ")";
            if (subj != null && subj.getClass().getName().startsWith("test.")) {
                Tool.cur_commander.m_fakeStack.add(t_mstr);
                Tool.cur_commander.m_lastCallofFake = t_mstr;
            }
            testId = curID;
            if ((curCase == null || curCase.length() == 0) && mname.equals("toString")) {
                return;
            }
            e_msg = "";
            CtClass t_impl = null;
            int phase = 0;
            String src = "";
            try {
                CtMethod t_mt;
                FakeMethodRecord t_fake;
                block22: {
                    t_impl = subj != null ? c_pool.get(subj.getClass().getName()) : c_pool.get(cname);
                    t_impl.defrost();
                    t_fake = Tool._db().getMethodSource(cname, mname, Tool.convClassNameList(objs), version);
                    if (t_fake == null) {
                        t_fake = new FakeMethodRecord(2);
                        t_fake.className = cname;
                        t_fake.methodName = mname;
                        t_fake.superName = t_impl.getSuperclass().getName();
                        t_fake.argTypes = Tool.convClassNameList(objs);
                        t_fake.source = Tool._defaultSource4Abstract(mname, vtype.getName(), Tool.getCtParams(t_fake.argTypes), null);
                    }
                    t_mt = null;
                    try {
                        if (!editmode) {
                            return;
                        }
                        t_mt = t_impl.getDeclaredMethod(mname, Tool.getCtParams(t_fake.argTypes));
                    }
                    catch (NotFoundException e1) {
                        if (editmode) break block22;
                        Tool.alertAndExit(String.valueOf(cname) + "#" + mname + Messages.getString("Tool.26"), null, testId);
                        return;
                    }
                }
                if (t_mt == null) {
                    return;
                }
                Exception t_exp = new Exception();
                FakeEditorOnRun t_dlg = new FakeEditorOnRun(t_fake, vtype, subj, objs, t_exp, Tool.readAnnotationFromMethod(t_mt, "updated"));
                t_dlg.setDefaultCloseOperation(2);
                t_dlg.setBounds(50, 100, 300, 100);
                t_dlg.setVisible(true);
                if (t_dlg.isExiting) {
                    Tool.alertAndStop(Messages.getString("Tool.27"));
                    break block23;
                }
                if (t_dlg.changed()) {
                    s_db.updateRecordBySQL(t_fake.getUpdateSQL(), true);
                    CtClass t_sup = t_impl.getSuperclass();
                    CtClass t_newsup = c_pool.get(t_dlg.getSuperClassName());
                    if (!t_newsup.isInterface() && !t_sup.getName().equals(t_dlg.getSuperClassName())) {
                        t_impl.setSuperclass(t_newsup);
                    }
                    if ((src = CodeProcessor.preProcessMain(t_impl, (CtBehavior)t_mt, t_dlg.getSource())) == null) {
                        Tool.alertMSG(null, String.valueOf(cname) + "#" + mname + Messages.getString("Tool.28") + t_dlg.getSource());
                        Tool.destroy();
                        System.exit(1000 + testId);
                    } else {
                        phase = 200;
                        t_mt.setBody(src);
                        ++phase;
                        SimpleDateFormat t_fmt = new SimpleDateFormat("yyyy/MM/dd (hh:mm:ss)");
                        Tool.writeAnnotationToMethod(t_mt, "updated", t_fmt.format(new Date()));
                        ++phase;
                        t_impl.writeFile(fake_dir);
                        ++phase;
                    }
                    Tool.alertMSG(null, String.valueOf(Messages.getString("Tool.29")) + t_mstr + Messages.getString("Tool.30"));
                    Tool.destroy();
                    System.exit(999);
                    break block23;
                }
                t_mt = t_impl.getDeclaredMethod(mname, Tool.getCtParams(t_fake.argTypes));
                if (t_mt == null) {
                    Tool.alertAndStop(String.valueOf(mname) + Messages.getString("Tool.31"));
                    break block23;
                }
                if (t_dlg.beSkipped) {
                    return;
                }
                Tool.alertMSG(null, String.valueOf(cname) + "#" + mname + Messages.getString("Tool.32"));
                return;
            }
            catch (IOException | SQLException | CannotCompileException | NotFoundException e) {
                if (e.getMessage() != null) {
                    e_msg = String.valueOf(e_msg) + e.getMessage() + "\n";
                }
            }
            catch (Exception e) {
                if (phase >= 200 && phase < 300) {
                    if (phase == 200) {
                        e_msg = String.valueOf(Messages.getString("Tool.33")) + src + "\n";
                        e_msg = String.valueOf(e_msg) + "obj = " + Tool.getJSONfromObject(subj) + "\n";
                    }
                } else if (e.getClass().getSimpleName().equals("RejectedExecutionException")) {
                    throw (RejectedExecutionException)e;
                }
                if (e_msg.length() != 0 || phase >= 200) break block23;
                e_msg = Messages.getString("Tool.34");
            }
        }
        Tool.alertAndExit(String.valueOf(t_mstr) + " msg =" + e_msg, null, testId);
    }

    public static void poppedFake() {
        int n;
        if (editmode && (n = Tool.cur_commander.m_fakeStack.size()) > 0) {
            Tool.cur_commander.m_fakeStack.remove(n - 1);
        }
    }

    public static String readAnnotationFromMethod(CtMethod ctm, String attrName) {
        MethodInfo t_minfo;
        AnnotationsAttribute t_attr;
        CtClass t_c = ctm.getDeclaringClass();
        if (t_c.isFrozen()) {
            t_c.defrost();
        }
        if ((t_attr = (AnnotationsAttribute)(t_minfo = ctm.getMethodInfo()).getAttribute("RuntimeVisibleAnnotations")) == null) {
            return "";
        }
        Annotation t_an = t_attr.getAnnotation("Updated");
        String t_res = null;
        if (t_an != null && attrName != null) {
            t_res = ((StringMemberValue)t_an.getMemberValue(attrName)).getValue();
        }
        if (t_res == null) {
            t_res = "";
        }
        return t_res;
    }

    private static void writeAnnotationToMethod(CtMethod ctm, String attrName, String info) {
        ClassFile t_cfile = ctm.getDeclaringClass().getClassFile();
        ConstPool t_constp = t_cfile.getConstPool();
        AnnotationsAttribute t_aa = new AnnotationsAttribute(t_constp, "RuntimeVisibleAnnotations");
        Annotation t_ant = new Annotation("Updated", t_constp);
        t_ant.addMemberValue(attrName, (MemberValue)new StringMemberValue(info, t_constp));
        t_aa.setAnnotation(t_ant);
        ctm.getMethodInfo().addAttribute((AttributeInfo)t_aa);
    }

    public static Class<?>[] getArgClasses(TestCommandRecord cmd) {
        int len = cmd.numArgs();
        int pos = cmd.varArgsPos();
        ArrayList t_list = new ArrayList();
        if (pos >= 0) {
            String vcname = cmd.getArgClass(pos);
            try {
                Class<?> compClass = Tool.forName(vcname);
                Object t_arry = Array.newInstance(compClass, 0);
                t_list.add(t_arry.getClass());
            }
            catch (ClassNotFoundException e) {
                Tool.alertMSG(null, e.getMessage());
            }
        } else {
            pos = len;
        }
        int i = pos - 1;
        while (i >= 0) {
            try {
                String t_str = cmd.getArgClass(i);
                t_list.add(0, Tool.forName(t_str));
            }
            catch (ClassNotFoundException e1) {
                Tool.alertMSG(null, e1.getMessage());
            }
            --i;
        }
        return t_list.toArray(new Class[t_list.size()]);
    }

    public static CtClass[] getCtParams(String[] atypes) {
        ArrayList<CtClass> t_list = new ArrayList<CtClass>();
        int i = 0;
        while (i < atypes.length) {
            try {
                String t_str = atypes[i];
                if (t_str.matches("^.*\\s+[0-9\\$]+$")) {
                    t_str = t_str.replaceAll("^(.*)\\s+[0-9\\$]+$", "$1");
                } else if (t_str.matches("^.*\\s+\\$[0-9]+$")) {
                    t_str = t_str.replaceAll("^(.*)\\s+\\$[0-9]+$", "$1");
                }
                if (t_str.length() > 0) {
                    t_list.add(c_pool.get(t_str));
                }
            }
            catch (NotFoundException e) {
                Tool.alertMSG(null, e.getMessage());
            }
            ++i;
        }
        return t_list.toArray(new CtClass[t_list.size()]);
    }

    public static CtMethod getCtMethod(CtClass t_c, String cname, String mname, String[] argtypes) throws NotFoundException {
        CtMethod res;
        block10: {
            if (t_c == null) {
                t_c = c_pool.get(cname);
            }
            res = null;
            if (argtypes == null || argtypes.length == 0) {
                CtClass s_c;
                CtMethod[] t_m = t_c.getDeclaredMethods();
                int i = 0;
                while (i < t_m.length) {
                    if (mname.equals(t_m[i].getName())) {
                        res = t_m[i];
                        break;
                    }
                    ++i;
                }
                if (res == null && (s_c = t_c.getSuperclass()) != null) {
                    return Tool.getCtMethod(s_c, s_c.getName(), mname, argtypes);
                }
            } else {
                try {
                    res = t_c.getDeclaredMethod(mname, Tool.getCtParams(argtypes));
                }
                catch (NotFoundException e) {
                    CtClass s_c = t_c.getSuperclass();
                    if (s_c == null) break block10;
                    return Tool.getCtMethod(s_c, s_c.getName(), mname, argtypes);
                }
            }
        }
        if (res == null) {
            CtClass[] ifs = t_c.getInterfaces();
            int j = 0;
            while (j < ifs.length) {
                res = Tool.getCtMethod(ifs[j], ifs[j].getName(), mname, argtypes);
                if (res != null) break;
                ++j;
            }
        }
        return res;
    }

    public static String[] getExceptions(TestCommandRecord rec) {
        ArrayList<String> t_list = new ArrayList<String>();
        try {
            CtClass t_c = c_pool.get(rec.className);
            CtMethod t_b = t_c.getDeclaredMethod(rec.methodName.replaceFirst("static ", ""));
            CtClass[] tc_list = t_b.getExceptionTypes();
            if (tc_list != null) {
                int i = 0;
                while (i < tc_list.length) {
                    t_list.add(tc_list[i].getName());
                    ++i;
                }
            }
        }
        catch (NotFoundException e) {
            Tool.alertMSG(null, e.getMessage());
            return null;
        }
        return t_list.toArray(new String[t_list.size()]);
    }

    public static Method getMethod(Class<?> c, String mname, Class<?>[] argtypes) throws NotFoundException, NoSuchMethodException, SecurityException {
        if (c == null) {
            return null;
        }
        Method t_result = null;
        Method[] t_ms = c.getDeclaredMethods();
        if (t_ms != null && t_ms.length > 0) {
            Class<?> s_c;
            int i = 0;
            while (i < t_ms.length) {
                Method t_m = t_ms[i];
                if (mname.equals(t_m.getName())) {
                    boolean t_match = true;
                    Class<?>[] t_types = t_m.getParameterTypes();
                    int j = 0;
                    while (j < t_types.length) {
                        if (argtypes[j] != null && !t_types[j].isAssignableFrom(argtypes[j])) {
                            t_match = false;
                        }
                        ++j;
                    }
                    if (t_match) {
                        t_result = t_m;
                    }
                }
                ++i;
            }
            if (t_result == null && (s_c = c.getSuperclass()) != null) {
                t_result = Tool.getMethod(s_c, mname, argtypes);
            }
        }
        if (t_result == null) {
            Class<?>[] ifs = c.getInterfaces();
            int j = 0;
            while (j < ifs.length) {
                t_result = Tool.getMethod(ifs[j], mname, argtypes);
                if (t_result != null) break;
                ++j;
            }
        }
        return t_result;
    }

    public static ClassOutLine getClassOutLine(String cname) {
        if (cname == null || cname.indexOf("%") >= 0) {
            return null;
        }
        try {
            CtClass t_c = c_pool.get(cname);
            if (t_c != null) {
                return new ClassOutLine(t_c, Tool.isFake(cname));
            }
        }
        catch (NotFoundException e) {
            Tool.alertMSG(null, String.valueOf(e.getMessage()) + Messages.getString("Tool.35"));
        }
        return null;
    }

    public static boolean isFake(String cname) {
        if (cname.endsWith("?")) {
            return true;
        }
        if (cname.startsWith("test.fake")) {
            return true;
        }
        if (cname.startsWith("test.impl")) {
            return true;
        }
        try {
            if (!cname.startsWith("test.fake.")) {
                cname = "test.fake." + cname;
            }
            CtClass ctClass = c_pool.get(cname);
        }
        catch (Exception e1) {
            return false;
        }
        return true;
    }

    public static <T> String[] convClassNameList(T[] objs) {
        String[] t_list = new String[objs.length];
        int i = 0;
        while (objs.length > i) {
            t_list[i] = objs[i].getClass().getName();
            ++i;
        }
        return t_list;
    }

    public static void addInstance(String stack, Object obj) {
        if (obj != null) {
            instance_table.put(stack, obj);
        }
    }

    public static void addInstanceArgs(String sid, Object[] objs, int vpos) {
        int i = 0;
        while (i < objs.length) {
            if (i == vpos) {
                Object t_ary = objs[i];
                int n = Array.getLength(t_ary);
                int j = 0;
                while (j < n) {
                    Object t_obj = Array.get(t_ary, j);
                    instance_table.put(String.valueOf(sid) + "$" + new Integer(i + j + 1).toString(), t_obj);
                    ++j;
                }
                break;
            }
            instance_table.put(String.valueOf(sid) + "$" + new Integer(i + 1).toString(), objs[i]);
            ++i;
        }
    }

    public static Object getInstance(String name) {
        return instance_table.get(name);
    }

    public static String primitiveToFQN(String cname) {
        if ("int".equals(cname)) {
            cname = "java.lang.Integer";
        } else if ("long".equals(cname)) {
            cname = "java.lang.Long";
        } else if ("float".equals(cname)) {
            cname = "java.lang.Float";
        } else if ("double".equals(cname)) {
            cname = "java.lang.Double";
        } else if ("boolean".equals(cname)) {
            cname = "java.lang.Boolean";
        } else if ("byte".equals(cname)) {
            cname = "java.lang.Byte";
        } else if ("char".equals(cname)) {
            cname = "java.lang.Character";
        } else if ("int[]".equals(cname)) {
            cname = "java.lang.Integer[]";
        } else if ("float[]".equals(cname)) {
            cname = "java.lang.Float[]";
        } else if ("double[]".equals(cname)) {
            cname = "java.lang.Double[]";
        } else if ("boolean[]".equals(cname)) {
            cname = "java.lang.Boolean[]";
        } else if ("byte[]".equals(cname)) {
            cname = "java.lang.Byte[]";
        } else if ("char[]".equals(cname)) {
            cname = "java.lang.Character[]";
        } else if ("String".equals(cname)) {
            cname = "java.lang.String";
        } else if ("String[]".equals(cname)) {
            cname = "java.lang.String[]";
        }
        return cname;
    }

    private static boolean isPrimitive2(CtClass c) {
        if (c.isPrimitive() || c.isArray() || "java.lang.String".equals(c.getName())) {
            return true;
        }
        String t_p = "^.*(Boolean|Character|Integer|Long|Float|Double|BigDecimal|BigInteger|AtomicInteger|AtomicLong)$";
        return c.getName().matches("^.*(Boolean|Character|Integer|Long|Float|Double|BigDecimal|BigInteger|AtomicInteger|AtomicLong)$");
    }

    public static boolean isPrimitive2(Class<?> c) {
        if (c.isPrimitive() || c.isArray() || "java.lang.String".equals(c.getName())) {
            return true;
        }
        String t_p = "^.*(Boolean|Character|Integer|Long|Float|Double|BigDecimal|BigInteger|AtomicInteger|AtomicLong)$";
        return c.getName().matches("^.*(Boolean|Character|Integer|Long|Float|Double|BigDecimal|BigInteger|AtomicInteger|AtomicLong)$");
    }

    public static Object primitive2ToObject(Object o) {
        Class<?> c = o.getClass();
        if (c.isPrimitive()) {
            if (c.equals(Integer.TYPE)) {
                return (Integer)o;
            }
            if (c.equals(Long.TYPE)) {
                return (Long)o;
            }
            if (c.equals(Float.TYPE)) {
                return (Float)o;
            }
            if (c.equals(Double.TYPE)) {
                return (Double)o;
            }
            if (c.equals(Boolean.TYPE)) {
                return (Boolean)o;
            }
            if (c.equals(Byte.TYPE)) {
                return (Byte)o;
            }
            if (c.equals(Character.TYPE)) {
                return (Character)o;
            }
        } else if (c.isArray()) {
            ArrayList<Object> t_list = new ArrayList<Object>();
            int i = 0;
            while (i < Array.getLength(o)) {
                t_list.add(Tool.primitive2ToObject(Array.get(o, i)));
                ++i;
            }
            return t_list;
        }
        return o;
    }

    public static String classToJSON(String cname) {
        try {
            Class<?> t_cl = Tool.forName(Tool.primitiveToFQN(cname));
            if (cname.endsWith("[]")) {
                cname = cname.replaceFirst("\\[\\]", "");
                return "[" + Tool.classToJSON(cname) + "]";
            }
            CtClass t_ct = c_pool.get(cname);
            if (Tool.hasDefaultConstructor(t_ct)) {
                return Fson.toDefaultJson(t_cl);
            }
            Class<?>[] clist = Tool.getParamsOfJsonableConstructor(t_cl);
            if (clist != null) {
                String t_str = "{";
                int j = 0;
                while (j < clist.length) {
                    t_str = String.valueOf(t_str) + "\"$" + Integer.toString(j + 1) + "(" + clist[j].getName() + "): ???,\n";
                    ++j;
                }
                String json = Fson.toDefaultJson(t_cl);
                if (json != null) {
                    return json.replaceFirst("^\\s*\\{", Matcher.quoteReplacement(t_str));
                }
            }
        }
        catch (ClassNotFoundException e) {
            Tool.alertMSG(null, String.valueOf(e.getMessage()) + Messages.getString("Tool.36"));
        }
        catch (SecurityException e) {
            Tool.alertMSG(null, String.valueOf(e.getMessage()) + Messages.getString("Tool.37"));
        }
        catch (IllegalArgumentException e) {
            Tool.alertMSG(null, String.valueOf(e.getMessage()) + Messages.getString("Tool.38"));
        }
        catch (NotFoundException e) {
            Tool.alertMSG(null, String.valueOf(e.getMessage()) + Messages.getString("Tool.39"));
        }
        return null;
    }

    private static Class<?>[] getParamsOfJsonableConstructor(Class<?> t_cl) {
        Constructor<?>[] conslist = t_cl.getConstructors();
        int i = 0;
        while (i < conslist.length) {
            Class<?>[] param_types = conslist[i].getParameterTypes();
            ArrayList t_list = new ArrayList();
            boolean jsonable = true;
            int j = 0;
            while (j < param_types.length) {
                if (!Tool.hasDefaultConstructor(param_types[j].getName(), true)) {
                    jsonable = false;
                    break;
                }
                t_list.add(param_types[j]);
                ++j;
            }
            if (jsonable) {
                return t_list.toArray(new Class[t_list.size()]);
            }
            ++i;
        }
        return null;
    }

    public static String getJSONfromObject(Object obj) {
        return Tool.getJSONfromObject(obj, null);
    }

    public static String getJSONfromObject(Object obj, String regs) {
        String t_result = null;
        try {
            if (obj != null) {
                t_result = Fson.toJson(obj, obj.getClass(), regs);
            }
        }
        catch (Fson.NotSupportedClassException | ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            Tool.logIfDebug(e, "@Tool#getJSONfromObject");
        }
        return t_result;
    }

    public static Object getObjectfromJSON(Class<?> cl, String json) {
        if (json == null) {
            return null;
        }
        if ("null".equals(json)) {
            return null;
        }
        try {
            return Fson.fromJson(json, cl);
        }
        catch (Exception e) {
            String msg = "fromJson@getObjectfromJSON :" + e.getMessage() + "\nstacktrace=" + Tool.getStackMessage(e, 0, 10);
            Tool.logForTesting(e, msg);
            if (cur_commander != null) {
                Tool.cur_commander.is_stopping = true;
                throw new RejectedExecutionException(msg);
            }
            return null;
        }
    }

    public static void saveJSONfromObject(String name, Object obj, String filterReg) throws SQLException {
        JSONRecord t_json = JSONRecord.getJSONRec(obj.getClass().getName(), name);
        if (t_json == null) {
            t_json = new JSONRecord(2);
            t_json.className = "com.ftinc.si.assist.test.web.MacroActions";
            t_json.name = name;
        }
        t_json.content = Tool.getJSONfromObject(obj, filterReg);
        t_json.changed();
        Tool._db().updateRecordBySQL(t_json.getUpdateSQL(), true);
        JSONRecord.updatingJSONRec(t_json);
    }

    public static synchronized void logForTesting(Throwable e, String str) {
        if (child_mode) {
            s_out.print(str);
        } else {
            if (log_stream == null) {
                try {
                    File t_log = new File(logFolder);
                    File f_log = null;
                    f_log = t_log.isDirectory() ? new File(String.valueOf(logFolder) + "\\log.txt") : t_log;
                    if (!f_log.exists()) {
                        f_log.createNewFile();
                    }
                    log_stream = new PrintStream(new FileOutputStream(f_log, false));
                    log_stream.append("<?xml version=\"1.0\" ?>\n");
                }
                catch (FileNotFoundException e1) {
                    Tool.alertMSG(null, Messages.getString("Tool.2"));
                }
                catch (IOException e1) {
                    Tool.alertMSG(null, Messages.getString("Tool.1"));
                }
            }
            log_stream.append(String.valueOf(str) + "\n" + Tool.getStackMessage(e, 0, 10) + "\n");
            log_stream.flush();
            if (e != null) {
                e.printStackTrace();
            }
            if (logStack == null) {
                logStack = "";
            }
            logStack = String.valueOf(logStack) + str;
        }
    }

    public static void initStatusWin(boolean ifExit) {
        s_statuswin = new AssertStatusWindow();
        if (ifExit) {
            s_statuswin.setDefaultCloseOperation(3);
            Tool.s_statuswin.ifexit = true;
        }
    }

    public static void displayResult(String msg) {
        if (!child_mode) {
            if (s_statuswin == null) {
                s_statuswin = new AssertStatusWindow();
            }
            if (msg != null) {
                s_statuswin.setResult(msg);
            } else {
                s_statuswin.setResult(logStack);
                logStack = null;
            }
            if (!s_statuswin.isVisible()) {
                s_statuswin.setVisible(true);
            }
        }
    }

    public static void waitDisplayEvent() {
        if (!child_mode && s_statuswin != null) {
            s_statuswin.subLoop();
        }
    }

    public static void logIfDebug(Throwable e, String msg) {
        if (debug_mode) {
            String t_msg = "";
            if (e != null) {
                t_msg = String.valueOf(t_msg) + Tool.getStackMessage(e, 0, 10);
            }
            s_out.print(String.valueOf(t_msg) + msg + "\n");
        }
    }

    public static void alertMSG(JDialog comp, String msg) {
        if (!child_mode) {
            JTextArea t_area = new JTextArea(6, 40);
            t_area.setText(msg);
            t_area.setEditable(false);
            JScrollPane s_pane = new JScrollPane(t_area);
            JOptionPane.showMessageDialog(comp, s_pane);
            Tool.logIfDebug(null, msg);
        }
    }

    public static void alertAndStop(String msg) {
        if (!child_mode) {
            Tool.alertMSG(null, msg);
        }
        if (cur_commander != null) {
            Tool.cur_commander.is_stopping = true;
            throw new RejectedExecutionException(msg);
        }
    }

    public static void alertAndExit(String msg, Exception e, int testid) {
        String er_msg;
        if (e == null) {
            e = new Exception();
        }
        if ((er_msg = e.getMessage()) == null) {
            er_msg = "";
        }
        String t_msg = String.valueOf(msg) + e.getMessage() + "\n";
        t_msg = String.valueOf(t_msg) + Tool.getStackMessage(e, 0, 10);
        Tool.logIfDebug(null, t_msg);
        int opt = 0;
        if (!child_mode) {
            JTextArea t_area = new JTextArea(6, 40);
            t_area.setText(t_msg);
            t_area.setEditable(false);
            JScrollPane s_pane = new JScrollPane(t_area);
            opt = JOptionPane.showConfirmDialog(null, s_pane, Messages.getString("Tool.41"), 0, 0);
        }
        if (opt == 0) {
            TestLogger.err(String.valueOf(t_msg) + " @ " + Integer.toString(testid) + "\n");
            Tool.logForTesting(null, TestLogger.endTestSuite());
            Tool.displayResult(null);
            Tool.destroy();
            System.exit(testid + 1000);
        }
    }

    public static String getStackMessage(Throwable e, int offset, int n) {
        if (!debug_mode) {
            return "";
        }
        String t_result = "";
        StackTraceElement[] elms = e.getStackTrace();
        String sps = "";
        int i = 0;
        while (i < elms.length && i < n) {
            if (i >= offset) {
                t_result = String.valueOf(t_result) + sps + elms[i].toString() + "\n";
                sps = String.valueOf(sps) + ">";
            }
            ++i;
        }
        return t_result;
    }

    public static boolean refleshFakes() {
        SimpleDateFormat t_fmt = new SimpleDateFormat("yyyy/MM/dd (hh:mm:ss)");
        HashMap<String, CtClass> t_map = new HashMap<String, CtClass>();
        ArrayList<FakeMethodRecord> all_fakes = Tool._db().getAllFakes(version);
        int i = 0;
        while (i < all_fakes.size()) {
            String m_name = all_fakes.get((int)i).methodName;
            String c_name = all_fakes.get((int)i).className;
            String[] a_types = all_fakes.get((int)i).argTypes;
            String src = all_fakes.get((int)i).source;
            try {
                CtMethod t_method;
                CtClass t_class;
                block25: {
                    t_class = (CtClass)t_map.get(c_name);
                    if (t_class == null) {
                        ObjectRecord t_rec = new ObjectRecord(0);
                        t_rec.className = c_name;
                        t_class = (CtClass)Tool.createNewFakeClass(t_rec, false);
                        t_map.put(c_name, t_class);
                    }
                    t_class.defrost();
                    t_method = null;
                    try {
                        t_method = t_class.getDeclaredMethod(m_name, Tool.getCtParams(a_types));
                    }
                    catch (NotFoundException e) {
                        CtMethod t_orgmt = null;
                        t_orgmt = Tool.getCtMethod(t_class, c_name, m_name, a_types);
                        if (t_orgmt == null) break block25;
                        try {
                            t_method = Tool.makeSkinOfMethod(t_class, t_orgmt, null, true, null);
                        }
                        catch (Exception e2) {
                            Tool.alertMSG(null, String.valueOf(e2.getMessage()) + Messages.getString("Tool.42") + m_name);
                            throw new CannotCompileException(String.valueOf(e2.getMessage()) + " : " + m_name);
                        }
                    }
                }
                if (t_method != null) {
                    String t_src = CodeProcessor.preProcessMain(t_class, (CtBehavior)t_method, src);
                    if (t_src != null) {
                        t_method.setBody(t_src);
                        Tool.writeAnnotationToMethod(t_method, "updated", t_fmt.format(new Date()));
                    } else {
                        Tool.alertMSG(null, String.valueOf(Messages.getString("Tool.33")) + src);
                    }
                } else {
                    Tool.alertMSG(null, String.valueOf(c_name) + "#" + m_name + Messages.getString("Tool.43"));
                }
            }
            catch (NotFoundException e) {
                Tool.alertMSG(null, String.valueOf(e.getMessage()) + Messages.getString("Tool.44"));
                return false;
            }
            catch (CannotCompileException e) {
                Tool.alertMSG(null, String.valueOf(e.getMessage()) + Messages.getString("Tool.45") + src);
                return false;
            }
            catch (IOException e) {
                Tool.alertMSG(null, String.valueOf(e.getMessage()) + " IOException@Tool#refleshFakes");
                return false;
            }
            catch (SecurityException e) {
                Tool.alertMSG(null, String.valueOf(e.getMessage()) + " SecurityException@Tool#refleshFakes");
                return false;
            }
            catch (IllegalArgumentException e) {
                Tool.alertMSG(null, String.valueOf(e.getMessage()) + " IllegalArgumentException@Tool#refleshFakes");
                return false;
            }
            catch (InstantiationException e) {
                Tool.alertMSG(null, String.valueOf(e.getMessage()) + " InstantiationException@Tool#refleshFakes");
                return false;
            }
            catch (IllegalAccessException e) {
                Tool.alertMSG(null, String.valueOf(e.getMessage()) + " IllegalAccessException@Tool#refleshFakes");
                return false;
            }
            catch (NoSuchFieldException e) {
                Tool.alertMSG(null, String.valueOf(e.getMessage()) + " NoSuchFieldException@Tool#refleshFakes");
                return false;
            }
            catch (NoSuchMethodException e) {
                Tool.alertMSG(null, String.valueOf(e.getMessage()) + " NoSuchMethodException@Tool#refleshFakes");
                return false;
            }
            catch (InvocationTargetException e) {
                Tool.alertMSG(null, String.valueOf(e.getMessage()) + " InvocationTargetException@Tool#refleshFakes");
                return false;
            }
            ++i;
        }
        for (Map.Entry entry : t_map.entrySet()) {
            try {
                ((CtClass)entry.getValue()).writeFile(fake_dir);
            }
            catch (CannotCompileException e) {
                Tool.alertMSG(null, String.valueOf(e.getMessage()) + " CannotCompileException@Tool#refleshFakes:" + (String)entry.getKey());
                return false;
            }
            catch (IOException e) {
                Tool.alertMSG(null, String.valueOf(e.getMessage()) + " IOException@Tool#refleshFakes:" + (String)entry.getKey());
                return false;
            }
        }
        return true;
    }

    public static Field getField(Class<?> c, String fldname) {
        Field t_f;
        block5: {
            if (c.getName().startsWith("test.fake.") && !fldname.equals("_impl")) {
                return null;
            }
            if (c.getName().startsWith("test.impl.") && !fldname.equals("_table")) {
                return null;
            }
            t_f = null;
            try {
                t_f = c.getDeclaredField(fldname);
                t_f.setAccessible(true);
            }
            catch (SecurityException e) {
                return null;
            }
            catch (NoSuchFieldException e) {
                Class<?> t_s = c.getSuperclass();
                if (t_s == null || t_s.getName().equals("java.lang.Object")) break block5;
                return Tool.getField(c.getSuperclass(), fldname);
            }
        }
        return t_f;
    }

    public static void getAllFields(Class<?> c, ArrayList<Field> list) {
        Field[] t_fs = null;
        try {
            t_fs = c.getDeclaredFields();
            int i = 0;
            while (i < t_fs.length) {
                list.add(t_fs[i]);
                ++i;
            }
            if (Object.class.equals(c.getSuperclass())) {
                Tool.getAllFields(c.getSuperclass(), list);
            }
        }
        catch (SecurityException e) {
            return;
        }
    }

    public static Object getFakeInstance(String ... vals) {
        Pattern t_pat0;
        Matcher t_m;
        Object res_obj = null;
        String t_key = vals[0];
        if (vals.length > 1) {
            t_key = String.valueOf(t_key) + "#" + vals[1];
        }
        if ((t_m = (t_pat0 = Pattern.compile("^([0-9]*)\\$[0-9_]+$")).matcher(t_key)).find() && t_key.startsWith("$")) {
            t_key = String.valueOf(String.valueOf(curID)) + t_key;
        }
        if ((res_obj = Tool.getInstance(t_key)) != null) {
            return res_obj;
        }
        try {
            ObjectRecord t_rec = new ObjectRecord(0);
            t_rec.className = vals[0];
            if (t_rec.className.endsWith("?")) {
                t_rec.className = t_rec.className.substring(0, t_rec.className.length() - 1);
                t_rec.isPOJO = false;
            }
            t_rec.testCase = curCase;
            ObjectRecord t_rec2 = Tool._db().getObjectRecord(t_rec);
            if (t_rec2 != null) {
                t_rec = t_rec2;
            }
            res_obj = Tool.existClass("test.fake." + t_rec.className) ? Tool.deserializeObject(t_rec) : Tool.createNewFakeClass(t_rec, true);
            Pattern t_pat = Pattern.compile("^(\\w+?)=(.*)$");
            int i = 1;
            while (i < vals.length) {
                t_m = t_pat.matcher(vals[i]);
                if (t_m.find()) {
                    String f_name = t_m.group(1);
                    String json = t_m.group(2);
                    String cname = "java.lang.String";
                    Pattern t_pat2 = Pattern.compile("\\(([^\\)]+?)\\)(.+)$");
                    t_m = t_pat2.matcher(json);
                    if (t_m.find()) {
                        cname = t_m.group(1);
                        json = t_m.group(2);
                    }
                    Fson.updateByJsonPath(res_obj, "$." + f_name, json);
                    Fson.updateByJsonPath(res_obj, "$." + f_name + "_class", cname);
                }
                ++i;
            }
        }
        catch (Fson.NotSupportedClassException | IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException | ParseException | CannotCompileException | NotFoundException e) {
            Tool.alertMSG(null, String.valueOf(e.getMessage()) + " @Tool#getTInstance");
        }
        if (res_obj != null) {
            Tool.addInstance(t_key, res_obj);
        }
        return res_obj;
    }

    public static Inspector createInspector(int id, String src) throws CannotCompileException, InstantiationException, IllegalAccessException, ClassNotFoundException, NotFoundException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        CtClass s_c = c_pool.get("com.ftinc.si.assist.test.Inspector");
        Class<?> t_c = null;
        try {
            t_c = Tool.forName("TestInspector_" + Integer.toString(id));
        }
        catch (ClassNotFoundException e) {
            CtClass c_ins = c_pool.makeClass("TestInspector_" + Integer.toString(id));
            c_ins.setSuperclass(s_c);
            c_ins.setModifiers(1);
            CtMethod t_orgmt = s_c.getDeclaredMethod("inspect", new CtClass[0]);
            CtMethod t_m = CtNewMethod.copy((CtMethod)t_orgmt, (CtClass)c_ins, null);
            c_ins.addMethod(t_m);
            String t_msg = Messages.getString("Tool.46");
            try {
                String t_src = CodeProcessor.preProcessMain(c_ins, (CtBehavior)t_m, src);
                if (t_src != null) {
                    t_m.setBody(t_src);
                    t_msg = Messages.getString("Tool.47");
                    t_c = Tool.toClass(c_ins);
                } else {
                    Tool.alertMSG(null, String.valueOf(Messages.getString("Tool.33")) + src);
                }
            }
            catch (CannotCompileException e1) {
                try {
                    t_c = Tool.forName(c_ins.getName());
                }
                catch (Exception e2) {
                    throw new CannotCompileException(String.valueOf(e1.getMessage()) + Messages.getString("Tool.48") + t_msg);
                }
            }
        }
        if (t_c == null) {
            throw new NotFoundException("TestInspector_" + Integer.toString(id) + Messages.getString("Tool.95"));
        }
        Class[] clist = new Class[]{};
        Object[] olist = new Object[]{};
        return (Inspector)Tool.newObject(t_c, clist, olist);
    }

    public static Object constructObject(String cname, String src) throws CannotCompileException, InstantiationException, IllegalAccessException, ClassNotFoundException, NotFoundException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        AnyConstructor t_const = null;
        if (instance_table.containsKey(String.valueOf(cname) + "_new")) {
            t_const = (AnyConstructor)instance_table.get(String.valueOf(cname) + "_new");
            return t_const.create();
        }
        if ((src = src.trim()) == null || src.length() < 10) {
            return Tool.newObject(Tool.forName(cname), new Class[0], new Object[0]);
        }
        CtClass s_c = c_pool.get("com.ftinc.si.assist.test.AnyConstructor");
        Class<?> t_c = null;
        CtClass c_ins = c_pool.makeClass("TestConstructor_" + Long.toString(new Date().getTime()));
        c_ins.setSuperclass(s_c);
        c_ins.setModifiers(1);
        CtMethod t_orgmt = s_c.getDeclaredMethod("create", new CtClass[0]);
        CtMethod t_m = CtNewMethod.copy((CtMethod)t_orgmt, (CtClass)c_ins, null);
        c_ins.addMethod(t_m);
        try {
            String t_src = CodeProcessor.preProcessMain(c_ins, (CtBehavior)t_m, src);
            if (t_src != null) {
                t_m.setBody(t_src);
                t_c = Tool.toClass(c_ins);
            } else {
                Tool.alertMSG(null, String.valueOf(Messages.getString("Tool.33")) + src);
            }
        }
        catch (CannotCompileException e1) {
            try {
                t_c = Tool.forName(c_ins.getName());
            }
            catch (Exception e2) {
                throw new CannotCompileException(String.valueOf(e1.getMessage()) + "\n" + Messages.getString("Tool.48"));
            }
        }
        if (t_c == null) {
            throw new NotFoundException("TestConstructor_" + Long.toString(new Date().getTime()) + Messages.getString("Tool.98"));
        }
        Class[] clist = new Class[]{};
        Object[] olist = new Object[]{};
        t_const = (AnyConstructor)Tool.newObject(t_c, clist, olist);
        instance_table.put(String.valueOf(cname) + "_new", t_const);
        return t_const.create();
    }

    public static Object getFieldValue(Object obj, String fname) throws NoSuchFieldException {
        if (obj == null) {
            return null;
        }
        try {
            Class<?> t_c = obj.getClass();
            if (t_c.isArray()) {
                if ("length".equals(fname)) {
                    return Array.getLength(obj);
                }
                throw new NoSuchFieldException();
            }
            Field t_f = Tool.getField(t_c, fname);
            if (t_f != null) {
                t_f.setAccessible(true);
                Class<?> t_type = t_f.getType();
                if (t_type.getName().equals("boolean")) {
                    return new Boolean(t_f.getBoolean(obj));
                }
                if (t_type.getName().equals("int")) {
                    return new Integer(t_f.getInt(obj));
                }
                if (t_type.getName().equals("long")) {
                    return new Long(t_f.getLong(obj));
                }
                if (t_type.getName().equals("double")) {
                    return new Double(t_f.getDouble(obj));
                }
                if (t_type.getName().equals("float")) {
                    return new Float(t_f.getFloat(obj));
                }
                if (t_type.getName().equals("byte")) {
                    return new Byte(t_f.getByte(obj));
                }
                if (t_type.getName().equals("char")) {
                    return new Character(t_f.getChar(obj));
                }
                return t_f.get(obj);
            }
            if (Tool.isFake(t_c.getName())) {
                return Tool.getFieldValueForFake(obj, fname);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            Tool.logIfDebug(e, "@Tool#getFieldValue");
        }
        throw new NoSuchFieldException();
    }

    private static Object getFieldValueForFake(Object obj, String fname) {
        HashMap t_map;
        block5: {
            Class<?> t_c = obj.getClass();
            String cname = t_c.getName();
            Field t_f2 = null;
            Object t_impl = null;
            if (cname.startsWith("test.fake.")) {
                Field t_f1 = Tool.getField(t_c, "_impl");
                t_f1.setAccessible(true);
                t_impl = t_f1.get(obj);
                t_f2 = Tool.getField(t_impl.getClass(), "_table");
                t_f2.setAccessible(true);
            } else {
                t_impl = obj;
                t_f2 = Tool.getField(t_c, "_table");
            }
            t_map = (HashMap)t_f2.get(t_impl);
            if (t_map.containsKey(fname)) break block5;
            AssertRecord.setLost(t_c.getName(), fname);
            return null;
        }
        try {
            return t_map.get(fname);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            Tool.logIfDebug(e, "@Tool#getInspectSourceForFake");
            return null;
        }
    }

    public static String getFieldTypeNameForFake(String className, String fname) {
        if (className.startsWith("test.fake.")) {
            className = className.substring(10);
        }
        ArrayList<FakeMethodRecord> fake_list = Tool._db().getFakeMethods(className, version);
        int i = 0;
        while (i < fake_list.size()) {
            String t_result = fake_list.get(i).getFieldType(fname);
            if (t_result != null) {
                return t_result;
            }
            ++i;
        }
        return null;
    }

    public static Object fieldValue(Object obj, String name, Object fobj) {
        Pattern t_pat;
        Matcher t_m;
        if (obj == null) {
            Tool.logIfDebug(null, "1st arg==null @Tool#fieldValue");
            return null;
        }
        if (name == null || name.length() == 0) {
            Tool.logIfDebug(null, "field=empty@Tool#fieldValue");
            return null;
        }
        String fname = name;
        if (fname.startsWith("$.")) {
            fname = fname.substring(2);
        }
        if ((t_m = (t_pat = Pattern.compile("^(.*?)\\.([^\\.]+)$")).matcher(fname)).find()) {
            String jpath = t_m.group(1);
            String attrName = t_m.group(2);
            ArrayList<Object> t_list = Fson.valueByJsonPath(obj, jpath);
            if (t_list != null && t_list.size() > 0) {
                return Tool.fieldValue(t_list.get(0), attrName, fobj);
            }
            Tool.logIfDebug(null, "valueByJsonPath @Tool#fieldValue");
            return null;
        }
        if (fobj != null) {
            Class<?> t_c = obj.getClass();
            if (!Tool.isPrimitive2(t_c)) {
                if (obj instanceof Map) {
                    ((Map)obj).put(fname, fobj);
                } else if (t_c.getName().startsWith("test.fake.")) {
                    try {
                        Object t_impl = Tool.getFieldValue(obj, "_impl");
                        HashMap t_map = (HashMap)Tool.getFieldValue(t_impl, "_table");
                        t_map.put(fname, fobj);
                    }
                    catch (IllegalArgumentException | NoSuchFieldException e) {
                        Tool.logIfDebug(e, "getField&set (0)@Tool#fieldValue");
                    }
                } else if (t_c.getName().startsWith("test.impl.")) {
                    try {
                        HashMap t_map = (HashMap)Tool.getFieldValue(obj, "_table");
                        t_map.put(fname, fobj);
                    }
                    catch (IllegalArgumentException | NoSuchFieldException e) {
                        Tool.logIfDebug(e, "getField&set (1)@Tool#fieldValue");
                    }
                } else {
                    try {
                        Field t_f = Tool.getField(t_c, fname);
                        if (t_f != null) {
                            t_f.setAccessible(true);
                            t_f.set(obj, fobj);
                        }
                    }
                    catch (Exception e) {
                        Tool.logIfDebug(e, "getField&set (2)@Tool#fieldValue");
                    }
                }
            }
        } else {
            try {
                return Tool.getFieldValue(obj, fname);
            }
            catch (NoSuchFieldException e) {
                return null;
            }
        }
        return fobj;
    }

    public static boolean existClass(String cname) {
        return Tool.getClassFilePath(cname) != null;
    }

    public static void setPrevPath(String curPath) {
        if (curPath != null) {
            String _sep = File.separator;
            s_prevPath = curPath.replaceAll("^([\\w" + _sep + ":\\s]+" + _sep + "\\w+) " + _sep + "[\\w\\.]+$", "$1");
        }
    }

    public static String getPrevPath() {
        return s_prevPath;
    }

    public static String findClassName(Component parent, ArrayList<String> dirs) {
        String className = JOptionPane.showInputDialog(null, (Object)Messages.getString("Tool.55"));
        if (className != null && className.length() > 0) {
            if (Tool.getClassOutLine(className) != null) {
                return className;
            }
            Tool.alertMSG(null, Messages.getString("Tool.49"));
        }
        return "";
    }

    public static Window getParent(Component comp, String cname) {
        if (cname.equals("JDialog")) {
            if (comp instanceof JDialog) {
                return (Window)comp;
            }
            if (comp.getParent() != null) {
                return Tool.getParent(comp.getParent(), cname);
            }
        } else if (cname.equals("JFrame")) {
            if (comp instanceof JFrame) {
                return (Window)comp;
            }
            if (comp.getParent() != null) {
                return Tool.getParent(comp.getParent(), cname);
            }
        }
        return null;
    }

    private static String getClassFilePath(String cname) {
        try {
            CtClass t_c = c_pool.get(cname);
            return t_c.getClassFile().getSourceFile();
        }
        catch (NotFoundException e1) {
            return null;
        }
    }

    public static boolean existClassMethod(String cname, String mname) {
        try {
            CtClass t_c = c_pool.get(cname);
            return t_c.getMethod(mname, "([[Ljava/lang/String)Ljava/lang/String") != null;
        }
        catch (NotFoundException e1) {
            return false;
        }
    }

    public static boolean checkInteger(String value, KeyEvent evt, int max, int min) {
        if (evt.getKeyCode() == 127 || evt.getKeyCode() == 39 || evt.getKeyCode() == 37) {
            return true;
        }
        String t_str = new String(new char[]{evt.getKeyChar()});
        if (t_str.length() > 0 && t_str.matches("^(\b|\t|\n|\r)$")) {
            return true;
        }
        if (value.matches("^[0-9]*$") && t_str.matches("^[0-9]$")) {
            try {
                Integer t_val = new Integer(String.valueOf(value) + t_str);
                if (max == 0 || t_val <= max && min <= t_val) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static Font resizeFont(MouseWheelEvent e, Font f) {
        if (e.isControlDown()) {
            int n = e.getWheelRotation();
            int h = f.getSize();
            if (h > 8 && 33 > h) {
                if ((h += n) == 8) {
                    h = 9;
                }
                if (h == 33) {
                    h = 32;
                }
            }
            return new Font(f.getFontName(), 0, h);
        }
        return null;
    }

    public static int executeCommand(StringBuilder msg, String path, String ... cmd) {
        String t_tag;
        Pattern t_pat2;
        Pattern t_pat1;
        Matcher t_m;
        ProcessBuilder t_pb = new ProcessBuilder(cmd);
        if (path != null && path.length() > 0) {
            String l_path = String.valueOf(s_userdir) + "\\" + s_jarname + "_lib";
            String t_path = path.replaceFirst(Pattern.quote("$LIBDIR"), Matcher.quoteReplacement(l_path));
            File t_dir = new File(t_path);
            t_pb.directory(t_dir);
        }
        String cmd_str = Tool.getJSONfromObject(cmd);
        t_pb.redirectErrorStream(true);
        String t_buf = "";
        int t_res = 999;
        while (t_res == 999) {
            try {
                Process t_p = t_pb.start();
                t_p.getOutputStream().close();
                BufferedReader t_input = null;
                t_input = cmd_str.matches("^.*java.+\\-jar.+" + s_jarname + "\\.jar.+$") ? new BufferedReader(new InputStreamReader(t_p.getInputStream(), "UTF-8")) : new BufferedReader(new InputStreamReader(t_p.getInputStream(), "JISAutoDetect"));
                String t_result = Tool.readResultFromStream(t_input, true);
                if (t_result != null) {
                    t_buf = String.valueOf(t_buf) + t_result;
                }
                t_res = t_p.exitValue();
                t_input.close();
                t_p.destroy();
            }
            catch (IOException e1) {
                Tool.alertMSG(null, String.valueOf(Messages.getString("Tool.50")) + cmd_str);
                t_res = -1;
            }
        }
        if (!debug_mode && (t_m = (t_pat1 = Pattern.compile("\\A[^<]*<([\\w\\-]+)[^\\w\\-]")).matcher(t_buf)).find() && (t_m = (t_pat2 = Pattern.compile("\\A[\\s\\S]*?(<" + Pattern.quote(t_tag = t_m.group(1)) + "[\\s\\S]*</" + Pattern.quote(t_tag) + ">)[\\s\\S]*\\z")).matcher(t_buf)).find()) {
            t_buf = t_m.group(1);
        }
        msg.append(t_buf);
        return t_res;
    }

    public static String readResultFromStream(BufferedReader buf, boolean waitEnd) {
        String t_result = null;
        String t_line = null;
        try {
            while ((t_line = buf.readLine()) != null) {
                String t_tag;
                Pattern t_pat;
                if (t_result == null) {
                    t_result = "";
                }
                t_result = String.valueOf(t_result) + t_line + "\n";
                if (waitEnd) continue;
                t_result = t_result.replaceFirst("^[\\s\\S]*(<\\w+>)", "$1");
                ArrayList<String> esq_result = Fson.escapeBraket(t_result, "\"");
                Pattern t_pat0 = Pattern.compile("\\A[\\s\\S]*?<(\\w+)>");
                Matcher t_m = t_pat0.matcher(esq_result.get(0));
                if (!t_m.find() || !(t_m = (t_pat = Pattern.compile("\\A[\\s\\S]*?(<" + Pattern.quote(t_tag = t_m.group(1)) + "[\\s\\S]*</" + Pattern.quote(t_tag) + ">)[\\s\\S]*\\z", 32)).matcher(esq_result.get(0))).find()) continue;
                t_result = Fson.restoreBraket(t_m.group(1), esq_result);
                break;
            }
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
        }
        return t_result;
    }

    public static String convert2Alias(String category, String str) {
        if (aliasNames != null) {
            for (Map.Entry<String, String> entry : aliasNames.entrySet()) {
                Pattern t_pat;
                Matcher t_m;
                String key = entry.getKey();
                if (!key.matches("^(" + category + ")\\s*:.*$") || !(t_m = (t_pat = Pattern.compile(key = key.replaceFirst("(" + category + ")\\s*:\\s*", ""))).matcher(entry.getValue())).find()) continue;
                str = t_m.replaceAll(entry.getValue());
            }
        }
        return str;
    }

    public static HashMap<String, Object> getCommentMapFromJson(boolean ifGlobal, String json) {
        HashMap<String, Integer> t_nums = new HashMap<String, Integer>();
        HashMap<String, Object> t_list = new HashMap<String, Object>();
        ArrayList<String> t_esqList = null;
        try {
            t_esqList = Fson.escapeBraket(json, "\"");
        }
        catch (ParseException e) {
            e.printStackTrace();
            return t_list;
        }
        String t_src = t_esqList.get(0);
        String[] t_strs = t_src.split("\n");
        int i = 0;
        while (i < t_strs.length) {
            String t_restored;
            Matcher t_m = s_globalpat1.matcher(t_strs[i]);
            if (t_m.find()) {
                t_restored = Fson.restoreBraket(t_strs[i], t_esqList);
                t_m = s_globalpat1.matcher(t_restored);
                if (t_m.find()) {
                    String value;
                    String key = Fson.restoreBraket(t_m.group(1), t_esqList);
                    if (ifGlobal) {
                        if (key.startsWith("$.")) {
                            value = Fson.restoreBraket(t_m.group(2), t_esqList);
                            Object val = Tool.getObjectfromJSON(null, value);
                            t_list.put(key, val);
                        } else if ("$".equals(key)) {
                            value = Fson.restoreBraket(t_m.group(2), t_esqList);
                            HashMap _gmap = (HashMap)Tool.getObjectfromJSON(HashMap.class, value);
                            t_list.putAll(_gmap);
                        }
                    } else if (!key.startsWith("$.") && !key.equals("$")) {
                        value = Fson.restoreBraket(t_m.group(2), t_esqList);
                        t_list.put(key, value);
                    }
                }
            } else if (ifGlobal && (t_m = s_globalpat2.matcher(t_strs[i])).find() && (t_m = s_globalpat2.matcher(t_restored = Fson.restoreBraket(t_strs[i], t_esqList))).find()) {
                String cmd = Fson.restoreBraket(t_m.group(1), t_esqList);
                String key = Fson.restoreBraket(t_m.group(2), t_esqList);
                String value = Fson.restoreBraket(t_m.group(3), t_esqList);
                Object val = Tool.getObjectfromJSON(null, value);
                if (key.matches("^(after|before)$")) {
                    Integer n;
                    if (t_nums.containsKey(key)) {
                        n = (Integer)t_nums.get(key);
                        n = n + 1;
                        t_nums.put(key, n);
                    } else {
                        n = 0;
                        t_nums.put(key, n);
                        t_list.put(String.valueOf(key) + "_" + n.toString(), val);
                    }
                    t_list.put(String.valueOf(cmd) + " " + key + "_" + n.toString(), val);
                } else {
                    t_list.put(String.valueOf(cmd) + " " + key, val);
                }
            }
            ++i;
        }
        return t_list;
    }

    private static String removeCommentFromJson(String str) {
        if (str != null) {
            return str.replaceAll("^//[^\n]+$", "");
        }
        return "null";
    }

    public static String makeIndent(Throwable e) {
        String t_str;
        if (e != null && (t_str = e.getMessage()) != null) {
            if (t_str.startsWith("\t\t")) {
                t_str = t_str.replaceAll("\n", Matcher.quoteReplacement("\n   "));
                return "   " + t_str.substring(2);
            }
            return t_str;
        }
        return "";
    }

    public static String removeRedundancy(Throwable e, String str) {
        String t_str = String.valueOf(Tool.makeIndent(e)) + str;
        t_str = t_str.replaceFirst("Build info: version:[\\s\\S]*Driver info: driver.version: unknown.", "");
        return t_str;
    }

    public static String repairFileName(String fname) {
        if (fname != null) {
            fname = fname.replaceAll("\\s", "_");
            String osName = System.getProperty("os.name");
            if ("Linux".equals(osName)) {
                String t_result = fname;
                String newC = "_";
                t_result = t_result.replace('/', newC.charAt(0));
                return t_result;
            }
            return fname.replaceAll("(\\\\|/|:|\\*|\\?|\"|<|>)", "_");
        }
        return null;
    }

    public static String replaceB(String str, String target, String replaced) {
        int idx;
        int offset = 0;
        StringBuilder s_b = new StringBuilder(str.length());
        while ((idx = str.indexOf(target, offset)) >= 0) {
            s_b.append(str, offset, idx);
            s_b.append(replaced);
            offset = idx + target.length();
        }
        s_b.append(str, offset, str.length());
        return s_b.toString();
    }

    public static String regReplaceAll(String str, String regStr, String replaced) {
        StringBuilder s_b = new StringBuilder(str.length());
        int idx_start = 0;
        int idx_end = 0;
        Pattern t_pat = Pattern.compile(regStr);
        Matcher t_m = t_pat.matcher(str);
        while (t_m.find()) {
            String w_str = t_m.group();
            String w_str2 = w_str.replaceFirst(regStr, replaced);
            idx_end = t_m.start();
            s_b.append(str, idx_start, idx_end);
            s_b.append(w_str2);
            idx_start = t_m.end();
        }
        s_b.append(str, idx_start, str.length());
        return s_b.toString();
    }

    public static String esq4CMD(String option) {
        if (option != null) {
            String t_str = option;
            t_str = t_str.replaceFirst("\\A\"(.*?)\"\\z", "$1");
            t_str = Tool.replaceB(t_str, "\\", "\\\\");
            t_str = Tool.replaceB(t_str, "\"", "\\\"");
            t_str = Tool.replaceB(t_str, "\t", "\\t");
            t_str = Tool.replaceB(t_str, "\n", "\\n");
            return "\"" + t_str + "\"";
        }
        return null;
    }

    public static String rest4CMD(String option) {
        if (option != null) {
            String t_str = option;
            t_str = t_str.replaceFirst("\\A\"(.*?)\"\\z", "$1");
            t_str = Tool.replaceB(t_str, "\\\\", "_BQ%BQ_");
            t_str = Tool.replaceB(t_str, "\\t", "\t");
            t_str = Tool.replaceB(t_str, "\\n", "\n");
            t_str = Tool.replaceB(t_str, "\\\"", "\"");
            t_str = Tool.replaceB(t_str, "_BQ%BQ_", "\\");
            return t_str;
        }
        return null;
    }

    public static String getClosedBlock(String str, int fromIndex, String beginTag, String endTag) {
        String x_str = str.toLowerCase();
        String tail = "";
        String[] temp = beginTag.split("\t");
        if (temp.length == 2) {
            tail = temp[1];
            beginTag = temp[0];
        }
        int n_pos = 0;
        n_pos = x_str.indexOf(beginTag, fromIndex);
        if (n_pos >= fromIndex) {
            int x_pos = n_pos;
            int etag_count = 0;
            int i_pos = x_str.indexOf(endTag, x_pos + 1);
            while (i_pos >= 0) {
                ++etag_count;
                String c_str = x_str.substring(n_pos, i_pos);
                if (c_str.endsWith("\\")) {
                    --etag_count;
                } else {
                    c_str = String.valueOf(c_str) + endTag;
                    Pattern t_pat = Pattern.compile("(?<=[^\\\\])" + Pattern.quote(beginTag) + tail);
                    Matcher t_m = t_pat.matcher(c_str);
                    int btag_count = 1;
                    while (t_m.find()) {
                        ++btag_count;
                    }
                    if (etag_count == btag_count) {
                        return str.substring(n_pos, i_pos + endTag.length());
                    }
                }
                i_pos = x_str.indexOf(endTag, i_pos + endTag.length());
                while (i_pos >= 0 && '\\' == x_str.charAt(i_pos - 1)) {
                    i_pos = x_str.indexOf(endTag, i_pos + endTag.length());
                }
            }
        }
        return null;
    }

    public static String getClosedRange(String str) {
        String t_result = str;
        Pattern t_pat = Pattern.compile("^([^<]*)<(/?)([\\w\\-]+)(\\s[^>]*>|/?>)([\\s\\S]*)$");
        Matcher t_m = t_pat.matcher(str);
        if (t_m.find()) {
            String t_block;
            t_result = t_m.group(2).equals("/") ? t_m.group(1) : (t_m.group(4).endsWith("/>") ? String.valueOf(t_m.group(1)) + "<" + t_m.group(3) + t_m.group(4) + Tool.getClosedRange(t_m.group(5)) : ((t_block = Tool.getClosedBlock("<" + t_m.group(3) + t_m.group(4) + t_m.group(5), 0, "<" + t_m.group(3) + "\t(\\s|>)", "</" + t_m.group(3))) != null && t_block.length() > 0 ? String.valueOf(t_m.group(1)) + t_block + Tool.getClosedRange(String.valueOf(str.substring(t_m.end(1))) + t_block.length()) : t_m.group(1)));
        }
        return t_result;
    }

    public static ArrayList<String> createTableSQL() {
        ArrayList<String> t_list = new ArrayList<String>();
        File t_f = Tool._libfile("$LIBDIR\\createtable.sql");
        if (t_f.exists()) {
            try {
                String buf;
                BufferedReader t_br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(t_f), charset));
                while ((buf = t_br.readLine()) != null) {
                    t_list.add(buf);
                }
                t_br.close();
            }
            catch (IOException e1) {
                Tool.logForTesting(null, e1.getMessage());
            }
        }
        return t_list;
    }

    public static @interface Updated {
        public String updated();
    }
}

