/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.gui;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.gui.TestCaseBrowser;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class AssertStatusWindow
extends JFrame {
    private JTextField curStatus;
    private JTextArea failLogs;
    private Integer n_test = 0;
    private Integer n_fail = 0;
    private Integer n_err = 0;
    public boolean ifexit = false;
    private SecondaryLoop subloop = null;

    public AssertStatusWindow() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (AssertStatusWindow.this.ifexit) {
                    if (AssertStatusWindow.this.subloop != null) {
                        AssertStatusWindow.this.subloop.exit();
                    }
                    Tool.destroy();
                }
            }
        });
        this.setResizable(false);
        this.setTitle(String.valueOf(Messages.getString("AssertStatusWisndow.0")) + "  (Copyright:Toyoaki Furusawa, 2017-)");
        this.getContentPane().setLayout(null);
        this.setAlwaysOnTop(true);
        if (TestCaseBrowser.s_curFrame == null) {
            this.setBounds(100, 100, 720, 300);
        } else {
            this.setBounds(TestCaseBrowser.s_curFrame.getX() + 100, TestCaseBrowser.s_curFrame.getY() + 100, 720, 300);
        }
        this.curStatus = new JTextField();
        this.curStatus.setBounds(12, 32, 690, 19);
        this.getContentPane().add(this.curStatus);
        this.curStatus.setColumns(10);
        this.curStatus.setForeground(Color.WHITE);
        JLabel lblStatusOfCurrent = new JLabel(Messages.getString("AssertStatusWindow.1"));
        lblStatusOfCurrent.setBounds(12, 9, 196, 13);
        this.getContentPane().add(lblStatusOfCurrent);
        JLabel lblFailHistory = new JLabel(Messages.getString("AssertStatusWindow.2"));
        lblFailHistory.setBounds(12, 61, 115, 13);
        this.getContentPane().add(lblFailHistory);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(12, 82, 690, 169);
        this.getContentPane().add(scrollPane);
        this.failLogs = new JTextArea();
        scrollPane.setViewportView(this.failLogs);
    }

    public void setResult(String res) {
        if (res != null) {
            Pattern t_pat1 = Pattern.compile("testsuite.*?tests=\"([^\"]+?)\".*?errors=\"([^\"]+?)\".*?failures=\"([^\"]+?)\"");
            Matcher t_m = t_pat1.matcher(res);
            this.n_test = 0;
            this.n_err = 0;
            this.n_fail = 0;
            while (t_m.find()) {
                String num_tests = t_m.group(1);
                String num_errs = t_m.group(2);
                String num_fails = t_m.group(3);
                this.n_test = this.n_test + new Integer(num_tests);
                this.n_err = this.n_err + new Integer(num_errs);
                this.n_fail = this.n_fail + new Integer(num_fails);
            }
            if (this.n_err + this.n_fail == 0) {
                this.curStatus.setBackground(Color.GREEN);
            } else {
                this.curStatus.setBackground(Color.RED);
            }
            this.curStatus.setText("tests(" + Integer.toString(this.n_test) + ")  ERR(" + this.n_err.toString() + ")  FAIL(" + this.n_fail.toString() + Messages.getString("AssertStatusWindow.3"));
        }
        this.failLogs.setText(res);
        this.updateWindow();
    }

    public void updateWindow() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        EventQueue eq = tk.getSystemEventQueue();
        this.subloop = eq.createSecondaryLoop();
        ShortThread t_thread = new ShortThread();
        t_thread.start();
        this.subloop.enter();
    }

    public void subLoop() {
        if (this.ifexit) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            EventQueue eq = tk.getSystemEventQueue();
            this.subloop = eq.createSecondaryLoop();
            this.subloop.enter();
        }
    }

    class ShortThread
    extends Thread {
        ShortThread() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            AssertStatusWindow.this.subloop.exit();
        }
    }
}

