/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.web;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.Fson;
import com.ftinc.si.assist.test.TestLogger;
import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.web.PagePlayer;
import com.ftinc.si.assist.test.web.WebElementGetter;
import com.google.common.base.Function;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class PageAction {
    protected static String s_elmGetter = "function _elementAtXpath(path){return document.evaluate(path,document,null,XPathResult.FIRST_ORDERED_NODE_TYPE,null).singleNodeValue;}";
    protected static int s_defaultTimeout = -1;
    protected static int s_localTimeout = 20;
    protected HashMap<String, Object> arg_map = new HashMap();
    protected String options = "";
    protected static String s_win_id = null;
    protected PageAction refer_to;
    private boolean m_fixed;
    private Integer num_prev = null;
    private Integer num_hit = null;
    private WebElement pre_hit = null;
    private Integer req_pos = 0;
    private static String s_contains = "var xrect=arguments[0].getBoundingClientRect();var _x=xrect.left+xrect.width/2;var _y=xrect.top+xrect.height/2;var _elm=document.elementFromPoint(_x,_y);return arguments[0].contains(_elm);";

    protected void setReferTo(PageAction act) {
        this.refer_to = act;
    }

    protected int getTimeout() {
        if (this.getArg("timeout") != null) {
            return new Integer(this.getArg("timeout").toString());
        }
        return s_defaultTimeout;
    }

    protected PageAction() {
        String str_n;
        if (s_defaultTimeout < 0 && (str_n = PagePlayer.getProperty("webtest.timeout")).length() > 0 && str_n.matches("^[0-9]+$")) {
            s_defaultTimeout = new Integer(str_n);
        }
        if (s_defaultTimeout < 0) {
            s_defaultTimeout = s_localTimeout;
        }
        this.m_fixed = false;
    }

    public void initAction() {
    }

    public boolean isAutomatic() {
        return true;
    }

    public ArrayList<String> doAction(WebDriver drv) {
        WebElement elm = null;
        try {
            elm = this.waitUntil(drv);
            this.doCore(drv, elm);
        }
        catch (TimeoutException e) {
            throw new NotFoundException("\t\ttimeout at " + this.getClass().getSimpleName() + " [" + e.getMessage() + "] ,where location = " + this.getTarget());
        }
        return null;
    }

    protected WebElement waitUntil(WebDriver drv) {
        By t_loc = this.getLocator();
        if (t_loc != null) {
            int t_sec = this.getTimeout();
            WebDriverWait wait = new WebDriverWait(drv, (long)t_sec);
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)t_loc));
                if (!this.m_fixed) {
                    String t_path = this.getXpath();
                    String position = (String)this.getArg("$POSITION");
                    if (position != null && position.length() > 0 && !position.equals("[1]")) {
                        if (position.matches("^\\[\\d+\\]$")) {
                            this.req_pos = new Integer(position.replaceFirst("^\\[(\\d+)\\]$", "$1"));
                        }
                        WebDriverWait wait2 = new WebDriverWait(drv, 2L, 500L);
                        try {
                            ExpectedCondition<Boolean> t_ec = new ExpectedCondition<Boolean>(){

                                public Boolean apply(WebDriver drv) {
                                    List t_list = drv.findElements(PageAction.this.getLocator());
                                    if (PageAction.this.req_pos > 0 && t_list.size() >= PageAction.this.req_pos) {
                                        if (PageAction.this.pre_hit == null) {
                                            PageAction.this.pre_hit = (WebElement)t_list.get(PageAction.this.req_pos - 1);
                                            try {
                                                Thread.sleep(200L);
                                            }
                                            catch (InterruptedException e) {
                                                e.printStackTrace();
                                            }
                                        } else {
                                            if (PageAction.this.pre_hit.equals(t_list.get(PageAction.this.req_pos - 1))) {
                                                PageAction.this.num_hit = PageAction.this.req_pos;
                                                return true;
                                            }
                                            PageAction.this.pre_hit = (WebElement)t_list.get(PageAction.this.req_pos - 1);
                                            try {
                                                Thread.sleep(200L);
                                            }
                                            catch (InterruptedException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    } else if (t_list.size() > 1) {
                                        if (PageAction.this.num_prev == null) {
                                            PageAction.this.num_prev = t_list.size();
                                        } else {
                                            if (PageAction.this.num_prev.intValue() == t_list.size()) {
                                                PageAction.this.num_hit = t_list.size();
                                                return true;
                                            }
                                            PageAction.this.num_prev = t_list.size();
                                        }
                                    } else {
                                        try {
                                            Thread.sleep(500L);
                                        }
                                        catch (InterruptedException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    return false;
                                }
                            };
                            wait2.until((Function)t_ec);
                        }
                        catch (Exception e) {
                            this.num_hit = 1;
                        }
                        if (this.num_hit > 1 && position.equals("[last()]")) {
                            position = "[" + this.num_hit.toString() + "]";
                        } else if (this.num_hit > 1 && position.indexOf("last()") > 0) {
                            String exp = position.replaceFirst("\\[(.*)\\]", "$1");
                            Integer t_n = Fson.numberByExpression(exp = exp.replace("last()", this.num_hit.toString()));
                            position = t_n != null ? "[" + t_n.toString() + "]" : "[" + this.num_hit.toString() + "]";
                        } else if (this.num_hit < 2) {
                            if (!"[1]".equals("[" + this.num_hit.toString() + "]")) {
                                Tool.logIfDebug(null, String.valueOf(t_path) + Messages.getString("PageAction.9") + position);
                            }
                            position = "[" + this.num_hit.toString() + "]";
                        } else if (this.num_hit >= this.req_pos && this.req_pos > 0) {
                            position = "[" + this.req_pos.toString() + "]";
                        }
                        if (!t_path.matches("^\\(.*\\)\\[\\d+\\]$")) {
                            t_path = "(" + t_path + ")";
                        }
                        t_path = String.valueOf(t_path) + position;
                        this.setArg("xpath", t_path);
                    }
                }
                this.m_fixed = true;
                return this.scrollToView(drv);
            }
            catch (Exception e) {
                String target = "xpath=" + this.getXpath();
                if (this.arg_map.containsKey("itemID")) {
                    target = String.valueOf(target) + " itemID=" + this.arg_map.get("itemID").toString();
                }
                throw new NotFoundException("\t\tPageAction msg=" + e.getMessage() + target);
            }
        }
        return null;
    }

    protected void doCore(WebDriver drv, WebElement elm) {
    }

    protected WebElement scrollToView(WebDriver drv) {
        return this.scrollToViewByXpath(drv, this.getXpath());
    }

    private WebElement scrollToViewByXpath(WebDriver drv, String xpath) {
        if (xpath != null) {
            int t_sec = this.getTimeout();
            WebDriverWait wait = new WebDriverWait(drv, (long)t_sec);
            WebElement elm = null;
            elm = (WebElement)ExpectedConditions.visibilityOfElementLocated((By)this.getLocator()).apply((Object)drv);
            if (elm != null) {
                if (this.isCovered(drv, elm)) {
                    TestLogger.err("Warning:" + this.getXpath() + Messages.getString("PageAction.10"));
                }
                return elm;
            }
            Actions t_acts = new Actions(drv);
            t_acts.moveToElement(elm).perform();
            elm = (WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((WebElement)elm));
            return elm;
        }
        return null;
    }

    protected boolean isCovered(WebDriver drv, WebElement elm) {
        try {
            JavascriptExecutor jsexe = (JavascriptExecutor)drv;
            Object obj = jsexe.executeScript(s_contains, new Object[]{elm});
            Boolean t_result = new Boolean(obj.toString());
            return t_result == false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected final By getLocator() {
        if (this.arg_map.containsKey("id")) {
            return By.id((String)((String)this.arg_map.get("id")));
        }
        if (this.arg_map.containsKey("xpath")) {
            return By.xpath((String)this.getXpath());
        }
        return null;
    }

    protected String getXpath() {
        String t_path = (String)this.getArg("xpath");
        if (t_path != null) {
            String position;
            if (t_path.contains("$KEY")) {
                String t_key = (String)this.getArg("$KEY");
                if (t_key != null && t_key.length() > 0) {
                    t_path = t_path.replaceAll(Pattern.quote("$KEY"), Matcher.quoteReplacement(t_key));
                } else {
                    Tool.logForTesting(null, String.valueOf(Messages.getString("PageAction.7")) + t_path + ".");
                }
            } else {
                this.m_fixed = true;
            }
            if (t_path.indexOf("$)[1]") > 0) {
                this.m_fixed = true;
                t_path = t_path.replace("$)[1]", ")[1]");
                this.setArg("xpath", t_path);
            }
            if (!this.m_fixed && (position = (String)this.getArg("$POSITION")) != null && !position.equals("[1]") && t_path.endsWith("[1]")) {
                t_path = t_path.replaceFirst("^\\((.*)\\)\\[1\\]$", "$1");
            }
            if (t_path.contains("$VAR")) {
                Object t_var = this.getArg("$VAR");
                if (t_var != null && t_var.toString().length() > 0) {
                    t_path = t_path.replaceAll(Pattern.quote("$VAR"), Matcher.quoteReplacement(t_var.toString()));
                } else {
                    Tool.logForTesting(null, String.valueOf(Messages.getString("PageAction.13")) + t_path + ".");
                }
                if (this.m_fixed) {
                    this.setArg("xpath", t_path);
                }
            }
            return t_path;
        }
        String t_id = (String)this.getArg("id");
        if (t_id != null) {
            return "//*[@id='" + t_id + "']";
        }
        return null;
    }

    protected Object getArg(String key) {
        if (this.arg_map.containsKey(key)) {
            return this.arg_map.get(key);
        }
        if (this.refer_to != null) {
            return this.refer_to.getArg(key);
        }
        return null;
    }

    protected void setArg(String key, Object value) {
        this.arg_map.put(key, value);
        if (key.startsWith("$") && this.refer_to != null) {
            this.refer_to.setArg(key, value);
        }
    }

    protected String getTarget() {
        if (this.arg_map.containsKey("xpath")) {
            return "\"xpath\":\"" + this.getXpath() + "\"";
        }
        if (this.arg_map.containsKey("id")) {
            return "\"id\":\"" + (String)this.arg_map.get("id") + "\"";
        }
        if (this.arg_map.containsKey("title")) {
            return "\"title\":\"" + (String)this.arg_map.get("title") + "\"";
        }
        return null;
    }

    protected boolean hasPath() {
        return true;
    }

    protected String getJsonElement(String target, String arg) {
        String t_result = "";
        if (target == null && arg == null) {
            t_result = Tool.getJSONfromObject(this, "^(?!s_).+");
            t_result = t_result.replaceAll("(\\A\\s*\\{|\\}\\s*\\z)", "");
            t_result = t_result.replaceAll(",", ",\n");
        } else if (target != null && target.matches("^\\s*\".+\":\".+\"\\s*[\\s\\S]*$")) {
            t_result = target;
        }
        return t_result;
    }

    protected boolean assertable() {
        return false;
    }

    protected ArrayList<String> getLabelAndParams() {
        ArrayList<String> t_list = new ArrayList<String>();
        if (this.assertable()) {
            t_list.add(Messages.getString("PageAction.6"));
            t_list.add("visible=true");
            t_list.add("visible=false");
            t_list.add("enabled=true");
            t_list.add("enabled=false");
            t_list.add(":SKIP");
        }
        return t_list;
    }

    protected String convertReg(String str) {
        if (str != null) {
            str = str.replaceFirst("=~", "").trim();
            if ("|>|<|=|".contains((str = str.replaceFirst("==", "=").trim()).substring(0, 1))) {
                return "$" + str;
            }
        } else {
            str = "";
        }
        return str;
    }

    protected ArrayList<String> getRegs() {
        if (this.assertable() && this.arg_map.get("value") != null) {
            ArrayList<String> t_list = new ArrayList<String>();
            t_list.add(this.convertReg(this.arg_map.get("value").toString()));
            return t_list;
        }
        return null;
    }

    protected String[] getFocussingXPaths(String xpath) {
        if (xpath != null && xpath.length() > 0) {
            if (!xpath.startsWith("(") && !xpath.startsWith("//")) {
                xpath = "//" + xpath;
            }
            return new String[]{xpath};
        }
        return null;
    }

    protected boolean getFocussingElements(WebDriver drv, ArrayList<WebElement> el_list, ArrayList<String> xp_list, String xpath) {
        String[] t_xpaths;
        if (drv != null && (t_xpaths = this.getFocussingXPaths(xpath)) != null) {
            int i = 0;
            while (i < t_xpaths.length) {
                List t_elms1 = drv.findElements(By.xpath((String)t_xpaths[i]));
                if (t_elms1.size() > 1) {
                    int j = 0;
                    while (j < t_elms1.size()) {
                        el_list.add((WebElement)t_elms1.get(j));
                        String str_num = "";
                        if (t_xpaths.length > 0) {
                            str_num = "[" + Integer.toString(j + 1) + "]";
                        }
                        xp_list.add("(" + t_xpaths[i] + ")" + str_num);
                        ++j;
                    }
                } else if (t_elms1.size() == 1) {
                    el_list.add((WebElement)t_elms1.get(0));
                    xp_list.add(t_xpaths[i]);
                }
                ++i;
            }
        }
        return true;
    }

    protected String getTemplateString() {
        return null;
    }

    protected JPopupMenu getPopup(WebElementGetter wg, String cur_str) {
        if (this.hasPath()) {
            JPopupMenu t_pop = new JPopupMenu();
            t_pop.add(new JMenuItem(new InsertAction("\"id\":\"\"", "AddID", wg, cur_str)));
            t_pop.add(new JMenuItem(new InsertAction("\"xpath\":\"//*[@id='']\"", "AddXpath", wg, cur_str)));
            JMenu t_menu = new JMenu(Messages.getString("PageAction.21"));
            t_menu.add(new JMenuItem(new InsertAction(Messages.getString("PageAction.22"), "EqualsText", wg, cur_str)));
            t_menu.add(new JMenuItem(new InsertAction(Messages.getString("PageAction.24"), "ContainsText", wg, cur_str)));
            t_menu.add(new JMenuItem(new InsertAction(Messages.getString("PageAction.26"), "HasTag", wg, cur_str)));
            t_pop.add(t_menu);
            return t_pop;
        }
        return null;
    }

    protected boolean modifyByKeyInput(KeyEvent e, StringBuilder strb) {
        return false;
    }

    class InsertAction
    extends AbstractAction {
        String m_string;
        String act_name;
        String m_target;
        WebElementGetter m_master;
        HashMap<String, String> m_dic = new HashMap();

        InsertAction(String str, String a_name, WebElementGetter master, String cstr) {
            this.putValue("Name", str);
            this.m_string = str;
            this.act_name = a_name;
            this.m_master = master;
            this.m_target = cstr;
            if (this.m_dic.size() == 0) {
                this.m_dic.put("ContainsText", "[contains(.,'$')]");
                this.m_dic.put("EqualsText", "[.='$']");
                this.m_dic.put("HasTag", "[.//$]");
                this.m_dic.put("ContainsText@", "[contains(@value,'$')]");
                this.m_dic.put("EqualsText@", "[@value='$']");
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (this.act_name) {
                case "HasTag": 
                case "ContainsText": 
                case "EqualsText": 
                case "ContainsText@": 
                case "EqualsText@": {
                    this.m_master.setTargetFromPopup(this.addingStringToTarget());
                    break;
                }
                case "SelectFile": {
                    JFileChooser t_fc = new JFileChooser(Tool.getPrevPath());
                    if (t_fc.showOpenDialog(this.m_master) != 0) break;
                    File t_file = t_fc.getSelectedFile();
                    String jf_name = t_file.getAbsolutePath();
                    this.m_master.setTargetFromPopup(jf_name);
                    Tool.setPrevPath(t_file.getAbsolutePath());
                    break;
                }
                default: {
                    this.m_master.setTargetFromPopup(this.m_string);
                }
            }
        }

        private String addingStringToTarget() {
            String t_data = JOptionPane.showInputDialog(this.m_master, this.m_string, "");
            String t_result = this.m_target;
            if (t_data.length() > 0) {
                String tail = this.m_dic.get(this.act_name);
                tail = tail.replaceAll("\\$", Matcher.quoteReplacement(t_data));
                if (t_result.matches("\\A[\\s\\S]*\"xpath\":\"[^\"]+\\[[0-9]+\\]\"[\\s\\S]*\\z")) {
                    tail = Matcher.quoteReplacement(String.valueOf(tail) + "\"");
                    t_result = t_result.replaceFirst("^([\\s\\S]*\"xpath\":\"[^\"]+)\\[[0-9]+\\]\"([\\s\\S]*)\\z", "$1" + tail + "$2");
                } else if (t_result.matches("\\A[\\s\\S]*\"xpath\":\"[^\"]+\"[\\s\\S]*\\z")) {
                    tail = Matcher.quoteReplacement(String.valueOf(tail) + "\"");
                    t_result = t_result.replaceFirst("^([\\s\\S]*\"xpath\":\"[^\"]+)\"([\\s\\S]*)\\z", "$1" + tail + "$2");
                } else if (t_result.matches("\\A[\\s\\S]*\\(xpath=\"[^\"]+\\[[0-9]+\\][\\s\\S]*\\z")) {
                    tail = Matcher.quoteReplacement(String.valueOf(tail) + "\"");
                    t_result = t_result.replaceFirst("\\A([\\s\\S]*\\(xpath=\"[^\"]+)\\[[0-9]+\\]\"([\\s\\S]*)\\z", "$1" + tail + "$2");
                } else if (t_result.matches("\\A[\\s\\S]*\\(xpath=\"[^\"]+\"[\\s\\S]*\\z")) {
                    tail = Matcher.quoteReplacement(String.valueOf(tail) + "\"");
                    t_result = t_result.replaceFirst("\\A([\\s\\S]*\\(xpath=\"[^\"]+)\"([\\s\\S]*)\\z", "$1" + tail + "$2");
                } else {
                    t_result = String.valueOf(t_result) + tail;
                }
            }
            return t_result;
        }
    }
}

