package com.ftinc.si.assist.test.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map.Entry;

import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.ClassOutLine;
import com.ftinc.si.assist.test.Tool;

public class ConstructorSelector extends JDialog {
	private JTextField className;
	private DefaultListModel<String> const_model = new DefaultListModel<String>();
	private JList<String> list;
	public boolean is_OK = false;
	
	public ConstructorSelector(JDialog owner, ClassOutLine co) {
		super(owner, true); // modalにする。

		setTitle(Messages.getString("ConstructorSelector.0")); //$NON-NLS-1$
		setBounds(100, 100, 450, 300);
		
		getContentPane().setLayout(null);
		
		JLabel lblClassName = new JLabel(Messages.getString("ConstructorSelector.1")); //$NON-NLS-1$
		lblClassName.setBounds(owner.getX() + 100, owner.getY() + 100, 126, 13);
		getContentPane().add(lblClassName);
		
		className = new JTextField();
		className.setEditable(false);
		className.setBounds(12, 33, 410, 19);
		getContentPane().add(className);
		className.setColumns(10);
		className.setText(co.getClassName());
		
		list = new JList<String>();
		list.setBounds(12, 62, 410, 164);
		getContentPane().add(list);
		
		initList(co);
		
		JButton btnOk = new JButton(Messages.getString("ConstructorSelector.2")); //$NON-NLS-1$
		btnOk.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				is_OK = true;
				setVisible(false);
			}
		});
		btnOk.setBounds(107, 236, 91, 21);
		getContentPane().add(btnOk);
		
		JButton btnCancel = new JButton(Messages.getString("ConstructorSelector.3")); //$NON-NLS-1$
		btnCancel.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				setVisible(false);
			}
		});
		btnCancel.setBounds(238, 236, 91, 21);
		getContentPane().add(btnCancel);
	}
	
	private void initList(ClassOutLine co) {
		HashMap<String, String> t_con = co.getDeclaredConstructors();//最後尾のクラスのフィールド一覧
		
		for(Entry<String, String> entry : t_con.entrySet()) {
			if (entry.getKey().endsWith("_name")) { //$NON-NLS-1$
				String t_key = entry.getKey();
				t_key = t_key.replaceFirst("_name", ""); //$NON-NLS-1$ //$NON-NLS-2$

				t_key = String.format("%1$03d", new Integer(t_key));//3桁の数字で先頭0埋め //$NON-NLS-1$
				Integer i = 1;
				String t_type = null;
				String t_res = ""; //$NON-NLS-1$
				boolean has_dc = true;
				
				while ((t_type = t_con.get(t_key + "_$" + i.toString())) != null) { //$NON-NLS-1$
					t_res += t_type + ","; //$NON-NLS-1$
					
					if (!Tool.hasDefaultConstructor(t_type, true)) {//true：t_typeのコンストラクタの引数はデフォルトコンストラクタを持つか引数をDB登録すべしという条件。
						has_dc = false;
					}
					i++;
				}
				//引数がprimitiveもしくはデフォルトコンストラクタがあること。
				if (has_dc) {
					t_res = t_res.substring(0, t_res.length() - 1);//最後のカンマを取る
					const_model.addElement(t_res); //$NON-NLS-1$
				}
				
			}
		}
		list.setModel(const_model);
	}
	
	//JSONEditorから呼ばれる。コンストラクタ用JSONの編集のため。引数は最初のコンストラクタを返すかどうかの指定。
	//※初期化時にJson化できるコンストラクタのみを選んでいる
	public HashMap<String, String> getParameters(boolean bfirst) {
		HashMap<String, String> res = new HashMap<String, String>();
		String t_con = null;
		if (bfirst) {
			t_con = (String)list.getModel().getElementAt(0).toString();
		} else {
			t_con = (String)list.getSelectedValue();
		}
		if (t_con != null) {
			String[] types = t_con.split(","); //$NON-NLS-1$
			if (t_con != null) {
				for (Integer i = 0; i < types.length; i++) {
					res.put("arg" + i.toString() + "(" + types[i] + ")", types[i]); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				}
			}
		}

		res.put("initialize", "java.lang.String");//初期化の空ソース
		return res;
	}
}
