/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.web;

import com.ftinc.si.assist.run.VCentral;
import com.ftinc.si.assist.test.Fson;
import com.ftinc.si.assist.test.Tool;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.openqa.selenium.WebDriver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PageAssistMenu
extends JDialog {
    private JList<String> _list;
    private ArrayList<ArrayList<String>> m_history;
    private String m_head = "";
    private DefaultListModel<String> m_model;
    public String m_answer = null;
    private WebDriver m_driver;
    private String m_src;
    private char m_c;
    private JDialog me = this;
    private Document m_xmldoc;

    public int countCandidate() {
        return this.m_model.getSize();
    }

    public void addCandidates(ArrayList<String> list) {
        Collections.sort(list);
        int i = 0;
        while (i < list.size()) {
            this.m_model.addElement(list.get(i));
            ++i;
        }
    }

    public PageAssistMenu(JDialog owner, WebDriver drv, char c, String src, Point pt) {
        super((Dialog)owner, true);
        this.m_history = new ArrayList();
        this.m_driver = drv;
        this.m_src = src;
        this.m_c = c;
        this.m_xmldoc = null;
        this.setBounds(pt.x, pt.y, 300, 200);
        this.setUndecorated(true);
        JScrollPane scrollPane = new JScrollPane();
        this.getContentPane().add((Component)scrollPane, "Center");
        this.m_model = new DefaultListModel();
        this._list = new JList<String>(this.m_model);
        this._list.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (PageAssistMenu.this.m_model.getSize() == 0) {
                    PageAssistMenu.this.setVisible(false);
                }
            }
        });
        this._list.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PageAssistMenu.this.setVisible(false);
            }
        });
        this._list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int i = PageAssistMenu.this._list.getSelectedIndex();
                if (PageAssistMenu.this.m_model.getElementAt(i) != null) {
                    PageAssistMenu.this.setVisible(false);
                    PageAssistMenu.this.m_answer = (String)PageAssistMenu.this.m_model.getElementAt(i);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PageAssistMenu.this.setVisible(false);
            }
        });
        this._list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    int i = PageAssistMenu.this._list.getSelectedIndex();
                    if (PageAssistMenu.this.m_model.getElementAt(i) != null) {
                        PageAssistMenu.this.m_answer = (String)PageAssistMenu.this.m_model.getElementAt(i);
                    }
                    PageAssistMenu.this.setVisible(false);
                } else if (e.getKeyCode() == 27 || e.getKeyCode() == 8) {
                    PageAssistMenu.this.setVisible(false);
                } else if (e.getKeyCode() == 37) {
                    if (PageAssistMenu.this.m_history.size() == 0) {
                        PageAssistMenu.this.setVisible(false);
                    } else {
                        ArrayList t_list = (ArrayList)PageAssistMenu.this.m_history.get(PageAssistMenu.this.m_history.size() - 1);
                        PageAssistMenu.this.m_head = PageAssistMenu.this.m_head.substring(0, PageAssistMenu.this.m_head.length() - 1);
                        PageAssistMenu.this.m_model.removeAllElements();
                        int i = 0;
                        while (i < t_list.size()) {
                            PageAssistMenu.this.m_model.addElement((String)t_list.get(i));
                            ++i;
                        }
                        PageAssistMenu.this.m_history.remove(t_list);
                    }
                } else {
                    String t_char = Character.toString(e.getKeyChar());
                    if (t_char.matches("[\\w_\\-#!@/]")) {
                        ArrayList<String> t_list = new ArrayList<String>();
                        PageAssistMenu pageAssistMenu = PageAssistMenu.this;
                        pageAssistMenu.m_head = String.valueOf(pageAssistMenu.m_head) + t_char;
                        int i = PageAssistMenu.this.m_model.getSize() - 1;
                        while (i >= 0) {
                            String t_elm = (String)PageAssistMenu.this.m_model.get(i);
                            t_list.add(t_elm);
                            if (!t_elm.toLowerCase().startsWith(PageAssistMenu.this.m_head)) {
                                PageAssistMenu.this.m_model.remove(i);
                            }
                            --i;
                        }
                        Collections.sort(t_list);
                        PageAssistMenu.this.m_history.add(t_list);
                        if (PageAssistMenu.this.m_model.getSize() == 0) {
                            PageAssistMenu.this.m_answer = PageAssistMenu.this.m_head;
                            PageAssistMenu.this.setVisible(false);
                        }
                    }
                }
            }
        });
        scrollPane.setViewportView(this._list);
        if (src != null) {
            this.initMenu();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                    SwingUtilities.getWindowAncestor(PageAssistMenu.this.me).toFront();
                    if (PageAssistMenu.this.countCandidate() > 0) {
                        PageAssistMenu.this._list.setSelectedIndex(0);
                        PageAssistMenu.this._list.requestFocusInWindow();
                    } else {
                        PageAssistMenu.this.setVisible(false);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private ArrayList<String> getAttrListForXPATH() {
        Pattern t_pat0 = null;
        Pattern t_pat1 = null;
        Pattern t_pat2 = null;
        String a_name = null;
        if (this.m_c == '=') {
            t_pat0 = Pattern.compile("^\\(.*xpath\\s*=\\s*\"([^\"]+)\\[@([\\w\\-]+)$");
            t_pat1 = Pattern.compile("\"xpath\":\"([^\"]+)\\[@([\\w\\-]+)$");
            t_pat2 = Pattern.compile("^([^\"]+)\\[@([\\w\\-]+)$");
            Matcher t_m = t_pat0.matcher(this.m_src);
            if (t_m.find()) {
                String cpath = t_m.group(1);
                a_name = t_m.group(2);
                return this.pickAttrsFromHtml(cpath, a_name);
            }
            t_m = t_pat1.matcher(this.m_src);
            if (t_m.find()) {
                String cpath = t_m.group(1);
                a_name = t_m.group(2);
                return this.pickAttrsFromHtml(cpath, a_name);
            }
            t_m = t_pat2.matcher(this.m_src);
            if (t_m.find()) {
                String cpath = t_m.group(1);
                a_name = t_m.group(2);
                return this.pickAttrsFromHtml(cpath, a_name);
            }
        } else if (this.m_c == '@') {
            t_pat0 = Pattern.compile("^\\(.*xpath\\s*=\\s*\"(.+\\]?)\\[.*?$");
            t_pat1 = Pattern.compile("\"xpath\":\"(.+\\]?)\\[.*?$");
            t_pat2 = Pattern.compile("^([^\"]+\\]?)\\[[^\\[\\]]*?$");
            Matcher t_m = t_pat0.matcher(this.m_src);
            if (t_m.find()) {
                String cpath = Fson.restore(t_m.group(1));
                return this.pickAttrsFromHtml(cpath, null);
            }
            t_m = t_pat1.matcher(this.m_src);
            if (t_m.find()) {
                String cpath = Fson.restore(t_m.group(1));
                return this.pickAttrsFromHtml(cpath, null);
            }
            t_m = t_pat2.matcher(this.m_src);
            if (t_m.find()) {
                String cpath = Fson.restore(t_m.group(1));
                return this.pickAttrsFromHtml(cpath, null);
            }
        }
        return null;
    }

    private ArrayList<String> pickAttrsFromHtml(String xpath, String attrName) {
        String t_html = this.m_driver.getPageSource();
        if (xpath.startsWith("//")) {
            xpath = xpath.substring(2);
        }
        if (xpath.matches("^[\\w\\-]+?::.*$")) {
            xpath = xpath.replaceFirst("^[\\w\\-]+?::", "");
        }
        String e_msg = "Xpath=" + xpath + " not found.";
        try {
            if (this.m_xmldoc == null) {
                DocumentBuilderFactory t_fact = DocumentBuilderFactory.newInstance();
                DocumentBuilder t_builder = t_fact.newDocumentBuilder();
                try {
                    this.m_xmldoc = t_builder.parse(new ByteArrayInputStream(t_html.getBytes("UTF-8")));
                }
                catch (SAXException e) {
                    t_html = VCentral.html2XML(t_html);
                    this.m_xmldoc = t_builder.parse(new ByteArrayInputStream(t_html.getBytes("UTF-8")));
                }
            }
            XPath t_xpath = XPathFactory.newInstance().newXPath();
            e_msg = "Xpath.evaluate error: //" + xpath;
            NodeList n_list = null;
            if (attrName != null && attrName.length() > 0) {
                e_msg = "Xpath=//" + xpath + "[@" + attrName + "]/@" + attrName + " not found.";
                n_list = (NodeList)t_xpath.evaluate("//" + xpath + "[@" + attrName + "]/@" + attrName, this.m_xmldoc, XPathConstants.NODESET);
            } else {
                e_msg = "Xpath=//" + xpath + "[@*]/@*" + " not found.";
                n_list = (NodeList)t_xpath.evaluate("//" + xpath + "[@*]/@*", this.m_xmldoc, XPathConstants.NODESET);
            }
            ArrayList<String> t_list = new ArrayList<String>();
            int i = 0;
            while (i < n_list.getLength()) {
                Node t_elm = n_list.item(i);
                String a_value = t_elm.toString();
                String[] str_values = null;
                if (attrName != null) {
                    a_value = a_value.replaceFirst("^" + attrName + "=\"(.*)\"$", "$1");
                    str_values = "style".equals(attrName) ? a_value.split("\\s*;\\s*", -1) : a_value.split("\\s+", -1);
                } else {
                    a_value = a_value.replaceFirst("^([^\"]+)=.*$", "$1");
                    str_values = new String[]{a_value};
                }
                String t_tail = "";
                if (attrName != null && str_values.length > 1) {
                    t_tail = "\t   :" + attrName;
                }
                int j = 0;
                while (j < str_values.length) {
                    String t_val;
                    if (!t_list.contains(str_values[j]) && (t_val = str_values[j]).length() > 0) {
                        t_list.add(String.valueOf(t_val) + t_tail);
                    }
                    ++j;
                }
                ++i;
            }
            if (t_list.size() > 0) {
                Collections.sort(t_list);
                return t_list;
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            e.printStackTrace();
            Tool.alertMSG(null, String.valueOf(e_msg) + e.getMessage() + " in pickAttrsFromHtml.\nhtml =\n" + t_html);
        }
        return null;
    }

    private void initMenu() {
        ArrayList<String> t_list = this.getAttrListForXPATH();
        if (t_list != null && t_list.size() > 0) {
            int i = 0;
            while (i < t_list.size()) {
                if (!this.m_model.contains(t_list.get(i))) {
                    this.m_model.addElement(t_list.get(i));
                }
                ++i;
            }
        }
    }
}

