/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.web;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.TestLogger;
import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.web.PageAction;
import com.ftinc.si.assist.test.web.PagePlayer;
import com.ftinc.si.assist.test.web.SnapshotException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.imageio.ImageIO;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class Snap
extends PageAction {
    private PageAction cur_action = null;

    public Snap() {
    }

    public Snap(PageAction caction) {
        this.cur_action = caction;
    }

    @Override
    protected WebElement waitUntil(WebDriver drv) {
        return null;
    }

    @Override
    protected void doCore(WebDriver drv, WebElement elm) {
        String t_msg2;
        String t_msg;
        File t_f;
        if (drv instanceof TakesScreenshot) {
            String fname = this.makeFileName(drv);
            t_f = this.createJPEGFile(drv, fname);
            t_msg = "";
            if (this.cur_action != null) {
                t_msg = String.valueOf(t_msg) + this.cur_action.getClass().getSimpleName() + "(" + this.cur_action.getTarget() + ")";
            }
            t_msg2 = "";
            if (this.arg_map.containsKey("value")) {
                t_msg2 = this.arg_map.get("value").toString();
            }
            if ((t_msg2 == null || t_msg.length() == 0) && this.arg_map.containsKey("message")) {
                t_msg2 = this.arg_map.get("message").toString();
            }
        } else {
            throw new SnapshotException("\t\tsnap " + Messages.getString("Snap.10"));
        }
        this.addMessage(t_f, String.valueOf(Tool.curCase) + "(" + Integer.toString(Tool.curID) + "): " + t_msg + t_msg2);
    }

    private File createJPEGFile(WebDriver drv, String fname) {
        File t_out = new File(fname);
        File temp_png = null;
        try {
            temp_png = (File)((TakesScreenshot)drv).getScreenshotAs(OutputType.FILE);
            BufferedImage t_image = ImageIO.read(temp_png);
            BufferedImage tmp_raw = new BufferedImage(t_image.getWidth(), t_image.getHeight(), 1);
            Graphics2D t_g2d = tmp_raw.createGraphics();
            t_g2d.drawImage(t_image, 0, 0, Color.WHITE, null);
            ImageIO.write((RenderedImage)tmp_raw, "jpg", t_out);
        }
        catch (IOException e) {
            throw new SnapshotException("\t\tsnap file=" + fname + Messages.getString("Snap.2") + " msg =" + e.getMessage());
        }
        return t_out;
    }

    private String makeFileName(WebDriver drv) {
        File t_snapdir;
        String t_header = "";
        if (this.arg_map.get("file_header") != null) {
            t_header = String.valueOf(this.arg_map.get("file_header").toString()) + "!";
        }
        t_header = String.valueOf(t_header) + Tool.replaceB(TestLogger.cmdName(), ".", "_");
        Date t_date = new Date();
        SimpleDateFormat t_sfmt = new SimpleDateFormat("yyyyMMddhhmmssSSS");
        String f_name = null;
        f_name = PagePlayer.getProperty("webtest.snap.folder");
        if (f_name == null) {
            f_name = String.valueOf(Tool.s_userdir) + "\\snap";
        }
        if (!(t_snapdir = new File(f_name = Tool.convert2Alias("path", f_name))).exists()) {
            t_snapdir.mkdir();
        }
        f_name = String.valueOf(f_name) + "\\" + Tool.repairFileName(String.valueOf(t_header) + "@" + t_sfmt.format(t_date)) + ".jpg";
        return f_name;
    }

    @Override
    protected boolean getFocussingElements(WebDriver drv, ArrayList<WebElement> el_list, ArrayList<String> xp_list, String xpaths) {
        return false;
    }

    private void addMessage(File fin, Object msg) {
        if (PagePlayer.getProperty("webtest.exifcmd").length() > 0) {
            String[] t_params = PagePlayer.getProperty("webtest.exifcmd").split("\\\\,");
            File cmd_file = Tool._libfile(t_params[0]);
            if (!cmd_file.exists()) {
                Tool.logIfDebug(null, "not found exif_exe=" + cmd_file.getAbsolutePath());
                throw new SnapshotException(String.valueOf(t_params[0]) + Messages.getString("Snap.11") + msg + "]");
            }
            ArrayList<String> t_cmds = new ArrayList<String>();
            String t_msg = msg.toString();
            t_msg = t_msg.replaceAll("[\\s\"']", "_");
            t_msg = Tool.esq4CMD(t_msg);
            int i = 0;
            while (i < t_params.length) {
                String t_str = t_params[i];
                if (t_str.matches("^.*\\$MSG.*$")) {
                    t_str = t_str.replace("$MSG", t_msg);
                    try {
                        t_str = new String(t_str.getBytes("ISO-10646-UCS-2"), "ISO-10646-UCS-2");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new SnapshotException("Failed to translate '" + t_str + "' to UTF-16.");
                    }
                }
                t_cmds.add(t_str);
                ++i;
            }
            String f_name = fin.getAbsolutePath();
            t_cmds.add("\"" + f_name + "\"");
            StringBuilder t_result = new StringBuilder();
            int t_res = 0;
            try {
                t_res = Tool.executeCommand(t_result, fin.getParent(), t_cmds.toArray(new String[t_cmds.size()]));
                if (t_res != 0) {
                    throw new SnapshotException(String.valueOf(t_result.toString()) + "[\n" + msg + "]");
                }
            }
            catch (Exception e) {
                throw new SnapshotException(String.valueOf(t_result.toString()) + "[\n" + msg + "]");
            }
            Tool.logIfDebug(null, "succeeded to edit exif area:" + msg);
        }
    }
}

