/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.web;

import com.ftinc.si.assist.test.Tool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DayForTest {
    protected static String[] weekday_name = new String[]{"sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"};
    protected static String[] weekday_jname = new String[]{"\u65e5\u66dc\u65e5", "\u6708\u66dc\u65e5", "\u706b\u66dc\u65e5", "\u6c34\u66dc\u65e5", "\u6728\u66dc\u65e5", "\u91d1\u66dc\u65e5", "\u571f\u66dc\u65e5"};
    private static ArrayList<String> s_national_holidays = null;
    private static ArrayList<String> s_holidays = null;

    public static void initDayForTest() {
        File t_holidayfile = Tool._libfile("$LIBDIR\\holidays_*.txt");
        if (t_holidayfile != null && t_holidayfile.exists()) {
            try {
                HashMap _map;
                String t_line;
                FileReader t_r = new FileReader(t_holidayfile);
                String t_json = "";
                BufferedReader t_buf = new BufferedReader(t_r);
                while ((t_line = t_buf.readLine()) != null) {
                    t_json = String.valueOf(t_json) + t_line;
                }
                t_buf.close();
                t_r.close();
                if (t_json != null && t_json.length() > 0 && (_map = (HashMap)Tool.getObjectfromJSON(HashMap.class, t_json)) != null) {
                    s_national_holidays = (ArrayList)_map.get("nationals");
                    s_holidays = (ArrayList)_map.get("holidays");
                }
            }
            catch (IOException e) {
                Tool.logIfDebug(e, e.getMessage());
            }
        }
    }

    protected static ArrayList<String> fixedDayOff() {
        ArrayList<String> t_list;
        if (s_holidays == null) {
            DayForTest.initDayForTest();
        }
        if ((t_list = s_holidays) == null) {
            t_list = new ArrayList();
        }
        return t_list;
    }

    protected static ArrayList<String> nationalHolidays() {
        ArrayList<String> t_list;
        if (s_national_holidays == null) {
            DayForTest.initDayForTest();
        }
        if ((t_list = s_national_holidays) == null) {
            t_list = new ArrayList();
        }
        return t_list;
    }

    protected static String replace(Pattern pat, String str, int val) {
        Matcher t_m = pat.matcher(str);
        if (t_m.find()) {
            return t_m.replaceFirst(Integer.toString(val));
        }
        return str;
    }

    protected static ArrayList<Integer> lengthList(String fmt) {
        ArrayList<Integer> t_list = new ArrayList<Integer>();
        Pattern t_pat = Pattern.compile("^.*?[^ymd]*?(y+)[^ymd]*?.*?$");
        Matcher t_m = t_pat.matcher(fmt);
        if (t_m.find()) {
            t_list.add(t_m.group(1).length());
        } else {
            t_list.add(0);
        }
        t_pat = Pattern.compile("^.*?[^ymd]*?(m+)[^ymd]*?.*?$");
        t_m = t_pat.matcher(fmt);
        if (t_m.find()) {
            t_list.add(t_m.group(1).length());
        } else {
            t_list.add(0);
        }
        t_pat = Pattern.compile("^.*?[^ymd]*?(d+)[^ymd]*?.*?$");
        t_m = t_pat.matcher(fmt);
        if (t_m.find()) {
            t_list.add(t_m.group(1).length());
        } else {
            t_list.add(0);
        }
        return t_list;
    }

    protected static String toDateString(String template, ArrayList<Integer> lenlist, int year, int month, int day) {
        String str_y = String.format("%04d", year);
        String str_m = String.format("%02d", month);
        String str_d = String.format("%02d", day);
        if (lenlist.get(0) > 0) {
            template = template.replaceFirst("y+", str_y.substring(str_y.length() - lenlist.get(0), str_y.length()));
        }
        if (lenlist.get(1) > 0) {
            template = template.replaceFirst("m+", str_m.substring(str_m.length() - lenlist.get(1), str_m.length()));
        }
        if (lenlist.get(2) > 0) {
            template = template.replaceFirst("d+", str_d.substring(str_d.length() - lenlist.get(2), str_d.length()));
        }
        return template;
    }

    public static String today(String[] strs) {
        String day_template = strs[0];
        ArrayList<Integer> f_list = DayForTest.lengthList(day_template);
        Calendar t_clndr = Calendar.getInstance();
        int t_year = t_clndr.get(1);
        int t_month = t_clndr.get(2) + 1;
        int t_day = t_clndr.get(5);
        return DayForTest.toDateString(day_template, f_list, t_year, t_month, t_day);
    }

    public static String nextBusinessDay(String[] strs) {
        String day_template = strs[0];
        ArrayList<Integer> f_list = DayForTest.lengthList(day_template);
        Calendar t_clndr = Calendar.getInstance();
        int i = 0;
        while (i < 31) {
            String x_year = Integer.toString(t_clndr.get(1));
            String x_month = Integer.toString(t_clndr.get(2) + 1);
            String x_day = Integer.toString(t_clndr.get(5));
            int w_day = t_clndr.get(7) - 1;
            if (!DayForTest.fixedDayOff().contains(weekday_name[w_day]) && !DayForTest.nationalHolidays().contains(String.valueOf(x_year) + "/" + x_month + "/" + x_day)) {
                return DayForTest.toDateString(day_template, f_list, t_clndr.get(1), t_clndr.get(2) + 1, t_clndr.get(5));
            }
            t_clndr.add(5, 1);
            ++i;
        }
        return null;
    }

    public static String nextWeekday(String[] strs) {
        if (strs.length < 1) {
            Tool.logIfDebug(null, "ERROR: unexpected # of arguments @nextWeekday");
            return "ERROR: unexpected # of arguments @nextWeekday";
        }
        String day_template = strs[0];
        ArrayList<Integer> f_list = DayForTest.lengthList(day_template);
        Calendar t_clndr = Calendar.getInstance();
        int i = 0;
        while (i < 31) {
            int w_day = t_clndr.get(7) - 1;
            if (strs[1].toLowerCase().equals(weekday_name[w_day]) || strs[1].equals(weekday_jname[w_day])) {
                return DayForTest.toDateString(day_template, f_list, t_clndr.get(1), t_clndr.get(2) + 1, t_clndr.get(5));
            }
            t_clndr.add(5, 1);
            ++i;
        }
        return null;
    }

    public static String nextHoliday(String[] strs) {
        String day_template = strs[0];
        ArrayList<Integer> f_list = DayForTest.lengthList(day_template);
        Calendar t_clndr = Calendar.getInstance();
        int i = 0;
        while (i < 31) {
            String x_year = Integer.toString(t_clndr.get(1));
            String x_month = Integer.toString(t_clndr.get(2) + 1);
            String x_day = Integer.toString(t_clndr.get(5));
            if (DayForTest.nationalHolidays().contains(String.valueOf(x_year) + "/" + x_month + "/" + x_day)) {
                return DayForTest.toDateString(day_template, f_list, t_clndr.get(1), t_clndr.get(2) + 1, t_clndr.get(5));
            }
            t_clndr.add(5, 1);
            ++i;
        }
        return null;
    }

    public static String nextBusinessDayAfter(String[] strs) {
        return DayForTest.lookupBusinessDayAround(strs, 1);
    }

    public static String nextBusinessDayBefore(String[] strs) {
        return DayForTest.lookupBusinessDayAround(strs, -1);
    }

    private static Integer[] getDateFromString(String template, String str_date) {
        String reg_y = "";
        Pattern pat_y = Pattern.compile("([^ymd]*)y+([^ymd]*)");
        Matcher t_m = pat_y.matcher(template);
        if (t_m.find() && (t_m.group(1).length() > 0 || t_m.group(2).length() > 0)) {
            reg_y = t_m.group(1).length() == 0 ? "^" : Pattern.quote(t_m.group(1));
            reg_y = String.valueOf(reg_y) + "(\\d+)";
            reg_y = t_m.group(2).length() == 0 ? String.valueOf(reg_y) + "$" : String.valueOf(reg_y) + Pattern.quote(t_m.group(2));
        }
        String reg_m = "";
        Pattern pat_m = Pattern.compile("([^ymd]*)m+([^ymd]*)");
        t_m = pat_m.matcher(template);
        if (t_m.find() && (t_m.group(1).length() > 0 || t_m.group(2).length() > 0)) {
            reg_m = t_m.group(1).length() == 0 ? "^" : Pattern.quote(t_m.group(1));
            reg_m = String.valueOf(reg_m) + "(\\d+)";
            reg_m = t_m.group(2).length() == 0 ? String.valueOf(reg_m) + "$" : String.valueOf(reg_m) + Pattern.quote(t_m.group(2));
        }
        String reg_d = "";
        Pattern pat_d = Pattern.compile("([^dym]*)d+([^ymd]*)");
        t_m = pat_d.matcher(template);
        if (t_m.find() && (t_m.group(1).length() > 0 || t_m.group(2).length() > 0)) {
            reg_d = t_m.group(1).length() == 0 ? "^" : Pattern.quote(t_m.group(1));
            reg_d = String.valueOf(reg_d) + "(\\d+)";
            reg_d = t_m.group(2).length() == 0 ? String.valueOf(reg_d) + "$" : String.valueOf(reg_d) + Pattern.quote(t_m.group(2));
        }
        Calendar t_clndr = Calendar.getInstance();
        Integer x_year = t_clndr.get(1);
        Integer x_month = t_clndr.get(2) + 1;
        Integer x_day = t_clndr.get(5);
        String str_year = x_year.toString();
        String str_month = x_month.toString();
        String str_day = x_day.toString();
        t_clndr.set(x_year, x_month - 1, x_day);
        int status = 2;
        Pattern t_pat = Pattern.compile(reg_y);
        t_m = t_pat.matcher(str_date);
        if (t_m.find()) {
            str_year = t_m.group(1);
        } else {
            status = 1;
        }
        t_pat = Pattern.compile(reg_m);
        t_m = t_pat.matcher(str_date);
        if (t_m.find()) {
            str_month = t_m.group(1);
        } else {
            status = 0;
        }
        t_pat = Pattern.compile(reg_d);
        t_m = t_pat.matcher(str_date);
        if (t_m.find()) {
            str_day = t_m.group(1);
        }
        x_day = Integer.valueOf(str_day);
        x_month = Integer.valueOf(str_month);
        x_year = Integer.valueOf(str_year);
        Calendar t_clndr2 = Calendar.getInstance();
        t_clndr2.set(x_year, x_month - 1, x_day);
        if (t_clndr2.before(t_clndr)) {
            if (status == 1) {
                x_year = x_year + 1;
            } else if (status == 0) {
                t_clndr2.add(2, 1);
                x_year = t_clndr.get(1);
                x_month = t_clndr.get(2) + 1;
                x_day = t_clndr.get(5);
            }
        }
        return new Integer[]{x_year, x_month, x_day};
    }

    public static String lookupBusinessDayAround(String[] strs, int n) {
        String day_template = strs[0];
        ArrayList<Integer> f_list = DayForTest.lengthList(day_template);
        Integer[] t_date = DayForTest.getDateFromString(day_template, strs[1]);
        if (t_date == null) {
            return null;
        }
        Integer x_year = t_date[0];
        Integer x_month = t_date[1];
        Integer x_day = t_date[2];
        Calendar t_clndr = Calendar.getInstance();
        t_clndr.set(x_year, x_month - 1, x_day);
        int i = 0;
        while (i < 31) {
            String t_year = Integer.toString(t_clndr.get(1));
            String t_month = Integer.toString(t_clndr.get(2) + 1);
            String t_day = Integer.toString(t_clndr.get(5));
            int w_day = t_clndr.get(7) - 1;
            if (!DayForTest.fixedDayOff().contains(weekday_name[w_day]) && !DayForTest.nationalHolidays().contains(String.valueOf(t_year) + "/" + t_month + "/" + t_day)) {
                return DayForTest.toDateString(day_template, f_list, t_clndr.get(1), t_clndr.get(2) + 1, t_clndr.get(5));
            }
            t_clndr.add(5, n);
            ++i;
        }
        return null;
    }
}

