/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test;

import com.ftinc.si.assist.test.AssertRecord;
import com.ftinc.si.assist.test.ObjectRecord;
import com.ftinc.si.assist.test.Record;
import com.ftinc.si.assist.test.TestCaseIF;
import com.ftinc.si.assist.test.Tool;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TestCaseRecord
extends Record
implements TestCaseIF {
    public String name;
    public String description;
    public int begin;
    public int end;
    public int snapshot = 0;
    public String include = "NONE";
    public boolean loggable = true;
    public String groupCode = Tool.group_code;
    public String version = Tool.version;
    public static int s_unitSize = 100;
    public ObjectRecord[] snapshot_Args;
    public AssertRecord snapshot_Assert;

    public TestCaseRecord() {
        super(0);
    }

    public TestCaseRecord(int i) {
        super(i);
        if (i == 2) {
            this.name = "NEW";
            this.description = "To Be Filled.";
            this.loggable = true;
            this.snapshot = 0;
            this.include = "NONE";
        }
    }

    public TestCaseRecord(int i, String[] rec) {
        super(i);
        if (rec.length > 0) {
            this.name = rec[0].trim();
        }
        if (rec.length > 1) {
            this.description = rec[1].trim();
        }
        if (rec.length > 2) {
            this.begin = Integer.valueOf(rec[2].trim());
        }
        if (rec.length > 3) {
            this.end = Integer.valueOf(rec[3].trim());
        }
        if (rec.length > 4) {
            this.loggable = Boolean.valueOf(rec[4].trim());
        }
        if (rec.length > 5) {
            this.snapshot = Integer.valueOf(rec[5].trim());
        }
        if (rec.length > 6) {
            this.include = rec[6].trim();
        }
        if (rec.length > 7) {
            this.groupCode = rec[7].trim();
        }
        if (rec.length > 8) {
            this.version = rec[8].trim();
        }
    }

    public boolean isEquivalentTo(TestCaseRecord rec) {
        if (!this.name.equals(rec.name)) {
            return false;
        }
        if (!this.description.equals(rec.description)) {
            return false;
        }
        if (!this.include.equals(rec.include)) {
            return false;
        }
        if (!this.version.equals(rec.version)) {
            return false;
        }
        if (!this.groupCode.equals(rec.groupCode)) {
            return false;
        }
        if (this.begin != rec.begin) {
            return false;
        }
        if (this.end != rec.end) {
            return false;
        }
        if (this.loggable != rec.loggable) {
            return false;
        }
        if (this.loggable != rec.loggable) {
            return false;
        }
        return this.snapshot == rec.snapshot;
    }

    public String getCmdArgsStyle() {
        String t_result = "[";
        t_result = String.valueOf(t_result) + "\"" + this.name + "\"";
        t_result = String.valueOf(t_result) + ",\"" + this.description + "\"";
        t_result = String.valueOf(t_result) + ",\"" + Integer.toString(this.begin) + "\"";
        t_result = String.valueOf(t_result) + ",\"" + Integer.toString(this.end) + "\"";
        t_result = String.valueOf(t_result) + ",\"" + Boolean.toString(this.loggable) + "\"";
        t_result = String.valueOf(t_result) + ",\"" + Integer.toString(this.snapshot) + "\"";
        t_result = String.valueOf(t_result) + ",\"" + this.include + "\"";
        t_result = String.valueOf(t_result) + ",\"" + this.groupCode + "\"";
        t_result = String.valueOf(t_result) + ",\"" + this.version + "\"";
        return String.valueOf(t_result) + "]";
    }

    @Override
    public void read(ResultSet r) throws SQLException {
        this.name = r.getString("Name");
        this.description = r.getString("Description");
        this.begin = r.getInt("Begin");
        this.end = r.getInt("End");
        this.loggable = r.getBoolean("Loggable");
        this.snapshot = r.getInt("Snapshot");
        this.include = r.getString("Include");
        this.groupCode = r.getString("GroupCode");
        this.version = r.getString("Version");
    }

    public TestCaseRecord _dup() {
        TestCaseRecord t_rec = new TestCaseRecord(0);
        t_rec.name = this.name;
        t_rec.description = this.description;
        t_rec.begin = this.begin;
        t_rec.end = this.end;
        t_rec.loggable = this.loggable;
        t_rec.snapshot = this.snapshot;
        t_rec.include = this.include;
        t_rec.groupCode = this.groupCode;
        t_rec.version = this.version;
        return t_rec;
    }

    @Override
    public String getUpdateSQL() {
        if (this.removed && this.isNew()) {
            return null;
        }
        String str_conds = "";
        if (Tool.group_code.length() != 0) {
            str_conds = " and \"GroupCode\"='" + this.esq(this.groupCode) + "'";
        }
        if (this.version != null && this.version.length() > 0) {
            str_conds = String.valueOf(str_conds) + " and \"Version\"='" + this.version + "'";
        }
        if (this.removed) {
            if (this.begin > 0 && this.end > 0) {
                return "delete from \"tbl_TestCaseRecord\" where \"Begin\"='" + Integer.toString(this.begin) + "' and \"End\"='" + Integer.toString(this.end) + "' and \"Name\"='" + this.name + "'" + str_conds;
            }
            return "delete from \"tbl_TestCaseRecord\" where \"Name\"='" + this.name + "'" + str_conds;
        }
        if (this.isNew()) {
            return "insert into \"tbl_TestCaseRecord\" (\"Name\", \"Description\", \"Begin\", \"End\", \"Snapshot\", \"Include\", \"Loggable\", \"GroupCode\", \"Version\") values ('" + this.name + "','" + this.description + "','" + Integer.toString(this.begin) + "','" + Integer.toString(this.end) + "','" + String.valueOf(this.snapshot) + "','" + this.esq(this.include) + "','" + Boolean.toString(this.loggable) + "','" + this.esq(this.groupCode) + "','" + this.version + "')";
        }
        if (this.isUpdated()) {
            String[] names = this.name.split("\t");
            String cond_name = "\"Name\"='" + this.name;
            String set_name = "";
            if (names.length > 1) {
                cond_name = "\"Name\"='" + names[1];
                set_name = "\"Name\"='" + names[0] + "',";
            }
            return "update \"tbl_TestCaseRecord\" set " + set_name + " \"Description\"='" + this.description + "', \"Loggable\"='" + Boolean.toString(this.loggable) + "', \"Snapshot\"='" + Integer.toString(this.snapshot) + "', \"Include\"='" + this.esq(this.include) + "' where " + cond_name + "' and \"Begin\"='" + Integer.toString(this.begin) + "' and \"End\"='" + Integer.toString(this.end) + "'" + str_conds;
        }
        return null;
    }

    @Override
    public String getCaseName() {
        return this.name;
    }

    @Override
    public String getIncludeCase() {
        return this.include;
    }

    @Override
    public String getGroupCode() {
        return this.groupCode;
    }
}

