/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.run.VCentral;
import com.ftinc.si.assist.test.AssertRecord;
import com.ftinc.si.assist.test.Fson;
import com.ftinc.si.assist.test.Record;
import com.ftinc.si.assist.test.TestCommandIF;
import com.ftinc.si.assist.test.Tool;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.NotFoundException;

public class TestCommandRecord
extends Record
implements TestCommandIF {
    public int id;
    public String subject;
    public String className;
    public String methodName;
    public String returnType;
    public String testCase;
    public String[][] argTypes;
    public String argStatus;

    public TestCommandRecord() {
        super(0);
    }

    public TestCommandRecord(int i) {
        super(i);
    }

    @Override
    public void read(ResultSet r) throws SQLException {
        this.testCase = r.getString("TestCase");
        this.id = r.getInt("ID");
        this.className = r.getString("ClassName");
        this.methodName = r.getString("MethodName");
        this.returnType = r.getString("ReturnType");
        this.subject = r.getString("Subject");
        this.setArgTypes(r.getString("ArgTypes"));
        this.enable = r.getBoolean("Enable");
        this.argStatus = r.getString("ArgStatus");
    }

    public TestCommandRecord _dup(int nID) {
        TestCommandRecord t_rec = new TestCommandRecord(2);
        t_rec.id = nID;
        t_rec.subject = this.subject;
        t_rec.className = this.className;
        t_rec.methodName = this.methodName;
        t_rec.returnType = this.returnType;
        t_rec.testCase = this.testCase;
        t_rec.argTypes = (String[][])this.argTypes.clone();
        t_rec.enable = this.enable;
        t_rec.argStatus = this.argStatus;
        return t_rec;
    }

    @Override
    public boolean isStatic() {
        if (this.methodName.startsWith("static")) {
            return true;
        }
        if (this.methodName.indexOf("$replay") >= 0) {
            String t_id = this.methodName.replaceFirst("^\\$replay\\(\\s*(\\d+)\\s*\\).*$", "$1");
            TestCommandRecord t_rec = Tool._db().getTestCmd(t_id);
            if (t_rec != null) {
                return t_rec.isStatic();
            }
        }
        return false;
    }

    @Override
    public int varArgsPos() {
        if (this.methodName.matches("^.*\\s([0-9]+)$")) {
            String s = this.methodName.replaceFirst("^.*\\s([0-9]+)$", "$1");
            return Integer.valueOf(s);
        }
        return -1;
    }

    public int numArgs() {
        if (this.argTypes == null) {
            return 0;
        }
        return this.argTypes.length;
    }

    public String getArgClassByName(String name) {
        if ("$_".equals(name)) {
            return this.returnType;
        }
        if ("$0".equals(name)) {
            return this.className;
        }
        if (name.matches("^\\$[0-9]+$")) {
            String num = name.substring(1);
            return this.getArgClass(Integer.valueOf(num) - 1);
        }
        return null;
    }

    public String getArgClass(int i) {
        if (this.numArgs() > 0) {
            return this.argTypes[i][0];
        }
        return "";
    }

    public String getArgStack(int i) {
        if (this.numArgs() > 0) {
            return this.argTypes[i][1];
        }
        return "";
    }

    private String getArgJSON() {
        if (this.argTypes != null) {
            return Tool.getJSONfromObject(this.argTypes);
        }
        return "";
    }

    public void setArgType(int n, String cname, String stack) {
        if (this.numArgs() > 0) {
            this.argTypes[n][0] = cname;
            this.argTypes[n][1] = stack;
            this.changed();
        }
    }

    public void setArgTypes(String json) {
        this.argTypes = json == null || json.length() == 0 ? new String[0][] : (String[][])Tool.getObjectfromJSON(String[][].class, json);
    }

    public void addArg(String cname, String stack) {
        ArrayList<String[]> t_list = new ArrayList<String[]>();
        int i = 0;
        while (i < this.numArgs()) {
            t_list.add(this.argTypes[i]);
            ++i;
        }
        t_list.add(new String[]{cname, stack});
        this.argTypes = (String[][])t_list.toArray((T[])new String[t_list.size()][]);
    }

    public void removeLast() {
        ArrayList<String[]> t_list = new ArrayList<String[]>();
        int i = 0;
        while (i < this.numArgs() - 1) {
            t_list.add(this.argTypes[i]);
            ++i;
        }
        this.argTypes = (String[][])t_list.toArray((T[])new String[t_list.size()][]);
    }

    public void relink(String oid, String nid) {
        if (this.subject != null && this.subject.startsWith(oid)) {
            this.subject = this.subject.replaceFirst("[0-9]+(\\$[0-9_]+)", String.valueOf(nid) + "$1");
            this.changed();
        }
        int i = 0;
        while (i < this.numArgs()) {
            String t_stack = this.argTypes[i][1];
            if (t_stack.startsWith(oid)) {
                this.argTypes[i][1] = t_stack.replaceFirst("[0-9]+(\\$[0-9_]+)", String.valueOf(nid) + "$1");
                this.changed();
            }
            ++i;
        }
    }

    public boolean isComplete() {
        Boolean[] blist = (Boolean[])Tool.getObjectfromJSON(Boolean[].class, this.argStatus);
        return !Arrays.asList(blist).contains(false);
    }

    @Override
    public String getUpdateSQL() {
        if (this.removed && this.isNew()) {
            return null;
        }
        if (this.removed) {
            return "delete from \"tbl_TestCommandRecord\" where \"ID\"='" + Integer.toString(this.id) + "'";
        }
        if (this.isNew()) {
            return "insert into \"tbl_TestCommandRecord\" (\"ID\", \"ClassName\", \"MethodName\", \"ReturnType\", \"Subject\", \"ArgTypes\", \"TestCase\", \"Enable\", \"ArgStatus\") values (" + Integer.toString(this.id) + ",'" + this.className + "','" + this.methodName + "','" + this.returnType + "','" + this.subject + "','" + this.getArgJSON() + "','" + this.testCase + "','" + Boolean.toString(this.enable) + "','" + this.argStatus + "')";
        }
        if (this.isUpdated()) {
            return "update \"tbl_TestCommandRecord\" set \"ClassName\"='" + this.className + "', \"MethodName\"='" + this.methodName + "', \"ReturnType\"='" + this.returnType + "', \"Subject\"='" + this.subject + "', \"ArgTypes\"='" + this.getArgJSON() + "', \"ArgStatus\"='" + this.argStatus + "', \"TestCase\"='" + this.testCase + "', \"Enable\"='" + Boolean.toString(this.enable) + "' where \"ID\"='" + Integer.toString(this.id) + "'";
        }
        return null;
    }

    public String toString() {
        return "ID=" + Integer.toString(this.id) + "\t" + "Class=" + this.className + "\t" + "Method=" + this.methodName + "\n";
    }

    public static ArrayList<TestCommandRecord> convertToObject(ArrayList<TestCommandRecord> cmdlist, int snapshot) {
        if (cmdlist == null) {
            return null;
        }
        ArrayList<TestCommandRecord> t_list = new ArrayList<TestCommandRecord>();
        int i = 0;
        while (i < cmdlist.size()) {
            TestCommandRecord t_rec = cmdlist.get(i);
            t_list.add(t_rec);
            ++i;
        }
        return t_list;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getTestCase() {
        return this.testCase;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setSubject(String s) {
        this.subject = s;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void setClassName(String s) {
        this.className = s;
    }

    @Override
    public String getMethodName() {
        String m = this.methodName;
        m = m.replaceFirst("static+\\s*", "");
        m = m.replaceFirst("\\s*[0-9]+", "");
        return m;
    }

    @Override
    public void setMethod(String m, boolean isStatic, int varAPos) {
        this.methodName = m;
        if (isStatic) {
            this.methodName = "static " + this.methodName;
        }
        if (varAPos >= 0) {
            this.methodName = String.valueOf(this.methodName) + " " + Integer.toString(varAPos);
        }
    }

    @Override
    public String getReturnType() {
        return this.returnType;
    }

    @Override
    public void setReturnType(String s) {
        this.returnType = s;
    }

    @Override
    public String[][] getArgTypes() {
        return this.argTypes;
    }

    @Override
    public void setArgTypes(String[][] s) {
        this.argTypes = s;
    }

    @Override
    public boolean getArgStatus(int n) {
        try {
            Boolean[] t_s = (Boolean[])Fson.fromJson(this.argStatus, Tool.forName("Boolean[]"));
            return t_s[n];
        }
        catch (Exception e) {
            Tool.alertMSG(null, String.valueOf(e.getMessage()) + " @TestCommandRecord#getArgStatus");
            return false;
        }
    }

    @Override
    public void setArgStatus(int n, boolean b) {
        try {
            if (this.argStatus == null) {
                int m = this.argTypes.length + 2;
                Boolean[] t_status = new Boolean[m];
                int i = 0;
                while (i < m) {
                    t_status[i] = false;
                    ++i;
                }
                this.argStatus = Fson.toJson(t_status, Boolean[].class);
            }
            Boolean[] t_s = (Boolean[])Fson.fromJson(this.argStatus, Boolean[].class);
            t_s[n] = b;
            this.argStatus = Fson.toJson(t_s, Boolean[].class);
        }
        catch (Exception e) {
            Tool.alertMSG(null, String.valueOf(e.getMessage()) + " @TestCommandRecord#setArgStatus");
        }
    }

    public Object getTObject(Integer i) throws SecurityException, IllegalArgumentException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException, CannotCompileException, IOException, NotFoundException, NoSuchMethodException, InvocationTargetException, ParseException, Fson.NotSupportedClassException {
        Object t_obj = null;
        t_obj = i == 0 ? Tool.getTObject(this.id, this.subject) : Tool.getTObject(this.id, this.getArgStack(i - 1));
        return t_obj;
    }

    @Override
    public boolean isAutomatic() {
        HashMap t_map = (HashMap)VCentral.getValue("_POST_EXECS");
        if (t_map != null) {
            for (Map.Entry entry : t_map.entrySet()) {
                String val = (String)entry.getValue();
                if (!val.startsWith("verify")) continue;
                return false;
            }
        }
        return true;
    }

    public AssertRecord getAssert() throws ProcessException {
        this.postExec();
        HashMap t_map = (HashMap)VCentral.getValue("_ASSERTABLES");
        if (t_map == null) {
            return Tool._db().getAssert(this.id);
        }
        return new AssertMacroRecord(this.id, t_map);
    }

    @Override
    public void preExec() {
    }

    public String getInstanceID() {
        return Integer.toString(this.id);
    }

    protected void postExec() throws ProcessException {
        HashMap t_map = (HashMap)VCentral.getValue("_POST_EXECS");
        if (t_map != null) {
            for (Map.Entry entry : t_map.entrySet()) {
                ArrayList t_list = (ArrayList)Tool.getObjectfromJSON(ArrayList.class, (String)entry.getValue());
                int t_res = Tool.executeCommand(new StringBuilder(), (String)entry.getKey(), t_list.toArray(new String[t_list.size()]));
                if (t_res <= 0) continue;
                throw new ProcessException(String.valueOf((String)entry.getKey()) + "failed. ERRORCODE=" + Integer.toString(t_res));
            }
        }
    }

    @Override
    public String getName4Log() {
        return this.getMethodName();
    }

    class AssertMacroRecord
    extends AssertRecord {
        private HashMap<String, String> assertable_map;

        public AssertMacroRecord(int n, HashMap<String, String> map) {
            super(0);
            this.id = n;
            this.assertable_map = map;
            this.targetObj = "_ASSERTABLES";
        }

        @Override
        public boolean isCompleted() {
            return true;
        }

        @Override
        protected ArrayList<Object> getResultString(TestCommandRecord curCmd) throws SecurityException, IllegalArgumentException, CannotCompileException, InstantiationException, IllegalAccessException, ClassNotFoundException, NotFoundException, NoSuchMethodException, InvocationTargetException, NoSuchFieldException, ParseException {
            ArrayList<Object> t_result = new ArrayList<Object>();
            ArrayList<String> t_regs = new ArrayList<String>();
            for (Map.Entry<String, String> entry : this.assertable_map.entrySet()) {
                if (entry.getKey().startsWith("SQL_") && entry.getValue().toLowerCase().matches("^select\\s[\\s\\S]*$")) {
                    t_regs.add("true");
                } else {
                    t_regs.add(entry.getValue());
                }
                Object t_str = VCentral.getValue(entry.getKey());
                t_result.add(t_str);
            }
            this.criteriaRex = Tool.getJSONfromObject(t_regs);
            if (t_result.size() == 0) {
                throw new NotFoundException(Messages.getString("TestCommandRecord.70"));
            }
            return t_result;
        }
    }

    public class ProcessException
    extends Exception {
        public ProcessException(String msg) {
            super(msg);
        }
    }
}

