#pragma once

#include "WatchThreadGroup.hpp"
#include "LockManager.hpp"

#include <string>
#include <vector>

#include <assert.h>


class ResourceAccessor
{
public:
	virtual ~ResourceAccessor() {};
	virtual HINSTANCE getInstanceHandle() const = 0;
	virtual LPCTSTR getApplicationName() const;
	virtual HWND getMainHWnd() const;

	int LoadString(UINT uMessageID, LPTSTR buffer, int nBufferMax) const;
	int LoadInteger(UINT uMessageID) const;

	tstring LoadString(UINT uMessageID) const;
	tstring LoadStringFormat(UINT uMessageID, ...) const;
	tstring LoadStringFormatV(UINT uMessageID, va_list marker) const;

	int showMessageBox(UINT uType, LPCTSTR caption, UINT uMessageID, ...) const;
	int showMessageBox(HWND hWnd, UINT uType, LPCTSTR caption, UINT uMessageID, ...) const;
};


class Configuration
{
private:
	
	bool nameMatcherIgnoreCase_;

	bool deleteLog_;

	bool rotateLog_;

	long logCloseSpan_;

	tstring impersonatePasswordEncryption_;

	bool currentDirSetToWatchDir_;


public:
	Configuration();

	virtual ~Configuration() = 0 {};

	bool IsNameMatcherIgnoreCase() const;

	bool IsDeleteLog() const;

	bool IsRotateLog() const;

	long GetLogCloseSpan() const;

	tstring GetImpersonatePasswordEncryption() const;

	bool IsCurrentDirSetToWatchDir() const;

	tstring GetString(LPCTSTR appName, LPCTSTR name, LPCTSTR defValue) const;

	long GetLong(LPCTSTR appName, LPCTSTR name, int defValue) const;

	virtual const tstring& getIniPath() const = 0;

	void initCache();

};

class VersionInfoProvider
{
private:
	tstring fileVersion_;		// t@Co[W

	tstring legalCopyright_;	// Rs[Cg

	tstring versionComment_;	// Rg

public:

	VersionInfoProvider();

	const tstring& getFileVersion() const;

	const tstring& getLegalCopyright() const;

	const tstring& getVersionComment() const;
};


class FWatchApp
	: public ResourceAccessor
	, public Configuration
	, public LockManager
	, public VersionInfoProvider
{
private:
	FWatchApp(const FWatchApp&); //<! Ȃ
	FWatchApp& operator=(const FWatchApp&); //<! Ȃ

	void initDefaultPath();

public:
	FWatchApp();
	virtual ~FWatchApp();
	
	int run(HINSTANCE v_hInstance, LPCTSTR v_lpCmdLine);

	virtual HINSTANCE getInstanceHandle() const;
	virtual LPCTSTR getApplicationName() const;
	virtual HWND getMainHWnd() const;

	virtual const tstring& getInfPath() const;
	virtual const tstring& getInfDir() const;
	virtual const tstring& getIniPath() const;
	virtual const tstring& getIniDir() const;

	void setAppConfVariablesTo(PropertyStringExpander& varExpander, bool useInfDir = true);
	void showHelp(HWND hWnd) const;
	void showContextHelp(HWND hWnd, UINT helpid, POINT pt) const;

	CWatchThreadGroup& getCL();

private:
	HINSTANCE hInstance_;
	HWND hMainWnd_;

	tstring applicationName_;

	tstring helpFile_;		// wvt@C̃pX
	tstring iniPath_;		// INIt@Cւ̃pX
	tstring iniDir_;		// INIt@C̃fBNg
	tstring infPath_;		// LSTt@Cւ̃pX
	tstring infDir_;		// LSTt@CփfBNg
	tstring userDataDir_;	// [Uf[^fBNg
	tstring moduleDir_;		// st@CfBNg

	CWatchThreadGroup cl_;
};


/*!
 * O[oȃAvP[VCX^X
 */
extern FWatchApp app;
