#pragma once

#include <exception>
#include <vector>
#include <iterator>

/*!
 * t@Co̗͂O
 */
class CFileIOException
	: public std::exception
{
private:
	DWORD errorcode_;

public:
	CFileIOException(DWORD errorcode);

	DWORD GetErrorCode() const;
};


/*!
 * UNICODE/MBCS̑o̓ǂݍ݁E݂tstringłł悤ɂ邽߂̃NX
 */
class CFileIO
{
private:
	tstring fname_;

	HANDLE hFile_;

	bool eof_;

	bool unicode_;

	bool wrote_;

	typedef std::vector<unsigned char> rawbuffer;

	rawbuffer buf_;

	rawbuffer::iterator pt_, endpt_;

	rawbuffer::value_type pch_;

	CFileIO(const CFileIO&); //<! Ȃ

	CFileIO& operator=(const CFileIO&); //<! Ȃ

public:

	/*!
	 * t@Cw肵č\z܂B
	 */
	CFileIO(const tstring& fname);

	/*!
	 * t@C܂JĂΕ܂B
	 */
	~CFileIO() throw();

	/*!
	 * ǂݍ݂܂͏݃[hŊJ܂B
	 * ǂݍ݃[hł̓t@B̃I[vɎsꍇfalseԂ܂B
	 * ݃[h̏ꍇAt@C̃I[vɎsꍇCFileIOExceptionO܂B
	 * ݃[hŃI[vłꍇÃt@C̃TCY̓[ɂȂ܂B
	 * ǂݍ݃[h̏ꍇAt@C̐擪UTF-16BOM邩ǂݎ胂[hݒ肵܂B
	 * BOM̓ǂݎɎsꍇCFileIOExceptionO܂B
	 * \param save trueȂΏ݃[h
	 */
	bool Open(bool save);

	/*!
	 * t@C𖾎Iɕ܂B
	 * t@C̃N[YɎsĂO͕Ԃ܂B
	 */
	void Close() throw();
	
	/*!
	 * ǂݍ݃[hAΏۃt@CUNICODEłtrueԂ܂B
	 * \return Ώۃt@CBOMUNICODEłtrue
	 */
	bool IsUnicode() const;

	/*!
	 * t@CɃeLXg݂܂B
	 * UNICODErhłUTF-16AłȂMBCSŏ܂܂B
	 * UNICODErh̍ŏ݂̏BOM܂܂B
	 * \param line ݍs
	 */
	void PutText(tstring& line);

	/*!
	 * t@CPsǂݎ܂B
	 * LF܂łPsƂȂ܂B(EOF)
	 * ԂsCR/LF͏܂B
	 * s̒͂܂B
	 * t@CUNICODE/MBCSǂłĂtstringŕԂ܂B
	 * t@C̓ǂݎG[ꍇAUNICODEMBCS̕ϊɎsꍇ
	 * CFileIOExceptionO܂B
	 * EOFɒBꍇ̎̓ǂݍ݂łline͋ƂȂ߂lfalseƂȂ܂B
	 * \param line ܂s
	 * \return sǂݎꂽꍇtrueAI[ɒBꍇfalse
	 */
	bool GetText(tstring& line);

private:
	/*!
	 * 
	 */
	void Init() throw();

	/*!
	 * t@CBOMǂݎABOM̎̈ʒuɈʒuÂ܂B
	 * BOMȂꍇ̓t@C̐擪ɈʒuÂ܂B
	 */
	void CheckUnicode();
};


