#pragma once

#include "ActionInvoker.hpp"

/*!
 * vZXNANV̒ۃNXB
 * Np[^̓WJAvZXnh̊ǗAs̔蓙s܂B
 */
class AbstractProcessExecActionInvoker
	: public ActionInvoker
{
private:
	AbstractProcessExecActionInvoker(const AbstractProcessExecActionInvoker&); //<! Ȃ
	AbstractProcessExecActionInvoker& operator=(const AbstractProcessExecActionInvoker&); //<! Ȃ

private:

	/*!
	 * ĎvZXnhƁAɊ֘A^[Qbgt@C
	 */
	typedef std::map<HANDLE, tstring> ProcessHandleMap;

	ProcessHandleMap processHandleMap_;

protected:

	DWORD runCount_;

public:
	AbstractProcessExecActionInvoker(const CSettingInfo& v_settingInfo);

	virtual ~AbstractProcessExecActionInvoker() = 0;

	virtual bool canDoAction() throw();

	virtual unsigned int sweepGarbage() throw();

	virtual void Reset();

	virtual void Load(CObjectReader &reader);

	virtual void Save(CObjectWriter &writer);

	/*!
	 * ANVs܂B
	 * ANV̍ő吔𒴂Ă邩͔肳Ȃ߁A
	 * ĂяoƂœKXcanDoActionŃ`FbNKv܂B
	 * \param v_absolutePath ^[Qbgt@C̐΃pX
	 * \param fileInfo Ďt@C
	 * \return ptOAtruełΔ񓯊ɎsꂽƂ
	 */
	virtual bool doAction(const tstring& v_absolutePath, const CFileInfo& fileInfo) throw();

protected:

	/*!
	 * w肵^[Qbgt@CƁAɊ֘AvZXnhw肵
	 * vZX̏IĎB
	 * \param v_hProcess vZXnh
	 * \param v_absolutePath ^[Qbgt@C
	 */
	virtual void addTraceProcessHandle(HANDLE v_hProcess, const tstring& v_absolutePath) throw();

	/*!
	 * w肵^[Qbgt@CɊ֘AvZXĎł邩?
	 * \param ^[Qbgt@C
	 * \return ĎłtrueAłȂfalse
	 */
	virtual bool isWatchedProcess(const tstring& v_absolutePath) const throw();

	/*!
	 * ϐCOUNT̓WJɎgp鑍s񐔂擾܂B
	 * \return s
	 */
	virtual DWORD internalGetRunCount();
};


/*!
 * ShellExecuteExŃvZXNANV
 */
class ShellExecActionInvoker
	: public AbstractProcessExecActionInvoker
{
private:
	ShellExecActionInvoker(const ShellExecActionInvoker&); //<! Ȃ
	ShellExecActionInvoker& operator=(const ShellExecActionInvoker&); //<! Ȃ

public:
	ShellExecActionInvoker(const CSettingInfo& v_settingInfo);

	virtual ~ShellExecActionInvoker() throw();

protected:
	/*!
	 * vZX̎s
	 * \param v_absoluePath ^[Qbg̐΃pX
	 * \param v_fileInfo ^[Qbg̃t@C
	 * \param verb ANV^Cv
	 * \param appName AvP[V(WJς)
	 * \param param p[^(WJς)
	 * \param appCurrentDir JgfBNg(WJς)
	 * \return ptOAtruełΔ񓯊ɎsꂽƂ
	 */
	virtual bool internalDoAction(
		const tstring v_absolutePath,
		const CFileInfo& v_fileInfo,
		const tstring& verb,
		const tstring& appName, 
		const tstring& param,
		const tstring& appCurrentDir) throw();
};

/*!
 * CreateProcessAsLogonŃvZXNANV
 */
class CreateProcessAsLogonActionInvoker
	: public AbstractProcessExecActionInvoker
{
private:
	enum VERB_TYPE
	{
		VERB_PROCESS = 1,
		VERB_RUN_AS_USER,
		VERB_RUN_AS_USER_WITH_PROFILE
	};

	VERB_TYPE verbType_;

	CreateProcessAsLogonActionInvoker(const CreateProcessAsLogonActionInvoker&); //<! Ȃ
	CreateProcessAsLogonActionInvoker& operator=(const CreateProcessAsLogonActionInvoker&); //<! Ȃ

public:
	CreateProcessAsLogonActionInvoker(const CSettingInfo& v_settingInfo);

	virtual ~CreateProcessAsLogonActionInvoker() throw();

protected:
	/*!
	 * vZX̎s
	 * \param v_absoluePath ^[Qbg̐΃pX
	 * \param v_fileInfo ^[Qbg̃t@C
	 * \param verb ANV^Cv
	 * \param appName AvP[V(WJς)
	 * \param param p[^(WJς)
	 * \param appCurrentDir JgfBNg(WJς)
	 * \return ptOAtruełΔ񓯊ɎsꂽƂ
	 */
	virtual bool internalDoAction(
		const tstring v_absolutePath,
		const CFileInfo& v_fileInfo,
		const tstring& verb,
		const tstring& appName, 
		const tstring& param,
		const tstring& appCurrentDir) throw();
};
