#include "stdafx.h"

#include "Utility.hpp"

#include <assert.h>
#include <string.h>

#include <string>
#include <vector>
#include <algorithm>
#include <exception>

#include <strsafe.h>
#pragma comment(lib, "strsafe.lib")



/*!
 * R}hC𕪉܂B
 * ̓kɂĔj󂳂܂B
 * \param lpCmdLine R}hC
 * \param argv i[z
 * \param mx z̑傫
 * \return ꂽ̐
 */
int GetCmdArgs(LPTSTR lpCmdLine,LPTSTR* argv,int mx)
{
	//required:
	assert(lpCmdLine != NULL && "lpCmdLineNULL͎wł܂B");
	assert(argv != NULL && "argvnull͎wł܂B");
	assert(mx >= 0 && "mxɕ̒l͎wł܂B");

	//do:
	int argc = 0;
	LPTSTR p = lpCmdLine;
	while (*p && argc < mx) {
		while (*p == ' ' || *p == '\t') p++; // s󔒂͏O
		if (*p == '\"') {
			// _uNH[e[Vŋ؂ꂽꍇ
			p++;
			argv[argc++] = p;
			while (*p && *p != '\"') {
				p = ::CharNext(p);
			}
		}
		else {
			// ^uNH[e[VȊOŎn܂g[N
			argv[argc++] = p;
			while (*p && *p != ' ' && *p != '\t') {
				p = ::CharNext(p);
			}
		}
		if (*p) {
			*p++ = 0;
		}
	}
	return argc;
}

/*!
 * 𕶎ƂĕԂ܂B
 * ԂIuWFNg͈ꎞIuWFNgłB
 * \param v_value 
 * \return 
 */
tstring IntToString(long v_value) throw()
{
	return ToString(_T("%ld"), v_value);
}

/*!
 * 𕶎ɕϊĕԂ܂B
 * ԂIuWFNg͈ꎞIuWFNgłB
 * \param v_format tH[}bg
 * \return 
 */
tstring ToString(const LPCTSTR v_format, ...) throw()
{
	//required:
	assert(v_format != NULL && "v_formatnull͎wł܂B");

	//do:
	va_list marker;
	va_start(marker, v_format);

	return ToStringV(v_format, marker);
}

tstring ToStringV(const LPCTSTR v_format, va_list marker) throw()
{
	//required:
	assert(v_format != NULL && "v_formatnull͎wł܂B");

	//do:

	int bufsiz = 4096;
	for (;;) {
		std::vector<TCHAR> buf(bufsiz);

		LPTSTR pNext = NULL;
		size_t zan = 0;

		HRESULT hr;
		hr = StringCchVPrintfEx(
			&buf[0],
			bufsiz,
			&pNext,
			&zan,
			STRSAFE_IGNORE_NULLS | STRSAFE_FILL_BEHIND_NULL,
			v_format,
			marker
			);
		if (hr == STRSAFE_E_INSUFFICIENT_BUFFER) {
			bufsiz *= 2;
			continue;
		}
		if (SUCCEEDED(hr)) {
			return tstring(&buf[0]);
		}

		assert(false && "bZ[W̍\zɎs܂B");
		break;
	}

	return _T("*FORMAT ERROR*");
}

/*!
 * 񂩂琔lo܂B
 * lƂĕϊłȂꍇ0ƂȂ܂B
 * \param v_text 
 * \return l
 */
int atoi(const tstring& v_text) throw()
{
	return _tstoi(v_text.c_str());
}

namespace
{
	void InternalGetModuleFileName(std::vector<tstring::value_type> &buf)
	{
		DWORD bufsiz = MAX_PATH;
		for (;;) {
			buf.resize(bufsiz + 1); // kI[K[h
			memset(&buf[0], 0, bufsiz + 1);

			DWORD siz = GetModuleFileName(NULL, &buf[0], bufsiz);

			if (siz == 0) {
				// G[̏ꍇ
				// (g̃W[pXȂƂ͂蓾ȂƎv)
				assert(false && "GetModuleFileNames܂");
				throw std::logic_error("GetModuleFileNames܂");
			}

			if (siz >= bufsiz) {
				// obt@TCY̓kI[܂݁Aobt@ꍇ
				// obt@TCYɐ؂l߂B(̓kI[, XP/2000͔kI[?)
				// āAsiz == bufsiz ̏ꍇ͂傤ǓA͕sĂB
				// XP/2000ł̓G[R[hERROR_SUCCESSȂ̂ŃG[ł͕sĂ邩łȂ.
				bufsiz *= 2;
				continue;
			}

			break;
		}
	}
}

/*!
 * ̎st@C̃tpX擾܂.
 * \return tpX
 */
tstring GetModuleFileName()
{
	std::vector<tstring::value_type> buf;
	InternalGetModuleFileName(buf);
	return tstring(&buf[0]);
}

/*!
 * W[̎st@Cx[XɊgqύXt@CpXԂ܂B
 * \param ExtName gq
 * \return W[̎st@Cx[XɊgqύXt@CpX
 */
tstring GetBaseFileNameWithExtention(LPCTSTR ExtName)
{
	// obt@ɑߊgq̒OɎ擾.
	if (ExtName == NULL) {
		ExtName = _T("");
	}
	size_t extnameLen = _tcslen(ExtName);

	// sW[̃tpX擾
	std::vector<TCHAR> buf;
	InternalGetModuleFileName(buf);

	// ܂ŃV[N
	LPTSTR pBase = &buf[0];
	LPTSTR p = pBase;
	while (*p) p++;

	// tH_؂𒴂Ȃŏ́u.v̈ʒu𔭌.
	// tH_؂𒴂܂Łu.v݂Ȃꍇ͖u.v̈ʒuƂ݂Ȃ.
	LPTSTR ext_p = NULL;
	while (p > pBase) {
		if (*p == '\\' || *p=='/') {
			break;
		}
		if (*p == '.') {
			ext_p = p;
			break;
		}
		// 擪ɂ̂ڂ
		p = CharPrev(pBase, p);
	}

	if (ext_p == NULL) {
		// u.v݂Ȃꍇ͖܂ŃV[NAu.vJnʒuƂ݂Ȃ.
		while (*p) p++;
		ext_p = p;
	}

	// gqʒu܂ł̒
	size_t len = ext_p - pBase;
	// obt@TCYɑ΂gqʒu܂ł̒c
	size_t bufsiz = buf.size();
	size_t zan = bufsiz - len - 1; // I[

	if (extnameLen == 0) {
		// gqłꍇAŏI[
		*ext_p = 0;
	}
	else {
		// gqłȂꍇ
		// gq́u.vݒ
		assert(zan >= (extnameLen + 1) && "obt@TCYsĂ܂.");

		*ext_p++ = '.';
		zan--;

		// gqݒ
		if (_tcscpy_s(ext_p, zan, ExtName)) {
			assert(false && "obt@TCYsĂ܂.");
		}
	}

	// 
	return tstring(&buf[0]);
}

/*!
 * ϐ擾܂.
 * ݂ȂꍇfalseԂ܂.
 * \param name ϐ
 * \param value ϐ̒l̊i[(ϐȂꍇ͕ύXȂ)
 * \return ݂trueA݂Ȃfalse
 */
bool GetEnvironmentVariable(LPCTSTR name, tstring& value)
{
	if (name == NULL) {
		return false;
	}
	
	const DWORD strsize = ::GetEnvironmentVariable(name, NULL, 0);
	if (strsize != 0) {
		std::vector<tstring::value_type> buf(strsize);
		if (::GetEnvironmentVariable(name, &buf[0], strsize)) {
			value = tstring(&buf[0]);
			return true;
		}
	}
	return false;
}

/*!
 * tpXZpX擾܂.
 * ϊłȂꍇ͈̂܂ܕԂ܂.
 * \param path tpX
 * \return ZpX
 */
tstring GetShortPathName(const tstring& path)
{
	size_t bufsiz = 40;
	std::vector<tstring::value_type> buf(bufsiz);
	for (;;) {
		DWORD siz = GetShortPathName(path.c_str(), &buf[0], static_cast<DWORD>(bufsiz));
		if (siz == 0) {
			// ZpX̎擾Ɏsꍇ͕ϊȂ
			return path;
		}
		if (siz >= bufsiz) {
			bufsiz = siz + 1;
			buf.resize(bufsiz);
			memset(&buf[0], 0, bufsiz);
			continue;
		}
		break;
	}
	return tstring(&buf[0]);
}

/*!
 * 񂩂󔒋؂̗vf1o܂B
 * s󔒂̓XLbv܂B
 * 擪_uNH[gŎn܂Ăꍇ͋󔒂ł͂Ȃ̃_uNH[g܂łvfƂȂ܂B
 * I[܂ŒBꍇ́AInfPath͋ƂȂAI[(k)̃AhXԂ܂B
 * obt@TCYȂꍇNULLԂAGetLastErrorłERROR_INSUFFICIENT_BUFFER擾܂B
 * \param InfPath i[AsvȂnull
 * \param lpCmdLine ǂݎJn|C^ANULLw肵ꍇNULLԂ܂B
 * \param bufsiz i[obt@̃TCY
 * \return ̓ǂݎʒuA͏I[
 */
LPCTSTR GetToken(LPTSTR InfPath, LPCTSTR lpCmdLine, int bufsiz)
{
	if (lpCmdLine == NULL) {
		SetLastError(ERROR_INVALID_PARAMETER);
		return NULL;
	}

	LPCTSTR p = lpCmdLine;

	LPTSTR d = InfPath;

	// s󔒂܂̓^uXLbv
	while (*p == ' '|| *p == '\t') p++;

	// _uNH[gŎn܂Ă邩?
	if (*p == '\"') {
		// _uNH[e[VŎn܂Ă΋󔒂؂Ƃ݂ȂA
		// ̃_uNH[g܂łvfƂB
		p++;
		while (*p && *p!='\"') {
			TCHAR c = *p++;
			if (d) {
				if (bufsiz <= 0) {
					SetLastError(ERROR_INSUFFICIENT_BUFFER);
					return NULL;
				}
				bufsiz--;
				*d++ = c;
			}
		}
		if (*p == '\"') {
			p++;
		}
	}
	else {
		// 󔒂ŋ؂Ƃ݂Ȃ
		while (*p && *p!=' ') {
			TCHAR c = *p++;
			if (d) {
				if (bufsiz <= 0) {
					SetLastError(ERROR_INSUFFICIENT_BUFFER);
					return NULL;
				}
				bufsiz--;
				*d++ = c;
			}
		}
	}

	if (d) {
		if (bufsiz <= 0) {
			SetLastError(ERROR_INSUFFICIENT_BUFFER);
			return NULL;
		}
		bufsiz--;
		*d = 0;
	}
	return p;
}

/*!
 * Ő󔒂ƃ^ug܂B
 * ͔j󂳂܂B
 * \param buf g镶
 * \return gꂽ
 */
LPTSTR StrTrim(LPTSTR buf)
{
	LPTSTR p = buf;
	LPTSTR d = buf;
	while (*p == ' ' || *p == '\t' || *p == '\r' || *p == '\n') p++;
	LPTSTR t = p;
	while (*p) *d++ = *p++;
	*d = 0;
	while (d > t) {
		d = ::CharPrev(t, d);
		if (*d != ' ' && *d != '\t' && *p != '\r' && *p != '\n') {
			break;
		}
		*d = 0;
	}
	return t;
}

/*!
 * ̑OɊ܂܂󔒂ƃ^vAsR[h菜Ԃ܂B
 * ͔j󂳂܂B
 * Ԃ镶͈ꎞIIuWFNgłB
 */
tstring StrTrim(const tstring& v_in)
{
	if (v_in.empty()) {
		return v_in;
	}

	size_t st = v_in.find_first_not_of(_T(" \t\r\n"));
	size_t en = v_in.find_last_not_of(_T(" \t\r\n"));

	if (st == -1) {
		// 󔒁E^uAsR[hȂ
		return v_in;
	}
	return tstring(v_in, st, en - st + 1);
}


/*!
 * 񂪎w肵ŏI[邱ƂۏႵ܂B
 * w肵ŏI[ĂȂ͖ɏI[񂪒ǉ܂B
 * Ώە͔jIɑ삳܂B
 * Ώە͂炩ߏI[ǉĂSȒKvłB
 * \param v_str Ώە
 * \param v_endStr I[
 * \param bufsiz obt@TCY
 */
void EnsureLast(LPTSTR v_str, LPCTSTR v_endStr, size_t bufsiz)
{
	//required:
	assert(v_str != NULL && "v_strNULL͎wł܂B");
	assert(v_endStr != NULL && "v_endStrNULL͎wł܂B");

	//do:

	// ܂ŃV[N
	LPTSTR p1 = v_str;
	LPCTSTR p2 = v_endStr;
	while (*p1) p1++;
	while (*p2) p2++;

	// ݂̕擪ɂ̂ڂ
	// ǂ炩ɐ擪ɒBꍇ́AŎ~܂
	while (p1 > v_str && p2 > v_endStr) {
		p1 = CharPrev(v_str, p1);
		p2 = CharPrev(v_endStr, p2);
	}

	if (p2 == v_endStr) {
		// I[擪܂ŃV[Nłꍇ
		if (_tcscmp(p1, p2) == 0) {
			// ͎w肵I[
			return;
		}
	}

	// ͏I[ZAI[vȂ
	_tcscat_s(v_str, bufsiz, v_endStr);
}

/*!
 * 񂪎w肵ŏI[邱ƂۏႵ܂B
 * ͔j󂳂܂B
 * Ԃ镶͈ꎞIuWFNgłB
 * \param v_str 
 * \param v_endStr I[镶
 * \return I[Ă邱ƂۏႳꂽ(ꎞIuWFNg)
 */
tstring EnsureLast(const tstring& v_str, const tstring& v_endStr)
{
	const size_t bufsiz = v_str.size() + v_endStr.size() + 1;
	std::vector<TCHAR> buf(bufsiz);
	_tcscpy_s(&buf[0], bufsiz, v_str.c_str());
	EnsureLast( &buf[0], v_endStr.c_str(), bufsiz);
	return tstring(&buf[0]);
}

/*!
 * p^[}b`s܂B
 * p^[ɂ́u*vƁu?v̓ꕶ܂߂邱Ƃł܂B
 * rΏƂƂȂ镶ɂ́A̓ꕶ܂߂邱Ƃ͂ł܂B
 * u*v͏I[܂߂0ȏ̃}b`Au?v͏I[ȊO̔Cӂ1ƃ}b`܂B
 * 啶Eʂ܂B
 * \param v_text rΏƕ
 * \param v_pattern p^[
 * \return }b`ꍇAtrue
 */
bool IsMatch(LPCTSTR v_text, LPCTSTR v_pattern)
{
	//required:
	assert(v_text != NULL && v_pattern != NULL && "null͎wł܂B");
	
	//do:
	LPCTSTR s = v_text;
	LPCTSTR p = v_pattern;
	while (*p) {
		const TCHAR cp = *p;
		if (cp == '?') {
			if ( !*s) {
				// 1vꏊŏI[̂ߕsv
				return false;
			}
		}
		else if(cp == '*') {
			TCHAR cn = 0;
			do {
				p = ::CharNext(p);
				cn = *p;
			} while (cn == '*' || cn == '?');
			if (cn == 0) {
				// ̕I[ł邽߁Aȍ~s
				return true;
			}
			while (*s) {
				if (*s == cn) {
					if (IsMatch(s, p)) {
						return true;
					}
				}
				s = ::CharNext(s);
			}
			return false;
		}
		else {
			if (cp != *s) {
				// vB
				return false;
			}
#ifndef _UNICODE
			if (::IsDBCSLeadByte(cp)) {
				if (*(p + 1) != *(s + 1)) {
					// _uoCǧ㑱v
					return false;
				}
			}
#endif
		}
		s = ::CharNext(s); // ɏI[ɒBꍇ͏I[wÂB
		p = ::CharNext(p);
	}
	
	return *s == 0 && *p == 0; // oɏI[ɂǂ蒅Ȃ}b`ĂB
}


/*!
 * pX̍Ṓu\v܂ł̕Ԃ܂B
 * u\v܂݂܂B
 * u\vȂꍇ́u.vԂ܂B
 * \param path pX
 * \return fBNg̃pXÁu.v
 */
tstring GetDirName(const tstring& path)
{
	LPCTSTR st = path.c_str();
	LPCTSTR p = st;
	while (*p) p++;
	while (st < p) {
		if (*p == '\\' || *p == '/') {
			break;
		}
		p = CharPrev(st, p);
	}
	if (p == st) {
		// tH_؂肪Ȃ̂Łu.vԂ܂B
		return _T(".");
	}

	size_t len = p - st + 1;
	return path.substr(0, len);
}


/*!
 * pX̍Ṓu\v̕Ԃ܂Bu\v͊܂݂܂B
 * u\vȂꍇ́ApX̂܂ܕԂ܂B
 * \param pX
 * \return t@CA̓pX̂
 */
tstring GetBaseName(const tstring& path)
{
	LPCTSTR st = path.c_str();
	LPCTSTR p = st;
	while (*p) p++;
	while (st < p) {
		if (*p == '\\' || *p == '/') {
			break;
		}
		p = CharPrev(st, p);
	}
	if (p == st) {
		// tH_؂肪Ȃ̂ŁÂ܂ܕԂ
		return path;
	}

	size_t len = p - st + 1;
	return path.substr(len);
}

/*!
 * pX̍Ṓu\vȍ~ŁAṒu.v܂ł̕Ԃ܂B
 * u\vȂꍇ́AṒu.v܂ł̕Ԃ܂B
 * \param pX
 * \return t@C̊gq́ÁAt@CA̓pX̂́B
 */
tstring GetNameBody(const tstring& path)
{
	tstring basename = GetBaseName(path);
	LPCTSTR st = basename.c_str();
	LPCTSTR p = st;
	while (*p) p++;
	while (st < p) {
		if (*p == '.') {
			break;
		}
		p = CharPrev(st, p);
	}
	if (p == st) {
		return basename;
	}
	size_t len = p - st;
	return basename.substr(0, len);
}

tstring GetRelativePath(const tstring& dirname, const tstring& absolutePath)
{
	// u\vłΐ΃pX̂̓tH_ł
	DWORD dwAttrTo = FILE_ATTRIBUTE_NORMAL;
	LPCTSTR pSt = absolutePath.c_str();
	LPCTSTR p = pSt;
	while (*p) p++;
	p = CharPrev(pSt, p);
	if (*p == '\\') {
		dwAttrTo = FILE_ATTRIBUTE_DIRECTORY;
	}

	// ΃pXɕϊ
	TCHAR buf[MAX_PATH] = {0};
	if (PathRelativePathTo(
		buf,
		dirname.c_str(),
		FILE_ATTRIBUTE_DIRECTORY,
		absolutePath.c_str(),
		dwAttrTo)) {
		return buf;
	}

	// 炩̌ŎsꍇabsolutePatĥ܂܂B
	return absolutePath;
}

/*!
 * G[R[h𕶎ɂĕԂ܂B
 * \param errcode G[R[h
 * \return G[bZ[W(ꎞIuWFNg)
 */
tstring ToErrorMessage(DWORD errcode) throw()
{
	LPTSTR lpMsgBuf;
	FormatMessage(
		FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,
		errcode,
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), //  ftHg
		(LPTSTR) &lpMsgBuf,
		0,
		NULL 
	);
	tstring mes(lpMsgBuf);
	LocalFree(lpMsgBuf);
	return mes;
}

/*!
 * ɔ󎚕܂܂ꍇ̓GXP[v܂B
 * \r/\n/\t\x00`T|[g܂B
 * Ԃ镶͈ꎞIuWFNgłB
 * \return GXP[vꂽ
 */
tstring EscapeUnprintableChars(const tstring& v_str)
{
	tstring result;

	LPCTSTR p = v_str.c_str();

	while (*p) {
		TCHAR ch = *p;
		if ((ch >= 0 && ch < ' ') || ch == 0x7e || ch == '\\') {
			if (ch == '\r') {
				result.append(_T("\\r"));
			}
			else if (ch == '\n') {
				result.append(_T("\\n"));
			}
			else if (ch == '\t') {
				result.append(_T("\\t"));
			}
			else if (ch == '\\') {
				result.append(_T("\\\\"));
			}
			else {
				result.append(ToString(_T("\\x%02x"), (unsigned int) ch & 0xff));
			}
		}
#ifdef _UNICODE
		else if ((ch >= 0x80 && ch <= 0xa1) || ch == 0xad) {
			result.append(ToString(_T("\\u%04x"), (unsigned int) ch));
		}
		else {
			result.push_back(ch);
		}
#else
		else {
			LPCTSTR p2 = CharNext(p);
			int len = p2 - p;
			if (len > 1) {
				result.append(p, len);
			}
			else {
				result.push_back(ch);
			}
		}
#endif
		p = CharNext(p);
	}

	return result;
}

/*!
 * ɃGXP[v܂܂ꍇ̓GXP[v܂B
 * \r/\n/\t\x00`T|[g܂B
 * Ԃ镶͈ꎞIuWFNgłB
 */
tstring UnescapeUnprintableChars(const tstring& v_str)
{
	tstring result;

	LPCTSTR p = v_str.c_str();

	while (*p) {
		TCHAR ch = *p;
		if (ch == '\\') {
			p = CharNext(p);

			TCHAR typ = *p;

			if (typ == 'r') {
				ch = '\r';
			}
			else if (typ == 'n') {
				ch = '\n';
			}
			else if (typ == 't') {
				ch = '\t';
			}
			else if (typ == 'x' || typ == 'u') {
				int len = (typ == 'x') ? 2 : 4;
				tstring hex;
				p = CharNext(p);
				while (*p && len > 0
					&& ((*p >= '0' && *p <= '9')
					|| (*p >= 'a' && *p <= 'f') 
					|| (*p >= 'A' && *p <= 'F'))) {
					hex.push_back(*p);
					p = CharNext(p);
					len--;
				}
				if ( !hex.empty()) {
					ch = (TCHAR) _tcstoul(hex.c_str(), NULL, 16);
					result.push_back(ch);
				}
				continue;
			}
		}

#ifdef _UNICODE
		result.push_back(ch);
#else
		LPCTSTR p2 = CharNext(p);
		int len = p2 - p;
		if (len > 1) {
			result.append(p, len);
		}
		else {
			result.push_back(ch);
		}
#endif
		p = CharNext(p);
	}

	return result;
}

/*!
 * ɔ󎚕܂܂ꍇ͒uŒu܂B
 * Ԃ镶͈ꎞIuWFNgłB
 * \return uꂽ
 */
tstring EliminateUnprintableChars(const tstring& v_str, const tstring& v_replace)
{
	tstring result;

	LPCTSTR p = v_str.c_str();

	while (*p) {
		TCHAR ch = *p;
		if ((ch >= 0 && ch < ' ') || ch == 0x7e) {
			result.append(v_replace);
		}
#ifdef _UNICODE
		else if ((ch >= 0x80 && ch <= 0xa1) || ch == 0xad) {
			result.append(v_replace);
		}
		else {
			result.push_back(ch);
		}
#else
		else {
			LPCTSTR p2 = CharNext(p);
			int len = p2 - p;
			if (len > 1) {
				result.append(p, len);
			}
			else {
				result.push_back(ch);
			}
		}
#endif
		p = CharNext(p);
	}

	return result;
}

/*!
 * w莞o߂Ă邩肷B
 * nowŎAtargetŎ + span~bȏłꍇAtrueB
 * \param v_now ݎ
 * \param v_span P\
 * \param v_target Ώێ
 */
bool IsExpired(const FILETIME& v_now, DWORD v_span, const FILETIME& v_target)
{
	LARGE_INTEGER now = {v_now.dwLowDateTime, v_now.dwHighDateTime};
	LARGE_INTEGER target = {v_target.dwLowDateTime, v_target.dwHighDateTime};

	target.QuadPart += (__int64) v_span * 10000; // mSecP

	return now.QuadPart > target.QuadPart;
}

#ifdef _UNICODE
namespace
{
	/*!
	 * UnicodeŃAt@xbgނ̂ݏ.
	 */
	int tolower_utf16(int c)
	{
		// Basic Latin
		if ((c >= 0x0041) && (c <= 0x005A)) {
			c += 0x0020;
		}
		// Latin-1 Supplement
		else if ((c >= 0x00C0) && (c <= 0x00DE)) {
			c += 0x0020;
		}
		// Latin Extended-A
		else if ((c >= 0x0100) && (c <= 0x017D) && ((c % 2) == 0)) {
			c += 0x0001;
		}
		return c;
	}
}
#endif

/*!
 * 񒆂Ɋ܂܂啶ɕϊ.
 * XV܂.
 * \param (IN/OUT)
 */
void ToLower(tstring& str)
{
#ifdef _UNICODE
	std::transform(str.begin(), str.end(), str.begin(), tolower_utf16);
#else
	for (tstring::iterator ite = str.begin(); ite != str.end();) {
		TCHAR ch = *ite;
		if (!IsDBCSLeadByteEx(0, ch)) {
			// 2oCg̐擪oCgłȂΑ啶->ϊs
			int cc = tolower(ch);
			if (cc != ch) {
				*ite = static_cast<TCHAR>(cc);
			}
			++ite;
		} else {
			// 2oCg̐擪oCgł
			// ϊsv2oCgƂXLbv.
			++ite;
			if (ite != str.end()) {
				++ite;
			}
		}
	}
#endif
}
