/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder;

import com.hisagisoft.eclipse.gadgetholder.ParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserUtils {
    private static Logger logger = Logger.getLogger(ParserUtils.class.getName());
    private static Pattern beginPattern = Pattern.compile("<script[^\n]+[^/]>", 2);
    private static Pattern endPattern = Pattern.compile("</script>", 2);
    private static Pattern monoPattern = Pattern.compile("<script.+/>", 2);

    private ParserUtils() {
    }

    public static List<String> getScriptTags(File file) throws ParseException {
        assert (file != null);
        StringBuilder inputAsString = new StringBuilder();
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new FileReader(file));
                String line = null;
                while ((line = br.readLine()) != null) {
                    inputAsString.append(line.replaceAll("<", "\n<"));
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new ParseException(e);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ParseException(e);
            }
        }
        catch (Throwable throwable) {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            } else {
                br = null;
            }
            throw throwable;
        }
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        } else {
            br = null;
        }
        ArrayList<String> tags = new ArrayList<String>();
        String beginTag = null;
        Scanner scanner = new Scanner(inputAsString.toString());
        while (scanner.hasNextLine()) {
            String nextLine = scanner.nextLine();
            Matcher beginMatcher = beginPattern.matcher(nextLine);
            Matcher endMatcher = endPattern.matcher(nextLine);
            Matcher monoMatcher = monoPattern.matcher(nextLine);
            boolean isBegin = beginMatcher.find();
            boolean isEnd = endMatcher.find();
            boolean isMono = monoMatcher.find();
            if (isBegin && isEnd) {
                String s = beginMatcher.group();
                tags.add(s);
                logger.fine("begin and end : " + s);
            } else if (isBegin) {
                beginTag = beginMatcher.group();
                logger.fine("begin : " + beginTag);
            } else if (isEnd) {
                logger.fine("end : " + endMatcher.group());
                if (beginTag != null) {
                    tags.add(String.valueOf(beginTag) + endMatcher.group());
                    beginTag = null;
                }
            }
            if (!isMono) continue;
            logger.fine("mono : " + monoMatcher.group());
            tags.add(monoMatcher.group());
        }
        return tags;
    }

    public static File createFile(String prefix, String suffix, String data) {
        assert (data != null);
        File file = null;
        PrintWriter out = null;
        try {
            try {
                file = File.createTempFile(prefix, suffix);
                logger.info("create temp file = " + file.getAbsoluteFile().toString());
                out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                out.print(data);
            }
            catch (IOException e) {
                logger.severe(e.getClass() + " : " + e.getMessage());
                e.printStackTrace();
                throw new Error(e);
            }
        }
        finally {
            if (out != null) {
                out.close();
            } else {
                out = null;
            }
        }
        return file;
    }
}

