/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder.actions;

import com.hisagisoft.eclipse.gadgetholder.Constants;
import com.hisagisoft.eclipse.gadgetholder.actions.GadgetAction;
import com.hisagisoft.eclipse.gadgetholder.views.GadgetView;
import java.io.File;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ExportAction
extends GadgetAction
implements IAction {
    public ExportAction(GadgetView gv) {
        super(gv);
        this.logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.setToolTipText("\u30a8\u30af\u30b9\u30dd\u30fc\u30c8");
        this.setImageDescriptor(this.imageRegistry.getDescriptor("IMG_EXPORT"));
        this.setDisabledImageDescriptor(this.imageRegistry.getDescriptor("IMG_EXPORT_DISABLED"));
    }

    void doRun() throws Exception {
        boolean ok;
        this.logger.fine("EXPORT Action");
        FileDialog fd = new FileDialog(this.shell);
        fd.setFileName("export.html");
        fd.setFilterExtensions(new String[]{"*.html"});
        fd.setFilterPath(Constants.PATH_MY_DOCUMENTS);
        String filePath = fd.open();
        if (filePath == null) {
            return;
        }
        File file = new File(filePath);
        if (file.exists() && !(ok = MessageDialog.openConfirm((Shell)this.shell, (String)"Confirm", (String)"File already exists. Overwrite?"))) {
            this.logger.fine("CANCEL");
            return;
        }
        this.manager.exportGadget(file);
    }

    protected void postRun() {
    }
}

