/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.common.io;

import com.hisagisoft.common.io.ParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserUtils {
    private static Logger logger = Logger.getLogger(ParserUtils.class.getName());

    private ParserUtils() {
    }

    public static String fileToString(File file) throws IOException {
        String[] replaces = new String[]{"<", "\n<"};
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line.replaceAll(replaces[0], replaces[1]));
            }
        }
        catch (Throwable throwable) {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }

    public static List<String> extractTagContents(File file, String tag) throws ParseException {
        String input;
        assert (file != null);
        try {
            input = ParserUtils.fileToString(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ParseException(e);
        }
        ArrayList<String> contents = new ArrayList<String>();
        Pattern beginPattern = Pattern.compile("<" + tag, 2);
        Pattern endPattern = Pattern.compile("</" + tag + ">", 2);
        StringBuilder sb = null;
        boolean doit = false;
        Scanner scanner = new Scanner(input);
        while (scanner.hasNextLine()) {
            String nextLine = scanner.nextLine();
            Matcher beginMatcher = beginPattern.matcher(nextLine);
            Matcher endMatcher = endPattern.matcher(nextLine);
            if (beginMatcher.find()) {
                doit = true;
                sb = new StringBuilder();
                continue;
            }
            if (endMatcher.find()) {
                contents.add(sb.toString().replace("\n", ""));
                doit = false;
                sb = null;
                continue;
            }
            if (!doit) continue;
            sb.append(nextLine);
        }
        return contents;
    }

    public static File createFile(String prefix, String suffix, String data) {
        assert (data != null);
        File file = null;
        PrintWriter out = null;
        try {
            try {
                file = File.createTempFile(prefix, suffix);
                logger.info("create temp file = " + file.getAbsoluteFile().toString());
                out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                out.print(data);
            }
            catch (IOException e) {
                logger.severe(e.getClass() + " : " + e.getMessage());
                e.printStackTrace();
                throw new Error(e);
            }
        }
        finally {
            if (out != null) {
                out.close();
            } else {
                out = null;
            }
        }
        return file;
    }
}

