/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder.actions;

import com.hisagisoft.eclipse.gadgetholder.Constants;
import com.hisagisoft.eclipse.gadgetholder.Messages;
import com.hisagisoft.eclipse.gadgetholder.actions.GadgetAction;
import com.hisagisoft.eclipse.gadgetholder.views.GadgetView;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ExportAction
extends GadgetAction
implements IAction {
    public ExportAction(GadgetView gv) {
        super(gv);
        this.logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.setText(Constants.ACTION_NAME_EXPORT);
        this.setToolTipText(Constants.ACTION_NAME_EXPORT);
        this.setImageDescriptor(this.imageRegistry.getDescriptor("IMG_EXPORT"));
        this.setDisabledImageDescriptor(this.imageRegistry.getDescriptor("IMG_EXPORT_DISABLED"));
    }

    void doRun() throws Exception {
        boolean ok;
        this.logger.fine("EXPORT Action");
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String today = df.format(cal.getTime());
        this.logger.fine("today = " + today);
        FileDialog fd = new FileDialog(this.shell);
        fd.setFileName("export_" + today + ".html");
        fd.setFilterExtensions(new String[]{"*.html"});
        fd.setFilterPath(Constants.PATH_MY_DOCUMENTS);
        String filePath = fd.open();
        if (filePath == null) {
            return;
        }
        File file = new File(filePath);
        if (file.exists() && !(ok = MessageDialog.openConfirm((Shell)this.shell, (String)Messages.getString("dialog.overwrite.title"), (String)Messages.getString("dialog.overwrite.message")))) {
            this.logger.fine("CANCEL");
            return;
        }
        this.manager.exportGadget(file);
    }

    protected void postRun() {
    }
}

