/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder.actions;

import com.hisagisoft.eclipse.gadgetholder.Activator;
import com.hisagisoft.eclipse.gadgetholder.GadgetManager;
import com.hisagisoft.eclipse.gadgetholder.model.GadgetList;
import com.hisagisoft.eclipse.gadgetholder.views.GadgetView;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class GadgetAction
extends Action {
    protected Logger logger;
    protected Shell shell;
    protected GadgetManager manager;
    protected GadgetList gadgets;
    protected GadgetView view;
    protected ImageRegistry imageRegistry;

    public GadgetAction(GadgetView gv) {
        assert (gv != null);
        this.view = gv;
        this.shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        this.imageRegistry = Activator.getDefault().getImageRegistry();
        this.manager = GadgetManager.getInstance();
        this.gadgets = this.manager.getGadgets();
    }

    public final void run() {
        try {
            this.preRun();
            this.doRun();
            this.postRun();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void preRun() {
    }

    abstract void doRun() throws Exception;

    protected void postRun() {
        this.view.updateItemIcon();
        this.view.setEnabledActions();
    }
}

