/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder.views;

import com.hisagisoft.eclipse.gadgetholder.Activator;
import com.hisagisoft.eclipse.gadgetholder.Constants;
import com.hisagisoft.eclipse.gadgetholder.GadgetManager;
import com.hisagisoft.eclipse.gadgetholder.model.Gadget;
import com.hisagisoft.eclipse.gadgetholder.model.GadgetList;
import com.hisagisoft.eclipse.gadgetholder.views.PaletteListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class PaletteBrowser
extends ViewPart
implements Observer {
    public static final String ID = "com.hisagisoft.eclipse.gadgetholder.views.PaletteBrowser";
    private static Logger logger = Logger.getLogger(PaletteBrowser.class.getName());
    private GadgetManager manager = GadgetManager.getInstance();
    private GadgetList gadgets = this.manager.getGadgets();
    private IAction saveLocationAction;
    private IAction relocateAction;
    private ImageRegistry imageRegistry;
    private List<Composite> elements;
    private Composite base;
    private boolean isRelocatable = false;

    public PaletteBrowser() {
        this.gadgets.addObserver(this);
    }

    public void createPartControl(Composite parent) {
        this.imageRegistry = Activator.getDefault().getImageRegistry();
        this.elements = new ArrayList<Composite>();
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        this.base = new Composite((Composite)scrollComposite, 0);
        this.base.setBackground(Display.getCurrent().getSystemColor(1));
        int i = 0;
        while (i < this.gadgets.size()) {
            this.addBrowser(this.gadgets.get(i));
            ++i;
        }
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        scrollComposite.setContent((Control)this.base);
        scrollComposite.setMinSize(this.base.computeSize(-1, -1));
        parent.layout();
        this.makeActions();
    }

    public void dispose() {
        super.dispose();
        logger.fine("delete observer");
        this.gadgets.deleteObserver(this);
    }

    private void addBrowser(Gadget gadget) {
        logger.fine("add to palette. gadget.id = " + gadget.getId());
        Composite element = new Composite(this.base, 0);
        this.elements.add(element);
        element.setEnabled(!this.isRelocatable);
        element.setLayout((Layout)new GridLayout(1, false));
        if (this.isRelocatable) {
            element.setBackground(Display.getCurrent().getSystemColor(10));
        } else {
            element.setBackground(Display.getCurrent().getSystemColor(15));
        }
        if (gadget.getWidth() > 0) {
            element.setBounds(gadget.getLocation().x, gadget.getLocation().y, gadget.getWidth(), gadget.getHeight());
        } else {
            int i = gadget.getId();
            element.setBounds(i * 25, i * 25, 220, 220);
        }
        element.setData(Gadget.class.getName(), (Object)gadget);
        PaletteListener listener = new PaletteListener(element);
        this.base.addListener(3, (Listener)listener);
        this.base.addListener(4, (Listener)listener);
        this.base.addListener(5, (Listener)listener);
        Browser browser = new Browser(element, 0);
        browser.setUrl(gadget.getFile().getAbsolutePath());
        browser.setLayoutData((Object)new GridData(1808));
        element.layout();
        element.moveAbove(null);
    }

    private void makeActions() {
        this.saveLocationAction = new Action(){

            public void run() {
                logger.fine("Save Location Action");
                try {
                    for (Composite c : PaletteBrowser.this.elements) {
                        if (c.isDisposed()) continue;
                        Gadget g = (Gadget)c.getData(Gadget.class.getName());
                        g.getLocation().x = c.getLocation().x;
                        g.getLocation().y = c.getLocation().y;
                        g.setWidth(c.getSize().x);
                        g.setHeight(c.getSize().y);
                        logger.fine("bounds = " + g.getBounds());
                    }
                    PaletteBrowser.this.manager.saveProperties();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.saveLocationAction.setToolTipText(Constants.ACTION_NAME_SAVE_LOACTION);
        this.saveLocationAction.setText(Constants.ACTION_NAME_SAVE_LOACTION);
        this.saveLocationAction.setImageDescriptor(this.imageRegistry.getDescriptor("IMG_SAVE"));
        this.saveLocationAction.setDisabledImageDescriptor(this.imageRegistry.getDescriptor("IMG_SAVE_DISABLED"));
        this.relocateAction = new Action(Constants.ACTION_NAME_CHANGE_TO_RELOCATE_MODE, 2){

            public void run() {
                try {
                    PaletteBrowser.this.isRelocatable = !PaletteBrowser.this.isRelocatable;
                    for (Composite element : PaletteBrowser.this.elements) {
                        if (element.isDisposed()) continue;
                        element.setEnabled(!PaletteBrowser.this.isRelocatable);
                        if (PaletteBrowser.this.isRelocatable) {
                            element.setBackground(Display.getCurrent().getSystemColor(10));
                            continue;
                        }
                        element.setBackground(Display.getCurrent().getSystemColor(15));
                    }
                    if (PaletteBrowser.this.isRelocatable) {
                        PaletteBrowser.this.base.setBackground(Display.getCurrent().getSystemColor(16));
                        PaletteBrowser.this.base.setCursor(Constants.CURSOR_HAND);
                    } else {
                        PaletteBrowser.this.base.setBackground(Display.getCurrent().getSystemColor(1));
                        PaletteBrowser.this.base.setCursor(null);
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        };
        this.relocateAction.setImageDescriptor(this.imageRegistry.getDescriptor("IMG_RELOCATE"));
        this.relocateAction.setToolTipText(Constants.ACTION_NAME_CHANGE_TO_RELOCATE_MODE);
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager tbm = bars.getToolBarManager();
        tbm.add(this.relocateAction);
        tbm.add(this.saveLocationAction);
    }

    public void setFocus() {
    }

    public void update(Observable o, Object arg) {
        logger.fine("observable = " + o.getClass());
        if (o instanceof GadgetList) {
            int maxIdOfElements = -1;
            for (Composite element : this.elements) {
                if (element.isDisposed()) continue;
                Gadget g = (Gadget)element.getData(Gadget.class.getName());
                maxIdOfElements = g.getId();
                logger.fine("remove gadget.id = " + g.getId());
                if (this.gadgets.contains(g)) continue;
                element.dispose();
            }
            for (Gadget g : this.gadgets) {
                if (g.getId() <= maxIdOfElements) continue;
                this.addBrowser(g);
            }
        }
    }
}

