/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Properties;
import main.Debug;
import main.DocError;
import main.DocLoader;
import main.InteractionControler;
import org.xml.sax.SAXParseException;
import util.Getopt;
import util.Util;

public class Phoenix {
    public static final String COPYRIGHT = "(c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)\nUses Mozilla Rhino from mozilla.org.\nSee http://www.mozilla.org/rhino/.\n";
    public static final String NAME = "Galatea Dialog Manager 1.1.0 ";

    public static void showVersion() {
        System.out.println("Galatea Dialog Manager 1.1.0 (061020.1711)");
        System.out.print(COPYRIGHT);
        System.out.println();
    }

    public static void showUsage() {
        System.out.println("Usage:\tgalatea [options] document.vxml");
        System.out.println("\t -v : show version");
        System.out.println("\t -p : print translation results");
        System.out.println();
    }

    public static void main(String[] argv) {
        String s;
        int c;
        String conf = "phoenix.conf";
        boolean isPrintOnly = false;
        Getopt g = new Getopt("", argv, "c:p");
        g.setOpterr(false);
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 99: {
                    conf = g.getOptarg();
                    break;
                }
                case 112: {
                    isPrintOnly = true;
                }
            }
        }
        File conffile = new File(conf);
        if (!conffile.canRead()) {
            System.err.println("Cannot read configration file.");
            System.exit(1);
        }
        if (argv.length - g.getOptind() != 1) {
            Phoenix.showVersion();
            Phoenix.showUsage();
            System.exit(1);
        }
        try {
            Properties props = new Properties(System.getProperties());
            props.load(new FileInputStream(conffile));
            System.setProperties(props);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        if (isPrintOnly) {
            DocLoader.convert(argv[g.getOptind()]);
            System.exit(0);
        }
        if (Integer.parseInt(s = System.getProperty("ShowVersion", "1")) != 0) {
            Phoenix.showVersion();
        }
        s = System.getProperty("EnableTerminate", "0");
        boolean enableTerminate = false;
        if (Integer.parseInt(s) != 0) {
            enableTerminate = true;
        }
        Debug dbg = new Debug("Phoenix");
        try {
            String filename = argv[g.getOptind()];
            InteractionControler ic = new InteractionControler();
            while (filename.length() > 0) {
                dbg.print("Phoenix: filename:" + filename);
                ic.loadDocument(filename);
                ic.mainLoop();
                String nf = ic.getNextDocFile();
                if (nf.length() > 0) {
                    dbg.print("Phoenix: nf:" + nf);
                    filename = Util.resolveAdrs(filename, nf);
                    continue;
                }
                filename = "";
            }
            if (enableTerminate) {
                ic.terminate();
            }
        }
        catch (DocError e) {
            System.err.println();
            System.err.println(e);
            System.err.println("Document error.");
        }
        catch (SAXParseException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            System.err.println();
            System.err.println("File not found.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (enableTerminate) {
            System.err.println("Dialog Manager Terminated.");
            System.exit(0);
        } else {
            Util.halt();
        }
    }
}

