/*
 * Decompiled with CFR 0.152.
 */
package document;

import command.AddOutItemCommand;
import command.Command;
import command.CompositeCommand;
import command.EndCommand;
import command.EvaluateCommand;
import command.GotoCommand;
import command.HttpGetCommand;
import command.SetNextCommand;
import document.AbstractDoc;
import java.net.URI;
import java.net.URL;
import java.util.Stack;
import java.util.Vector;
import main.ContentState;
import main.Debug;
import main.DocError;
import main.DocWarning;
import main.GrammarSet;
import main.StateMap;
import org.w3c.dom.Element;
import outitem.AudioOutItem;
import outitem.BreakOutItem;
import outitem.LogOutItem;
import outitem.NativeOutItem;
import outitem.VoiceOutItem;
import relaxer.vxml20.GramGrammar;
import relaxer.vxml20.GramRule;
import relaxer.vxml20.GramToken;
import relaxer.vxml20.IGramGrammarChoice;
import relaxer.vxml20.IGramRuleMixed;
import relaxer.vxml20.IVxmlChoiceMixed;
import relaxer.vxml20.IVxmlVxmlChoice;
import relaxer.vxml20.RString;
import relaxer.vxml20.RVisitorBase;
import relaxer.vxml20.URVisitor;
import relaxer.vxml20.VxmlAssign;
import relaxer.vxml20.VxmlAudio;
import relaxer.vxml20.VxmlBlock;
import relaxer.vxml20.VxmlBreak;
import relaxer.vxml20.VxmlCONTEXT;
import relaxer.vxml20.VxmlCatch;
import relaxer.vxml20.VxmlChoice;
import relaxer.vxml20.VxmlClear;
import relaxer.vxml20.VxmlDisconnect;
import relaxer.vxml20.VxmlEMPH;
import relaxer.vxml20.VxmlElse;
import relaxer.vxml20.VxmlElseif;
import relaxer.vxml20.VxmlEmotion;
import relaxer.vxml20.VxmlEmphasis;
import relaxer.vxml20.VxmlEnumerate;
import relaxer.vxml20.VxmlError;
import relaxer.vxml20.VxmlExit;
import relaxer.vxml20.VxmlField;
import relaxer.vxml20.VxmlFilled;
import relaxer.vxml20.VxmlForm;
import relaxer.vxml20.VxmlGoto;
import relaxer.vxml20.VxmlHelp;
import relaxer.vxml20.VxmlIf;
import relaxer.vxml20.VxmlInitial;
import relaxer.vxml20.VxmlJVOICE;
import relaxer.vxml20.VxmlLink;
import relaxer.vxml20.VxmlLog;
import relaxer.vxml20.VxmlMark;
import relaxer.vxml20.VxmlMenu;
import relaxer.vxml20.VxmlMeta;
import relaxer.vxml20.VxmlNative;
import relaxer.vxml20.VxmlNoinput;
import relaxer.vxml20.VxmlNomatch;
import relaxer.vxml20.VxmlObject;
import relaxer.vxml20.VxmlOption;
import relaxer.vxml20.VxmlP;
import relaxer.vxml20.VxmlPITCH;
import relaxer.vxml20.VxmlPRON;
import relaxer.vxml20.VxmlParagraph;
import relaxer.vxml20.VxmlParam;
import relaxer.vxml20.VxmlPhoneme;
import relaxer.vxml20.VxmlPrompt;
import relaxer.vxml20.VxmlProperty;
import relaxer.vxml20.VxmlProsody;
import relaxer.vxml20.VxmlRATE;
import relaxer.vxml20.VxmlRecord;
import relaxer.vxml20.VxmlReprompt;
import relaxer.vxml20.VxmlReturn;
import relaxer.vxml20.VxmlS;
import relaxer.vxml20.VxmlSILENCE;
import relaxer.vxml20.VxmlSPELL;
import relaxer.vxml20.VxmlSayAs;
import relaxer.vxml20.VxmlScript;
import relaxer.vxml20.VxmlSentence;
import relaxer.vxml20.VxmlSubmit;
import relaxer.vxml20.VxmlThrow;
import relaxer.vxml20.VxmlTransfer;
import relaxer.vxml20.VxmlVOLUME;
import relaxer.vxml20.VxmlValue;
import relaxer.vxml20.VxmlVar;
import relaxer.vxml20.VxmlVoice;
import relaxer.vxml20.VxmlVxml;
import util.GrammarUtil;
import util.HashArray;
import util.Util;

public class VXMLDoc
implements AbstractDoc {
    private static double promptTimeout_ = 10.0;
    private static double startupWait_ = 10.0;
    private Debug dbg = new Debug("VXMLDoc");
    private String docAddress_ = null;
    private GrammarSet grammarSet_ = null;
    private VxmlVxml vxml_ = null;
    private StateMap stateMap_ = null;
    private Vector docErrors_ = null;
    private Vector docWarnings_ = null;
    private int unique_ = 0;

    private String _getEvalWith(String s, String w) {
        if (s == null) {
            return "true";
        }
        if (w.length() > 0) {
            StringBuffer script = new StringBuffer("with(");
            script.append(w);
            script.append("){");
            script.append(s);
            script.append("}");
            return script.toString();
        }
        return s;
    }

    private String _getCSS2TimesAsMsec(String in) {
        String ret = in;
        if (in.endsWith("ms")) {
            String num = in.substring(0, in.length() - 2);
            int n = Float.valueOf(num).intValue();
            ret = Integer.toString(n);
        } else if (in.endsWith("s")) {
            String num = in.substring(0, in.length() - 1);
            float d = Float.valueOf(num).floatValue();
            int n = new Float((double)d * 1000.0).intValue();
            ret = Integer.toString(n);
        }
        return ret;
    }

    private String _getUniqueId() {
        ++this.unique_;
        StringBuffer id = new StringBuffer("$").append(this.unique_);
        return id.toString();
    }

    public String getDocAddress() {
        return this.docAddress_;
    }

    public void setDocAddress(String adrs) {
        this.docAddress_ = adrs;
    }

    public String resolveAdrs(String org) {
        return Util.resolveAdrs(this.docAddress_, org);
    }

    public boolean isInsideDoc(String f) {
        return Util.isSameFile(this.docAddress_, f);
    }

    public String getDialogID(String f) {
        String dlg = "__default__";
        try {
            URI u = new URI(f);
            dlg = u.getFragment();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dlg;
    }

    private String getFirstDialogID() {
        String firstId = null;
        this.dbg.print("vxml_:" + this.vxml_);
        int nContent = this.vxml_.sizeContent();
        this.dbg.print("nContent:" + nContent, 2);
        int i = 0;
        while (i < nContent) {
            IVxmlVxmlChoice choice = this.vxml_.getContent(i);
            if (choice instanceof VxmlForm) {
                VxmlForm o = (VxmlForm)choice;
                firstId = o.getId();
                if (firstId == null) {
                    o.setId("__first_dialog__");
                    firstId = o.getId();
                } else if (firstId.equals("")) {
                    o.setId("__first_dialog__");
                    firstId = o.getId();
                }
                this.dbg.print("firstId:" + firstId);
                break;
            }
            if (choice instanceof VxmlMenu) {
                VxmlMenu o = (VxmlMenu)choice;
                firstId = o.getId();
                if (firstId == null) {
                    o.setId("__first_dialog__");
                    firstId = o.getId();
                } else if (firstId.equals("")) {
                    o.setId("__first_dialog__");
                    firstId = o.getId();
                }
                this.dbg.print("firstId:" + firstId);
                break;
            }
            ++i;
        }
        return firstId;
    }

    private String getText(IVxmlChoiceMixed cm) {
        String text = "";
        if (cm instanceof RString) {
            RString rs = (RString)cm;
            text = Util.removeSpaces(rs.getText());
        } else if (cm instanceof GramGrammar) {
            GramGrammar gram = (GramGrammar)cm;
            int j = 0;
            while (j < gram.sizeContent()) {
                IGramGrammarChoice gc = gram.getContent(j);
                if (gc instanceof GramRule) {
                    GramRule rule = (GramRule)gc;
                    int k = 0;
                    while (k < rule.sizeContent()) {
                        IGramRuleMixed rm = rule.getContent(k);
                        if (rm instanceof GramToken) {
                            GramToken gt = (GramToken)rm;
                            text = Util.removeSpaces(gt.getContent());
                        }
                        ++k;
                    }
                }
                ++j;
            }
        }
        return text;
    }

    private void _addJulianGrammarToGS(GrammarSet gs, GramGrammar gram) throws Exception {
        String src = gram.getSrc();
        String julianGramName = null;
        julianGramName = src != null ? src : System.getProperty("GrammarName");
        gs.setJulian(true);
        gs.setJulianGramName(julianGramName);
    }

    private void _addGrammarToGS(GrammarSet gs, GramGrammar gram) throws Exception {
        String type = gram.getType();
        if (type == null) {
            type = "application/srgs+xml";
        }
        if (type.equals("application/julian") || type.equals("julian")) {
            this._addJulianGrammarToGS(gs, gram);
        } else {
            this.dbg.ASSERT(type.equals("application/srgs+xml"), "grammar type error");
            GramGrammar gramXml = null;
            String gramAdrs = null;
            String src = gram.getSrc();
            if (src == null) {
                gramXml = gram;
                gramAdrs = this.docAddress_;
            } else {
                gramAdrs = Util.resolveAdrs(this.docAddress_, src);
                gramXml = new GramGrammar(gramAdrs);
            }
            GrammarUtil.makePhonemeFromSym(gramXml);
            gs.setJulian(false);
            gs.addRules(gramXml, gramAdrs);
        }
    }

    private void _addAppInitStates(String app, StateMap stateMap) throws Exception {
        String firstID;
        String appInitScript = "document = new Object();\ndialog = new Object();\n";
        if (app == null) {
            appInitScript = String.valueOf(appInitScript) + "session = new Object();\napplication = new Object();\n";
        } else {
            appInitScript = String.valueOf(appInitScript) + "var $root = '" + this.docAddress_ + "';\n" + "if ( $current_root == undefined ) {\n" + "  var $current_root;\n" + "}\n" + "if ( $current_root != $root ) {\n" + "  $current_root = $root;\n" + "  session = new Object();\n" + "  application = new Object();\n";
            String applicationRoot = this.resolveAdrs(app);
            this.dbg.print("rootVxml:" + applicationRoot);
            VxmlVxml rootVxml = new VxmlVxml(applicationRoot);
            this.dbg.print("Parsing applicationRoot...", 2);
            int nContent = rootVxml.sizeContent();
            int i = 0;
            while (i < nContent) {
                IVxmlVxmlChoice choice = rootVxml.getContent(i);
                if (choice instanceof VxmlVar) {
                    VxmlVar var = (VxmlVar)choice;
                    String name = var.getName();
                    String expr = var.getExpr();
                    String command = "  application." + name + "=" + expr + ";\n";
                    appInitScript = String.valueOf(appInitScript) + command;
                } else if (choice instanceof VxmlLink) {
                    VxmlLink link = (VxmlLink)choice;
                    String n = link.getNext();
                    String next = Util.resolveAdrs(applicationRoot, n);
                    this.dbg.print("link next=" + next);
                }
                ++i;
            }
            appInitScript = String.valueOf(appInitScript) + "}\n";
        }
        ContentState appInitState = new ContentState();
        String docName = "@document";
        appInitState.setName(docName);
        if (appInitScript.length() > 0) {
            appInitState.addCommand(new EvaluateCommand(appInitScript));
        }
        if ((firstID = this.getFirstDialogID()) == null) {
            throw new DocError("VXML leaf document " + this.docAddress_ + " has no menu or form.");
        }
        stateMap.add(appInitState);
        stateMap.setFirstStateName(docName);
        stateMap.setNext(docName, "@" + firstID);
        stateMap.addCommand(docName, new AddOutItemCommand(new BreakOutItem(startupWait_ * 1000.0, false)));
        String script = "$prompt_timeout = " + Double.toString(promptTimeout_ * 1000.0);
        stateMap.addCommand(docName, new EvaluateCommand(script));
    }

    public VXMLDoc(Element e, String adrs) throws Exception {
        String s = System.getProperty("VXMLDoc.PromptTimeout", "10.0");
        promptTimeout_ = Double.parseDouble(s);
        s = System.getProperty("VXMLDoc.StartupWait", "10.0");
        startupWait_ = Double.parseDouble(s);
        this.docErrors_ = new Vector();
        this.docWarnings_ = new Vector();
        if (!VxmlVxml.isMatch(e)) {
            throw new DocError("Not a valid <vxml> document.");
        }
        this.vxml_ = new VxmlVxml(e);
        this.grammarSet_ = new GrammarSet();
        this.docAddress_ = adrs;
        this.stateMap_ = new StateMap();
        this._addAppInitStates(this.vxml_.getApplication(), this.stateMap_);
        Visitor visitor = new Visitor();
        URVisitor.traverse(this.vxml_, visitor);
        if (this.docErrors_.size() > 0) {
            String err = "";
            int i = 0;
            while (i < this.docErrors_.size()) {
                err = String.valueOf(err) + this.docErrors_.get(i).toString() + "\n";
                ++i;
            }
            throw new DocError("Leaf document has following error(s):\n" + err);
        }
        if (this.docWarnings_.size() > 0) {
            String err = "";
            int i = 0;
            while (i < this.docWarnings_.size()) {
                System.err.println(e);
                ++i;
            }
        }
        this.stateMap_.setGrammarSet(this.grammarSet_);
    }

    public StateMap getStateMap() {
        return this.stateMap_;
    }

    protected class Visitor
    extends RVisitorBase {
        private Dialog dialog_ = new Dialog();
        private HashArray formItems_ = null;
        private String formVarInitScript_ = null;
        private Stack visitorStack_ = new Stack();
        private Vector promptList_ = null;
        Commands commands_ = new Commands();
        ExecContents execContents_ = new ExecContents();
        TextBuf textBuf_ = new TextBuf();
        private String currPromptCond_ = null;
        private String currPromptCount_ = null;
        private boolean currPromptBargein_ = true;
        private String currPromptBargeintype_ = "speech";
        private String currPromptTimeout_ = null;
        private String currIfCond_ = null;
        private String leaveProsodyTag_ = null;

        protected Visitor() {
        }

        public boolean enter(VxmlVxml v) {
            this.visitorStack_.push(v);
            return true;
        }

        public void leave(VxmlVxml v) {
            this.visitorStack_.pop();
        }

        private void _grammarProcState(String text) {
            String formitem = String.valueOf(this.dialog_.getName()) + "." + this.dialog_.getItemName();
            String filled = "@" + this.dialog_.getName() + ".@process";
            String s = "@" + formitem + "." + VXMLDoc.this._getUniqueId();
            String newID = VXMLDoc.this.stateMap_.newState(s);
            VXMLDoc.this.stateMap_.addTrans("@" + formitem, newID, text);
            VXMLDoc.this.stateMap_.addCommand(newID, new EvaluateCommand(String.valueOf(formitem) + "='" + text + "';\n"));
            VXMLDoc.this.stateMap_.addCommand(newID, new EvaluateCommand(String.valueOf(formitem) + "$.justfilled = true;\n"));
            VXMLDoc.this.stateMap_.setNext(newID, filled);
        }

        public boolean enter(GramGrammar gram) {
            try {
                VXMLDoc.this._addGrammarToGS(VXMLDoc.this.grammarSet_, gram);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.visitorStack_.peek() instanceof VxmlField) {
                int k = 0;
                while (k < gram.sizeContent()) {
                    IGramGrammarChoice gc = gram.getContent(k);
                    if (gc instanceof GramRule) {
                        GramRule rule = (GramRule)gc;
                        int l = 0;
                        while (l < rule.sizeContent()) {
                            IGramRuleMixed rm = rule.getContent(l);
                            if (rm instanceof GramToken) {
                                GramToken gt = (GramToken)rm;
                                String text = Util.removeSpaces(gt.getContent());
                                this._grammarProcState(text);
                            }
                            ++l;
                        }
                    }
                    ++k;
                }
            }
            return true;
        }

        private String _makeFormState() {
            String form = "@" + this.dialog_.getName();
            String t = VXMLDoc.this.stateMap_.newState(form);
            VXMLDoc.this.dbg.ASSERT(t.equals(form), "VxmlForm#leave");
            String sc = String.valueOf(this.dialog_.getName()) + " = new Object();\n";
            sc = String.valueOf(sc) + this.dialog_.getName() + ".next$ = undefined;\n";
            sc = String.valueOf(sc) + this.formVarInitScript_;
            VXMLDoc.this.stateMap_.addCommand(form, new EvaluateCommand(sc));
            int i = 0;
            while (i < this.formItems_.size()) {
                String name = this.formItems_.getKey(i);
                sc = String.valueOf(this.dialog_.getName()) + "." + name + " = undefined;\n";
                VXMLDoc.this.stateMap_.addScriptCommand(form, sc);
                Object fi = this.formItems_.get(i);
                String shadow = String.valueOf(this.dialog_.getName()) + "." + name + "$";
                if (fi instanceof VxmlField) {
                    sc = String.valueOf(shadow) + " = new Object();\n";
                    sc = String.valueOf(sc) + shadow + ".promptcount = 1;\n";
                    sc = String.valueOf(sc) + shadow + ".justfilled = false;\n";
                    sc = String.valueOf(sc) + shadow + ".noprompt = false;\n";
                    VXMLDoc.this.stateMap_.addScriptCommand(form, sc);
                }
                ++i;
            }
            return form;
        }

        private String _makeFormSelectState() {
            String name;
            String select = "@" + this.dialog_.getName() + ".@select";
            String t = VXMLDoc.this.stateMap_.newState(select);
            VXMLDoc.this.dbg.ASSERT(t.equals(select), "VxmlForm#leave");
            String sc = "";
            int i = 0;
            while (i < this.formItems_.size()) {
                name = this.formItems_.getKey(i);
                if (i > 0) {
                    sc = String.valueOf(sc) + "} else ";
                }
                sc = String.valueOf(sc) + "if (" + this.dialog_.getName() + "." + name + " == undefined) {\n";
                sc = String.valueOf(sc) + this.dialog_.getName() + ".next$ = '@" + this.dialog_.getName() + "." + name + "';\n";
                ++i;
            }
            sc = String.valueOf(sc) + "}\n";
            VXMLDoc.this.stateMap_.addCommand(select, new EvaluateCommand(sc));
            i = 0;
            while (i < this.formItems_.size()) {
                name = this.formItems_.getKey(i);
                Object fi = this.formItems_.get(i);
                if (fi instanceof VxmlField) {
                    sc = String.valueOf(this.dialog_.getName()) + "." + name + "$.justfilled = false;";
                    VXMLDoc.this.stateMap_.addCommand(select, new EvaluateCommand(sc));
                }
                ++i;
            }
            sc = String.valueOf(this.dialog_.getName()) + ".next$";
            VXMLDoc.this.stateMap_.addCommand(select, new SetNextCommand(sc));
            return select;
        }

        private String _makeFormFilledState() {
            String filled = "@" + this.dialog_.getName() + ".@process";
            String t = VXMLDoc.this.stateMap_.newState(filled);
            VXMLDoc.this.dbg.ASSERT(t.equals(filled), "VxmlForm#leave");
            return filled;
        }

        public boolean enter(VxmlForm vxmlForm) {
            this.dialog_.setName(vxmlForm.getId());
            this.formItems_ = new HashArray();
            this.formVarInitScript_ = "";
            this.visitorStack_.push(vxmlForm);
            return true;
        }

        public void leave(VxmlForm o) {
            String form = this._makeFormState();
            String select = this._makeFormSelectState();
            String filled = this._makeFormFilledState();
            VXMLDoc.this.stateMap_.setNext(form, select);
            VXMLDoc.this.stateMap_.setNext(filled, select);
            this.visitorStack_.pop();
        }

        public boolean enter(VxmlBlock vxmlBlock) {
            if (vxmlBlock.getName() == null) {
                this.dialog_.setItemName(VXMLDoc.this._getUniqueId());
            } else {
                this.dialog_.setItemName(vxmlBlock.getName());
            }
            String s = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName();
            String t = VXMLDoc.this.stateMap_.newState(s);
            VXMLDoc.this.dbg.ASSERT(t.equals(s), "VxmlBlock#enter");
            VXMLDoc.this.stateMap_.addCommand(s, new EvaluateCommand(String.valueOf(this.dialog_.getName()) + "." + this.dialog_.getItemName() + "= true;\n"));
            this.visitorStack_.push(vxmlBlock);
            this.formItems_.put(this.dialog_.getItemName(), vxmlBlock);
            this.commands_.setupCommands();
            this.execContents_.setupExecContent();
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlBlock vxmlBlock) {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String s = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName();
            this.commands_.flushCommands(s);
            VXMLDoc.this.stateMap_.setNext(s, "@" + this.dialog_.getName() + ".@select");
            this.visitorStack_.pop();
        }

        public boolean enter(VxmlFilled e) {
            String cond = "true";
            VXMLDoc.this.dbg.print("VXMLDoc:enter#VxmlFilled peek:" + this.visitorStack_.peek());
            this.commands_.setupCommands();
            if (this.visitorStack_.peek() instanceof VxmlField) {
                String sWith = String.valueOf(this.dialog_.getName()) + "." + this.dialog_.getItemName() + "$";
                cond = String.valueOf(sWith) + ".justfilled";
            } else {
                cond = "with(" + this.dialog_.getName() + "){";
                int i = 0;
                while (i < this.formItems_.size()) {
                    String name = this.formItems_.getKey(i);
                    if (i > 0) {
                        cond = String.valueOf(cond) + " && ";
                    }
                    cond = String.valueOf(cond) + name + "!=undefined";
                    ++i;
                }
                cond = String.valueOf(cond) + "}";
            }
            this.execContents_.setupExecContent(cond);
            this.textBuf_.setupSpeak();
            this.visitorStack_.push(e);
            return true;
        }

        public void leave(VxmlFilled e) {
            this.visitorStack_.pop();
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String filled = "@" + this.dialog_.getName() + ".@process";
            this.commands_.flushCommands(filled);
        }

        private void _makeInputEventHandler(String field) {
            String select = "@" + this.dialog_.getName() + ".@select";
            String noinput = VXMLDoc.this.stateMap_.newState(String.valueOf(field) + ".noinput");
            VXMLDoc.this.stateMap_.setNext(field, noinput);
            VXMLDoc.this.stateMap_.setNext(noinput, select);
            String nomatch = VXMLDoc.this.stateMap_.newState(String.valueOf(field) + ".nomatch");
            VXMLDoc.this.stateMap_.addTrans(field, nomatch, "<nomatch>");
            VXMLDoc.this.stateMap_.setNext(nomatch, select);
            String help = VXMLDoc.this.stateMap_.newState(String.valueOf(field) + ".help");
            VXMLDoc.this.stateMap_.addTrans(field, help, "HELP");
            VXMLDoc.this.stateMap_.setNext(help, select);
        }

        public boolean enter(VxmlField vxmlField) {
            if (vxmlField.getName() == null) {
                this.dialog_.setItemName(VXMLDoc.this._getUniqueId());
            } else {
                if (this.formItems_.has(vxmlField.getName())) {
                    VXMLDoc.this.docErrors_.add(new DocError("Field name dupulication."));
                    return false;
                }
                this.dialog_.setItemName(vxmlField.getName());
            }
            this.formItems_.put(this.dialog_.getItemName(), vxmlField);
            VXMLDoc.this.dbg.ASSERT(this.dialog_.getItemName() != null, "vxmlForm#enter");
            String f = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName();
            String field = VXMLDoc.this.stateMap_.newState(f);
            this._makeInputEventHandler(field);
            this.promptList_ = new Vector();
            this.visitorStack_.push(vxmlField);
            return true;
        }

        private void _makePromptSelect() {
            int n;
            Prompt prompt;
            String field = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName();
            String promptCond = "!" + this.dialog_.getName() + "." + this.dialog_.getItemName() + "$" + ".noprompt";
            CompositeCommand promptCmd = new CompositeCommand(new Vector(), promptCond);
            if (this.promptList_ == null) {
                return;
            }
            String sWith = String.valueOf(this.dialog_.getName()) + "." + this.dialog_.getItemName() + "$";
            String script = "";
            int i = 0;
            while (i < this.promptList_.size()) {
                prompt = (Prompt)this.promptList_.get(i);
                script = prompt.cond == null ? String.valueOf(script) + "p" + i + " = true;\n" : String.valueOf(script) + "p" + i + " = (" + prompt.cond + ");\n";
                ++i;
            }
            promptCmd.addScriptCommand(script, sWith);
            script = "cc = 1;\n";
            i = 0;
            while (i < this.promptList_.size()) {
                prompt = (Prompt)this.promptList_.get(i);
                n = prompt.count;
                script = String.valueOf(script) + "if(" + n + "<=promptcount && cc<" + n + "){cc=" + n + "};\n";
                ++i;
            }
            promptCmd.addScriptCommand(script, sWith);
            script = "";
            i = 0;
            while (i < this.promptList_.size()) {
                prompt = (Prompt)this.promptList_.get(i);
                n = prompt.count;
                script = String.valueOf(script) + "if(" + n + "!=cc){p" + i + "=false};\n";
                ++i;
            }
            promptCmd.addScriptCommand(script, sWith);
            script = String.valueOf(this.dialog_.getName()) + "." + this.dialog_.getItemName() + "$" + ".promptcount++;\n";
            promptCmd.addScriptCommand(script);
            i = 0;
            while (i < this.promptList_.size()) {
                Command co;
                prompt = (Prompt)this.promptList_.get(i);
                String cond = "with(" + sWith + "){p" + i + "}";
                if (prompt.commands.size() == 1 && prompt.commands.get(0) instanceof CompositeCommand) {
                    co = (Command)prompt.commands.get(0);
                    co.setCondition(cond);
                    promptCmd.addCommand(co);
                } else {
                    co = new CompositeCommand(prompt.commands, cond);
                    promptCmd.addCommand(co);
                }
                ++i;
            }
            VXMLDoc.this.stateMap_.addCommand(field, promptCmd);
            AddOutItemCommand c = new AddOutItemCommand(new BreakOutItem("$prompt_timeout", this.currPromptBargein_));
            VXMLDoc.this.stateMap_.addCommand(field, c);
        }

        public void leave(VxmlField vxmlField) {
            this.visitorStack_.pop();
            this._makePromptSelect();
        }

        public boolean enter(VxmlVar e) {
            if (e.getName() == null) {
                return false;
            }
            String aname = e.getName();
            String aexpr = "undefined";
            if (e.getExpr() != null) {
                aexpr = e.getExpr();
            }
            if (this.visitorStack_.peek() instanceof VxmlVxml) {
                String sc = VXMLDoc.this._getEvalWith(String.valueOf(aname) + "=" + aexpr, "document");
                this.formVarInitScript_ = String.valueOf(this.formVarInitScript_) + sc + ";\n";
            } else if (this.visitorStack_.peek() instanceof VxmlForm) {
                String sc = VXMLDoc.this._getEvalWith(String.valueOf(aname) + "=" + aexpr, this.dialog_.getName());
                this.formVarInitScript_ = String.valueOf(this.formVarInitScript_) + sc + ";\n";
            }
            return true;
        }

        public boolean enter(VxmlMenu vxmlMenu) {
            if (vxmlMenu.getId() == null) {
                this.dialog_.setName(VXMLDoc.this._getUniqueId());
            } else {
                this.dialog_.setName(vxmlMenu.getId());
            }
            this.dialog_.setItemName("_menu_");
            String m = "@" + this.dialog_.getName();
            String menu = VXMLDoc.this.stateMap_.newState(m);
            VXMLDoc.this.dbg.ASSERT(m.equals(menu), "vxmlMenu#enter");
            String select = VXMLDoc.this.stateMap_.newState(String.valueOf(menu) + ".@select");
            String f = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName();
            String field = VXMLDoc.this.stateMap_.newState(f);
            VXMLDoc.this.dbg.ASSERT(f.equals(field), "vxmlMenu#enter");
            VXMLDoc.this.stateMap_.setNext(menu, select);
            VXMLDoc.this.stateMap_.setNext(select, field);
            this._makeInputEventHandler(field);
            this.promptList_ = new Vector();
            this.visitorStack_.push(vxmlMenu);
            return true;
        }

        public void leave(VxmlMenu o) {
            this.visitorStack_.pop();
            String form = "@" + this.dialog_.getName();
            String field = String.valueOf(form) + "." + this.dialog_.getItemName();
            String script = String.valueOf(this.dialog_.getName()) + " = new Object();\n";
            String shadow = String.valueOf(this.dialog_.getName()) + "._menu_$";
            script = String.valueOf(script) + shadow + " = new Object();\n";
            script = String.valueOf(script) + shadow + ".promptcount = 1;\n";
            script = String.valueOf(script) + shadow + ".noprompt = false;\n";
            VXMLDoc.this.stateMap_.addScriptCommand(form, script);
            VXMLDoc.this.stateMap_.setNext(form, field);
            this._makePromptSelect();
        }

        public boolean enter(VxmlChoice vxmlChoice) {
            String next = null;
            String n = vxmlChoice.getNext();
            if (n == null) {
                VXMLDoc.this.docErrors_.add(new DocError("No next in choice."));
                return false;
            }
            next = Util.removeSpaces(n);
            String image = "";
            String im = vxmlChoice.getImage();
            if (im != null) {
                image = Util.removeSpaces(im);
                image = VXMLDoc.this.resolveAdrs(image);
                VXMLDoc.this.dbg.ASSERT(image != null, "VxmlChoce#enter");
            }
            String menuState = "@" + this.dialog_.getName() + "._menu_";
            int i = 0;
            while (i < vxmlChoice.sizeContent()) {
                String text = VXMLDoc.this.getText(vxmlChoice.getContent(i));
                VXMLDoc.this.dbg.ASSERT(text != null, "VxmlChoce#enter");
                if (text.length() > 0) {
                    if (next.startsWith("#")) {
                        String nextState = "@" + next.substring(1);
                        VXMLDoc.this.stateMap_.addTrans(menuState, nextState, text);
                    } else if (next.startsWith("http://")) {
                        HttpGetCommand c = null;
                        try {
                            c = new HttpGetCommand(new URL(next));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        VXMLDoc.this.stateMap_.addCommand(menuState, c);
                    }
                }
                ++i;
            }
            return true;
        }

        public boolean enter(VxmlPrompt vxmlPrompt) {
            if (vxmlPrompt.getBargein() != null && vxmlPrompt.getBargein().equals("false")) {
                this.currPromptBargein_ = false;
            }
            if (vxmlPrompt.getBargeintype() != null) {
                this.currPromptBargeintype_ = vxmlPrompt.getBargeintype();
            }
            if (this.visitorStack_.peek() instanceof VxmlMenu || this.visitorStack_.peek() instanceof VxmlField) {
                this.currPromptCond_ = vxmlPrompt.getCond();
                this.currPromptCount_ = vxmlPrompt.getCount();
                this.commands_.setCommands(new Vector());
                this.execContents_.setupExecContent();
            }
            if (vxmlPrompt.getTimeout() != null) {
                String msec = VXMLDoc.this._getCSS2TimesAsMsec(vxmlPrompt.getTimeout());
                String script = "$prompt_timeout = " + msec;
                this.commands_.appendCommands(new EvaluateCommand(script));
            }
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlPrompt vxmlPrompt) {
            this.textBuf_.flushSpeak();
            if (this.visitorStack_.peek() instanceof VxmlMenu || this.visitorStack_.peek() instanceof VxmlField) {
                this.execContents_.flushExecContent();
                Prompt prompt = new Prompt();
                prompt.cond = this.currPromptCond_ == null ? "true" : this.currPromptCond_;
                prompt.count = this.currPromptCount_ == null ? 1 : Integer.valueOf(this.currPromptCount_);
                prompt.commands = this.commands_.getCommands();
                this.commands_.clearCommands();
                this.promptList_.add(prompt);
            }
            this.currPromptBargein_ = true;
            this.currPromptBargeintype_ = "speech";
            this.currPromptTimeout_ = null;
        }

        private void _enterNomatch() {
            this.commands_.setupCommands();
            this.execContents_.setupExecContent();
            this.textBuf_.setupSpeak();
            String shadow = String.valueOf(this.dialog_.getName()) + "." + this.dialog_.getItemName() + "$";
            this.execContents_.appendExecContent(new EvaluateCommand("noprompt = true;", shadow));
        }

        public boolean enter(VxmlNomatch o) {
            this._enterNomatch();
            this.visitorStack_.push(o);
            return true;
        }

        private void _leaveNomatch() {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String nomatch = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName() + ".nomatch";
            this.commands_.flushCommands(nomatch);
        }

        public void leave(VxmlNomatch o) {
            this._leaveNomatch();
            this.visitorStack_.pop();
        }

        private void _enterNoinput() {
            this.commands_.setupCommands();
            this.execContents_.setupExecContent();
            this.textBuf_.setupSpeak();
            String shadow = String.valueOf(this.dialog_.getName()) + "." + this.dialog_.getItemName() + "$";
            this.execContents_.appendExecContent(new EvaluateCommand("noprompt = true;", shadow));
        }

        public boolean enter(VxmlNoinput o) {
            this._enterNoinput();
            this.visitorStack_.push(o);
            return true;
        }

        private void _leaveNoinput() {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String noinput = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName() + ".noinput";
            this.commands_.flushCommands(noinput);
        }

        public void leave(VxmlNoinput o) {
            this._leaveNoinput();
            this.visitorStack_.pop();
        }

        private void _enterHelp() {
            this.commands_.setupCommands();
            this.execContents_.setupExecContent();
            this.textBuf_.setupSpeak();
            String shadow = String.valueOf(this.dialog_.getName()) + "." + this.dialog_.getItemName() + "$";
            this.execContents_.appendExecContent(new EvaluateCommand("noprompt = true;", shadow));
        }

        public boolean enter(VxmlHelp o) {
            this._enterHelp();
            this.visitorStack_.push(o);
            return true;
        }

        private void _leaveHelp() {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String help = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName() + ".help";
            this.commands_.flushCommands(help);
        }

        public void leave(VxmlHelp e) {
            this._leaveHelp();
            this.visitorStack_.pop();
        }

        public boolean enter(VxmlCatch o) {
            if (o.getEvent() == null) {
                VXMLDoc.this.docErrors_.add(new DocError("No EVENT in <catch>"));
                return false;
            }
            String event = o.getEvent();
            if (event.equals("nomatch")) {
                this._enterNomatch();
            } else if (event.equals("noinput")) {
                this._enterNoinput();
            } else if (event.equals("help")) {
                this._enterHelp();
            } else {
                if (event.equals("error")) {
                    VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <catch event=error>"));
                    return false;
                }
                VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <catch>"));
                return false;
            }
            this.visitorStack_.push(o);
            return true;
        }

        public void leave(VxmlCatch o) {
            if (this.visitorStack_.peek() instanceof VxmlCatch && ((VxmlCatch)this.visitorStack_.peek()).getEvent() != null) {
                String event = ((VxmlCatch)this.visitorStack_.peek()).getEvent();
                if (event.equals("nomatch")) {
                    this._leaveNomatch();
                } else if (event.equals("noinput")) {
                    this._leaveNoinput();
                } else if (event.equals("help")) {
                    this._leaveHelp();
                }
            }
            this.visitorStack_.pop();
        }

        public boolean enter(VxmlReprompt e) {
            this.textBuf_.flushSpeak();
            String shadow = String.valueOf(this.dialog_.getName()) + "." + this.dialog_.getItemName() + "$";
            String script = "noprompt = false;\n";
            this.execContents_.appendExecContent(new EvaluateCommand(script, shadow));
            this.textBuf_.setupSpeak();
            return true;
        }

        public boolean enter(RString rs) {
            String text = rs.getText();
            VXMLDoc.this.dbg.print("RString: " + text);
            this.textBuf_.appendString(text);
            return true;
        }

        public boolean enter(VxmlValue vxmlValue) {
            if (vxmlValue.getExpr() != null) {
                String expr = vxmlValue.getExpr();
                this.textBuf_.appendValue("(" + expr + ")");
            }
            return true;
        }

        public boolean enter(VxmlGoto g) {
            this.textBuf_.flushSpeak();
            String n = g.getNext();
            if (n == null) {
                VXMLDoc.this.docErrors_.add(new DocError("no next in <goto>"));
                return false;
            }
            String next = Util.removeSpaces(n);
            if (next.startsWith("#")) {
                String sc = "'@" + next.substring(1) + "'";
                this.execContents_.appendExecContent(new GotoCommand(sc));
            } else {
                boolean now = false;
                String cond = "true";
                String eval = "'" + next + "'";
                EndCommand c = new EndCommand(eval, cond, now);
                this.execContents_.appendExecContent(c);
            }
            this.textBuf_.setupSpeak();
            return true;
        }

        public boolean enter(VxmlExit e) {
            this.textBuf_.flushSpeak();
            this.execContents_.appendExecContent(new EndCommand(false));
            return true;
        }

        public boolean enter(VxmlAssign e) {
            this.textBuf_.flushSpeak();
            String aname = e.getName();
            String aexpr = e.getExpr();
            if (aname == null || aexpr == null) {
                VXMLDoc.this.docErrors_.add(new DocError("<assign> needs NAME and EXPR."));
                return false;
            }
            String sc = VXMLDoc.this._getEvalWith(String.valueOf(aname) + "=" + aexpr, this.dialog_.getName());
            this.execContents_.appendExecContent(new EvaluateCommand(sc));
            this.textBuf_.setupSpeak();
            return true;
        }

        public boolean enter(VxmlScript e) {
            this.textBuf_.flushSpeak();
            String text = e.getContent();
            String sc = VXMLDoc.this._getEvalWith(text, this.dialog_.getName());
            this.execContents_.appendExecContent(new EvaluateCommand(sc));
            this.textBuf_.setupSpeak();
            return true;
        }

        public boolean enter(VxmlIf e) {
            this.currIfCond_ = e.getCond();
            String cond = VXMLDoc.this._getEvalWith(this.currIfCond_, this.dialog_.getName());
            this.execContents_.setupExecContent(cond);
            return true;
        }

        public void leave(VxmlIf e) {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
        }

        public boolean enter(VxmlElse e) {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String cond = VXMLDoc.this._getEvalWith("!(" + this.currIfCond_ + ")", this.dialog_.getName());
            this.execContents_.setupExecContent(cond);
            return true;
        }

        public boolean enter(VxmlElseif e) {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String c = e.getCond();
            String cond = VXMLDoc.this._getEvalWith(c, this.dialog_.getName());
            this.currIfCond_ = String.valueOf(this.currIfCond_) + " || " + c;
            this.execContents_.setupExecContent(cond);
            this.textBuf_.setupSpeak();
            return true;
        }

        public boolean enter(VxmlBreak e) {
            String time = e.getTime();
            String msec = "500";
            if (time != null) {
                msec = time.equals("large") ? "2000" : (time.equals("medium") ? "500" : (time.equals("small") ? "200" : (time.equals("none") ? "100" : VXMLDoc.this._getCSS2TimesAsMsec(time))));
            }
            this.textBuf_.appendString("<SILENCE MSEC=\"" + msec + "\"/>");
            return true;
        }

        public boolean enter(VxmlClear e) {
            if (e.getNamelist() == null) {
                VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <clear/>"));
                return false;
            }
            this.textBuf_.flushSpeak();
            String[] names = e.getNamelist().split(" ");
            int i = 0;
            while (i < names.length) {
                String aname = names[i];
                String aexpr = "undefined";
                String sc = VXMLDoc.this._getEvalWith(String.valueOf(aname) + "=" + aexpr, this.dialog_.getName());
                this.execContents_.appendExecContent(new EvaluateCommand(sc));
                ++i;
            }
            this.textBuf_.setupSpeak();
            return true;
        }

        public boolean enter(VxmlDisconnect e) {
            this.textBuf_.flushSpeak();
            this.execContents_.appendExecContent(new EndCommand(true));
            return true;
        }

        public boolean enter(VxmlEmphasis e) {
            if (e.getLevel() != null) {
                VXMLDoc.this.docWarnings_.add(new DocWarning("Ignored feature: <emphasis level>"));
                return false;
            }
            this.textBuf_.appendString("<EMPH>");
            return true;
        }

        public void leave(VxmlEmphasis e) {
            this.textBuf_.appendString("</EMPH>");
        }

        public boolean enter(VxmlEnumerate e) {
            VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <enumerate>"));
            return false;
        }

        public boolean enter(VxmlError e) {
            VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <error>"));
            return false;
        }

        public boolean enter(VxmlInitial e) {
            if (e.getName() == null) {
                this.dialog_.setItemName(VXMLDoc.this._getUniqueId());
            } else {
                this.dialog_.setItemName(e.getName());
            }
            String s = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName();
            String t = VXMLDoc.this.stateMap_.newState(s);
            VXMLDoc.this.dbg.ASSERT(t.equals(s), "VxmlInitial#enter");
            VXMLDoc.this.stateMap_.addCommand(s, new EvaluateCommand(String.valueOf(this.dialog_.getName()) + "." + this.dialog_.getItemName() + "= true;\n"));
            this.visitorStack_.push(e);
            this.formItems_.put(this.dialog_.getItemName(), e);
            this.commands_.setupCommands();
            this.execContents_.setupExecContent();
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlInitial e) {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String s = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName();
            this.commands_.flushCommands(s);
            VXMLDoc.this.stateMap_.setNext(s, "@" + this.dialog_.getName() + ".@select");
            this.visitorStack_.pop();
        }

        public boolean enter(VxmlLink e) {
            VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <link>"));
            return false;
        }

        public boolean enter(VxmlLog e) {
            this.textBuf_.flushSpeak();
            this.textBuf_.setupLog();
            String expr = e.getExpr();
            if (expr != null) {
                this.textBuf_.appendValue("(" + expr + ")");
            }
            return true;
        }

        public void leave(VxmlLog e) {
            this.textBuf_.flushLog();
            this.textBuf_.setupSpeak();
        }

        public boolean enter(VxmlNative e) {
            this.textBuf_.flushSpeak();
            this.textBuf_.setupNative();
            String expr = e.getExpr();
            if (expr != null) {
                this.textBuf_.appendValue("(" + expr + ")");
            }
            return true;
        }

        public void leave(VxmlNative e) {
            this.textBuf_.flushNative();
            this.textBuf_.setupSpeak();
        }

        public boolean enter(VxmlMark e) {
            return true;
        }

        public boolean enter(VxmlMeta e) {
            VXMLDoc.this.docWarnings_.add(new DocWarning("Ignored feature: <meta>"));
            return true;
        }

        public boolean enter(VxmlObject e) {
            VXMLDoc.this.docWarnings_.add(new DocWarning("Ignored feature: <object>"));
            return true;
        }

        public boolean enter(VxmlOption e) {
            VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <option>"));
            return false;
        }

        public boolean enter(VxmlParam e) {
            VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <param>"));
            return false;
        }

        public boolean enter(VxmlPhoneme e) {
            this.textBuf_.appendString("<PRON SYM=\"" + e.getPh() + "\">");
            return true;
        }

        public void leave(VxmlPhoneme e) {
            this.textBuf_.appendString("</PRON>");
        }

        public boolean enter(VxmlProperty e) {
            VXMLDoc.this.docWarnings_.add(new DocWarning("Ignored feature: <property>"));
            return true;
        }

        public boolean enter(VxmlRecord e) {
            VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <record>"));
            return false;
        }

        public boolean enter(VxmlReturn e) {
            VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <return>"));
            return false;
        }

        public boolean enter(VxmlSayAs e) {
            VXMLDoc.this.docWarnings_.add(new DocWarning("Ignored feature: <say-as>"));
            return true;
        }

        public boolean enter(VxmlSubmit e) {
            this.textBuf_.flushSpeak();
            String n = e.getNext();
            if (n == null) {
                VXMLDoc.this.docErrors_.add(new DocError("No 'next' in <submit>"));
                return false;
            }
            String namelist = e.getNamelist();
            if (namelist == null) {
                VXMLDoc.this.docErrors_.add(new DocError("No 'namelist' in <submit>"));
                return false;
            }
            String next = Util.removeSpaces(n);
            boolean now = false;
            String cond = "true";
            String script = "'" + next + "?'";
            String[] names = namelist.split(" ");
            int i = 0;
            while (i < names.length) {
                if (i != 0) {
                    script = String.valueOf(script) + "+'&'";
                }
                script = String.valueOf(script) + "+'" + names[i] + "='+" + names[i];
                ++i;
            }
            String eval = VXMLDoc.this._getEvalWith(script, this.dialog_.getName());
            EndCommand c = new EndCommand(eval, cond, now);
            this.execContents_.appendExecContent(c);
            this.textBuf_.setupSpeak();
            return true;
        }

        public boolean enter(VxmlThrow e) {
            VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <throw>"));
            return false;
        }

        public boolean enter(VxmlTransfer e) {
            VXMLDoc.this.docWarnings_.add(new DocWarning("Not supported feature: <transfer>"));
            this.textBuf_.flushSpeak();
            this.execContents_.appendExecContent(new EndCommand(false));
            return true;
        }

        public boolean enter(VxmlVoice e) {
            String optional = "male01";
            if (e.getName() != null) {
                optional = e.getName();
            } else if (e.getGender() != null) {
                if (e.getGender().equals("male")) {
                    optional = "male01";
                } else if (e.getGender().equals("female")) {
                    optional = "female01";
                }
            }
            this.textBuf_.appendString("<VOICE OPTIONAL=\"" + optional + "\">");
            return true;
        }

        public void leave(VxmlVoice e) {
            this.textBuf_.appendString("</VOICE>");
        }

        public boolean enter(VxmlProsody e) {
            String enterProsodyTag = "";
            this.leaveProsodyTag_ = "";
            if (e.getPitch() != null) {
                if (e.getPitch().equals("x-high")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH LEVEL=\"140\">";
                } else if (e.getPitch().equals("high")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH LEVEL=\"120\">";
                } else if (e.getPitch().equals("medium")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH LEVEL=\"100\">";
                } else if (e.getPitch().equals("low")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH LEVEL=\"80\">";
                } else if (e.getPitch().equals("x-low")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH LEVEL=\"60\">";
                } else if (e.getPitch().equals("default")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH LEVEL=\"100\">";
                }
                this.leaveProsodyTag_ = "</PITCH>" + this.leaveProsodyTag_;
            }
            if (e.getRange() != null) {
                if (e.getRange().equals("x-high")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH RANGE=\"140\">";
                } else if (e.getRange().equals("high")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH RANGE=\"120\">";
                } else if (e.getRange().equals("medium")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH RANGE=\"100\">";
                } else if (e.getRange().equals("low")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH RANGE=\"80\">";
                } else if (e.getRange().equals("x-low")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH RANGE=\"60\">";
                } else if (e.getRange().equals("default")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH RANGE=\"100\">";
                }
                this.leaveProsodyTag_ = "</PITCH>" + this.leaveProsodyTag_;
            }
            if (e.getVolume() != null) {
                if (e.getRange().equals("silent")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<VOLUME LEVEL=\"0\">";
                } else if (e.getRange().equals("x-soft")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<VOLUME LEVEL=\"60\">";
                } else if (e.getRange().equals("soft")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<VOLUME LEVEL=\"80\">";
                } else if (e.getRange().equals("medium")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<VOLUME LEVEL=\"100\">";
                } else if (e.getRange().equals("loud")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<VOLUME LEVEL=\"120\">";
                } else if (e.getRange().equals("x-loud")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<VOLUME LEVEL=\"140\">";
                } else if (e.getRange().equals("default")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<VOLUME LEVEL=\"100\">";
                }
                this.leaveProsodyTag_ = "</VOLUME>" + this.leaveProsodyTag_;
            }
            this.textBuf_.appendString(enterProsodyTag);
            return true;
        }

        public void leave(VxmlProsody e) {
            VXMLDoc.this.dbg.ASSERT(this.leaveProsodyTag_ != null, "leave VxmlProsody");
            this.textBuf_.appendString(this.leaveProsodyTag_);
            this.leaveProsodyTag_ = null;
        }

        public boolean enter(VxmlP e) {
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlP e) {
            this.textBuf_.appendString("<SILENCE MSEC=\"500\"/>");
            this.textBuf_.flushSpeak();
        }

        public boolean enter(VxmlParagraph e) {
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlParagraph e) {
            this.textBuf_.appendString("<SILENCE MSEC=\"500\"/>");
            this.textBuf_.flushSpeak();
        }

        public boolean enter(VxmlS e) {
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlS e) {
            this.textBuf_.flushSpeak();
        }

        public boolean enter(VxmlSentence e) {
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlSentence e) {
            this.textBuf_.flushSpeak();
        }

        public boolean enter(VxmlEMPH e) {
            this.textBuf_.appendString("<EMPH>");
            return true;
        }

        public void leave(VxmlEMPH e) {
            this.textBuf_.appendString("</EMPH>");
        }

        public boolean enter(VxmlSILENCE e) {
            this.textBuf_.appendString("<SILENCE MSEC=\"" + e.getMSEC() + "\"/>");
            return true;
        }

        public boolean enter(VxmlPRON e) {
            this.textBuf_.appendString("<PRON SYM=\"" + e.getSYM() + "\">");
            return true;
        }

        public void leave(VxmlPRON e) {
            this.textBuf_.appendString("</PRON>");
        }

        public boolean enter(VxmlJVOICE e) {
            String alpha;
            String optional = e.getOPTIONAL();
            if (optional == null && e.getREQUIRED() != null) {
                optional = e.getREQUIRED().equals("FEMALE") || e.getREQUIRED().equals("female") ? "female01" : "male01";
            }
            String str = "<VOICE";
            if (optional != null) {
                str = String.valueOf(str) + " OPTIONAL=\"" + optional + "\"";
            }
            if ((alpha = e.getALPHA()) != null) {
                str = String.valueOf(str) + " ALPHA=\"" + alpha + "\"";
            }
            str = String.valueOf(str) + ">";
            this.textBuf_.appendString(str);
            return true;
        }

        public void leave(VxmlJVOICE e) {
            this.textBuf_.appendString("</VOICE>");
        }

        public boolean enter(VxmlRATE e) {
            this.textBuf_.appendString("<RATE SPEED=\"" + e.getSPEED() + "\">");
            return true;
        }

        public void leave(VxmlRATE e) {
            this.textBuf_.appendString("</RATE>");
        }

        public boolean enter(VxmlVOLUME e) {
            this.textBuf_.appendString("<VOLUME LEVEL=\"" + e.getLEVEL() + "\">");
            return true;
        }

        public void leave(VxmlVOLUME e) {
            this.textBuf_.appendString("</VOLUME>");
        }

        public boolean enter(VxmlPITCH e) {
            String att = "";
            if (e.getLEVEL() != null) {
                att = String.valueOf(att) + " LEVEL=\"" + e.getLEVEL() + "\"";
            }
            if (e.getRANGE() != null) {
                att = String.valueOf(att) + " RANGE=\"" + e.getRANGE() + "\"";
            }
            this.textBuf_.appendString("<PITCH" + att + ">");
            return true;
        }

        public void leave(VxmlPITCH e) {
            this.textBuf_.appendString("</PITCH>");
        }

        public boolean enter(VxmlSPELL e) {
            this.textBuf_.appendString("<SPELL>");
            return true;
        }

        public void leave(VxmlSPELL e) {
            this.textBuf_.appendString("</SPELL>");
        }

        public boolean enter(VxmlCONTEXT e) {
            String att = "";
            if (e.getTYPE() != null) {
                att = String.valueOf(att) + " TYPE=\"" + e.getTYPE() + "\"";
            }
            if (e.getTYPE().equals("NUMBER") && e.getFORMAT() != null) {
                att = String.valueOf(att) + " FORMAT=\"" + e.getFORMAT() + "\"";
            }
            if (e.getTYPE().equals("DATE")) {
                if (e.getFORMAT() != null) {
                    att = String.valueOf(att) + " FORMAT=\"" + e.getFORMAT() + "\"";
                }
                if (e.getDELIM() != null) {
                    att = String.valueOf(att) + " DELIM=\"" + e.getDELIM() + "\"";
                }
            }
            this.textBuf_.appendString("<CONTEXT" + att + ">");
            return true;
        }

        public void leave(VxmlCONTEXT e) {
            this.textBuf_.appendString("</CONTEXT>");
        }

        public boolean enter(VxmlAudio e) {
            this.textBuf_.flushSpeak();
            String src = e.getSrc();
            if (src == null) {
                VXMLDoc.this.docWarnings_.add(new DocWarning("Error: <audio src> missing."));
                return true;
            }
            String fileRel = VXMLDoc.this.resolveAdrs(src);
            String userdir = String.valueOf(System.getProperty("user.dir")) + "/";
            String file = Util.resolveAdrs(userdir, fileRel);
            file = "'" + file + "'";
            this.execContents_.appendExecContent(new AddOutItemCommand(new AudioOutItem(file, this.currPromptBargein_)));
            return true;
        }

        public void leave(VxmlAudio e) {
            this.textBuf_.setupSpeak();
        }

        public boolean enter(VxmlEmotion e) {
            this.textBuf_.flushSpeak();
            String typename = e.getType();
            int value = 100;
            int duration = 0;
            int pattern = 1;
            if (e.checkPattern()) {
                value = e.getPattern();
            }
            if (e.checkValue()) {
                value = e.getValue();
            }
            if (e.checkDuration()) {
                duration = e.getDuration();
            }
            if (typename == null) {
                typename = "NEUTRAL";
            }
            if ((typename = typename.toUpperCase()).equals("SURPRISED")) {
                value /= 2;
            }
            String text = "'to @FSM set FaceExp = " + typename + " " + pattern + " " + value + " " + duration + "'";
            NativeOutItem item = new NativeOutItem(text, this.dialog_.getName());
            this.execContents_.appendExecContent(new AddOutItemCommand(item));
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlEmotion emotion) {
            this.textBuf_.flushSpeak();
            String text = "'to @FSM set FaceExp = NEUTRAL'";
            NativeOutItem item = new NativeOutItem(text, this.dialog_.getName());
            this.execContents_.appendExecContent(new AddOutItemCommand(item));
            this.textBuf_.setupSpeak();
        }

        protected class Dialog {
            private String currFormName_ = null;
            private String currFormItemName_ = null;

            protected Dialog() {
            }

            public void setName(String s) {
                this.currFormName_ = s;
            }

            public String getName() {
                return this.currFormName_;
            }

            public void setItemName(String s) {
                this.currFormItemName_ = s;
            }

            public String getItemName() {
                return this.currFormItemName_;
            }
        }

        protected class Prompt {
            public int count = 1;
            public String cond = null;
            public Vector commands = null;

            protected Prompt() {
            }
        }

        protected class Commands {
            private Vector cmdvec_ = null;

            protected Commands() {
            }

            public void setupCommands() {
                if (this.cmdvec_ == null) {
                    this.cmdvec_ = new Vector();
                }
            }

            public void appendCommands(Command c) {
                VXMLDoc.this.dbg.print("appendCommands:" + c.toString());
                if (this.cmdvec_ != null) {
                    this.cmdvec_.add(c);
                }
            }

            public void flushCommands(String s) {
                if (this.cmdvec_ != null && this.cmdvec_.size() > 0) {
                    VXMLDoc.this.stateMap_.addCommand(s, this.cmdvec_);
                    this.cmdvec_ = null;
                }
            }

            public Vector getCommands() {
                return this.cmdvec_;
            }

            public void setCommands(Vector v) {
                this.cmdvec_ = v;
            }

            public void clearCommands() {
                this.cmdvec_ = null;
            }
        }

        protected class ExecContents {
            private Stack execContentsStack_ = new Stack();
            private int stackCount_ = 0;

            protected ExecContents() {
            }

            private void setupExecContent(String cond) {
                ++this.stackCount_;
                VXMLDoc.this.dbg.print("setupExecContent: " + this.stackCount_ + " " + cond);
                Vector c = new Vector();
                CompositeCommand co = new CompositeCommand(c, cond);
                this.execContentsStack_.push(co);
            }

            private void setupExecContent() {
                this.setupExecContent("true");
            }

            private void appendExecContent(Command c) {
                CompositeCommand co;
                VXMLDoc.this.dbg.print("appendExecContent: " + this.stackCount_ + " " + c);
                if (!this.execContentsStack_.empty() && (co = (CompositeCommand)this.execContentsStack_.peek()) != null) {
                    co.getCommands().add(c);
                }
            }

            private void flushExecContent() {
                VXMLDoc.this.dbg.print("flushExecContent: " + this.stackCount_);
                --this.stackCount_;
                if (!this.execContentsStack_.empty()) {
                    CompositeCommand co = (CompositeCommand)this.execContentsStack_.pop();
                    if (this.execContentsStack_.empty()) {
                        Visitor.this.commands_.appendCommands(co);
                    } else {
                        CompositeCommand c = (CompositeCommand)this.execContentsStack_.peek();
                        c.getCommands().add(co);
                    }
                }
            }
        }

        protected class TextBuf {
            private BaseText speakText_ = new SpeakText();
            private BaseText logText_ = new LogText();
            private BaseText nativeText_ = new NativeText();
            private BaseText context_ = this.speakText_;

            protected TextBuf() {
            }

            public void appendString(String text) {
                this.context_.appendString(text);
            }

            public void appendValue(String expr) {
                this.context_.appendValue(expr);
            }

            public void setupSpeak() {
                this.context_ = this.speakText_;
                this.context_.resetText();
            }

            public void flushSpeak() {
                VXMLDoc.this.dbg.ASSERT(this.context_ instanceof SpeakText, "error");
                StringBuffer sb = this.context_.getText();
                if (sb != null) {
                    String text = new String(sb).trim();
                    if (text.length() > 0) {
                        VoiceOutItem item = new VoiceOutItem(text, Visitor.this.dialog_.getName(), Visitor.this.currPromptBargein_);
                        AddOutItemCommand c = new AddOutItemCommand(item);
                        Visitor.this.execContents_.appendExecContent(c);
                    }
                    this.context_.resetText();
                }
            }

            public void setupLog() {
                this.context_ = this.logText_;
                this.context_.resetText();
            }

            public void flushLog() {
                VXMLDoc.this.dbg.ASSERT(this.context_ instanceof LogText, "error flushLog()");
                StringBuffer log = this.context_.getText();
                if (log != null) {
                    String text = new String(log).trim();
                    if (text.length() > 0) {
                        LogOutItem item = new LogOutItem(text, Visitor.this.dialog_.getName());
                        AddOutItemCommand c = new AddOutItemCommand(item);
                        Visitor.this.execContents_.appendExecContent(c);
                    }
                    this.context_.resetText();
                }
                this.context_ = this.speakText_;
            }

            public void setupNative() {
                this.context_ = this.nativeText_;
                this.context_.resetText();
            }

            public void flushNative() {
                VXMLDoc.this.dbg.ASSERT(this.context_ instanceof NativeText, "error flushNative()");
                StringBuffer sb = this.context_.getText();
                if (sb != null) {
                    String text = new String(sb).trim();
                    if (text.length() > 0) {
                        NativeOutItem item = new NativeOutItem(text, Visitor.this.dialog_.getName());
                        AddOutItemCommand c = new AddOutItemCommand(item);
                        Visitor.this.execContents_.appendExecContent(c);
                    }
                    this.context_.resetText();
                }
                this.context_ = this.speakText_;
            }

            private class BaseText {
                private StringBuffer text_ = null;

                BaseText() {
                }

                public void resetText() {
                    this.text_ = new StringBuffer();
                }

                public StringBuffer getText() {
                    if (this.text_ == null) {
                        this.text_ = new StringBuffer("");
                    }
                    return this.text_;
                }

                public void setText(StringBuffer text) {
                    this.text_ = text;
                }

                public void appendString(String text) {
                    VXMLDoc.this.dbg.ASSERT(TextBuf.this.context_ != null, "context_ null error");
                    StringBuffer sb = TextBuf.this.context_.getText();
                    if (sb != null && text != null && text.length() > 0) {
                        if (sb.length() > 0) {
                            sb.append("+");
                        }
                        sb.append("'");
                        sb.append(text);
                        sb.append("'");
                        TextBuf.this.context_.setText(sb);
                    }
                }

                public void appendValue(String expr) {
                    VXMLDoc.this.dbg.ASSERT(TextBuf.this.context_ != null, "context_ null error");
                    StringBuffer sb = TextBuf.this.context_.getText();
                    if (sb != null && expr != null && expr.length() > 0) {
                        if (sb.length() > 0) {
                            sb.append("+");
                        }
                        sb.append(expr);
                        TextBuf.this.context_.setText(sb);
                    }
                }
            }

            private class SpeakText
            extends BaseText {
                SpeakText() {
                }

                public void appendString(String text) {
                    String s = Util.xmlSafeRemoveSpaces(text);
                    super.appendString(s);
                }
            }

            private class LogText
            extends BaseText {
                LogText() {
                }

                public void appendString(String text) {
                    String s = Util.removeNewLines(text);
                    super.appendString(s);
                }
            }

            private class NativeText
            extends BaseText {
                NativeText() {
                }
            }
        }
    }
}

