/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import main.Debug;
import main.DeviceEvent;
import main.DeviceListener;
import main.GalateaRuntimeError;
import main.GrammarSet;
import main.InputDevice;
import main.OutputDevice;
import outitem.AudioOutItem;
import outitem.LogOutItem;
import outitem.NativeOutItem;
import outitem.OutItem;
import outitem.VoiceOutItem;
import util.SubProcess;
import util.Util;

public class AMThread
extends Thread
implements OutputDevice,
InputDevice {
    private int srmstate = 30;
    private Debug dbg = new Debug("AMThread", 0);
    private DeviceListener recoglistener_;
    private DeviceListener synthlistener_;
    private SubProcess sp_;
    private boolean showStdErr_ = true;
    private boolean useSIM = false;
    private boolean useMON = false;
    private boolean useSND = false;
    private boolean doInitRecogAtConstructor = false;
    private boolean doCheckSrmLog = Util.getPropertyBoolean("DoCheckSrmLog", true);
    private String srmMkdfaLogFile = Util.getPropertyStr("SrmMkdfaLogFile", "../SRM/temp/mkdfa.log");
    private String srmJulianLogFile = Util.getPropertyStr("SrmJulianLogFile", "../SRM/temp/julian.log");
    private boolean srmError = false;
    private String srmErrorLog = "";
    private boolean srmInsideRecogoutTag = false;
    private boolean srmInsideShypoRankOneTag = false;
    private String srmResult = "";
    private String AMCom_;

    public AMThread() {
        String amcom;
        this.useSND = Util.getPropertyBoolean("UseSND", false);
        this.useMON = Util.getPropertyBoolean("UseMON", false);
        this.useSIM = Util.getPropertyBoolean("UseSIM", false);
        String showerr = System.getProperty("AMThread.ShowStdErr");
        if (showerr != null && showerr.equals("1")) {
            this.showStdErr_ = true;
            this.dbg.print("AMT: ShowStdErr = true");
        }
        if ((amcom = System.getProperty("AMCommand")) == null) {
            Util.halt("AMThread(): Cannot run AM");
        }
        this.dbg.print("AMT: AMCommand = " + amcom);
        this.AMCom_ = amcom;
        this.sp_ = new SubProcess(this.AMCom_);
        if (!this.sp_.Run()) {
            Util.halt("AMThread(): Cannot run AM; " + this.AMCom_);
        }
        this.setName("Thread-AM");
        if (this.doInitRecogAtConstructor && this.srmstate == 30) {
            this._initRecog();
            this.srmstate = 20;
        }
        String s = System.getProperty("AMThread.StartupWait", "10.0");
        int waitms = (int)(Double.parseDouble(s) * 1000.0);
        this.dbg.print("AMT: StartupWait " + waitms);
        try {
            Thread.sleep(waitms);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dbg.print("AMT: StartupWait " + waitms + " done.");
    }

    public boolean isReady() {
        if (this.doInitRecogAtConstructor && this.srmstate == 20) {
            this.dbg.print("AMT: isReady = false");
            return false;
        }
        this.dbg.print("AMT: isReady = true");
        return true;
    }

    public boolean isListening() throws GalateaRuntimeError {
        if (this.doCheckSrmLog) {
            try {
                String mkdfaLog = Util.loadFromFile(this.srmMkdfaLogFile);
                if (mkdfaLog != null && mkdfaLog.indexOf("Error:") > 0) {
                    this.srmErrorLog = "\n[" + this.srmMkdfaLogFile + "]\n" + mkdfaLog;
                    this.srmError = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                String julianLog = Util.loadFromFile(this.srmJulianLogFile);
                if (julianLog != null && julianLog.indexOf("cannot access") > 0) {
                    this.srmErrorLog = String.valueOf(this.srmErrorLog) + "\n[" + this.srmJulianLogFile + "]\n" + julianLog;
                    this.srmError = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.srmError) {
            this.dbg.print("AMT: isReady = false (SRM Error)");
            throw new GalateaRuntimeError(this.srmErrorLog);
        }
        return this.srmstate == 0;
    }

    private void _initRecog() {
        if (this.useSIM) {
            this.outputNative("to @SIM set SRM_Recog = START");
        } else {
            this.outputNative("to @SRM set Run = INIT");
            this.outputNative("to @SRM set Run = START");
        }
    }

    public void setInputListener(DeviceListener l) {
        this.recoglistener_ = l;
    }

    public void setOutputListener(DeviceListener l) {
        this.synthlistener_ = l;
    }

    public void outputDeviceStart(OutItem obj) {
        if (obj instanceof VoiceOutItem) {
            VoiceOutItem o = (VoiceOutItem)obj;
            this.outputSpeak(o.getArg());
        } else if (obj instanceof AudioOutItem) {
            AudioOutItem o = (AudioOutItem)obj;
            this.outputAudio(o.getArg());
        } else if (obj instanceof LogOutItem) {
            LogOutItem o = (LogOutItem)obj;
            this.outputLog(o.getArg());
        } else if (obj instanceof NativeOutItem) {
            NativeOutItem o = (NativeOutItem)obj;
            this.outputNative(o.getArg());
        }
    }

    public void outputNative(String str) {
        this.sp_.ToStdin(str);
        this.dbg.print(str);
        if (this.useMON) {
            String[] lines = str.split("\n");
            int i = 0;
            while (i < lines.length) {
                this.sp_.ToStdin("to @MON set SysLogText = " + lines[i]);
                ++i;
            }
        }
    }

    public void outputSpeak(String str) {
        this.outputNative("to @AM-MCL set Speak = " + str);
    }

    public void outputAudio(String str) {
        if (this.useSND) {
            this.outputNative("to @SND set Play = " + str);
        } else {
            this.dbg.print("AMT: outputAudio " + str + " ignored.");
        }
    }

    public void outputLog(String str) {
        if (this.useMON) {
            this.outputNative("to @MON set AppLogText = " + str);
        } else {
            this.dbg.print("AMT: outputLog " + str + " ignored.");
        }
    }

    public void outputDeviceStop() {
        this.outputNative("to @AM-MCL set Speak = STOP");
    }

    public void setSpeaker(String str) {
        this.outputNative("to @SSM set Speaker = " + str);
    }

    public synchronized boolean prepareGrammar(GrammarSet gs) {
        this.dbg.print("AMT: prepareGrammar: " + gs);
        if (this.doInitRecogAtConstructor && (this.srmstate == 30 || this.srmstate == 20)) {
            this.dbg.print("AMT: prepareGrammar: ignored (srmstate" + this.srmstate + ")");
            return false;
        }
        if (gs.getJulian()) {
            String gram = gs.getJulianGramName();
            if (gram == null) {
                return false;
            }
            if (this.useSIM) {
                this.outputNative("to @SIM set SRM_Julian = " + gram);
            } else {
                this.outputNative("to @SRM set Run = INIT");
                this.outputNative("to @SRM set Grammar = " + gram + ".dfa");
                this.outputNative("to @SRM set Dic = " + gram + ".dict");
                this.outputNative("to @SRM set Run = START");
            }
            this.srmstate = 10;
        } else {
            String gramStr = gs.getSRMGramStr();
            if (gramStr == null) {
                return false;
            }
            if (this.useSIM) {
                this.outputNative("to @SIM set SRM_XML_String = " + gramStr);
            } else {
                this.outputNative("to @SRM set Run = INIT");
                this.outputNative("to @SRM set Grammar << EOF");
                this.outputNative("to @SRM <?xml version=\"1.0\" encoding=\"EUC-JP\"?>");
                gramStr = gramStr.replaceAll("<rule", "\n<rule");
                gramStr = gramStr.replaceAll("<token", "\n <token");
                String[] lines = gramStr.split("\n");
                int i = 0;
                while (i < lines.length) {
                    this.outputNative("to @SRM " + lines[i]);
                    ++i;
                }
                this.outputNative("to @SRM EOF");
                this.outputNative("to @SRM set Run = START");
            }
            this.srmstate = 10;
        }
        this.dbg.print("AMT: prepareGrammar: waiting for LISTEN");
        return true;
    }

    private synchronized boolean iteration() {
        Pattern pSNDTell;
        Matcher mSNDTell;
        Pattern pSSMSpeakStat;
        Matcher mSSMSpeakStat;
        if (this.recoglistener_ == null) {
            this.dbg.err("AMThread.run(): recoglistener not set");
            return false;
        }
        if (this.synthlistener_ == null) {
            this.dbg.err("AMThread.run(): synthlistener not set");
            return false;
        }
        String str = this.sp_.FromStdoutNB();
        if (str == null) {
            this.dbg.print("AMT: *** sp_.FromStdout() == null ***");
            return false;
        }
        if (str.length() > 0) {
            this.dbg.print("AMT: " + str);
        }
        if (this.useSIM) {
            Pattern pSIMResult;
            Matcher mSIMResult;
            Pattern pSIMStart;
            Matcher mSIMStart;
            Pattern pGrammarError;
            Pattern pListen = Pattern.compile("From \\@SIM\\s+tell\\s+status\\s+LISTEN$");
            if (pListen.matcher(str).matches()) {
                if (this.srmstate == 10) {
                    this.dbg.print("AMT: SRM READY");
                    this.srmstate = 0;
                }
                if (this.srmstate == 20) {
                    this.dbg.print("AMT: SRM default grammar active");
                    this.srmstate = 15;
                }
            }
            if ((pGrammarError = Pattern.compile("From \\@SIM\\s+tell\\s+status\\s+GRAMMAR_ERROR$")).matcher(str).matches()) {
                Util.halt("GRAMMAR_ERROR");
            }
            if ((mSIMStart = (pSIMStart = Pattern.compile("From \\@SIM\\s+tell\\s+status INPUT_START (.*)$")).matcher(str)).matches()) {
                String g1 = mSIMStart.group(1);
                this.dbg.print("AMT:SIM tell status INPUT_START " + g1);
                this.recoglistener_.update(new DeviceEvent(this, DeviceEvent.Type.INPUT, DeviceEvent.State.BUSY, g1));
                this.notify();
            }
            if ((mSIMResult = (pSIMResult = Pattern.compile("From \\@SIM\\s+tell\\s+result\\s+(.*)$")).matcher(str)).matches()) {
                String srmsentence = mSIMResult.group(1);
                this.dbg.print("AMT:SIM tell result " + srmsentence);
                this.recoglistener_.update(new DeviceEvent(this, DeviceEvent.Type.INPUT, DeviceEvent.State.READY, srmsentence));
                this.notify();
                this.dbg.print("AMT:SIM tell result done.");
            }
        } else {
            if (str.startsWith("From @SRM tell <INPUT STATUS=\"LISTEN\" ") && this.srmstate == 10) {
                this.dbg.print("AMT: " + str);
                this.dbg.print("AMT: SRM READY");
                this.srmstate = 0;
            }
            if (str.startsWith("From @SRM tell <INPUT STATUS=\"STARTREC\" ")) {
                this.recoglistener_.update(new DeviceEvent(this, DeviceEvent.Type.INPUT, DeviceEvent.State.BUSY, ""));
                this.notify();
            }
            if (str.startsWith("From @SRM <RECOGOUT>")) {
                this.srmInsideRecogoutTag = true;
            }
            if (str.startsWith("From @SRM </RECOGOUT>")) {
                this.srmInsideRecogoutTag = false;
            }
            if (str.startsWith("From @SRM   <SHYPO RANK=\"1\" ")) {
                this.srmInsideShypoRankOneTag = true;
                this.srmResult = "";
            }
            if (str.startsWith("From @SRM   </SHYPO>")) {
                this.srmInsideShypoRankOneTag = false;
                this.dbg.print("AMT: SRM RESULT " + this.srmResult);
                this.recoglistener_.update(new DeviceEvent(this, DeviceEvent.Type.INPUT, DeviceEvent.State.READY, this.srmResult));
                this.notify();
            }
            if (this.srmInsideRecogoutTag && this.srmInsideShypoRankOneTag && str.startsWith("From @SRM     <WHYPO ")) {
                String s = str.replaceAll("From @SRM     <WHYPO ", "");
                Pattern pat = Pattern.compile(".*WORD=\"([^\"]+)\".*");
                Matcher mat = pat.matcher(s);
                if (mat.matches()) {
                    String g1 = mat.group(1);
                    this.dbg.print("AMT: SRM matches word " + g1);
                    if (!g1.equals("silB") && !g1.equals("silE")) {
                        int p = g1.indexOf(58);
                        this.srmResult = p >= 0 ? String.valueOf(this.srmResult) + g1.substring(p + 1) : String.valueOf(this.srmResult) + g1;
                    }
                }
            }
        }
        if ((mSSMSpeakStat = (pSSMSpeakStat = Pattern.compile("From \\@SSM\\s+rep Speak.stat = (.*)$")).matcher(str)).matches()) {
            String g1 = mSSMSpeakStat.group(1);
            if (g1.equals("IDLE")) {
                this.synthlistener_.update(new DeviceEvent(this, DeviceEvent.Type.OUTPUT, DeviceEvent.State.READY, null));
            } else if (g1.equals("ERROR")) {
                this.synthlistener_.update(new DeviceEvent(this, DeviceEvent.Type.OUTPUT, DeviceEvent.State.READY, null));
            } else if (g1.equals("PROCESSING")) {
                this.synthlistener_.update(new DeviceEvent(this, DeviceEvent.Type.OUTPUT, DeviceEvent.State.BUSY, null));
            }
        }
        if (this.useSND && (mSNDTell = (pSNDTell = Pattern.compile("From \\@SND tell (\\S+) (.*)$")).matcher(str)).matches()) {
            String g1 = mSNDTell.group(1);
            String g2 = mSNDTell.group(2);
            if (g1.equals("start")) {
                this.synthlistener_.update(new DeviceEvent(this, DeviceEvent.Type.OUTPUT, DeviceEvent.State.BUSY, g2));
            } else if (g1.equals("end")) {
                this.synthlistener_.update(new DeviceEvent(this, DeviceEvent.Type.OUTPUT, DeviceEvent.State.READY, g2));
            }
        }
        while ((str = this.sp_.FromStderrNB()).length() > 0) {
            if (!this.showStdErr_) continue;
            this.dbg.print("AMT: (err) " + str);
        }
        return true;
    }

    public void run() {
        while (this.iteration()) {
            try {
                Thread.sleep(0L, 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void terminate() {
    }

    public boolean isSrmError() {
        return this.srmError;
    }

    public void setSrmError(boolean srmError) {
        this.srmError = srmError;
    }

    public String getSrmErrorLog() {
        return this.srmErrorLog;
    }
}

