/*
 * Decompiled with CFR 0.152.
 */
package main;

public class Debug {
    private int debuglevel;

    public Debug(int level) {
        this.debuglevel = level;
    }

    public Debug(String name, int defaultLevel) {
        String s = System.getProperty("Debug." + name);
        this.debuglevel = s == null ? defaultLevel : Integer.parseInt(s);
    }

    public Debug(String name) {
        String s = System.getProperty("Debug." + name);
        this.debuglevel = s == null ? 0 : Integer.parseInt(s);
    }

    public void Debug() {
        this.debuglevel = 0;
    }

    public void setLevel(int level) {
        this.debuglevel = level;
    }

    public int getLevel() {
        return this.debuglevel;
    }

    public void print(String msg) {
        if (this.debuglevel != 0) {
            System.out.println(msg);
        }
    }

    public void print(String msg, int level) {
        if (this.debuglevel >= level) {
            System.out.println(msg);
        }
    }

    public void err(String msg) {
        if (this.debuglevel != 0) {
            System.err.println(msg);
        }
    }

    public void err(String msg, int level) {
        if (this.debuglevel >= level) {
            System.err.println(msg);
        }
    }

    public void DIE(Exception e) {
        if (this.debuglevel != 0) {
            System.out.println("DIE:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void DIE(String msg) {
        if (this.debuglevel != 0) {
            System.out.println("DIE: " + msg);
            System.exit(1);
        }
    }

    public void ASSERT(boolean bool, String msg) {
        if (this.debuglevel != 0 && !bool) {
            System.out.println("ASSERTION FAILED: " + msg);
            System.exit(1);
        }
    }

    public void ASSERT(boolean bool, String msg, int level) {
        if (this.debuglevel >= level && !bool) {
            System.out.println("ASSERTION FAILED: " + msg);
            System.exit(1);
        }
    }

    public static void main(String[] args) throws Exception {
        Debug dbg = new Debug(5);
        dbg.print("1: this is shown.", 4);
        dbg.print("2: this is shown.", 5);
        dbg.print("3: not shown.", 6);
        int a = 1;
        int b = 2;
        dbg.ASSERT(a == a, "4: not shown.");
        dbg.ASSERT(a == b, "5: this is shown.", 4);
        dbg.ASSERT(a == b, "6: not shown.", 5);
        dbg.ASSERT(a == b, "7: not shown.", 6);
    }
}

