/*
 * Decompiled with CFR 0.152.
 */
package main;

import document.AbstractDoc;
import document.RawPhoenixDoc;
import document.VXMLDoc;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import main.DocError;
import main.StateMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXParseException;

public class DocLoader {
    private AbstractDoc doc;
    private StateMap stateMap;

    public DocLoader(String filename, String path) throws Exception {
        Document root;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (filename.startsWith("http:")) {
            String line;
            String buf = "";
            URL url = new URL(filename);
            HttpURLConnection uc = (HttpURLConnection)url.openConnection();
            uc.setRequestMethod("GET");
            InputStreamReader isr = new InputStreamReader(uc.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                buf = String.valueOf(buf) + line;
            }
            root = builder.parse(new ByteArrayInputStream(buf.getBytes()));
            br.close();
            uc.disconnect();
        } else {
            root = builder.parse(filename);
        }
        Element elem = root.getDocumentElement();
        String topName = elem.getNodeType() == 1 ? elem.getNodeName() : "";
        if (topName.equals("vxml")) {
            this.doc = new VXMLDoc(elem, path);
        } else if (topName.equals("pdoc")) {
            this.doc = new RawPhoenixDoc(elem, path);
        } else {
            this.doc = null;
            throw new DocError("Not a valid document.");
        }
    }

    public StateMap getStateMap() {
        if (this.doc != null) {
            this.stateMap = this.doc.getStateMap();
            return this.stateMap;
        }
        return null;
    }

    public static void convert(String src) {
        try {
            DocLoader loader = new DocLoader(src, src);
            StateMap stateMap = loader.getStateMap();
            if (stateMap == null) {
                System.err.println("DocLoader stopped: stateMap null.");
                return;
            }
            String s = stateMap.toString();
            System.out.print(s);
        }
        catch (DocError e) {
            System.err.println();
            System.err.println(e);
            System.err.println("DocLoader stopped.");
        }
        catch (FileNotFoundException e) {
            System.err.println();
            System.err.println(e);
            System.err.println("DocLoader stopped.");
        }
        catch (SAXParseException e) {
            System.err.println();
            System.err.println(e);
            System.err.println("Source:" + src);
            System.err.println("Line:" + e.getLineNumber() + " Column:" + e.getColumnNumber());
            System.err.println("DocLoader stopped.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

