/*
 * Decompiled with CFR 0.152.
 */
package main;

import relaxer.vxml20.GramGrammar;
import relaxer.vxml20.GramItem;
import relaxer.vxml20.GramOneOf;
import relaxer.vxml20.GramRule;
import relaxer.vxml20.GramRuleref;
import relaxer.vxml20.GramToken;
import relaxer.vxml20.IGramGrammarChoice;
import util.HashArray;
import util.Util;

public class GrammarSet {
    private boolean isJulian_ = true;
    private String julianGramName_ = null;
    private HashArray rules_ = new HashArray();
    private GramGrammar templateGrammar_ = new GramGrammar();
    private int unique_ = 0;

    private String _getUniqueId() {
        ++this.unique_;
        String id = "g" + this.unique_;
        return id;
    }

    public GrammarSet() {
        String gfile = System.getProperty("GrammarTemplateFile", "grammar.xml");
        try {
            this.templateGrammar_.setup(gfile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setJulian(boolean j) {
        this.isJulian_ = j;
    }

    public boolean getJulian() {
        return this.isJulian_;
    }

    public void setJulianGramName(String name) {
        this.julianGramName_ = name;
    }

    public String getJulianGramName() {
        return this.julianGramName_;
    }

    private String _getTokenContent(GramRule rule) {
        String phoneme = "";
        String content = "";
        int i = 0;
        while (i < rule.sizeContent()) {
            if (rule.getContent(i) instanceof GramToken) {
                phoneme = String.valueOf(phoneme) + ((GramToken)rule.getContent(i)).getPhoneme();
                content = String.valueOf(content) + ((GramToken)rule.getContent(i)).getContent();
            }
            ++i;
        }
        return String.valueOf(phoneme) + "/" + content;
    }

    private boolean _sameRuleExists(String curr) {
        int i = 0;
        while (i < this.rules_.size()) {
            String r = this._getTokenContent((GramRule)this.rules_.get(i));
            if (curr.equals(r)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void _addJulianRules(GramRule rule, String key) {
        String curr = this._getTokenContent(rule);
        if (!this._sameRuleExists(curr)) {
            this.rules_.put(key, rule);
        }
    }

    private boolean _isSingleTokenRule(GramRule rule) {
        int nToken = 0;
        int nOther = 0;
        int i = 0;
        while (i < rule.sizeContent()) {
            if (rule.getContent(i) instanceof GramToken) {
                ++nToken;
            } else if (rule.getContent(i) instanceof GramItem) {
                ++nOther;
            } else if (rule.getContent(i) instanceof GramOneOf) {
                ++nOther;
            } else if (rule.getContent(i) instanceof GramRuleref) {
                ++nOther;
            }
            ++i;
        }
        return nToken == 1 && nOther == 0;
    }

    private void _addRegularRules(GramRule rule, String key) {
    }

    public void addRules(GramGrammar gramXml, String gramAdrs) {
        if (gramXml == null) {
            return;
        }
        if (gramAdrs == null) {
            gramAdrs = "";
        }
        String root = gramXml.getRoot();
        int nContent = gramXml.sizeContent();
        int i = 0;
        while (i < nContent) {
            IGramGrammarChoice choice = gramXml.getContent(i);
            if (choice instanceof GramRule) {
                String id;
                GramRule rule = (GramRule)choice;
                boolean isRootGrammar = true;
                if (root != null && rule.getId() != null && !rule.getId().equals(root)) {
                    isRootGrammar = false;
                }
                if ((id = rule.getId()) == null) {
                    id = this._getUniqueId();
                    rule.setId(id);
                }
                if (id.matches("[A-Z_]+")) {
                    isRootGrammar = false;
                }
                if (isRootGrammar) {
                    String key = String.valueOf(gramAdrs) + ":" + id;
                    if (this._isSingleTokenRule(rule)) {
                        this._addJulianRules(rule, key);
                    } else {
                        this._addRegularRules(rule, key);
                    }
                }
            }
            ++i;
        }
    }

    private void _addRuleref(GramRule rule, String uri) {
        GramRuleref ref = new GramRuleref();
        ref.setUri(uri);
        rule.addContent(ref);
    }

    public String getSRMGramStr() {
        String gramStr = "";
        GramGrammar gramset = new GramGrammar();
        gramset.setVersion("1.0");
        int i = 0;
        while (i < this.templateGrammar_.sizeContent()) {
            IGramGrammarChoice c = this.templateGrammar_.getContent(i);
            if (c instanceof GramRule) {
                gramset.addContent((GramRule)c);
            }
            ++i;
        }
        i = 0;
        while (i < this.rules_.size()) {
            GramRule rule = (GramRule)this.rules_.get(i);
            gramset.addContent(rule);
            String id = rule.getId();
            GramRule sentRule = new GramRule();
            sentRule.setId("SENTENCE");
            this._addRuleref(sentRule, id);
            gramset.addContent(sentRule);
            ++i;
        }
        gramStr = Util.removeNewLines(gramset.makeTextDocument());
        gramStr = gramStr.replaceAll(" xmlns=\"[^\"]*\"", "");
        return gramStr;
    }

    public String getRulesAsString() {
        String gramStr = "";
        if (this.isJulian_) {
            gramStr = this.julianGramName_ == null ? "<julian name=\"\" />" : "<julian name=\"" + this.julianGramName_ + "\" />";
        } else {
            GramGrammar gramset = new GramGrammar();
            gramset.setVersion("1.0");
            int i = 0;
            while (i < this.rules_.size()) {
                GramRule rule = (GramRule)this.rules_.get(i);
                gramset.addContent(rule);
                ++i;
            }
            gramStr = Util.removeNewLines(gramset.makeTextDocument());
            gramStr = gramStr.replaceFirst(" xmlns=\"[^\"]*\"", "");
            gramStr = gramStr.replaceAll("<rule ", "\n<rule ");
            gramStr = gramStr.replaceAll("</grammar>", "\n</grammar>");
            gramStr = gramStr.replaceAll("> <", "><");
        }
        return gramStr;
    }

    public String getRuleNames() {
        String gramStr = "";
        int i = 0;
        while (i < this.rules_.size()) {
            GramRule rule = (GramRule)this.rules_.get(i);
            gramStr = String.valueOf(gramStr) + rule.getId() + ";";
            ++i;
        }
        return gramStr;
    }

    public String toString() {
        String str = this.isJulian_ ? "julian:" + this.julianGramName_ : "srgs:" + this.getRuleNames();
        return str;
    }
}

