/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import main.CachedFile;
import main.FetchThread;
import main.HttpManagerListener;

public class HttpManager {
    private Map cacheMap_ = new HashMap(100);
    private Map fetchingMap_ = new HashMap(10);
    private static HttpManager httpm_;

    private HttpManager() {
    }

    public static HttpManager getInstance() {
        if (httpm_ == null) {
            httpm_ = new HttpManager();
        }
        return httpm_;
    }

    public synchronized void store(URL url, String type, File file) {
        System.out.println("Stored file: " + url + " " + file.getPath());
        this.cacheMap_.put(url, new CachedFile(url, type, file));
        this.fetchingMap_.remove(url);
    }

    public synchronized boolean isCached(URL url) {
        return this.cacheMap_.containsKey(url);
    }

    public synchronized void purge(URL url) {
        File f;
        if (this.cacheMap_.containsKey(url) && (f = ((CachedFile)this.cacheMap_.remove(url)).getFile()).isFile()) {
            f.delete();
        }
    }

    public synchronized File getFile(URL url) {
        CachedFile cf = (CachedFile)this.cacheMap_.get(url);
        if (cf != null) {
            return cf.getFile();
        }
        return null;
    }

    public synchronized String getFileName(URL url) {
        CachedFile cf = (CachedFile)this.cacheMap_.get(url);
        if (cf != null) {
            return cf.getFile().getPath();
        }
        return null;
    }

    public synchronized String getContentType(URL url) {
        CachedFile cf = (CachedFile)this.cacheMap_.get(url);
        if (cf != null) {
            return cf.getContentType();
        }
        return null;
    }

    public synchronized void fetchStart(URL url, HttpManagerListener l) {
        FetchThread ft = new FetchThread(url, this, l);
        this.fetchingMap_.put(url, ft);
        Thread thd = new Thread(ft);
        thd.start();
    }

    public synchronized void maskEvent(URL url) {
        FetchThread ft = (FetchThread)this.fetchingMap_.get(url);
        if (ft != null) {
            ft.maskEvent();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            URL url = new URL(args[0]);
            FetchThread ft = new FetchThread(url);
            Thread thd = new Thread(ft);
            thd.start();
            thd.join();
            System.in.read();
        } else {
            System.out.println("No arg");
        }
    }
}

