/*
 * Decompiled with CFR 0.152.
 */
package main;

import command.HttpGetCommand;
import java.net.URL;
import java.util.Vector;
import main.ContentState;
import main.Debug;
import main.DocLoader;
import main.GrammarSet;
import main.StateMap;
import util.Util;

public class InterpreterContextManager {
    private Debug dbg = new Debug("ICM", 0);
    private StateMap stateMap_;
    private ContentState currState_;
    private String initialUrl_;
    private String nextStateName_ = null;

    public GrammarSet getGrammarSet() {
        this.dbg.ASSERT(this.stateMap_ != null, "InterpreterContextManager.getGrammarSet()");
        return this.stateMap_.getGrammarSet();
    }

    public InterpreterContextManager(String fn) throws Exception {
        if (fn.startsWith("http://")) {
            this.initialUrl_ = fn;
        } else {
            this.newDocument(fn, fn);
        }
    }

    public void newDocument(String fn, String path) throws Exception {
        DocLoader doc = new DocLoader(fn, path);
        this.stateMap_ = doc.getStateMap();
        this.currState_ = this.stateMap_.getFirstState();
        if (this.currState_ == null) {
            this.dbg.print("newDocument: no __first__ state.");
        }
        this.nextStateName_ = null;
    }

    public InterpreterContextManager() {
    }

    public void setDocument(DocLoader doc) {
        this.stateMap_ = doc.getStateMap();
        this.currState_ = this.stateMap_.getFirstState();
        if (this.currState_ == null) {
            this.dbg.print("newDocument: no __first__ state.");
        }
        this.nextStateName_ = null;
    }

    public synchronized void inputText(String str) {
        String next = this.currState_.findEventHandler(str);
        this.dbg.print("ICM: inputText next= " + next);
        if (next == null && (next = this.currState_.getEventHandler("<nomatch>")) == null) {
            this.dbg.print("<nomatch> not found in state=" + this.currState_);
            return;
        }
        this.currState_ = this.stateMap_.get(next);
        if (this.currState_ == null) {
            Util.halt("Bad destination: " + next);
        }
        this.dbg.print("inputText: next=" + next + " currState=" + this.currState_);
        this.nextStateName_ = null;
    }

    public synchronized void noinput() {
        String next;
        this.dbg.print("<noinput> invoked.");
        if (this.nextStateName_ != null) {
            next = this.nextStateName_;
            this.dbg.print("ICM: <setnext> nextStateName=" + next);
        } else {
            next = this.currState_.getEventHandler("<next>");
            this.dbg.print("ICM: <next>evh nextStateName=" + next);
        }
        if (next == null) {
            this.dbg.print("ICM: next not found.. continue..");
            return;
        }
        this.currState_ = this.stateMap_.get(next);
        if (this.currState_ == null) {
            Util.halt("Bad destination: " + next);
        }
        this.dbg.print("ICM: STATE-CHANGE: " + next);
        this.dbg.ASSERT(this.currState_ != null, "ICM: state not found");
        this.nextStateName_ = null;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized Vector getCmd() {
        cmdvec = new Vector<HttpGetCommand>();
        ready = false;
        if (this.initialUrl_ == null) ** GOTO lbl35
        try {
            try {
                cmdvec.add(new HttpGetCommand(new URL(this.initialUrl_)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            this.initialUrl_ = null;
        }
        return cmdvec;
lbl-1000:
        // 1 sources

        {
            this.dbg.print("getCmd: currState=" + this.currState_);
            if (this.currState_ == null) {
                return cmdvec;
            }
            cmdvec.addAll(this.currState_.getCommands());
            if (this.currState_.isExecOnly()) {
                next = this.currState_.getEventHandler("<next>");
                this.dbg.print("getCmd: next=" + next);
                if (next == null) {
                    ready = true;
                    continue;
                }
                this.dbg.print("stateMap_:" + this.stateMap_);
                this.currState_ = this.stateMap_.get(next);
                this.nextStateName_ = null;
                this.dbg.print("setting CurrState_ to:" + this.currState_);
                ready = false;
                continue;
            }
            ready = true;
lbl35:
            // 4 sources

            ** while (!ready)
        }
lbl36:
        // 1 sources

        this.dbg.print("ICM: " + this.currState_.getName() + " has " + cmdvec.size() + " commands.");
        return cmdvec;
    }

    public synchronized void setNextState(String state) {
        this.dbg.print("ICM: setnext=" + state);
        this.nextStateName_ = state;
    }
}

