/*
 * Decompiled with CFR 0.152.
 */
package relaxer.pdoc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import relaxer.pdoc.IPdocHeadChoice;
import relaxer.pdoc.PdocGrammar;
import relaxer.pdoc.PdocJulian;
import relaxer.pdoc.RStack;
import relaxer.pdoc.UJAXP;
import relaxer.pdoc.URelaxer;

public class PdocHead
implements Serializable,
Cloneable {
    private IPdocHeadChoice content_;

    public PdocHead() {
    }

    public PdocHead(PdocHead source) {
        this.setup(source);
    }

    public PdocHead(RStack stack) {
        this.setup(stack);
    }

    public PdocHead(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public PdocHead(Element element) {
        this.setup(element);
    }

    public PdocHead(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public PdocHead(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public PdocHead(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public PdocHead(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public PdocHead(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public PdocHead(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(PdocHead source) {
        this.setContent((IPdocHeadChoice)source.getContent().clone());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        if (PdocGrammar.isMatch(stack)) {
            this.setContent(new PdocGrammar(stack));
        } else if (PdocJulian.isMatch(stack)) {
            this.setContent(new PdocJulian(stack));
        } else {
            throw new IllegalArgumentException();
        }
    }

    public Object clone() {
        return new PdocHead(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("head");
        this.content_.makeElement(element);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final IPdocHeadChoice getContent() {
        return this.content_;
    }

    public final void setContent(IPdocHeadChoice content) {
        this.content_ = content;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<head");
        this.content_.makeTextAttribute(buffer);
        buffer.append(">");
        this.content_.makeTextElement(buffer);
        buffer.append("</head>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<head");
        this.content_.makeTextAttribute(buffer);
        buffer.write(">");
        this.content_.makeTextElement(buffer);
        buffer.write("</head>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<head");
        this.content_.makeTextAttribute(buffer);
        buffer.print(">");
        this.content_.makeTextElement(buffer);
        buffer.print("</head>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "head")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (PdocGrammar.isMatchHungry(target)) {
            $match$ = true;
        } else if (PdocJulian.isMatchHungry(target)) {
            $match$ = true;
        } else {
            return false;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return PdocHead.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (PdocHead.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

