/*
 * Decompiled with CFR 0.152.
 */
package relaxer.pdoc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import relaxer.pdoc.IPdocAddChoice;
import relaxer.pdoc.RStack;
import relaxer.pdoc.UJAXP;
import relaxer.pdoc.URelaxer;

public class PdocNative
implements Serializable,
Cloneable,
IPdocAddChoice {
    private String content_;
    private String with_;

    public PdocNative() {
    }

    public PdocNative(PdocNative source) {
        this.setup(source);
    }

    public PdocNative(RStack stack) {
        this.setup(stack);
    }

    public PdocNative(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public PdocNative(Element element) {
        this.setup(element);
    }

    public PdocNative(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public PdocNative(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public PdocNative(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public PdocNative(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public PdocNative(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public PdocNative(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(PdocNative source) {
        this.setContent(source.getContent());
        this.setWith(source.getWith());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.content_ = URelaxer.getElementPropertyAsString(element);
        this.with_ = URelaxer.getAttributePropertyAsString(element, "with");
    }

    public Object clone() {
        return new PdocNative(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("native");
        URelaxer.setElementPropertyByString(element, this.content_);
        if (this.with_ != null) {
            URelaxer.setAttributePropertyByString(element, "with", this.with_);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getContent() {
        return this.content_;
    }

    public final void setContent(String content) {
        this.content_ = content;
    }

    public final String getWith() {
        return this.with_;
    }

    public final void setWith(String with) {
        this.with_ = with;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<native");
        if (this.with_ != null) {
            buffer.append(" with=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getWith())));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.append("</native>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<native");
        if (this.with_ != null) {
            buffer.write(" with=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getWith())));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.write("</native>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<native");
        if (this.with_ != null) {
            buffer.print(" with=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getWith())));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.print("</native>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getContentAsString() {
        return URelaxer.getString(this.getContent());
    }

    public String getWithAsString() {
        return URelaxer.getString(this.getWith());
    }

    public void setContentByString(String string) {
        this.setContent(string);
    }

    public void setWithByString(String string) {
        this.setWith(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "native")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return PdocNative.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (PdocNative.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

