/*
 * Decompiled with CFR 0.152.
 */
package relaxer.pdoc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import relaxer.pdoc.PdocBody;
import relaxer.pdoc.PdocHead;
import relaxer.pdoc.RStack;
import relaxer.pdoc.UJAXP;
import relaxer.pdoc.URelaxer;

public class PdocPdoc
implements Serializable,
Cloneable {
    private float version_;
    private PdocHead head_;
    private PdocBody body_;

    public PdocPdoc() {
    }

    public PdocPdoc(PdocPdoc source) {
        this.setup(source);
    }

    public PdocPdoc(RStack stack) {
        this.setup(stack);
    }

    public PdocPdoc(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public PdocPdoc(Element element) {
        this.setup(element);
    }

    public PdocPdoc(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public PdocPdoc(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public PdocPdoc(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public PdocPdoc(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public PdocPdoc(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public PdocPdoc(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(PdocPdoc source) {
        this.setVersion(source.getVersion());
        this.setHead((PdocHead)source.getHead().clone());
        this.setBody((PdocBody)source.getBody().clone());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.version_ = URelaxer.getAttributePropertyAsFloat(element, "version");
        this.setHead(new PdocHead(stack));
        this.setBody(new PdocBody(stack));
    }

    public Object clone() {
        return new PdocPdoc(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("pdoc");
        URelaxer.setAttributePropertyByFloat(element, "version", this.version_);
        this.head_.makeElement(element);
        this.body_.makeElement(element);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final float getVersion() {
        return this.version_;
    }

    public final void setVersion(float version) {
        this.version_ = version;
    }

    public final PdocHead getHead() {
        return this.head_;
    }

    public final void setHead(PdocHead head) {
        this.head_ = head;
    }

    public final PdocBody getBody() {
        return this.body_;
    }

    public final void setBody(PdocBody body) {
        this.body_ = body;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<pdoc");
        buffer.append(" version=\"");
        buffer.append(URelaxer.getString(this.getVersion()));
        buffer.append("\"");
        buffer.append(">");
        this.head_.makeTextElement(buffer);
        this.body_.makeTextElement(buffer);
        buffer.append("</pdoc>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<pdoc");
        buffer.write(" version=\"");
        buffer.write(URelaxer.getString(this.getVersion()));
        buffer.write("\"");
        buffer.write(">");
        this.head_.makeTextElement(buffer);
        this.body_.makeTextElement(buffer);
        buffer.write("</pdoc>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<pdoc");
        buffer.print(" version=\"");
        buffer.print(URelaxer.getString(this.getVersion()));
        buffer.print("\"");
        buffer.print(">");
        this.head_.makeTextElement(buffer);
        this.body_.makeTextElement(buffer);
        buffer.print("</pdoc>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getVersionAsString() {
        return URelaxer.getString(this.getVersion());
    }

    public void setVersionByString(String string) {
        this.setVersion(Float.parseFloat(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "pdoc")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!URelaxer.hasAttributeHungry(target, "version")) {
            return false;
        }
        $match$ = true;
        if (!PdocHead.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        if (!PdocBody.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return PdocPdoc.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (PdocPdoc.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

