/*
 * Decompiled with CFR 0.152.
 */
package relaxer.pdoc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import relaxer.pdoc.RStack;
import relaxer.pdoc.UJAXP;
import relaxer.pdoc.URelaxer;

public class PdocToken
implements Serializable,
Cloneable {
    private String content_;
    private String phoneme_;
    private String sym_;

    public PdocToken() {
        this.phoneme_ = "";
    }

    public PdocToken(PdocToken source) {
        this.setup(source);
    }

    public PdocToken(RStack stack) {
        this.setup(stack);
    }

    public PdocToken(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public PdocToken(Element element) {
        this.setup(element);
    }

    public PdocToken(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public PdocToken(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public PdocToken(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public PdocToken(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public PdocToken(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public PdocToken(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(PdocToken source) {
        this.setContent(source.getContent());
        this.setPhoneme(source.getPhoneme());
        this.setSym(source.getSym());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.content_ = URelaxer.getElementPropertyAsString(element);
        this.phoneme_ = URelaxer.getAttributePropertyAsString(element, "phoneme");
        this.sym_ = URelaxer.getAttributePropertyAsString(element, "sym");
    }

    public Object clone() {
        return new PdocToken(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("token");
        URelaxer.setElementPropertyByString(element, this.content_);
        if (this.phoneme_ != null) {
            URelaxer.setAttributePropertyByString(element, "phoneme", this.phoneme_);
        }
        if (this.sym_ != null) {
            URelaxer.setAttributePropertyByString(element, "sym", this.sym_);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getContent() {
        return this.content_;
    }

    public final void setContent(String content) {
        this.content_ = content;
    }

    public final String getPhoneme() {
        return this.phoneme_;
    }

    public final void setPhoneme(String phoneme) {
        this.phoneme_ = phoneme;
    }

    public final String getSym() {
        return this.sym_;
    }

    public final void setSym(String sym) {
        this.sym_ = sym;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<token");
        if (this.phoneme_ != null) {
            buffer.append(" phoneme=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPhoneme())));
            buffer.append("\"");
        }
        if (this.sym_ != null) {
            buffer.append(" sym=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSym())));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.append("</token>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<token");
        if (this.phoneme_ != null) {
            buffer.write(" phoneme=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPhoneme())));
            buffer.write("\"");
        }
        if (this.sym_ != null) {
            buffer.write(" sym=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSym())));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.write("</token>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<token");
        if (this.phoneme_ != null) {
            buffer.print(" phoneme=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPhoneme())));
            buffer.print("\"");
        }
        if (this.sym_ != null) {
            buffer.print(" sym=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSym())));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.print("</token>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getContentAsString() {
        return URelaxer.getString(this.getContent());
    }

    public String getPhonemeAsString() {
        return URelaxer.getString(this.getPhoneme());
    }

    public String getSymAsString() {
        return URelaxer.getString(this.getSym());
    }

    public void setContentByString(String string) {
        this.setContent(string);
    }

    public void setPhonemeByString(String string) {
        this.setPhoneme(string);
    }

    public void setSymByString(String string) {
        this.setSym(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "token")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!URelaxer.hasAttributeHungry(target, "phoneme")) {
            return false;
        }
        $match$ = true;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return PdocToken.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (PdocToken.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

