/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: AddOutItemCommand.java,v 1.2 2006/10/18 08:16:35 nishi Exp $
 */

package command;
import outitem.*;
import main.*;

public class AddOutItemCommand extends Command
{

    private OutItem oi_;

    public AddOutItemCommand(OutItem oi)
    {
	oi_ = oi;
    }

    public AddOutItemCommand(OutItem oi, String cond)
    {
	oi_ = oi;
	oi_.setECMAScript(ecmascript_);
	setCondition(cond);
    }

    public OutItem getItem()
    {
	return(oi_);
    }


    public String toString()
    {
	String s = "  <add";
	if ( hasCondition() ) {
	    s += " cond=\"" + getConditionAsEncodedString() + "\"";
	}
	s += ">";
	s += oi_.toString() + "</add>";
	return s;
    }


    public void execute(InteractionControler ic)
    {
	if ( evaluateCondition() == true ) {
	    ic.enqueueOutput(oi_);
	    ic.setNextOut(true);
	}
    }

}
