/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 *
 * $Id: RawPhoenixDoc.java,v 1.1 2006/08/24 03:45:43 nishi Exp $
 */

package document;

import java.util.*;
import org.w3c.dom.*;
import java.io.*;
import javax.xml.parsers.*;
import java.util.*;
import java.net.URL;
import relaxer.pdoc.*;
import relaxer.vxml20.GramGrammar;
import main.*;
import command.*;
import outitem.*;

public class RawPhoenixDoc implements AbstractDoc
{
    private Debug dbg = new Debug("RawPhoenixDoc");
    private String docAddress_;
    private Element element_;
    private StateMap stateMap_;
    private GrammarSet gram_ = null;

    public StateMap getStateMap()
    {
	return stateMap_;
    }

    public String getDocAddress()
    {
	return docAddress_;
    }

    public void setDocAddress(String adrs)
    {
	docAddress_ = adrs;
    }


    private Command getCompositeCommand( PdocCmd composite ) {
	Vector vec = new Vector();

	for ( int j = 0; j < composite.sizeCmdContents(); j++ ) {
	    IPdocCmdContentsChoice cc = composite.getCmdContents(j);
	    if ( cc instanceof PdocAdd ) {
		PdocAdd add = (PdocAdd)cc;
		String cond = ((PdocAdd)cc).getCond();

		IPdocAddChoice ac = add.getContent();
		if ( ac instanceof PdocAudio ) {
		    String src = ((PdocAudio)ac).getContent();
		    AudioOutItem o = new AudioOutItem(src);
		    o.setBargein(((PdocAudio)ac).getBargein());
		    Command c = (Command)( new AddOutItemCommand(o, cond) );
		    vec.add(c);
		} else if ( ac instanceof PdocBreak ) {
		    BreakOutItem o = new BreakOutItem(((PdocBreak)ac));
		    Command c = (Command)( new AddOutItemCommand(o, cond) );
		    vec.add(c);
		    /*
		      double length = ((PdocBreak)ac).getLength();
		      BreakOutItem o = new BreakOutItem(length);
		      o.setBargein(((PdocBreak)ac).getBargein());
		      Command c = (Command)( new AddOutItemCommand(o, cond) );
		      vec.add(c);
		    */
		} else if ( ac instanceof PdocLog ) {
		    String with = ((PdocLog)ac).getWith();
		    String text = ((PdocLog)ac).getContent();
		    LogOutItem o = new LogOutItem(text, with);
		    Command c = (Command)( new AddOutItemCommand(o, cond) );
		    vec.add(c);
		} else if ( ac instanceof PdocNative ) {
		    String with = ((PdocNative)ac).getWith();
		    String text = ((PdocNative)ac).getContent();
		    NativeOutItem o = new NativeOutItem(text, with);
		    Command c = (Command)( new AddOutItemCommand(o, cond) );
		    vec.add(c);
		} else if ( ac instanceof PdocVoice ) {
		    String with = ((PdocVoice)ac).getWith();
		    String text = ((PdocVoice)ac).getContent();
		    VoiceOutItem o = new VoiceOutItem(text, with);
		    o.setBargein(((PdocVoice)ac).getBargein());
		    Command c = (Command)( new AddOutItemCommand(o, cond) );
		    vec.add(c);
		}

	    } else if ( cc instanceof PdocCmd ) {
		Command c = getCompositeCommand((PdocCmd)cc); // recursive
		vec.add(c);
	    } else if ( cc instanceof PdocEnd ) {
		String next = ((PdocEnd)cc).getContent();
		boolean now = ((PdocEnd)cc).getNow();
		String cond = ((PdocEnd)cc).getCond();
		Command c = (Command)( new EndCommand(next, cond, now) );
		vec.add(c);
	    } else if ( cc instanceof PdocGoto ) {
		String next = ((PdocGoto)cc).getContent();
		String cond = ((PdocGoto)cc).getCond();
		Command c = (Command)( new GotoCommand(next, cond) );
		vec.add(c);
	    } else if ( cc instanceof PdocNext ) {
		String next = ((PdocNext)cc).getContent();
		String cond = ((PdocNext)cc).getCond();
		Command c = (Command)( new SetNextCommand(next, cond) );
		vec.add(c);
	    } else if ( cc instanceof PdocScript ) {
		String content = ((PdocScript)cc).getContent();
		String with = ((PdocScript)cc).getWith();
		String cond = ((PdocScript)cc).getCond();
		Command c = (Command)( new EvaluateCommand(content, with, cond) );
		vec.add(c);
	    }
	}

	String cmdcond = composite.getCond();
	return (Command) new CompositeCommand(vec, cmdcond);
    }


    public RawPhoenixDoc(Element e, String path) throws Exception
    {
	element_ = e;
	docAddress_ = path;

	if (PdocPdoc.isMatch(e) == false) {
	    throw new DocError("Not a valid <pdoc> document.");
	}
	PdocPdoc pdoc = new PdocPdoc(e);

	stateMap_ = new StateMap();
	stateMap_.setPdocVersion(pdoc.getVersion());

	///
	PdocHead head = pdoc.getHead();

	if ( head.getContent() instanceof PdocGrammar ) {
	    gram_ = new GrammarSet();
	    gram_.setJulian(false);
	    // yattuke
	    String gramstr = ((PdocGrammar)(head.getContent())).toString();

	    //System.out.println("1:" + gramstr);

	    //gramstr = "<?xml version=\"1.0\" encoding=\"euc-jp\" ?>" + gramstr;
	    GramGrammar vg = new GramGrammar(gramstr);

	    //System.out.println("2:" + vg.toString());

	    gram_.addRules(vg, docAddress_);
	    stateMap_.setGrammarSet(gram_);

	    //System.out.println("3:" + gram_.getRulesAsString());

	} else if ( head.getContent() instanceof PdocJulian ) {
	    gram_ = new GrammarSet();
	    gram_.setJulian(true);
	    String name = ((PdocJulian)(head.getContent())).getName();
	    gram_.setJulianGramName(name);
	    stateMap_.setGrammarSet(gram_);
	}

	///
	PdocBody body = pdoc.getBody();

	String start = body.getStart();
	stateMap_.setFirstStateName(start);

	for ( int i = 0; i < body.sizeState(); i++ ) {
	    PdocState state = body.getState(i);
	    dbg.print(i+">"+state.toString());
	    String stateId = state.getId();
	    stateMap_.newState(stateId);

	    PdocCmd cmd = state.getCmd();
	    Command c = getCompositeCommand(cmd);
	    stateMap_.addCommand(stateId, c);

	    PdocNomatch nomatch = state.getNomatch();
	    if ( nomatch != null ) {
		//  ''  tentative
		String dst = nomatch.getGoto().getContent().replaceAll("'", "");
		stateMap_.addNomatch(stateId, dst);
	    }

	    for ( int j = 0; j < state.sizeCatch(); j++ ) {
		PdocCatch pcatch = state.getCatch(j);
		// String next = pcatch.getGoto();
		String next = "";
		String content = pcatch.getText();
		for ( int k = 0; k < pcatch.sizeContent(); k++ ) {
		    if ( pcatch.getContent(k) instanceof PdocGoto ) {
			next = ((PdocGoto)(pcatch.getContent(k))).getContent();
			next = next.replaceAll("'", "");
			stateMap_.addTrans(stateId, next, content);
		    }
		}
	    }
	}
    }

}
