/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: DeviceEvent.java,v 1.1 2006/08/24 03:45:43 nishi Exp $
 */
package main;

import java.util.*;

public class DeviceEvent
{

    public static class Type
    {

	private String type_;

	public static final DeviceEvent.Type INPUT
	    = new DeviceEvent.Type("DeviceEvent.Type.INPUT");
	public static final DeviceEvent.Type OUTPUT
	    = new DeviceEvent.Type("DeviceEvent.Type.OUTPUT");

	private Type(String type)
	{
	    type_ = type;
	}

	public String toString()
	{
	    return type_;
	}

    }

    public static class State
    {

	private String type_;

	public static final DeviceEvent.State READY
	    = new DeviceEvent.State("DeviceEvent.State.READY");
	public static final DeviceEvent.State BUSY
	    = new DeviceEvent.State("DeviceEvent.State.BUSY");
	public static final DeviceEvent.State EVENT
	    = new DeviceEvent.State("DeviceEvent.State.EVENT");

	protected State(String type)
	{
	    type_ = type;
	}

	public String toString()
	{
	    return type_;
	}

    }

    private DeviceEvent.Type type_;
    private DeviceEvent.State state_;
    private String str_;
    private Object src_;

    public DeviceEvent.Type getDeviceType()
    {
	return type_;
    }

    public DeviceEvent.State getState()
    {
	return state_;
    }

    public String getString()
    {
	return str_;
    }

    public Object getSource()
    {
	return src_;
    }

    public DeviceEvent(Object src, DeviceEvent.Type t, 
		       DeviceEvent.State s, String str)
    {
	src_ = src;
	type_ = t;
	state_ = s;
	str_ = str;
    }

}
