/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: GrammarSet.java,v 1.1 2006/08/24 03:45:43 nishi Exp $
 */

package main;

import java.util.*;
import relaxer.vxml20.*;
import util.*;

public class GrammarSet
{
    private boolean isJulian_;

    // if julian grammar
    private String julianGramName_;

    // if not julian grammar (srgs)
    // Map<String gramAdrs:gramId, GramRule rule>
    private HashArray rules_ = null;

    private GramGrammar templateGrammar_ = null;

    private int unique_ = 0;

    private String _getUniqueId()
    {
	unique_++;
	String id = "g" + unique_;
	return id;
    }


    public GrammarSet() {
	isJulian_ = true;
	julianGramName_ = null;
	rules_ = new HashArray();

	templateGrammar_ = new GramGrammar();

	String gfile = System.getProperty("GrammarTemplateFile", "grammar.xml");
	try {
	    templateGrammar_.setup(gfile);
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }

    public void setJulian(boolean j)
    {
	isJulian_ = j;
    }

    public boolean getJulian()
    {
	return(isJulian_);
    }

    public void setJulianGramName(String name)
    {
	julianGramName_ = name;
    }

    public String getJulianGramName()
    {
	return(julianGramName_);
    }


    private String _getTokenContent(GramRule rule)
    {
	String phoneme = "";
	String content = ""; 
	for ( int i = 0; i < rule.sizeContent(); i++ ) {
	    if ( rule.getContent(i) instanceof GramToken ) {
		phoneme += ((GramToken)(rule.getContent(i))).getPhoneme();
		content += ((GramToken)(rule.getContent(i))).getContent();
	    }
	}
	return phoneme + "/" + content;
    }
    
    // rules_ δ¸ GramRule  phoneme 
    // פƤ true ֤
    private boolean _sameRuleExists(String curr)
    {
	//System.out.println(curr);
	for ( int i = 0; i < rules_.size(); i++ ) {
	    String r = _getTokenContent((GramRule)(rules_.get(i)));
	    if ( curr.equals(r) )
		return true;
	}
	return false;
    }

    private void _addJulianRules(GramRule rule, String key)
    {
	String curr = _getTokenContent(rule);
	if ( ! _sameRuleExists(curr) ) {
	    rules_.put(key, (Object)rule);
	}
    }

    private boolean _isSingleTokenRule(GramRule rule)
    {
	int nToken = 0;
	int nOther = 0;
	for ( int i = 0; i < rule.sizeContent(); i++ ) {
	    if ( rule.getContent(i) instanceof GramToken ) {
		nToken ++;
	    } else if ( rule.getContent(i) instanceof GramItem ) {
		nOther ++;
	    } else if ( rule.getContent(i) instanceof GramOneOf ) {
		nOther ++;
	    } else if ( rule.getContent(i) instanceof GramRuleref ) {
		nOther ++;
	    }
	}
	if ( nToken == 1 && nOther == 0 ) return true;
	return false;
    }

    /**
     * ƵΤߤɽ褦Ѵ rules_ ɲä
     */
    private void _addRegularRules(GramRule rule, String key)
    {
	/*
	for ( int i = 0; i < rule.sizeContent(); i++ ) {
	    if ( rule.getContent(i) instanceof GramItem ) {
		GramItem item = (GramItem)(rule.getContent(i));
		_addGramItem(item, key);
	    } else if ( rule.getContent(i) instanceof GramOneOf ) {

	    } else if ( rule.getContent(i) instanceof GramRuleref ) {

	    }
	}
	*/
    }

    public void addRules(GramGrammar gramXml, String gramAdrs)
    {
	if ( gramXml == null )
	    return;
	if ( gramAdrs == null )
	    gramAdrs = "";

	String root = gramXml.getRoot();

	int nContent = gramXml.sizeContent();
	for ( int i = 0; i < nContent; i++ ) {
	    IGramGrammarChoice choice = gramXml.getContent(i);
	    if ( choice instanceof GramRule ) {

		GramRule rule = (GramRule)choice;

		// <grammar>  root °ʤϡ
		// ޤޤ뤹٤Ƥ <rule>  root ȸʤˤΤ
		boolean isRootGrammar = true;
		if ( root != null && rule.getId() != null ) {
		    if ( ! rule.getId().equals(root) ) {
			isRootGrammar = false;
		    }
		}

		String id = rule.getId();
		if ( id == null ) {
		    id = _getUniqueId();
		    rule.setId(id);
		}
		// String scope = rule.getScope(); // ignore

		// id.equals("S")||id.equals("SENTENCE")||id.equals("NS_B")||id.equals("NS_E") 
		// ʸΤߤ롼
		if ( id.matches("[A-Z_]+") ) {
		    isRootGrammar = false;
		}
		
		if ( isRootGrammar ) {
		    // ex. file.vxml:yes 
		    //     file.vxml#dialog:yes 
		    String key = gramAdrs + ":" + id;
		    if ( _isSingleTokenRule(rule) ) {
			_addJulianRules(rule, key);
		    } else {
			_addRegularRules(rule, key);
		    }
		}
	    }
	}
    }

    private void _addRuleref( GramRule rule, String uri )
    {
	GramRuleref ref = new GramRuleref();
	ref.setUri(uri);
	rule.addContent(ref);
    }

    /**
     * for SRM
     */
    public String getSRMGramStr()
    {
	String gramStr = "";
	GramGrammar gramset = new GramGrammar();
	gramset.setVersion("1.0");

	for ( int i = 0; i < templateGrammar_.sizeContent(); i++ ) {
	    IGramGrammarChoice c = templateGrammar_.getContent(i);
	    if ( c instanceof GramRule ) {
		gramset.addContent((GramRule)c);
	    }
	}

	for ( int i = 0; i < rules_.size(); i++ ) {
	    GramRule rule = (GramRule)rules_.get(i);

	    // <rule id="yes">
	    //  <token phoneme="h;a;i;">Ϥ</token>
	    // </rule>
	    gramset.addContent(rule);

	    String id = rule.getId();

	    // <rule id="SENTENCE">
	    //  <ruleref uri="yes"/>
	    // </rule>

	    GramRule sentRule = new GramRule();
	    sentRule.setId("SENTENCE");
	    _addRuleref( sentRule, id );
	    gramset.addContent(sentRule);
	}

	gramStr = Util.removeNewLines(gramset.makeTextDocument());
	// SRM ˼뤿 xmlns 
	// <grammar xmlns="http://hil.t.u-tokyo.ac.jp/XML/2002/SRGS" version="1.0"
	// <grammar version="1.0"
	gramStr = gramStr.replaceAll(" xmlns=\"[^\"]*\"","");
	return(gramStr); 
    }

    /**
     * for header-part printing
     */
    public String getRulesAsString()
    {
	String gramStr = "";
	if ( isJulian_ ) {
	    if (julianGramName_ == null) {
		gramStr = "<julian name=\"\" />";
	    } else {
		gramStr = "<julian name=\"" + julianGramName_ + "\" />";
	    }
	} else {
	    GramGrammar gramset = new GramGrammar();
	    gramset.setVersion("1.0");
	    for ( int i = 0; i < rules_.size(); i++ ) {
		GramRule rule = (GramRule)rules_.get(i);
		// <rule id="yes">
		//  <token phoneme="h;a;i;">Ϥ</token>
		// </rule>
		gramset.addContent(rule);
	    }
	    gramStr = Util.removeNewLines(gramset.makeTextDocument());
	    gramStr = gramStr.replaceFirst(" xmlns=\"[^\"]*\"","");
	    gramStr = gramStr.replaceAll("<rule ","\n<rule ");
	    gramStr = gramStr.replaceAll("</grammar>","\n</grammar>");
	    gramStr = gramStr.replaceAll("> <","><");
	}
	return(gramStr);
    }

    /**
     * for printing name list
     */
    public String getRuleNames()
    {
	String gramStr = "";
	for ( int i = 0; i < rules_.size(); i++ ) {
	    GramRule rule = (GramRule)rules_.get(i);
	    // <rule id="yes">
	    //  <token phoneme="h;a;i;">Ϥ</token>
	    // </rule>
	    gramStr += rule.getId() + ";";
	}
	return(gramStr);
    }

    public String toString()
    {
	String str;
	if ( isJulian_ ) {
	    str = "julian:" + julianGramName_;
	} else {
	    str = "srgs:" + getRuleNames();
	}
	return str;
    }
}
