/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: MultiModalManager.java,v 1.2 2006/10/18 08:16:36 nishi Exp $
 */

package main;

import scripting.ECMAScript;
import util.*;
import outitem.*;
import java.util.*;

public class MultiModalManager implements DeviceListener
{
	
	private Debug dbg = new Debug("MMM", 0);
	private OutputDevices odevs_;
	private Vector idevs_;           // Vector<InputDevice>
	private MMMListener mmml_;
	private OutItem currOutItem_;
	private boolean nowOutput_ = false;
	private AMThread amt_;
	private GrammarSet gs_;
	private ECMAScript script_ = null;  // ECMAScript Ķ
	
	public MultiModalManager()
	{
		gs_ = new GrammarSet();
		
		amt_ = new AMThread();
		
		amt_.setOutputListener(this);
		amt_.setInputListener(this);
		amt_.start();
		
		BreakThread bt = new BreakThread();
		bt.setOutputListener(this);
		bt.start();
		
		odevs_ = new OutputDevices();
		odevs_.addDevice(bt,   OutputDevices.Type.BREAK);
		odevs_.addDevice(amt_, OutputDevices.Type.VOICE);
		odevs_.addDevice(amt_, OutputDevices.Type.AUDIO);
		odevs_.addDevice(amt_, OutputDevices.Type.LOG);
		odevs_.addDevice(amt_, OutputDevices.Type.NATIVE);
		
		idevs_ = new Vector();
		idevs_.add(amt_);
		idevs_.trimToSize();
		
		while(! amt_.isReady()) {
			try { 
				Thread.sleep(1000);
			} catch (Exception e) {e.printStackTrace();}
		}
		
	}
	
	public synchronized void terminate()
	{
		
		dbg.print("MMM Terminate");
		while(!idevs_.isEmpty()) {
			((InputDevice)idevs_.remove(0)).terminate();
		}
		odevs_.terminate(OutputDevices.Type.BREAK);
		amt_.terminate();
	}
	
	
	public void prepareGrammar(GrammarSet gs) throws GalateaRuntimeError
	{
		dbg.print("MMM: AMT.prepareGrammar");
		if ( amt_.prepareGrammar(gs) ) {
			while(! amt_.isListening()) {
				try { 
					Thread.sleep(1000);
				} catch (Exception e) {e.printStackTrace();}
			}
		}
	}
	
	public synchronized void outputNow(OutItem item)
	{
		item.doOutput(odevs_);
	}
	
	public synchronized boolean output(OutItem item) // ֤:ֻϤʤtrue
	{
		dbg.print("MMM: output start: " + Thread.currentThread().getName() );
		dbg.ASSERT(Thread.currentThread().getName().equals("main"), "bad thread" );
		
		dbg.print(item.toString() + " isInstant=" + item.isInstant() );
		
		if(item.isInstant()) {
			item.setECMAScript(script_);
			outputNow(item); //item.doOutput(odevs_);
			dbg.print("MMM: output done: " + Thread.currentThread().getName());
			return true;
		}
		else {
			currOutItem_ = item;
			currOutItem_.setECMAScript(script_);
			currOutItem_.doOutput(odevs_);
			while(!nowOutput_) {
				dbg.print("MMM: output : outStart wait");
				try{ 
					wait(5000);
					nowOutput_ = false; // ???
					break;
				} catch(Exception e){e.printStackTrace();}
				dbg.print("MMM: output : outStart wait end...");
			}
			dbg.print("MMM: output : " + Thread.currentThread().getName());
			return false;
		}
		
	}
	
	public synchronized void stop()
	{
		if(currOutItem_ != null) {
			dbg.print("MMM.stop()");
			currOutItem_.stop(odevs_);
		}
	}
	
	
	public synchronized void updateInput(DeviceEvent evt)
	{
		DeviceEvent.State state = evt.getState();
		boolean canInput = false;
		if ( currOutItem_ != null ) {
			canInput = currOutItem_.canInput();
		}
		dbg.print("MMM : currOutItem=" + currOutItem_ + " caninput=" + canInput);
		
		if(canInput) {
			if(state == DeviceEvent.State.BUSY) {
				mmml_.updateMMMStatus(new MMMEvent(MMMEvent.Type.INPUT_START));
			} else if(state == DeviceEvent.State.READY) {
				String s = evt.getString();
				while(nowOutput_) {
					dbg.print("---- MMM.update : outEnd wait");
					try{ 
						wait(5000);
						nowOutput_ = false; // ???
						break;
					} catch(Exception e){e.printStackTrace();}
					dbg.print("---- MMM.output : outEnd wait end...");
				}
				if(s != null && !s.equals("")) {
					mmml_.updateMMMStatus(new MMMEvent(MMMEvent.Type.INPUT_END, s));
				}
				else {
					mmml_.updateMMMStatus(new MMMEvent(MMMEvent.Type.INPUT_END));
				}
			}
		}
	}
	
	
	public synchronized void updateOutput(DeviceEvent evt)
	{
		DeviceEvent.State state = evt.getState();
		if(state == DeviceEvent.State.READY) {
			if(currOutItem_.isLoop()) {
				output(currOutItem_);
			} else {
				nowOutput_ = false;
				mmml_.updateMMMStatus(new MMMEvent(MMMEvent.Type.OUTPUT_END));
				notify();
			}
		} else {
			nowOutput_ = true;
			notify();
		}
	}
	
	
	public void update(DeviceEvent evt) // not synchronized 
	{
		DeviceEvent.Type type = evt.getDeviceType();
		DeviceEvent.State state = evt.getState();
		
		dbg.print("::::::::::: MMM : INPUT EVENT");
		dbg.print("   " + type.toString());
		dbg.print("   " + state.toString());
		dbg.print("   String = " + evt.getString());
		dbg.print(":::::::::::::::::::::::::::::");
		
		dbg.print("---- MMM.update");
		if(mmml_ != null) {
			if(type == DeviceEvent.Type.INPUT) {
				updateInput(evt);
			} else if(type == DeviceEvent.Type.OUTPUT) { 
				updateOutput(evt);
			}
		}
	}
	
	public void setListener(MMMListener l)
	{
		mmml_ = l;
	}

	public void setECMAScript(ECMAScript sc) {
		script_ = sc;	
	}
	
}
