/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 *
 *  $Id: LogOutItem.java,v 1.3 2006/10/18 08:16:35 nishi Exp $
 */

package outitem;

import main.Debug;
import main.OutputDevice;
import main.OutputDevices;
import scripting.ECMAScript;

public class LogOutItem extends OutItem 
{
    private Debug dbg = new Debug(1);

    private String msg_;

    // msg_  ECMAScript Ȥ eval 뤫
    private boolean eval_ = true;

    private String arg_ = "";

    private String with_ = "";

    public void setEval(boolean b)
    {
	eval_ = b;
    }

    public boolean getEval()
    {
	return eval_;
    }

    public String getArg() 
    { 
	return arg_; 
    }

    public void setWith(String s) 
    {
	with_ = s;
    }

    public String getWith() 
    {
	return with_;
    }

    public LogOutItem(String msg)
    {
	this(msg, null);
    }

    public LogOutItem(String msg, String with)
    {
	myDevice_ = OutputDevices.Type.LOG;
	isInstant_ = true;
	msg_ = msg;
	gs_ = null;
	with_ = with;
    }

    public void doOutput(OutputDevices od)
    {
	String str = null;
	if (eval_) {
	    String script;
	    if ( with_.length() > 0 ) {
		script = "with(" + with_ + "){" + msg_ + "}";
	    } else {
		script = msg_;
	    }
	    str = doEvaluate(script);

	} else {
	    str = msg_;
	}

	arg_ = str;
	OutputDevice d = od.getDevice(myDevice_);
	d.outputDeviceStart(this);
    }

    public String toString()
    {
	String s = "<log";
	if ( eval_ == true && with_.length() > 0 ) {
	    s += " with=\"" + with_ + "\"";
	}
	s += ">";
	if ( eval_ == true ) {
	    s += msg_;
	} else {
	    s += "'" + msg_ + "'";
	}
	s += "</log>";
	return s;
    }
    
}
