package relaxer.pdoc;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>PdocAssign</b> is generated from pdoc.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="assign">
 *   <attribute name="var">
 *     <data type="token"/>
 *   </attribute>
 *   <attribute name="path">
 *     <data type="token"/>
 *   </attribute>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="assign"&gt;
 *   &lt;attribute name="var"&gt;
 *     &lt;data type="token"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;attribute name="path"&gt;
 *     &lt;data type="token"/&gt;
 *   &lt;/attribute&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version pdoc.rng (Thu Aug 14 17:30:13 JST 2003)
 * @author  Relaxer 1.0rc3b (http://www.relaxer.org)
 */
public class PdocAssign implements java.io.Serializable, Cloneable, IPdocCatchChoice {
    private String var_;
    private String path_;

    /**
     * Creates a <code>PdocAssign</code>.
     *
     */
    public PdocAssign() {
        var_ = "";
        path_ = "";
    }

    /**
     * Creates a <code>PdocAssign</code>.
     *
     * @param source
     */
    public PdocAssign(PdocAssign source) {
        setup(source);
    }

    /**
     * Creates a <code>PdocAssign</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public PdocAssign(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>PdocAssign</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public PdocAssign(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>PdocAssign</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public PdocAssign(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>PdocAssign</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocAssign(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>PdocAssign</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocAssign(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>PdocAssign</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocAssign(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>PdocAssign</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocAssign(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>PdocAssign</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocAssign(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>PdocAssign</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocAssign(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>PdocAssign</code> by the PdocAssign <code>source</code>.
     *
     * @param source
     */
    public void setup(PdocAssign source) {
        int size;
        setVar(source.getVar());
        setPath(source.getPath());
    }

    /**
     * Initializes the <code>PdocAssign</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>PdocAssign</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>PdocAssign</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        var_ = URelaxer.getAttributePropertyAsString(element, "var");
        path_ = URelaxer.getAttributePropertyAsString(element, "path");
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new PdocAssign(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("assign");
        int size;
        if (this.var_ != null) {
            URelaxer.setAttributePropertyByString(element, "var", this.var_);
        }
        if (this.path_ != null) {
            URelaxer.setAttributePropertyByString(element, "path", this.path_);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>PdocAssign</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>PdocAssign</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocAssign</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocAssign</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocAssign</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocAssign</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>var</b>.
     *
     * @return String
     */
    public final String getVar() {
        return (var_);
    }

    /**
     * Sets the String property <b>var</b>.
     *
     * @param var
     */
    public final void setVar(String var) {
        this.var_ = var;
    }

    /**
     * Gets the String property <b>path</b>.
     *
     * @return String
     */
    public final String getPath() {
        return (path_);
    }

    /**
     * Sets the String property <b>path</b>.
     *
     * @param path
     */
    public final void setPath(String path) {
        this.path_ = path;
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<assign");
        if (var_ != null) {
            buffer.append(" var=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getVar())));
            buffer.append("\"");
        }
        if (path_ != null) {
            buffer.append(" path=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getPath())));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append("</assign>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<assign");
        if (var_ != null) {
            buffer.write(" var=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getVar())));
            buffer.write("\"");
        }
        if (path_ != null) {
            buffer.write(" path=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getPath())));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write("</assign>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<assign");
        if (var_ != null) {
            buffer.print(" var=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getVar())));
            buffer.print("\"");
        }
        if (path_ != null) {
            buffer.print(" path=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getPath())));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print("</assign>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getVarAsString() {
        return (URelaxer.getString(getVar()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getPathAsString() {
        return (URelaxer.getString(getPath()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setVarByString(String string) {
        setVar(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setPathByString(String string) {
        setPath(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>PdocAssign</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "assign")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "var")) {
            return (false);
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "path")) {
            return (false);
        }
        $match$ = true;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocAssign</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocAssign</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
