package relaxer.pdoc;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>PdocPdoc</b> is generated from pdoc.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="pdoc">
 *   <attribute name="version">
 *     <data type="float"/>
 *   </attribute>
 *   <ref name="head"/>
 *   <ref name="body"/>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="pdoc"&gt;
 *   &lt;attribute name="version"&gt;
 *     &lt;data type="float"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;ref name="head"/&gt;
 *   &lt;ref name="body"/&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version pdoc.rng (Thu Aug 14 17:30:12 JST 2003)
 * @author  Relaxer 1.0rc3b (http://www.relaxer.org)
 */
public class PdocPdoc implements java.io.Serializable, Cloneable {
    private float version_;
    private PdocHead head_;
    private PdocBody body_;

    /**
     * Creates a <code>PdocPdoc</code>.
     *
     */
    public PdocPdoc() {
    }

    /**
     * Creates a <code>PdocPdoc</code>.
     *
     * @param source
     */
    public PdocPdoc(PdocPdoc source) {
        setup(source);
    }

    /**
     * Creates a <code>PdocPdoc</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public PdocPdoc(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>PdocPdoc</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public PdocPdoc(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>PdocPdoc</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public PdocPdoc(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>PdocPdoc</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocPdoc(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>PdocPdoc</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocPdoc(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>PdocPdoc</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocPdoc(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>PdocPdoc</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocPdoc(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>PdocPdoc</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocPdoc(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>PdocPdoc</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocPdoc(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>PdocPdoc</code> by the PdocPdoc <code>source</code>.
     *
     * @param source
     */
    public void setup(PdocPdoc source) {
        int size;
        setVersion(source.getVersion());
        setHead((PdocHead)source.getHead().clone());
        setBody((PdocBody)source.getBody().clone());
    }

    /**
     * Initializes the <code>PdocPdoc</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>PdocPdoc</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>PdocPdoc</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        version_ = URelaxer.getAttributePropertyAsFloat(element, "version");
        setHead(new PdocHead(stack));
        setBody(new PdocBody(stack));
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new PdocPdoc(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("pdoc");
        int size;
        URelaxer.setAttributePropertyByFloat(element, "version", this.version_);
        this.head_.makeElement(element);
        this.body_.makeElement(element);
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>PdocPdoc</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>PdocPdoc</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocPdoc</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocPdoc</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocPdoc</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocPdoc</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the float property <b>version</b>.
     *
     * @return float
     */
    public final float getVersion() {
        return (version_);
    }

    /**
     * Sets the float property <b>version</b>.
     *
     * @param version
     */
    public final void setVersion(float version) {
        this.version_ = version;
    }

    /**
     * Gets the PdocHead property <b>head</b>.
     *
     * @return PdocHead
     */
    public final PdocHead getHead() {
        return (head_);
    }

    /**
     * Sets the PdocHead property <b>head</b>.
     *
     * @param head
     */
    public final void setHead(PdocHead head) {
        this.head_ = head;
    }

    /**
     * Gets the PdocBody property <b>body</b>.
     *
     * @return PdocBody
     */
    public final PdocBody getBody() {
        return (body_);
    }

    /**
     * Sets the PdocBody property <b>body</b>.
     *
     * @param body
     */
    public final void setBody(PdocBody body) {
        this.body_ = body;
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<pdoc");
        buffer.append(" version=\"");
        buffer.append(URelaxer.getString(getVersion()));
        buffer.append("\"");
        buffer.append(">");
        head_.makeTextElement(buffer);
        body_.makeTextElement(buffer);
        buffer.append("</pdoc>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<pdoc");
        buffer.write(" version=\"");
        buffer.write(URelaxer.getString(getVersion()));
        buffer.write("\"");
        buffer.write(">");
        head_.makeTextElement(buffer);
        body_.makeTextElement(buffer);
        buffer.write("</pdoc>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<pdoc");
        buffer.print(" version=\"");
        buffer.print(URelaxer.getString(getVersion()));
        buffer.print("\"");
        buffer.print(">");
        head_.makeTextElement(buffer);
        body_.makeTextElement(buffer);
        buffer.print("</pdoc>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getVersionAsString() {
        return (URelaxer.getString(getVersion()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setVersionByString(String string) {
        setVersion(Float.parseFloat(string));
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>PdocPdoc</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "pdoc")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "version")) {
            return (false);
        }
        $match$ = true;
        if (!PdocHead.isMatchHungry(target)) {
            return (false);
        }
        $match$ = true;
        if (!PdocBody.isMatchHungry(target)) {
            return (false);
        }
        $match$ = true;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocPdoc</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocPdoc</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
