package relaxer.pdoc;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>PdocState</b> is generated from pdoc.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="state">
 *   <attribute name="id">
 *     <data type="token"/>
 *   </attribute>
 *   <ref name="cmd"/>
 *   <optional>
 *     <ref name="nomatch"/>
 *   </optional>
 *   <zeroOrMore>
 *     <ref name="catch"/>
 *   </zeroOrMore>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="state"&gt;
 *   &lt;attribute name="id"&gt;
 *     &lt;data type="token"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;ref name="cmd"/&gt;
 *   &lt;optional&gt;
 *     &lt;ref name="nomatch"/&gt;
 *   &lt;/optional&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="catch"/&gt;
 *   &lt;/zeroOrMore&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version pdoc.rng (Thu Aug 14 17:30:12 JST 2003)
 * @author  Relaxer 1.0rc3b (http://www.relaxer.org)
 */
public class PdocState implements java.io.Serializable, Cloneable {
    private String id_;
    private PdocCmd cmd_;
    private PdocNomatch nomatch_;
    // List<PdocCatch>
    private java.util.List catch_ = new java.util.ArrayList();

    /**
     * Creates a <code>PdocState</code>.
     *
     */
    public PdocState() {
        id_ = "";
    }

    /**
     * Creates a <code>PdocState</code>.
     *
     * @param source
     */
    public PdocState(PdocState source) {
        setup(source);
    }

    /**
     * Creates a <code>PdocState</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public PdocState(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>PdocState</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public PdocState(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>PdocState</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public PdocState(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>PdocState</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocState(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>PdocState</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocState(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>PdocState</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocState(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>PdocState</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocState(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>PdocState</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocState(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>PdocState</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocState(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>PdocState</code> by the PdocState <code>source</code>.
     *
     * @param source
     */
    public void setup(PdocState source) {
        int size;
        setId(source.getId());
        setCmd((PdocCmd)source.getCmd().clone());
        setNomatch((PdocNomatch)source.getNomatch().clone());
        this.catch_.clear();
        size = source.catch_.size();
        for (int i = 0;i < size;i++) {
            addCatch((PdocCatch)source.getCatch(i).clone());
        }
    }

    /**
     * Initializes the <code>PdocState</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>PdocState</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>PdocState</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        id_ = URelaxer.getAttributePropertyAsString(element, "id");
        setCmd(new PdocCmd(stack));
        if (PdocNomatch.isMatch(stack)) {
            setNomatch(new PdocNomatch(stack));
        }
        catch_.clear();
        while (true) {
            if (PdocCatch.isMatch(stack)) {
                addCatch(new PdocCatch(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new PdocState(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("state");
        int size;
        if (this.id_ != null) {
            URelaxer.setAttributePropertyByString(element, "id", this.id_);
        }
        this.cmd_.makeElement(element);
        if (this.nomatch_ != null) {
            this.nomatch_.makeElement(element);
        }
        size = this.catch_.size();
        for (int i = 0;i < size;i++) {
            PdocCatch value = (PdocCatch)this.catch_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>PdocState</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>PdocState</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocState</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocState</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocState</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocState</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>id</b>.
     *
     * @return String
     */
    public final String getId() {
        return (id_);
    }

    /**
     * Sets the String property <b>id</b>.
     *
     * @param id
     */
    public final void setId(String id) {
        this.id_ = id;
    }

    /**
     * Gets the PdocCmd property <b>cmd</b>.
     *
     * @return PdocCmd
     */
    public final PdocCmd getCmd() {
        return (cmd_);
    }

    /**
     * Sets the PdocCmd property <b>cmd</b>.
     *
     * @param cmd
     */
    public final void setCmd(PdocCmd cmd) {
        this.cmd_ = cmd;
    }

    /**
     * Gets the PdocNomatch property <b>nomatch</b>.
     *
     * @return PdocNomatch
     */
    public final PdocNomatch getNomatch() {
        return (nomatch_);
    }

    /**
     * Sets the PdocNomatch property <b>nomatch</b>.
     *
     * @param nomatch
     */
    public final void setNomatch(PdocNomatch nomatch) {
        this.nomatch_ = nomatch;
    }

    /**
     * Gets the PdocCatch property <b>catch</b>.
     *
     * @return PdocCatch[]
     */
    public final PdocCatch[] getCatch() {
        PdocCatch[] array = new PdocCatch[catch_.size()];
        return ((PdocCatch[])catch_.toArray(array));
    }

    /**
     * Sets the PdocCatch property <b>catch</b>.
     *
     * @param catchValue
     */
    public final void setCatch(PdocCatch[] catchValue) {
        this.catch_.clear();
        for (int i = 0;i < catchValue.length;i++) {
            addCatch(catchValue[i]);
        }
    }

    /**
     * Sets the PdocCatch property <b>catch</b>.
     *
     * @param catchValue
     */
    public final void setCatch(PdocCatch catchValue) {
        this.catch_.clear();
        addCatch(catchValue);
    }

    /**
     * Adds the PdocCatch property <b>catch</b>.
     *
     * @param catchValue
     */
    public final void addCatch(PdocCatch catchValue) {
        this.catch_.add(catchValue);
    }

    /**
     * Adds the PdocCatch property <b>catch</b>.
     *
     * @param catchValue
     */
    public final void addCatch(PdocCatch[] catchValue) {
        for (int i = 0;i < catchValue.length;i++) {
            addCatch(catchValue[i]);
        }
    }

    /**
     * Gets number of the PdocCatch property <b>catch</b>.
     *
     * @return int
     */
    public final int sizeCatch() {
        return (catch_.size());
    }

    /**
     * Gets the PdocCatch property <b>catch</b> by index.
     *
     * @param index
     * @return PdocCatch
     */
    public final PdocCatch getCatch(int index) {
        return ((PdocCatch)catch_.get(index));
    }

    /**
     * Sets the PdocCatch property <b>catch</b> by index.
     *
     * @param index
     * @param catchValue
     */
    public final void setCatch(int index, PdocCatch catchValue) {
        this.catch_.set(index, catchValue);
    }

    /**
     * Adds the PdocCatch property <b>catch</b> by index.
     *
     * @param index
     * @param catchValue
     */
    public final void addCatch(int index, PdocCatch catchValue) {
        this.catch_.add(index, catchValue);
    }

    /**
     * Remove the PdocCatch property <b>catch</b> by index.
     *
     * @param index
     */
    public final void removeCatch(int index) {
        this.catch_.remove(index);
    }

    /**
     * Remove the PdocCatch property <b>catch</b> by object.
     *
     * @param catchValue
     */
    public final void removeCatch(PdocCatch catchValue) {
        this.catch_.remove(catchValue);
    }

    /**
     * Clear the PdocCatch property <b>catch</b>.
     *
     */
    public final void clearCatch() {
        this.catch_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<state");
        if (id_ != null) {
            buffer.append(" id=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.append("\"");
        }
        buffer.append(">");
        cmd_.makeTextElement(buffer);
        if (nomatch_ != null) {
            nomatch_.makeTextElement(buffer);
        }
        size = this.catch_.size();
        for (int i = 0;i < size;i++) {
            PdocCatch value = (PdocCatch)this.catch_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</state>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<state");
        if (id_ != null) {
            buffer.write(" id=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.write("\"");
        }
        buffer.write(">");
        cmd_.makeTextElement(buffer);
        if (nomatch_ != null) {
            nomatch_.makeTextElement(buffer);
        }
        size = this.catch_.size();
        for (int i = 0;i < size;i++) {
            PdocCatch value = (PdocCatch)this.catch_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</state>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<state");
        if (id_ != null) {
            buffer.print(" id=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.print("\"");
        }
        buffer.print(">");
        cmd_.makeTextElement(buffer);
        if (nomatch_ != null) {
            nomatch_.makeTextElement(buffer);
        }
        size = this.catch_.size();
        for (int i = 0;i < size;i++) {
            PdocCatch value = (PdocCatch)this.catch_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</state>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getIdAsString() {
        return (URelaxer.getString(getId()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setIdByString(String string) {
        setId(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>PdocState</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "state")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "id")) {
            return (false);
        }
        $match$ = true;
        if (!PdocCmd.isMatchHungry(target)) {
            return (false);
        }
        $match$ = true;
        if (PdocNomatch.isMatchHungry(target)) {
        }
        while (true) {
            if (!PdocCatch.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocState</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocState</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
