package relaxer.vxml20;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>VxmlEmotion</b> is generated from vxml20.rxg by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="emotion">
 *   <mixed>
 *     <choice occurs="*">
 *       <ref label="audio"/>
 *       <ref label="enumerate"/>
 *       <ref label="value"/>
 *       <ref label="break"/>
 *       <ref label="emphasis"/>
 *       <ref label="mark"/>
 *       <ref label="phoneme"/>
 *       <ref label="prosody"/>
 *       <ref label="say-as"/>
 *       <ref label="voice"/>
 *       <ref label="paragraph"/>
 *       <ref label="p"/>
 *       <ref label="sentence"/>
 *       <ref label="s"/>
 *       <ref label="emotion"/>
 *       <ref label="BOOKMARK"/>
 *       <ref label="CONTEXT"/>
 *       <ref label="EMPH"/>
 *       <ref label="LANG"/>
 *       <ref label="PARTOFSP"/>
 *       <ref label="PITCH"/>
 *       <ref label="PRON"/>
 *       <ref label="RATE"/>
 *       <ref label="REGWORD"/>
 *       <ref label="RESET"/>
 *       <ref label="SPELL"/>
 *       <ref label="SILENCE"/>
 *       <ref label="SPEECH"/>
 *       <ref label="VOICE"/>
 *       <ref label="VOLUME"/>
 *     </choice>
 *   </mixed>
 * </elementRule>
 * 
 * <tag name="emotion">
 *   <attribute name="type" type="NMTOKEN">
 *     <enumeration value="neutral"/>
 *     <enumeration value="happy"/>
 *     <enumeration value="disgusted"/>
 *     <enumeration value="sad"/>
 *     <enumeration value="angry"/>
 *     <enumeration value="surprised"/>
 *     <enumeration value="feared"/>
 *     <enumeration value="NEUTRAL"/>
 *     <enumeration value="HAPPY"/>
 *     <enumeration value="DISGUSTED"/>
 *     <enumeration value="SAD"/>
 *     <enumeration value="ANGRY"/>
 *     <enumeration value="SURPRISED"/>
 *     <enumeration value="FEARED"/>
 *   </attribute>
 *   <attribute name="pattern" type="int"/>
 *   <attribute name="value" type="int"/>
 *   <attribute name="duration" type="int"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="emotion"&gt;
 *   &lt;mixed&gt;
 *     &lt;choice occurs="*"&gt;
 *       &lt;ref label="audio"/&gt;
 *       &lt;ref label="enumerate"/&gt;
 *       &lt;ref label="value"/&gt;
 *       &lt;ref label="break"/&gt;
 *       &lt;ref label="emphasis"/&gt;
 *       &lt;ref label="mark"/&gt;
 *       &lt;ref label="phoneme"/&gt;
 *       &lt;ref label="prosody"/&gt;
 *       &lt;ref label="say-as"/&gt;
 *       &lt;ref label="voice"/&gt;
 *       &lt;ref label="paragraph"/&gt;
 *       &lt;ref label="p"/&gt;
 *       &lt;ref label="sentence"/&gt;
 *       &lt;ref label="s"/&gt;
 *       &lt;ref label="emotion"/&gt;
 *       &lt;ref label="BOOKMARK"/&gt;
 *       &lt;ref label="CONTEXT"/&gt;
 *       &lt;ref label="EMPH"/&gt;
 *       &lt;ref label="LANG"/&gt;
 *       &lt;ref label="PARTOFSP"/&gt;
 *       &lt;ref label="PITCH"/&gt;
 *       &lt;ref label="PRON"/&gt;
 *       &lt;ref label="RATE"/&gt;
 *       &lt;ref label="REGWORD"/&gt;
 *       &lt;ref label="RESET"/&gt;
 *       &lt;ref label="SPELL"/&gt;
 *       &lt;ref label="SILENCE"/&gt;
 *       &lt;ref label="SPEECH"/&gt;
 *       &lt;ref label="VOICE"/&gt;
 *       &lt;ref label="VOLUME"/&gt;
 *     &lt;/choice&gt;
 *   &lt;/mixed&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="emotion"&gt;
 *   &lt;attribute name="type" type="NMTOKEN"&gt;
 *     &lt;enumeration value="neutral"/&gt;
 *     &lt;enumeration value="happy"/&gt;
 *     &lt;enumeration value="disgusted"/&gt;
 *     &lt;enumeration value="sad"/&gt;
 *     &lt;enumeration value="angry"/&gt;
 *     &lt;enumeration value="surprised"/&gt;
 *     &lt;enumeration value="feared"/&gt;
 *     &lt;enumeration value="NEUTRAL"/&gt;
 *     &lt;enumeration value="HAPPY"/&gt;
 *     &lt;enumeration value="DISGUSTED"/&gt;
 *     &lt;enumeration value="SAD"/&gt;
 *     &lt;enumeration value="ANGRY"/&gt;
 *     &lt;enumeration value="SURPRISED"/&gt;
 *     &lt;enumeration value="FEARED"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;attribute name="pattern" type="int"/&gt;
 *   &lt;attribute name="value" type="int"/&gt;
 *   &lt;attribute name="duration" type="int"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version vxml20.rxg (Thu Aug 14 17:30:01 JST 2003)
 * @author  Relaxer 1.0rc3b (http://www.relaxer.org)
 */
public class VxmlEmotion implements java.io.Serializable, Cloneable, IRNSContainer, IVxmlEmotionMixed, IVxmlEmotionMixedChoice, IVxmlCONTEXTMixed, IVxmlCONTEXTMixedChoice, IVxmlJVOICEMixed, IVxmlJVOICEMixedChoice, IVxmlPITCHMixed, IVxmlPITCHMixedChoice, IVxmlEmphasisMixed, IVxmlEmphasisMixedChoice, IVxmlLANGMixed, IVxmlLANGMixedChoice, IVxmlParagraphMixed, IVxmlParagraphMixedChoice, IVxmlSentenceMixed, IVxmlSentenceMixedChoice, IVxmlPARTOFSPMixed, IVxmlPARTOFSPMixedChoice, IVxmlPMixed, IVxmlPMixedChoice, IVxmlSMixed, IVxmlSMixedChoice, IVxmlPRONMixed, IVxmlPRONMixedChoice, IVxmlRATEMixed, IVxmlRATEMixedChoice, IVxmlVOLUMEMixed, IVxmlVOLUMEMixedChoice, IVxmlEnumerateMixed, IVxmlEnumerateMixedChoice, IVxmlEMPHMixed, IVxmlEMPHMixedChoice, IVxmlSPELLMixed, IVxmlSPELLMixedChoice, IVxmlSPEECHMixed, IVxmlSPEECHMixedChoice, IRVisitable, IRNode, IVxmlVoiceMixed, IVxmlVoiceMixedChoice, IVxmlProsodyMixed, IVxmlProsodyMixedChoice, IVxmlAudioMixed, IVxmlAudioMixedChoice, IVxmlChoiceMixed, IVxmlChoiceMixedChoice, IVxmlPromptMixed, IVxmlPromptMixedChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
    private String type_;
    private Integer pattern_;
    private Integer value_;
    private Integer duration_;
    // List<IVxmlEmotionMixed>
    private java.util.List content_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>VxmlEmotion</code>.
     *
     */
    public VxmlEmotion() {
    }

    /**
     * Creates a <code>VxmlEmotion</code>.
     *
     * @param source
     */
    public VxmlEmotion(VxmlEmotion source) {
        setup(source);
    }

    /**
     * Creates a <code>VxmlEmotion</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public VxmlEmotion(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>VxmlEmotion</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public VxmlEmotion(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>VxmlEmotion</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public VxmlEmotion(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>VxmlEmotion</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlEmotion(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>VxmlEmotion</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlEmotion(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>VxmlEmotion</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlEmotion(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>VxmlEmotion</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlEmotion(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>VxmlEmotion</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlEmotion(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>VxmlEmotion</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlEmotion(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>VxmlEmotion</code> by the VxmlEmotion <code>source</code>.
     *
     * @param source
     */
    public void setup(VxmlEmotion source) {
        int size;
        setType(source.getType());
        setPattern(source.getPattern());
        setValue(source.getValue());
        setDuration(source.getDuration());
        this.content_.clear();
        size = source.content_.size();
        for (int i = 0;i < size;i++) {
            addContent((IVxmlEmotionMixed)source.getContent(i).clone());
        }
    }

    /**
     * Initializes the <code>VxmlEmotion</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>VxmlEmotion</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>VxmlEmotion</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        type_ = URelaxer.getAttributePropertyAsString(element, "type");
        pattern_ = URelaxer.getAttributePropertyAsIntObject(element, "pattern");
        value_ = URelaxer.getAttributePropertyAsIntObject(element, "value");
        duration_ = URelaxer.getAttributePropertyAsIntObject(element, "duration");
        this.content_.clear();
        while (true) {
            if (RString.isMatch(stack)) {
                addContent(new RString(stack));
            } else if (VxmlAudio.isMatch(stack)) {
                addContent(new VxmlAudio(stack));
            } else if (VxmlProsody.isMatch(stack)) {
                addContent(new VxmlProsody(stack));
            } else if (VxmlVoice.isMatch(stack)) {
                addContent(new VxmlVoice(stack));
            } else if (VxmlEmotion.isMatch(stack)) {
                addContent(new VxmlEmotion(stack));
            } else if (VxmlCONTEXT.isMatch(stack)) {
                addContent(new VxmlCONTEXT(stack));
            } else if (VxmlREGWORD.isMatch(stack)) {
                addContent(new VxmlREGWORD(stack));
            } else if (VxmlJVOICE.isMatch(stack)) {
                addContent(new VxmlJVOICE(stack));
            } else if (VxmlPITCH.isMatch(stack)) {
                addContent(new VxmlPITCH(stack));
            } else if (VxmlBreak.isMatch(stack)) {
                addContent(new VxmlBreak(stack));
            } else if (VxmlEmphasis.isMatch(stack)) {
                addContent(new VxmlEmphasis(stack));
            } else if (VxmlPhoneme.isMatch(stack)) {
                addContent(new VxmlPhoneme(stack));
            } else if (VxmlSayAs.isMatch(stack)) {
                addContent(new VxmlSayAs(stack));
            } else if (VxmlParagraph.isMatch(stack)) {
                addContent(new VxmlParagraph(stack));
            } else if (VxmlP.isMatch(stack)) {
                addContent(new VxmlP(stack));
            } else if (VxmlSentence.isMatch(stack)) {
                addContent(new VxmlSentence(stack));
            } else if (VxmlS.isMatch(stack)) {
                addContent(new VxmlS(stack));
            } else if (VxmlLANG.isMatch(stack)) {
                addContent(new VxmlLANG(stack));
            } else if (VxmlPARTOFSP.isMatch(stack)) {
                addContent(new VxmlPARTOFSP(stack));
            } else if (VxmlPRON.isMatch(stack)) {
                addContent(new VxmlPRON(stack));
            } else if (VxmlRATE.isMatch(stack)) {
                addContent(new VxmlRATE(stack));
            } else if (VxmlVOLUME.isMatch(stack)) {
                addContent(new VxmlVOLUME(stack));
            } else if (VxmlEnumerate.isMatch(stack)) {
                addContent(new VxmlEnumerate(stack));
            } else if (VxmlValue.isMatch(stack)) {
                addContent(new VxmlValue(stack));
            } else if (VxmlMark.isMatch(stack)) {
                addContent(new VxmlMark(stack));
            } else if (VxmlBOOKMARK.isMatch(stack)) {
                addContent(new VxmlBOOKMARK(stack));
            } else if (VxmlEMPH.isMatch(stack)) {
                addContent(new VxmlEMPH(stack));
            } else if (VxmlSPELL.isMatch(stack)) {
                addContent(new VxmlSPELL(stack));
            } else if (VxmlSILENCE.isMatch(stack)) {
                addContent(new VxmlSILENCE(stack));
            } else if (VxmlSPEECH.isMatch(stack)) {
                addContent(new VxmlSPEECH(stack));
            } else if (VxmlRESET.isMatch(stack)) {
                addContent(new VxmlRESET(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new VxmlEmotion(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "emotion");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        if (this.pattern_ != null) {
            URelaxer.setAttributePropertyByInt(element, "pattern", this.pattern_);
        }
        if (this.value_ != null) {
            URelaxer.setAttributePropertyByInt(element, "value", this.value_);
        }
        if (this.duration_ != null) {
            URelaxer.setAttributePropertyByInt(element, "duration", this.duration_);
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlEmotionMixed value = (IVxmlEmotionMixed)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>VxmlEmotion</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>VxmlEmotion</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlEmotion</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlEmotion</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlEmotion</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlEmotion</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param text
     */
    public void setContent(String text) {
        setContent(new RString(text));
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param text
     */
    public void setContentByString(String text) {
        setContent(new RString(text));
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public final RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public final void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>type</b>.
     *
     * @return String
     */
    public final String getType() {
        return (type_);
    }

    /**
     * Sets the String property <b>type</b>.
     *
     * @param type
     */
    public final void setType(String type) {
        this.type_ = type;
    }

    /**
     * Gets the int property <b>pattern</b>.
     *
     * @return int
     */
    public int getPattern() {
        if (pattern_ == null) {
            return(-1);
        }
        return (pattern_.intValue());
    }

    /**
     * Gets the int property <b>pattern</b>.
     *
     * @param pattern
     * @return int
     */
    public int getPattern(int pattern) {
        if (pattern_ == null) {
            return(pattern);
        }
        return (this.pattern_.intValue());
    }

    /**
     * Gets the int property <b>pattern</b>.
     *
     * @return Integer
     */
    public Integer getPatternAsInteger() {
        return (pattern_);
    }

    /**
     * Check the int property <b>pattern</b>.
     *
     * @return boolean
     */
    public boolean checkPattern() {
        return (pattern_ != null);
    }

    /**
     * Sets the int property <b>pattern</b>.
     *
     * @param pattern
     */
    public void setPattern(int pattern) {
        this.pattern_ = new Integer(pattern);
    }

    /**
     * Sets the int property <b>pattern</b>.
     *
     * @param pattern
     */
    public void setPattern(Integer pattern) {
        this.pattern_ = pattern;
    }

    /**
     * Gets the int property <b>value</b>.
     *
     * @return int
     */
    public int getValue() {
        if (value_ == null) {
            return(-1);
        }
        return (value_.intValue());
    }

    /**
     * Gets the int property <b>value</b>.
     *
     * @param value
     * @return int
     */
    public int getValue(int value) {
        if (value_ == null) {
            return(value);
        }
        return (this.value_.intValue());
    }

    /**
     * Gets the int property <b>value</b>.
     *
     * @return Integer
     */
    public Integer getValueAsInteger() {
        return (value_);
    }

    /**
     * Check the int property <b>value</b>.
     *
     * @return boolean
     */
    public boolean checkValue() {
        return (value_ != null);
    }

    /**
     * Sets the int property <b>value</b>.
     *
     * @param value
     */
    public void setValue(int value) {
        this.value_ = new Integer(value);
    }

    /**
     * Sets the int property <b>value</b>.
     *
     * @param value
     */
    public void setValue(Integer value) {
        this.value_ = value;
    }

    /**
     * Gets the int property <b>duration</b>.
     *
     * @return int
     */
    public int getDuration() {
        if (duration_ == null) {
            return(-1);
        }
        return (duration_.intValue());
    }

    /**
     * Gets the int property <b>duration</b>.
     *
     * @param duration
     * @return int
     */
    public int getDuration(int duration) {
        if (duration_ == null) {
            return(duration);
        }
        return (this.duration_.intValue());
    }

    /**
     * Gets the int property <b>duration</b>.
     *
     * @return Integer
     */
    public Integer getDurationAsInteger() {
        return (duration_);
    }

    /**
     * Check the int property <b>duration</b>.
     *
     * @return boolean
     */
    public boolean checkDuration() {
        return (duration_ != null);
    }

    /**
     * Sets the int property <b>duration</b>.
     *
     * @param duration
     */
    public void setDuration(int duration) {
        this.duration_ = new Integer(duration);
    }

    /**
     * Sets the int property <b>duration</b>.
     *
     * @param duration
     */
    public void setDuration(Integer duration) {
        this.duration_ = duration;
    }

    /**
     * Gets the IVxmlEmotionMixed property <b>content</b>.
     *
     * @return IVxmlEmotionMixed[]
     */
    public final IVxmlEmotionMixed[] getContent() {
        IVxmlEmotionMixed[] array = new IVxmlEmotionMixed[content_.size()];
        return ((IVxmlEmotionMixed[])content_.toArray(array));
    }

    /**
     * Sets the IVxmlEmotionMixed property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IVxmlEmotionMixed[] content) {
        this.content_.clear();
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the IVxmlEmotionMixed property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IVxmlEmotionMixed content) {
        this.content_.clear();
        addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlEmotionMixed property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(IVxmlEmotionMixed content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlEmotionMixed property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(IVxmlEmotionMixed[] content) {
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the IVxmlEmotionMixed property <b>content</b>.
     *
     * @return int
     */
    public final int sizeContent() {
        return (content_.size());
    }

    /**
     * Gets the IVxmlEmotionMixed property <b>content</b> by index.
     *
     * @param index
     * @return IVxmlEmotionMixed
     */
    public final IVxmlEmotionMixed getContent(int index) {
        return ((IVxmlEmotionMixed)content_.get(index));
    }

    /**
     * Sets the IVxmlEmotionMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public final void setContent(int index, IVxmlEmotionMixed content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlEmotionMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public final void addContent(int index, IVxmlEmotionMixed content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Remove the IVxmlEmotionMixed property <b>content</b> by index.
     *
     * @param index
     */
    public final void removeContent(int index) {
        this.content_.remove(index);
    }

    /**
     * Remove the IVxmlEmotionMixed property <b>content</b> by object.
     *
     * @param content
     */
    public final void removeContent(IVxmlEmotionMixed content) {
        this.content_.remove(content);
    }

    /**
     * Clear the IVxmlEmotionMixed property <b>content</b>.
     *
     */
    public final void clearContent() {
        this.content_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.append("<");
        URelaxer.makeQName(prefix, "emotion", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (type_ != null) {
            buffer.append(" ");
            buffer.append("type");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.append("\"");
        }
        if (pattern_ != null) {
            buffer.append(" ");
            buffer.append("pattern");
            buffer.append("=\"");
            buffer.append(URelaxer.getString(getPattern()));
            buffer.append("\"");
        }
        if (value_ != null) {
            buffer.append(" ");
            buffer.append("value");
            buffer.append("=\"");
            buffer.append(URelaxer.getString(getValue()));
            buffer.append("\"");
        }
        if (duration_ != null) {
            buffer.append(" ");
            buffer.append("duration");
            buffer.append("=\"");
            buffer.append(URelaxer.getString(getDuration()));
            buffer.append("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlEmotionMixed value = (IVxmlEmotionMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlEmotionMixed value = (IVxmlEmotionMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "emotion", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.write("<");
        URelaxer.makeQName(prefix, "emotion", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (type_ != null) {
            buffer.write(" ");
            buffer.write("type");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.write("\"");
        }
        if (pattern_ != null) {
            buffer.write(" ");
            buffer.write("pattern");
            buffer.write("=\"");
            buffer.write(URelaxer.getString(getPattern()));
            buffer.write("\"");
        }
        if (value_ != null) {
            buffer.write(" ");
            buffer.write("value");
            buffer.write("=\"");
            buffer.write(URelaxer.getString(getValue()));
            buffer.write("\"");
        }
        if (duration_ != null) {
            buffer.write(" ");
            buffer.write("duration");
            buffer.write("=\"");
            buffer.write(URelaxer.getString(getDuration()));
            buffer.write("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlEmotionMixed value = (IVxmlEmotionMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlEmotionMixed value = (IVxmlEmotionMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "emotion", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.print("<");
        URelaxer.makeQName(prefix, "emotion", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (type_ != null) {
            buffer.print(" ");
            buffer.print("type");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.print("\"");
        }
        if (pattern_ != null) {
            buffer.print(" ");
            buffer.print("pattern");
            buffer.print("=\"");
            buffer.print(URelaxer.getString(getPattern()));
            buffer.print("\"");
        }
        if (value_ != null) {
            buffer.print(" ");
            buffer.print("value");
            buffer.print("=\"");
            buffer.print(URelaxer.getString(getValue()));
            buffer.print("\"");
        }
        if (duration_ != null) {
            buffer.print(" ");
            buffer.print("duration");
            buffer.print("=\"");
            buffer.print(URelaxer.getString(getDuration()));
            buffer.print("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlEmotionMixed value = (IVxmlEmotionMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlEmotionMixed value = (IVxmlEmotionMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "emotion", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getTypeAsString() {
        return (URelaxer.getString(getType()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getPatternAsString() {
        return (URelaxer.getString(getPattern()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getValueAsString() {
        return (URelaxer.getString(getValue()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDurationAsString() {
        return (URelaxer.getString(getDuration()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setTypeByString(String string) {
        setType(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setPatternByString(String string) {
        setPattern(Integer.parseInt(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setValueByString(String string) {
        setValue(Integer.parseInt(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDurationByString(String string) {
        setDuration(Integer.parseInt(string));
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>VxmlEmotion</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "emotion")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while (true) {
            if (VxmlAudio.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlProsody.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlVoice.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEmotion.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlCONTEXT.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlREGWORD.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlJVOICE.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPITCH.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlBreak.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEmphasis.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPhoneme.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSayAs.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlParagraph.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlP.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSentence.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlS.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlLANG.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPARTOFSP.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPRON.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlRATE.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlVOLUME.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEnumerate.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlValue.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlMark.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlBOOKMARK.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEMPH.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSPELL.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSILENCE.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSPEECH.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlRESET.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlEmotion</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlEmotion</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
