/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 *
 * $Id: ECMAScript.java,v 1.2 2006/10/18 08:16:36 nishi Exp $
 *
 * Simple wrappar class for Mozilla Rhino JavaScript Engine
 */

package scripting;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

import util.Util;

public class ECMAScript 
{
//	static private Debug dbg = new Debug("Script", 0);
	
	private Context context_ = null;
	private Scriptable scope_ = null;
	
	public ECMAScript()
	{
		try {
			context_ = Context.enter();
			scope_ = context_.initStandardObjects(null);
			
//			Global global = new Global(context_);
//			scope_.put("Shell", scope_, global);
//			
//			Tools tools = new Tools();
//			scope_.put("Tools", scope_, tools);
			
		} catch (Exception e) {
			if ( Util.getPropertyInt("ShowScriptError", 0) != 0 ) {
				Util.runtimeError("ECMAScript Runtime:\n" 
						+ e.getMessage());
			} 
		}
	}
	
	public void exit()
	{
		context_.exit();
	}
	
	
	public String evaluate(String script)
	{
		if ( context_ == null )
			return "context_error";
		
		if ( scope_ == null )
			return "scope_error";
		
		if ( script == null )
			return "error";
		
		String str = "error";
		
		Object result = null;
		
		try {
			result = context_.evaluateString(scope_, script, "GalateaDialogManager", 1, null);
			str = context_.toString(result);
			
		} catch (Exception e) {
			if ( Util.getPropertyInt("ShowScriptError", 0) != 0 ) {
				Util.runtimeError("ECMAScript Runtime:\n" 
						+ e.getMessage() + "\n"
						+ script);
			} 
		}
		return str;
	}
	
	
	public static void main(String args[]) throws Exception 
	{
		ECMAScript sc = new ECMAScript(); // ECMAScript.getInstance();
		String r = "";
		/*
		 r = sc.evaluate("o = {a:1, b:['x','y']}"); System.err.println(r);
		 r = sc.evaluate("o.b[0]"); System.err.println(r);
		 r = sc.evaluate("p = {a:1}"); System.err.println(r);
		 r = sc.evaluate("p.b = 2"); System.err.println(r);
		 r = sc.evaluate("1+1"); System.err.println(r);
		 r = sc.evaluate("p"); System.err.println(r);
		 */
		/*
		 r = sc.evaluate("var when = new Object();"); System.err.println(r);
		 r = sc.evaluate("var dialog = new Object();"); System.err.println(r);
		 r = sc.evaluate("dialog.when = when;"); System.err.println(r);
		 r = sc.evaluate("dialog.when.value = 20;"); System.err.println(r);
		 r = sc.evaluate("when.value;"); System.err.println(r);
		 */
		String s ="weather = new Object();"
			+"weather.initial1 = undefined;"
			+"weather.place  = undefined;"
			+"weather.when   = undefined;"
			+"weather.block2 = undefined;"
			+"weather.initial1$ = new Object();"
			+"weather.initial1$.promptcount = 1;"
			+"weather.place$ = new Object();"
			+"weather.place$.promptcount = 1;"
			+"weather.place$.justfilled = false;"
			+"weather.when$ = new Object();"
			+"weather.when$.promptcount = 1;"
			+"weather.when$.justfilled = false;"
			+"weather.nextitem$ = 'hello';";
		
		r = sc.evaluate(s); System.err.println(r);
		
		s = "with(weather){ nextitem$ }";
		r = sc.evaluate(s); System.err.println(r);
		
		s = "with(weather){ 'hoge' }";
		r = sc.evaluate(s); System.err.println(r);
		
		//r = sc.objectToString("o"); System.err.println(r);
		
		sc.exit();
	}
//
//    private Context context_ = null;
//    private Scriptable scope_ = null;
//
//    private ECMAScript()
//    {
//	context_ = Context.enter();
//	scope_ = context_.initStandardObjects(null);
//    }
//
//    public void exit()
//    {
//	context_.exit();
//    }
//
//    private String evaluate(String script) throws Exception
//    {
//	if ( context_ == null )
//	    return "context_error";
//
//	if ( scope_ == null )
//	    return "scope_error";
//
//	if ( script == null )
//	    return "error";
//
//	String str = "error";
//
//	Object result = null;
//
//        result = context_.evaluateString(scope_, script, "Phoenix", 1, null);
//        str = context_.toString(result);
//
//	return str;
//    }
//
//    // singleton
//
//    private static ECMAScript instance_ = null;
//
//    private static ECMAScript getInstance()
//    {
//	if(instance_ == null) {
//	    instance_ = new ECMAScript();
//	}
//	return instance_;
//    }
//
//
//    public static String doEvaluate(String script)
//    {
//        ECMAScript s = ECMAScript.getInstance();
//        String result = "";
//        try {
//            result = s.evaluate(script);
//        } catch (Exception e) {
//            System.err.println("ECMAScript Runtime Error: " + e.getMessage());
//            System.err.println(script);
//            e.printStackTrace();
//            Util.halt();
//        } 
//        return result;
//    }
//
//    public static void doExit()
//    {
//        ECMAScript s = ECMAScript.getInstance();
//	s.exit();
//    }
//
//    public static void main(String args[]) throws Exception 
//    {
//        ECMAScript sc = ECMAScript.getInstance();
//	String r = "";
//	/*
//	r = sc.evaluate("o = {a:1, b:['x','y']}"); System.err.println(r);
//	r = sc.evaluate("o.b[0]"); System.err.println(r);
//	r = sc.evaluate("p = {a:1}"); System.err.println(r);
//	r = sc.evaluate("p.b = 2"); System.err.println(r);
//	r = sc.evaluate("1+1"); System.err.println(r);
//	r = sc.evaluate("p"); System.err.println(r);
//        */
//        /*
//	r = sc.evaluate("var when = new Object();"); System.err.println(r);
//	r = sc.evaluate("var dialog = new Object();"); System.err.println(r);
//	r = sc.evaluate("dialog.when = when;"); System.err.println(r);
//	r = sc.evaluate("dialog.when.value = 20;"); System.err.println(r);
//	r = sc.evaluate("when.value;"); System.err.println(r);
//        */
//        String s ="weather = new Object();"
//            +"weather.initial1 = undefined;"
//            +"weather.place  = undefined;"
//            +"weather.when   = undefined;"
//            +"weather.block2 = undefined;"
//            +"weather.initial1$ = new Object();"
//            +"weather.initial1$.promptcount = 1;"
//            +"weather.place$ = new Object();"
//            +"weather.place$.promptcount = 1;"
//            +"weather.place$.justfilled = false;"
//            +"weather.when$ = new Object();"
//            +"weather.when$.promptcount = 1;"
//            +"weather.when$.justfilled = false;"
//            +"weather.nextitem$ = 'hello';";
//        
//        r = sc.evaluate(s); System.err.println(r);
//
//        s = "with(weather){ nextitem$ }";
//        r = sc.evaluate(s); System.err.println(r);
//
//        s = "with(weather){ 'hoge' }";
//        r = sc.evaluate(s); System.err.println(r);
//
//	//r = sc.objectToString("o"); System.err.println(r);
//
//	sc.exit();
//    }
}

