/*
 * Galatea Dialog Manager:
 * (c)2004 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 *
 * $Id: Tools.java,v 1.1 2006/10/18 08:16:36 nishi Exp $
 */
package scripting;

import util.Util;

import java.io.*;
import java.net.*;
//import javax.xml.parsers.*;
//import java.util.*;
//import java.util.regex.*;
//import org.w3c.dom.*;


public class Tools
{
	private static String _error = "";
	
	public static String getError()
	{
		return _error;
	}
	
	public static String readURL(String filename)
	{
		_error = "";
		String buf = "";
		if (filename.startsWith("http:")) {
			try {
				URL url = new URL(filename);
				HttpURLConnection uc;
				uc = (HttpURLConnection)url.openConnection();
				uc.setRequestMethod("GET");
				InputStreamReader isr = new InputStreamReader(uc.getInputStream());
				BufferedReader br = new BufferedReader(isr);
				while(true) {
					String line = br.readLine();
					if (line == null) 
						break;
					buf += line;
				}
				br.close();
				uc.disconnect();
			} catch ( Exception e ) {
				_error = e.toString();
			}
		} else {
			_error = "readURL() : unsupported function.";
		}
		return buf;
	}
	
	/**
	 * @returns: 0 (OK) / 1 (ERROR)
	 */
	public static int saveURL(String src, String dest)
	{
		_error = "";
		int ret = 0;
		String content = readURL(src);
		if (_error.equals("")) {
			try { 
				Util.writeToFile(dest, content);
			} catch ( Exception e ) {
				_error = e.toString();
				ret = 1;
			}
		} else {
			ret = 1;
		}
		return ret;
	}
	
	/**
	 * @returns: path
	 */
	public static String mktemp()
	{
		_error = "";
		String ret = "";
		
		String prefix = "galatea";
		String suffix = "";
		
		try { 
			File temp = File.createTempFile(prefix, suffix);
			if ( temp != null ) {
				ret = temp.getAbsolutePath();
			}
		} catch ( Exception e ) {
			_error = e.toString();
		}
		return ret;
	}
	
	
	public static void send(String msg)
	{
		System.out.println(msg);
		System.out.flush();
	}
	
}
