/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * 
 * $Id: Getopt.java,v 1.1 2006/08/24 03:45:43 nishi Exp $
 * 
 * GNU Getopt for Java λͤ˹碌ƥå
 */

package util;
import java.util.Vector;

public class Getopt
{
    private Vector options_;
    private int optind_;
    private int optpos_;
    private String optarg_;

    public Getopt(String name, String argv[], String opt)
    {
	options_ = new Vector();
	optind_ = 0;
	optpos_ = 0;
	optarg_ = "";

	// argv = 0:"-c" 1:"hoge.conf" 2:"-p" 3:"hoge.xml"
	// opt = "c:p"

	// argv Ǥĥå
	// if "-"ǻϤޤ륪ץx:
	//   if ("x:"opt˴ޤޤ) then
	//     {c, "hoge.conf"} ɲ
	//   else
	//     {p, null} ɲ
	// else
	//   optind ꤹ; break;
	// end
	// optpos = 0;

	for ( int i = 0; i < argv.length; i++ ) {
	    String curr = argv[i];
	    if ( curr.startsWith("-") && curr.length() == 2 ) {
		String currOpt = curr.substring(1);
		if ( opt.indexOf( currOpt + ":" ) >= 0 ) {
		    if ( i+1 < argv.length ) {
			String item = currOpt + ":" + argv[i+1];
			options_.add( (Object)item );
			i++;
		    }
		} else {
		    options_.add( (Object)currOpt );
		}
	    } else {
		optind_ = i;
		return;
	    }
	}
	optpos_ = 0;
    }

    public int getOptind()
    {
	return optind_;
    }

    public int getopt()
    {
	if ( optpos_ < options_.size() ) {
	    String curr = (String)(options_.get(optpos_));
	    if ( curr.length() > 1 ) {
		optarg_ = curr.substring(2);
	    } else {
		optarg_ = "";
	    }
	    if ( curr.length() > 0 ) {
		optpos_++;
		return curr.charAt(0);
	    }
	} 
	return -1;
    }

    public String getOptarg()
    {
	return optarg_;
    }

    public void setOpterr(boolean opterr)
    {
	// ignored
    }


    public static void main(String argv[])
    {
	util.Getopt g = new util.Getopt("", argv, "c:p");
	g.setOpterr(false);
	int c;
	while ((c = g.getopt()) != -1){
	    switch (c)	{
	    case 'c':
		System.out.println("option c:" + g.getOptarg());
		break;
	    case 'p':
		System.out.println("option p=true");
		break;
	    }
	}

	if (argv.length - g.getOptind() != 1){
	    System.out.println("Usage: hoge");
	    System.exit(1);
	} else {
	    System.out.println("arg:" + argv[g.getOptind()]);
	}
    }
}
