/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 *
 * $Id: GrammarUtil.java,v 1.1 2006/08/24 03:45:43 nishi Exp $
 */
package util;

import relaxer.vxml20.*;

public class GrammarUtil 
{
    public GrammarUtil() 
    {
    }

    private static HashArray _getKana2ph() 
    {
	HashArray kana2ph = new HashArray();
	kana2ph.put("","ky a ");
	kana2ph.put("","ky u ");
	kana2ph.put("","ky o ");
	kana2ph.put("","sh a ");
	kana2ph.put("","sh u ");
	kana2ph.put("","sh e ");
	kana2ph.put("","sh o ");
	kana2ph.put("","ch a ");
	kana2ph.put("","ch u ");
	kana2ph.put("","ch e ");
	kana2ph.put("","ch o ");
	kana2ph.put("Ĥ","ts e ");
	kana2ph.put("Ĥ","ts a ");
	kana2ph.put("Ĥ","ts i ");

	kana2ph.put("ˤ","ny a ");
	kana2ph.put("ˤ","ny u ");
	kana2ph.put("ˤ","ny o ");
	kana2ph.put("Ҥ","hy a ");
	kana2ph.put("Ҥ","hy u ");
	kana2ph.put("Ҥ","hy o ");
	kana2ph.put("ߤ","my a ");
	kana2ph.put("ߤ","my u ");
	kana2ph.put("ߤ","my o ");
	kana2ph.put("","ry a ");
	kana2ph.put("","ry u ");
	kana2ph.put("","ry o ");
	kana2ph.put("","gy a ");
	kana2ph.put("","gy u ");
	kana2ph.put("","gy o ");
	kana2ph.put("Ӥ","by a ");
	kana2ph.put("Ӥ","by u ");
	kana2ph.put("Ӥ","by o ");
	kana2ph.put("Ԥ","py a ");
	kana2ph.put("Ԥ","py u ");
	kana2ph.put("Ԥ","py o ");

	kana2ph.put("դ","f a ");
	kana2ph.put("դ","f i ");
	kana2ph.put("դ","f e ");
	kana2ph.put("դ","f o ");

	kana2ph.put("","j a ");
	kana2ph.put("","j a ");
	kana2ph.put("","j u ");
	kana2ph.put("","j e ");
	kana2ph.put("","j o ");

	kana2ph.put("¤","j a ");
	kana2ph.put("¤","j a ");
	kana2ph.put("¤","j u ");
	kana2ph.put("¤","j e ");
	kana2ph.put("¤","j o ");

	kana2ph.put("Ǥ","d i ");
	kana2ph.put("Ǥ","dy u ");

	kana2ph.put("","w e ");
	kana2ph.put("","w i ");

	kana2ph.put("Ȥ","t u ");
	kana2ph.put("Ƥ","t i ");
	kana2ph.put("Ƥ","t u ");


	kana2ph.put("","w o ");
	kana2ph.put("","z i ");
	kana2ph.put("ɤ","d u ");
	kana2ph.put("դ","hy o ");
	kana2ph.put("դ","hy u ");

	kana2ph.put("","k u e ");
	kana2ph.put("","s i ");
	kana2ph.put("ۤ","h o i ");
	kana2ph.put("","k u i ");
	kana2ph.put("","sh i ");
	kana2ph.put("","k u o ");
	kana2ph.put("ͤ","n e: ");

	kana2ph.put("","a ");
	kana2ph.put("","i ");
	kana2ph.put("","u ");
	kana2ph.put("","e ");
	kana2ph.put("","o ");
	kana2ph.put("","o ");

	kana2ph.put("","k a ");
	kana2ph.put("","k i ");
	kana2ph.put("","k u ");
	kana2ph.put("","k e ");
	kana2ph.put("","k o ");
	kana2ph.put("","s a ");
	kana2ph.put("","sh i ");
	kana2ph.put("","s u ");
	kana2ph.put("","s e ");
	kana2ph.put("","s o ");
	kana2ph.put("","t a ");
	kana2ph.put("","ch i ");
	kana2ph.put("","ts u ");
	kana2ph.put("","t e ");
	kana2ph.put("","t o ");
	kana2ph.put("","n a ");
	kana2ph.put("","n i ");
	kana2ph.put("","n u ");
	kana2ph.put("","n e ");
	kana2ph.put("","n o ");
	kana2ph.put("","h a ");
	kana2ph.put("","h i ");
	kana2ph.put("","f u ");
	kana2ph.put("","h e ");
	kana2ph.put("","h o ");
	kana2ph.put("","m a ");
	kana2ph.put("","m i ");
	kana2ph.put("","m u ");
	kana2ph.put("","m e ");
	kana2ph.put("","m o ");
	kana2ph.put("","y a ");
	kana2ph.put("","y u ");
	kana2ph.put("","y o ");
	kana2ph.put("","r a ");
	kana2ph.put("","r i ");
	kana2ph.put("","r u ");
	kana2ph.put("","r e ");
	kana2ph.put("","r o ");
	kana2ph.put("","w a ");
	kana2ph.put("","N ");

	kana2ph.put("","g a ");
	kana2ph.put("","g i ");
	kana2ph.put("","g u ");
	kana2ph.put("","g e ");
	kana2ph.put("","g o ");
	kana2ph.put("","z a ");
	kana2ph.put("","j i ");
	kana2ph.put("","z u ");
	kana2ph.put("","z e ");
	kana2ph.put("","z o ");
	kana2ph.put("","d a ");
	kana2ph.put("","j i ");
	kana2ph.put("","z u ");
	kana2ph.put("","d e ");
	kana2ph.put("","d o ");
	kana2ph.put("","b a ");
	kana2ph.put("","b i ");
	kana2ph.put("","b u ");
	kana2ph.put("","b e ");
	kana2ph.put("","b o ");
	kana2ph.put("","p a ");
	kana2ph.put("","p i ");
	kana2ph.put("","p u ");
	kana2ph.put("","p e ");
	kana2ph.put("","p o ");

	kana2ph.put("","q ");
	kana2ph.put("",": ");
	kana2ph.put("","a ");
	kana2ph.put("","i ");
	kana2ph.put("","u ");
	kana2ph.put("","e ");
	kana2ph.put("","o ");
	kana2ph.put("","y a ");
	kana2ph.put("","y u ");
	kana2ph.put("","y o ");
	kana2ph.put("","i ");
	kana2ph.put("","e ");

	kana2ph.put("a a ", "a: ");
	kana2ph.put("i i ", "i: ");
	kana2ph.put("u u ", "u: ");
	kana2ph.put("e e ", "e: ");
	kana2ph.put("o o ", "o: ");

	kana2ph.put("e i ", "e: ");
	kana2ph.put("o u ", "o: ");

	kana2ph.put(" :", ":");
	kana2ph.put("", "");
	kana2ph.put(" ", ";");
	return kana2ph;
    }

    public static String getPhonemeFromSym(String sym)
    {
	HashArray kana2ph = _getKana2ph();

	String phoneme = sym;
	for ( int i = 0; i < kana2ph.size(); i++ ) {
	    String key = kana2ph.getKey(i);
	    String str = (String)(kana2ph.get(i));
	    phoneme = phoneme.replaceAll(key, str);
	}
	return phoneme;
    }

    public static void makePhonemeFromSym(GramGrammar gram)
    {
	for (int i = 0; i < gram.sizeContent(); i++) {
	    if ( gram.getContent(i) instanceof GramRule ) {
		GramRule rule = (GramRule)(gram.getContent(i));
		for (int j = 0; j < rule.sizeContent(); j++) {
		    if ( rule.getContent(j) instanceof GramToken ) {
			GramToken token = (GramToken)(rule.getContent(j));
			if ( token.getPhoneme() == null ) {
			    token.setPhoneme(getPhonemeFromSym(token.getSym()));
			}
		    }
		}
	    }
	}
    }

    /**
     * make GrammarUtil.run
     */
    public static void main(String args[]) throws Exception
    {
    }

}
