# -*- coding: ascii -*-
#
#  gviewer.py - GViewer Window for GBotter
#  Copyright (C) 2004 by Atzm WATANABE <sitosito@p.chan.ne.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: gvwindow.py,v 1.10 2004/07/27 20:04:43 atzm Exp $
#

import gtk
from viewer.ghostmanager import GhostManager
from viewer.gviewer import GViewerQueue
from viewer.viewercommon import SIZE_SURFACE_H, SIZE_SURFACE_V

from common import *

class GVWindow:
	def __init__(self, ghost_dir, ghost_text):
		self.ghost_dir  = ghost_dir
		self.ghost_text = ghost_text

		self.ghostmanager = GhostManager(self.ghost_text)

		# sakura side
		sakura_frame = gtk.Frame()
		sakura_frame.set_shadow_type(gtk.SHADOW_NONE)
		sakura_frame.set_size_request(SIZE_SURFACE_H+5, SIZE_SURFACE_V+5)
		sakura_frame.show()

		t1 = gtk.TextView()
		t1.show()
		t1.set_wrap_mode(gtk.WRAP_CHAR)
		t1.set_editable(gtk.FALSE)
		t1.set_cursor_visible(gtk.FALSE)
		b1 = t1.get_buffer()
		sw1 = gtk.ScrolledWindow()
		sw1.show()
		sw1.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_ALWAYS)
		sw1.add(t1)
		f1 = gtk.Frame()
		f1.show()
		f1.set_shadow_type(gtk.SHADOW_IN)
		f1.add(sw1)

		sakurabox = gtk.HBox()
		sakurabox.show()
		sakurabox.pack_start(sakura_frame, gtk.FALSE, gtk.FALSE, 0)
		sakurabox.pack_start(f1)
		sakurabox.set_size_request(100 + 5, SIZE_SURFACE_V * 2 + 20 + 5)

		# kero side
		kero_frame = gtk.Frame()
		kero_frame.set_shadow_type(gtk.SHADOW_NONE)
		kero_frame.set_size_request(SIZE_SURFACE_H+5, SIZE_SURFACE_V+5)
		kero_frame.show()

		t2 = gtk.TextView()
		t2.show()
		t2.set_wrap_mode(gtk.WRAP_CHAR)
		t2.set_editable(gtk.FALSE)
		t2.set_cursor_visible(gtk.FALSE)
		b2 = t2.get_buffer()
		sw2 = gtk.ScrolledWindow()
		sw2.show()
		sw2.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_ALWAYS)
		sw2.add(t2)
		f2 = gtk.Frame()
		f2.show()
		f2.set_shadow_type(gtk.SHADOW_IN)
		f2.add(sw2)

		kerobox = gtk.HBox()
		kerobox.show()
		kerobox.pack_start(kero_frame, gtk.FALSE, gtk.FALSE, 0)
		kerobox.pack_start(f2)
		kerobox.set_size_request(100 + 5 , SIZE_SURFACE_V + 20 + 5)

		# sender, channel, rest
		sc_label = gtk.Label()
		sc_label.show()
		sc_frame = gtk.Frame()
		sc_frame.show()
		sc_frame.set_shadow_type(gtk.SHADOW_IN)
		sc_frame.add(sc_label)

		g_label = gtk.Label()
		g_label.show()
		g_frame = gtk.Frame()
		g_frame.show()
		g_frame.set_shadow_type(gtk.SHADOW_IN)
		g_frame.add(g_label)

		r_label = gtk.Label()
		r_label.show()
		i_label = gtk.Label(unicode(_('Items'), 'utf-8'))
		i_label.show()

		restbox = gtk.HBox()
		restbox.show()
		restbox.pack_start(r_label, gtk.TRUE, gtk.TRUE, 0)
		restbox.pack_start(i_label, gtk.FALSE, gtk.FALSE, 0)
		r_frame = gtk.Frame()
		r_frame.show()
		r_frame.set_shadow_type(gtk.SHADOW_IN)
		r_frame.add(restbox)

		scbox = gtk.HBox()
		scbox.show()
		scbox.pack_start(sc_frame, gtk.TRUE, gtk.TRUE, 0)
		scbox.pack_start(g_frame, gtk.TRUE, gtk.TRUE, 0)
		scbox.pack_start(r_frame, gtk.TRUE, gtk.TRUE, 0)

		# cancel button
		ibutton = gtk.Button(unicode(_('Cancel'), 'utf-8'))
		ibutton.show()

		# cancel button
		cbutton = gtk.Button(unicode(_('Cancel all'), 'utf-8'))
		cbutton.show()

		# buttons
		bbox = gtk.HBox()
		bbox.show()
		bbox.pack_start(ibutton)
		bbox.pack_start(cbutton)

		# all
		box = gtk.VBox()
		box.show()
		box.pack_start(sakurabox)
		box.pack_start(kerobox)
		box.pack_start(bbox)
		box.pack_start(scbox)

		# window
		accel_group = gtk.AccelGroup()
		self.window = gtk.Window()
		self.window.set_title(unicode(_(APP), "utf-8") + ": " + \
							  unicode(_("GViewer"), "utf-8"))
		self.window.set_size_request(400+10, SIZE_SURFACE_V * 2 + 160)
		self.window.add_accel_group(accel_group)
		self.window.connect('delete-event', self.close)
		self.window.add(box)

		self.gv = GViewerQueue([sakura_frame, b1, sw1],
							   [kero_frame, b2, sw2], sc_label, g_label, r_label)

		ibutton.connect('clicked', lambda x: self.gv.cancel())
		cbutton.connect('clicked', lambda x: self.gv.cancel_all())

	def enqueue(self, channel, ifghost, script, sender):
		ghost = self.ghostmanager.nominate_ghost(ifghost, self.ghost_dir)
		self.gv.enqueue(script, ghost, sender, channel, ifghost)

	def get_fmo_ghosts(self):
		return self.ghostmanager.get_fmo_ghosts()

	def notify_svg_changed(self):
		self.ghostmanager.generate_dictionary(self.ghost_text)

	def notify_use_gviewer(self, use):
		if use:
			self.gv.polling_start()
		else:
			self.gv.polling_stop()

	def notify_wait_1_char(self, num):
		try:
			self.gv.set_wait_1_char(int(num))
		except:
			pass

	def notify_wait_w1_tag(self, num):
		try:
			self.gv.set_wait_w1_tag(int(num))
		except:
			pass

	def open(self, widget=None, data=None):
		self.window.show()

	def close(self, widget=None, e=None, data=None):
		self.window.hide()
		return gtk.TRUE
