# -*- coding: ascii -*-
#
#  svgmanager.py - The Manager of SVG
#  Copyright (C) 2004 by Takuya KAWAHARA <num@sann.ne.jp>
#  Copyright (C) 2004 by Atzm WATANABE <sitosito@p.chan.ne.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.


import pygtk
import gtk
import os
import shutil
import sys
import string
import re

from common              import *
from viewer.ghostmanager import GhostManager
from viewer.viewercommon import *

class SVGManager:
	def __init__(self, app, prefs, base_dir, ghost_file='ghost.txt'):
		self.ghost_list = []
		self.app = app
		self.prefs = prefs
		self.base_dir = base_dir
		if not os.path.exists(self.base_dir):
			os.makedirs(self.base_dir)
			self.set_config(ghost_file)
		self.gm = GhostManager(ghost_file, True)

## Create Base Window
		self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
		self.window.connect("delete_event", self.close)
		self.window.set_title(unicode(_(APP), "utf-8") + ":" + unicode(_("SVGManager"), "utf-8"))
		self.window.set_size_request(450, 450)

		self.main = gtk.HBox(gtk.FALSE, 0)
		self.status = gtk.VBox(gtk.FALSE, 0)
		#self.status.set_size_request(300, -1)
		self.ctrl = gtk.VBox(gtk.FALSE, 0)

		self.main.pack_start(self.status, gtk.TRUE, gtk.TRUE, 0)
		self.main.pack_start(self.ctrl, gtk.FALSE, gtk.FALSE, 5)

## Create status (left) window
		## Create GhostList window
		self.gn_str = gtk.ListStore('gboolean', str, str, str)

		# generate self.ghost_list[][]
		self.get_config(ghost_file)
		self.set_ghost_tree()

		self.gn = gtk.TreeView(self.gn_str)
		self.gn.set_rules_hint(gtk.TRUE)
		self.gn.set_size_request(-1, 200)
		self.gn.connect("cursor-changed", self.cc)
		self.gn.connect("select-cursor-row", self.select_row)

		# make ghostlist column
		self.ucolumn = gtk.TreeViewColumn(unicode(_('Use'), 'utf-8'))
		self.gncolumn = gtk.TreeViewColumn(unicode(_('Ghost'), 'utf-8'))
		self.fcolumn = gtk.TreeViewColumn(unicode(_('FMO'), 'utf-8'))
		self.pcolumn = gtk.TreeViewColumn(unicode(_('Path'), 'utf-8'))
		self.gn.append_column(self.ucolumn)
		self.gn.append_column(self.gncolumn)
		self.gn.append_column(self.fcolumn)
		self.gn.append_column(self.pcolumn)

		# define width of each column
		self.ucell = gtk.CellRendererToggle()
		self.ucell.set_property('width', 40)
		self.ucell.connect("toggled", self.check_use_toggle)
		self.gncell = gtk.CellRendererText()
		self.gncell.set_property('width', 80)
		self.fcell = gtk.CellRendererText()
		self.fcell.set_property('width', 40)
		self.pcell = gtk.CellRendererText()
		self.pcell.set_property('width', 140)

		self.ucolumn.pack_start(self.ucell, gtk.TRUE)
		self.gncolumn.pack_start(self.gncell, gtk.TRUE)
		self.fcolumn.pack_start(self.fcell, gtk.TRUE)
		self.pcolumn.pack_start(self.pcell, gtk.TRUE)

		# '0' is self.ghost_list[*][0](GHOST),
		# '1' is [1](IfGhost),
		# '2' is [2](FMO flag),
		# '3' is [3](path of define file)
		self.ucolumn.add_attribute(self.ucell, 'active', 0)
		self.gncolumn.add_attribute(self.gncell, 'text', 1)
		self.fcolumn.add_attribute(self.fcell, 'text', 2)
		self.pcolumn.add_attribute(self.pcell, 'text', 3)

		self.gn.set_search_column(gtk.TRUE)
		self.gn.set_reorderable(gtk.FALSE)

		self.sw = gtk.ScrolledWindow()
		self.sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
		self.sw.add(self.gn)

		self.sw_f = gtk.Frame()
		self.sw_f.add(self.sw)
		self.sw_f.set_border_width(0)
		self.sw_f.set_shadow_type(gtk.SHADOW_IN)

		# Create GhostInformation main
		self.info = gtk.HBox()

		#self.info_ghost is 'showing surface [0] and [10]'
		self.info_ghost = gtk.HBox(gtk.FALSE)
		self.sakura_box = gtk.Image()
		self.unyuu_box = gtk.Image()

		self.sakura_f = gtk.Frame()
		self.sakura_f.set_border_width(0)
		self.sakura_f.set_size_request(SIZE_SURFACE_H + 1, SIZE_SURFACE_V + 1)
		#self.sakura_f.set_shadow_type(gtk.SHADOW_OUT)
		self.sakura_f.set_shadow_type(gtk.SHADOW_NONE)
		self.sakura_f.add(self.sakura_box)

		self.unyuu_f = gtk.Frame()
		self.unyuu_f.set_border_width(0)
		self.unyuu_f.set_size_request(SIZE_SURFACE_H + 1, SIZE_SURFACE_V + 1)
		#self.unyuu_f.set_shadow_type(gtk.SHADOW_OUT)
		self.unyuu_f.set_shadow_type(gtk.SHADOW_NONE)
		self.unyuu_f.add(self.unyuu_box)

		self.info_ghost.pack_start(self.unyuu_f, gtk.TRUE, gtk.FALSE, 0)
		self.info_ghost.pack_start(self.sakura_f, gtk.TRUE, gtk.FALSE, 0)
	

		self.button_id = None
		self.url_button = get_icon_button(gtk.STOCK_JUMP_TO, size=gtk.ICON_SIZE_BUTTON,
				relief=gtk.RELIEF_NORMAL, label=unicode(_('URL'), 'utf-8'))
		self.url_button.set_sensitive(gtk.FALSE)

		self.info_ghost_a = gtk.VBox(gtk.FALSE)
		self.info_ghost_a.pack_start(self.info_ghost, gtk.TRUE, gtk.FALSE, 0)
		self.hogehoge = gtk.HBox(gtk.TRUE)
		self.hogehoge.pack_start(self.url_button, gtk.FALSE, gtk.FALSE, 0)
		self.info_ghost_a.pack_start(self.hogehoge, gtk.FALSE, gtk.FALSE, 0)
		#self.info_svg is 'showing information of selected svg_file (from *.txt)'
		self.info_svg = gtk.TextView()
		self.info_svg.set_editable(gtk.FALSE)
		self.info_svg.set_cursor_visible(gtk.FALSE)
		self.isv = gtk.ScrolledWindow()
		self.isv.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
		self.isv.set_size_request(200, 200)
		self.isv.add(self.info_svg)
		self.tframe = gtk.Frame()
		self.tframe.set_shadow_type(gtk.SHADOW_IN)
		self.tframe.add(self.isv)

		self.ghost_name = gtk.Entry()
		self.ghost_name.set_editable(gtk.FALSE)
		#self.ghost_name.set_cursor_visible(gtk.FALSE)

		self.info.pack_start(self.info_ghost_a, gtk.FALSE, gtk.FALSE, 0)
		self.info.pack_start(self.tframe, gtk.TRUE, gtk.TRUE, 0)

		self.v_paned = gtk.VPaned()
		self.v_paned.pack1(self.info)
		self.v_paned.pack2(self.sw_f)

		self.status.pack_start(self.ghost_name, gtk.FALSE, gtk.FALSE, 0)
		self.status.pack_start(self.v_paned, gtk.TRUE, gtk.TRUE, 5)

## Create Bottons (right) window
		self.btns = gtk.VBox(gtk.FALSE, 0)

		self.add_b = get_icon_button(gtk.STOCK_ADD, size=gtk.ICON_SIZE_BUTTON,
									 relief=gtk.RELIEF_NORMAL, label=unicode(_('Add'), 'utf-8'))
		self.add_b.connect("clicked", self.add_ghost)
		self.fmo_b = get_icon_button(gtk.STOCK_YES, size=gtk.ICON_SIZE_BUTTON,
									 relief=gtk.RELIEF_NORMAL, label=unicode(_('FMO'), 'utf-8'))
		self.fmo_b.connect("clicked", self.check_fmo)
		self.use_b = get_icon_button(gtk.STOCK_NO, size=gtk.ICON_SIZE_BUTTON,
									 relief=gtk.RELIEF_NORMAL, label=unicode(_('Use'), 'utf-8'))
		self.use_b.connect("clicked", self.check_use)
		self.delete_g = get_icon_button(gtk.STOCK_REMOVE, size=gtk.ICON_SIZE_BUTTON,
										relief=gtk.RELIEF_NORMAL, label=unicode(_('Remove'), 'utf-8'))
		self.delete_g.connect("clicked", self.delete_ghost)
		self.reload_b = get_icon_button(gtk.STOCK_REFRESH, size=gtk.ICON_SIZE_BUTTON,
										relief=gtk.RELIEF_NORMAL, label=unicode(_('Reload'), 'utf-8'))
		self.reload_b.connect("clicked", self.reload)
		self.save_b = get_icon_button(gtk.STOCK_SAVE, size=gtk.ICON_SIZE_BUTTON,
									  relief=gtk.RELIEF_NORMAL, label=unicode(_('Save'), 'utf-8'))
		self.save_b.connect("clicked", self.save)
		self.fin_b = get_icon_button(gtk.STOCK_CLOSE, size=gtk.ICON_SIZE_BUTTON,
									 relief=gtk.RELIEF_NORMAL, label=unicode(_('Close'), 'utf-8'))
		self.fin_b.connect("clicked", self.close, self.window)

		self.ctrl.pack_start(self.add_b, gtk.TRUE, gtk.TRUE, 5)
		self.ctrl.pack_start(self.fmo_b, gtk.TRUE, gtk.TRUE, 5)
		self.ctrl.pack_start(self.use_b, gtk.TRUE, gtk.TRUE, 5)
		self.ctrl.pack_start(self.delete_g, gtk.TRUE, gtk.TRUE, 5)
		self.ctrl.pack_start(self.reload_b, gtk.TRUE, gtk.TRUE, 5)
		self.ctrl.pack_start(self.save_b, gtk.TRUE, gtk.TRUE, 5)
		self.ctrl.pack_start(self.fin_b, gtk.TRUE, gtk.TRUE, 5)

		self.window.add(self.main)

	def open(self, widget=None, data=None):
		self.window.show_all()

	def close(self, widget, event, data=None):
		self.window.hide()
		return gtk.TRUE

## 'cursor-changed' signal gtk.TreeView
	def cc(self, treeview):
		treeview.emit("select-cursor-row", gtk.FALSE)

	def select_row(self, treeview, se=gtk.FALSE):
		ifg = self.ghost_list[self.gn.get_cursor()[0][0]][3]
		ifg = re.match('"(.+?)"', ifg).group(1)
		ghost = self.gm
		g = ghost.nominate_ghost_txt(os.path.join(self.base_dir, ifg), \
										os.path.join(self.base_dir, 'Ghost'))

		## get and show sakura, unyuu surfaces
		sur_sakura = g.get_surface(0)
		sur_unyuu = g.get_surface(10)

		self.sakura_box.set_from_pixbuf(sur_sakura)
		self.unyuu_box.set_from_pixbuf(sur_unyuu)

		## get and show ghost information
		sakura = g.get_sakura()
		unyuu = g.get_unyu()
		craftman = g.get_craftman()
		hpname = g.get_hpname()
		hpurl = g.get_url()
		surfacefile = g.get_surfacefile()
		update = g.get_update()
		ghostname = g.get_ghostname()
		supported = g.get_supported()
		sakura_action = g.get_sakura_action()
		inform = g.get_inform()

		self.ghost_name.set_text(ghostname)

		information = sakura + '\n\t&\n\t' + unyuu + '\n'
		if craftman:      information = information + '\nby:\t' + craftman
		if hpname:        information = information + '\nHP Name:\t' + hpname
		if hpurl:         information = information + '\nHP URL:\n' + hpurl + '\n'
		if supported:     information = information + '\n' + supported
		if sakura_action: information = information + '\nSakuraAct:\t' + sakura_action
		information = information + '\nDEF.:./' + ifg
		if surfacefile:   information = information + '\nSUF.:./Ghost/' + surfacefile
		if update:        information = information + '\n\nVer.' + update
		if inform:        information = information + '\n' + inform

		info = gtk.TextBuffer()
		info.set_text(information)

		self.info_svg.set_buffer(info)

		if self.button_id:
			self.url_button.disconnect(self.button_id)
		self.button_id = None

		if hpurl:
			self.url_button.set_sensitive(gtk.TRUE)
			self.button_id = self.url_button.connect("clicked", self.url_jump, hpurl)
		else:
			self.url_button.set_sensitive(gtk.FALSE)

## if pressed button
	def add_ghost(self, button):
		def file_ok_sel(w):
			filename = filew.get_filename()
			filew.destroy()
			## call Ghost(filename)
			new_svg_dir = os.path.split(filename)[0]
			g = self.gm.nominate_ghost_txt(filename, new_svg_dir)
			new_ghost_name = g.get_sakura2()

			if not new_ghost_name:
				new_ghost_name = g.get_sakura()
			if not new_ghost_name and not g.get_ghostname():
				open_error_dialog(unicode(_("Can't open file"), 'utf-8'), self.window)
				return -1

			self.ghost_list.append(['GHOST', '%s' % new_ghost_name, '', '"%s"' % os.path.join('Ghost', os.path.split(filename)[-1])])
			self.set_ghost_tree()

			## added new_svg_txt if not same ghost_dir
			if not ghost_dir == new_svg_dir:
				shutil.copyfile(filename, os.path.join(ghost_dir, os.path.split(filename)[-1]))
				if os.path.exists(os.path.join(new_svg_dir, g.get_surfacefile())):
					shutil.copyfile(os.path.join(new_svg_dir, g.get_surfacefile()), \
					         os.path.join(ghost_dir, g.get_surfacefile()))

		filew = gtk.FileSelection()
		filew.set_select_multiple(gtk.FALSE)
		filew.connect("destroy", lambda x: filew.destroy())

		ghost_dir = os.path.join(self.base_dir, 'Ghost')
		if not os.path.exists(ghost_dir):
			os.makedirs(ghost_dir)
		filew.set_filename(os.path.normpath(os.path.join(ghost_dir, '*.txt')))
		filew.ok_button.connect("clicked", file_ok_sel)
		filew.cancel_button.connect("clicked", lambda x: filew.destroy())
		filew.show()

	def check_fmo(self, button):
		try:
			now = self.gn.get_cursor()[0][0]
			if self.ghost_list[now][2] == 'FMO':
				self.delete_fmo(now)
			else:
				self.set_fmo(now)
			self.set_ghost_tree()
			self.gn.set_cursor(now)
			self.gn.grab_focus()
		except:
			open_error_dialog(unicode(_('No selected Ghost!'), 'utf-8'), self.window)

	def check_use(self, button):
		try:
			now = self.gn.get_cursor()[0][0]
			if self.ghost_list[now][0] == 'GHOST':
				self.unuse_ghost(now)
			else:
				self.use_ghost(now)
			self.set_ghost_tree()
			self.gn.set_cursor(now)
			self.gn.grab_focus()
		except:
			open_error_dialog(unicode(_('No selected Ghost!'), 'utf-8'), self.window)

	def delete_ghost(self, button):
		try:
			self.ghost_list.pop(self.gn.get_cursor()[0][0])
		except:
			open_error_dialog(unicode(_('No selected Ghost!'), 'utf-8'), self.window)

		self.set_ghost_tree()

	def reload(self, button):
		self.get_config()
		self.set_ghost_tree()

	def save(self, button):
		self.set_config()
		self.set_ghost_tree()
		self.app.notify_svg_changed()

	def check_use_toggle(self, cellrenderer, path):
		ghost = string.atoi(path)
		try:
			if self.ghost_list[ghost][0] == 'GHOST':
				self.unuse_ghost(ghost)
			else:
				self.use_ghost(ghost)
			self.set_ghost_tree()
		except:
			open_error_dialog(unicode(_('No selected Ghost!'), 'utf-8'), self.window)

	def url_jump(self, button, hpurl):
		try:
			os.system(self.prefs.get('browser') % hpurl + ' &')
		except:
			open_error_dialog(unicode(_('No selected Ghost!'), 'utf-8'), self.window)

## operate the CONFIG_FILE
	def get_config(self, config_file='ghost.txt'):
		self.ghost_list = []
		## read a config_file, make a list, and return the list
		config_file = os.path.join(self.base_dir, config_file)
		try:
			file = open(config_file)
		except IOError:
			print "cannot open ", config_file
			return None

		## read ghost.txt
		flag = False
		while 1:
			#read file and hogehoge
			line = file.readline()
			if not line:
				continue
			if line[:4] == '/EOF':
				break
			if line[:7] == 'INSTALL' or not flag:
				flag = True
				continue

			key = line.strip()
			if not key:
				continue
			key = unicode(key, 'sjis', 'replace')
			key = re.sub(r'\\', r'/', key)
			tmp = key.split(',')
			self.ghost_list.append(tmp)
		file.close()

	def set_config(self, config_file='ghost.txt'):
		## save config, (write to CONFIG_FILE)
		config_file = os.path.join(self.base_dir, config_file)
		try:
			file = open(config_file, "w")
		except IOError:
			print "can't write to file"

		file.write('INSTALL,,,"Ghost\\"\n')
		for ghost in self.ghost_list:
			def_file = ghost[3]
			def_file = re.sub(r'/', r'\\', def_file)
			# write to flie
			tmp = ghost[0] + ',' + ghost[1] + ',' + ghost[2] + ',' + def_file + '\n'
			# change coding to 'sjis'
			tmp = tmp.encode('sjis')
			file.write(tmp)
		file.write('/EOF\n')
		file.close()

	def set_ghost_tree(self):
		self.gn_str.clear()
		if self.ghost_list == None:
			print "cannot open file", ghost_file
		else:
			for ghost in self.ghost_list:
				if ghost[0] == 'GHOST':
					self.gn_str.append([gtk.TRUE, '%s' % ghost[1], '%s' % ghost[2], '%s' % ghost[3]])
				else:
					self.gn_str.append([gtk.FALSE, '%s' % ghost[1], '%s' % ghost[2], '%s' % ghost[3]])

	def use_ghost(self, ghost):
		## delete '#' from  first item '#GHOST'
		self.ghost_list[ghost][0] = 'GHOST'

	def unuse_ghost(self, ghost):
		## insert '#' in first item 'GHOST'
		self.ghost_list[ghost][0] = '#GHOST'

	def set_fmo(self, ghost):
		## insert 'FMO' the third item 
		self.ghost_list[ghost][2] = 'FMO'

	def delete_fmo(self, ghost):
		## delete 'FMO' the third item 'FMO'
		self.ghost_list[ghost][2] = ''

	def set_ghost(self, svg_txt):
		## read 'svg_txt', and make new line 'GHOST,ghostname,,path'
		try:
			file = oepn(svg_txt)
		except IOError:
			print 'can not open file'

		base_dir = os.path.dirname(svg_txt)
		new_ghost = self.gm.nominate_ghost_txt(svg_txt, os.path.join(self.base_dir, 'Ghost'))
		new_ghost_name = new_ghost.get_sakura2()
		if new_ghost_name:
			new_ghost_name = new_ghost.get_sakura()
		tmp = 'GHOST', new_ghost_name, '', svg_txt
		self.ghost_list.append(tmp)

		self.set_ghost_tree()

	def show_svg(self, ghost=None):
		## show 'sakura' and 'unyu' from the svg.png in './Ghost'
		## Do you need this function?
		return 0


if __name__ == "__main__":
	sm = SVGManager()
	gtk.main()
