/***************************************************************/
//
//
//		DirectX	[particle.h]
//
//										Author	kazuki tanaka
//										Date	2016 07/25
/*---------------------------------------------------------------
Update : 2016/07/25
			
/*-------------------------------------------------------------*/
#ifndef _PARTICLE_H_

#define _PARTICLE_H_


#define PARTICLE_MAX (4096)					// qő吔

// p[eBN\
typedef struct{

	D3DXVECTOR2  center;					// qSW
	D3DXVECTOR2  speed;						// qx
	D3DXVECTOR2  ambientPower;				// ɂ镗̉e
	D3DXVECTOR2  velocity;					// qx
	D3DXCOLOR    color;						// qF
	D3DXCOLOR    amountOfChangeInColor;		// qF̕ω
	float        radius;					// qa
	float        amountOfChangeInRadius;	// qa̕ω
	float        arc;						// qopx
	float        radiusValue;				// q̔aω
	int          life;						// q̎
	int          age;						// q݂̑t[
	bool         isUse;						// ݂Ă邩ǂ

}PARTICLE;

// Tu[`
void InitParticle( void );					// p[eBN̏
void UninitParticle( void );				// p[eBN̏I
void UpdateParticle( void );				// p[eBN̍XV
void DrawParticle( void );					// p[eBN̕`

PARTICLE* GetParticle( void );				// p[eBN擾

// p[eBNp[^̎擾
D3DXVECTOR2 GetParticleCenterCoord( const int index );
D3DXVECTOR2 GetParticleSpeed( const int index );
D3DXVECTOR2 GetParticleVelocity( const int index );
D3DXCOLOR GetParticleColor( const int index );
D3DXCOLOR GetParticleChangeColor( const int index );
float GetParticleRadius( const int index );
float GetParticleChangeRadius( const int index );
float GetParticleEmitAngle( const int index );
int GetParticleLife( const int index );

// p[eBNp[^[̐ݒ
void SetParticleCenterCoord( LPD3DXVECTOR2 coord, const int index );
void SetParticleSpeed( LPD3DXVECTOR2 coord, const int index );
void SetParticleVelocity( LPD3DXVECTOR2 speed, const int index );
void SetParticleColor( D3DXCOLOR color, const int index );
void SetParticleChangeColor( D3DXCOLOR color, const int index );
void SetParticleRadius( float radius, const int index );
void SetParticleChangeRadius( float radius, const int index );
void SetParticleEmitAngle( float arc, const int index );
void SetParticleLife( int life, const int index );


// p[eBN̔ˊ֐
void SetParticle( 
	const LPD3DXVECTOR2 center,
	const LPD3DXVECTOR2 speed,
	const LPD3DXVECTOR2 velocity,
	const D3DXCOLOR color,
	const float radius,
	const int referenceAngle,
	const int actualAngle,
	const unsigned int life	);

void SetParticle( 
	const D3DXVECTOR2 center,
	const D3DXVECTOR2 speed,
	const D3DXVECTOR2 velocity,
	const D3DXCOLOR color,
	const float radius,
	const int referenceAngle,
	const int actualAngle,
	const unsigned int life);

void SetParticle( 
	const D3DXVECTOR2 center,
	const D3DXVECTOR2 speed,
	const D3DXVECTOR2 velocity,
	const float radius,
	const int referenceAngle,
	const int actualAngle,
	const unsigned int life);

void SetParticle( const D3DXVECTOR2 center );

void SetParticle(
	const D3DXVECTOR2 center,
	const float radius,
	const D3DXVECTOR2 speed,
	const float length,
	const D3DXCOLOR color,
	unsigned int life);

void SetParticle( 
	const D3DXVECTOR2 center,
	const float radius,
	const D3DXVECTOR2 speed,
	const D3DXVECTOR2 velocity,
	const float length,
	const D3DXCOLOR color,
	unsigned int life);


void SetParticleEx(
	const D3DXVECTOR2 center,
	const D3DXVECTOR2 speed,
	const D3DXVECTOR2 velocity,
	const D3DXCOLOR color,
	const D3DXCOLOR colorValue,
	const float radius,
	const float angle,
	const int life );

void EmitExplosion( 
	D3DXVECTOR2 center,
	const float radius,
	const D3DXVECTOR2 speed,
	const D3DXVECTOR2 velocity,
	const D3DXCOLOR color,
	const D3DXCOLOR colorValue,
	const int life,
	const int scale );



#endif	// _PARTICLE_H_
