program Arena;
	{ This program can hopefully be used as a test for all }
	{ the various GEARHEAD units. I want to make a game similar }
	{ to the old Amiga MechFight game, but based on the }
	{ GearHead engine. }

{
	GearHead: Arena, a roguelike mecha CRPG
	Copyright (C) 2005 Joseph Hewitt

	This library is free software; you can redistribute it and/or modify it
	under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation; either version 2.1 of the License, or (at
	your option) any later version.

	The full text of the LGPL can be found in license.txt.

	This library is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
	General Public License for more details. 

	You should have received a copy of the GNU Lesser General Public License
	along with this library; if not, write to the Free Software Foundation,
	Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
}


{$IFDEF SDLMODE}
  {$IFDEF DEBUG}
  {$ELSE DEBUG}
    {$APPTYPE GUI}
  {$ENDIF}
{$ENDIF}
{$IFDEF GUIMSWINMODE}
  {$IFDEF DEBUG}
  {$ELSE DEBUG}
    {$APPTYPE GUI}
  {$ENDIF DEBUG}
{$ENDIF GUIMSWINMODE}

{$IFDEF PATCH_GH}
uses
  {$IFDEF PATCH_I18N}
	dos,
	version,
  {$ENDIF PATCH_I18N}
  {$IFDEF DEBUG}
	errmsg,
  {$ENDIF DEBUG}
	gears_base,
	gears,
  {$IFDEF PATCH_I18N}
	i18nmsg,
  {$ENDIF PATCH_I18N}
	ui4gh,
  {$IFDEF PATCH_CHEAT}
	menugear,
  {$ENDIF PATCH_CHEAT}
  {$IFDEF SDLMODE}
	sdlgfx,arenahq,sdlmenus,randchar,navigate,sdlmap,
  {$ELSE}
	congfx,arenahq,conmenus,randchar,navigate,context,
  {$ENDIF}
	mapedit;
{$ELSE PATCH_GH}
uses
  {$IFDEF PATCH_I18N}
	dos,
	version,
  {$ENDIF PATCH_I18N}
  {$IFDEF DEBUG}
	errmsg,
  {$ENDIF DEBUG}
	gears,
  {$IFDEF PATCH_I18N}
	i18nmsg,
  {$ENDIF PATCH_I18N}
  {$IFDEF PATCH_CHEAT}
	ui4gh,
	menugear,
  {$ENDIF PATCH_CHEAT}
  {$IFDEF SDLMODE}
	sdlgfx,arenahq,sdlmenus,randchar,navigate,sdlmap
  {$ELSE}
	congfx,arenahq,conmenus,randchar,navigate,context,mapedit
  {$ENDIF}
	;
{$ENDIF PATCH_GH}

{$IFDEF PATCH_I18N}
{$ELSE PATCH_I18N}
const
	Version = '1.100-github';
{$ENDIF PATCH_I18N}

var
	RPM: RPGMenuPtr;
	N: Integer;
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: arena.pas(begin)');
{$ENDIF DEBUG}

	RPM := CreateRPGMenu( MenuItem , MenuSelect , ZONE_Menu );
{$IFDEF PATCH_I18N}
	AddRPGMenuItem( RPM , I18N_MsgString( 'arena.pas', 'Start RPG Campaign' ) , 4 );
	AddRPGMenuItem( RPM , I18N_MsgString( 'arena.pas', 'Load RPG Campaign' ) , 5 );
  {$IFDEF PATCH_GH}
	if Enable_ArenaMode then begin
		AddRPGMenuItem( RPM , I18N_MsgString( 'arena.pas', 'New Arena Unit' ) , 1 );
		AddRPGMenuItem( RPM , I18N_MsgString( 'arena.pas', 'Load Arena Unit' ) , 2 );
	end;
  {$ELSE PATCH_GH}
    {$IFNDEF SDLMODE}
	AddRPGMenuItem( RPM , I18N_MsgString( 'arena.pas', 'New Arena Unit' ) , 1 );
	AddRPGMenuItem( RPM , I18N_MsgString( 'arena.pas', 'Load Arena Unit' ) , 2 );
    {$ENDIF SDLMODE}
  {$ENDIF PATCH_GH}
	AddRPGMenuItem( RPM , I18N_MsgString( 'arena.pas', 'Create Character' ) , 3 );
  {$IFDEF PATCH_GH}
	if Enable_EditMap then begin
		AddRPGMenuItem( RPM , I18N_MsgString( 'arena.pas', 'Edit Map' ) , 6 );
	end;
  {$ELSE PATCH_GH}
    {$IFNDEF SDLMODE}
	AddRPGMenuItem( RPM , I18N_MsgString( 'arena.pas', 'Edit Map' ) , 6 );
    {$ENDIF SDLMODE}
  {$ENDIF PATCH_GH}
	AddRPGMenuItem( RPM , I18N_MsgString( 'arena.pas', 'View Design Files' ) , 7 );
	AddRPGMenuItem( RPM , '(v' + Version_org + ')' , 8 );
	AddRPGMenuItem( RPM , '(BIN:' + Version_I18N + ')' , 8 );
	AddRPGMenuItem( RPM , '(MSG: ' + Version_txt + ')' , 8 );
	AddRPGMenuItem( RPM , I18N_MsgString( 'arena.pas', 'Quit Game' ) , -1 );
{$ELSE PATCH_I18N}
	AddRPGMenuItem( RPM , 'Start RPG Campaign' , 4 );
	AddRPGMenuItem( RPM , 'Load RPG Campaign' , 5 );
  {$IFNDEF SDLMODE}
	AddRPGMenuItem( RPM , 'New Arena Unit' , 1 );
	AddRPGMenuItem( RPM , 'Load Arena Unit' , 2 );
  {$ENDIF SDLMODE}
	AddRPGMenuItem( RPM , 'Create Character' , 3 );
  {$IFNDEF SDLMODE}
	AddRPGMenuItem( RPM , 'Edit Map' , 6 );
  {$ENDIF SDLMODE}
	AddRPGMenuItem( RPM , 'View Design Files' , 7 );
	AddRPGMenuItem( RPM , 'Quit Game' , -1 );
{$ENDIF PATCH_I18N}
{$IFDEF PATCH_CHEAT}
	if Cheat_MainMenu_AddMenuKey then begin
		AlphaKeyMenu( RPM );
	end;
{$ENDIF PATCH_CHEAT}

	repeat
{$IFDEF DEBUG}
		ErrorMessage_fork( 'DEBUG_MESSAGE: Main Loop' );
  {$IFDEF PATCH_I18N}
		ErrorMessage_fork( rcsid );
		ErrorMessage_fork( '(MSG: ' + Version_txt + ')' );
  {$ELSE PATCH_I18N}
		ErrorMessage_fork( 'GearHead Arena v' + Version );
  {$ENDIF PATCH_I18N}
{$ENDIF DEBUG}
		ClrScreen;

		{ Get rid of the console history from previous games. }
		DisposeSAtt( Console_History );

{$IFDEF PATCH_I18N}
		CMessage( 'GearHead Arena v' + Version_org + ' BIN:' + Version_I18N + ', MSG: ' + Version_txt, ZONE_Map, InfoHilight );
{$ELSE PATCH_I18N}
		CMessage( 'GearHead Arena v' + Version, ZONE_Map, InfoHilight );
{$ENDIF PATCH_I18N}
		if not STARTUP_OK then DialogMsg( 'ERROR: Main game directories not found. Please check installation of the game.' );
{$IFDEF SDLMODE}
		PrepOpening;
		N := SelectMenu( RPM , @RedrawOpening );
{$ELSE}
		N := SelectMenu( RPM );
{$ENDIF}

		case N of
			1:	CreateNewUnit;
			2:	LoadUnit;
			3:	GenerateNewPC;
			4:	StartRPGCampaign;
			5:	RestoreCampaign;
{$IFDEF PATCH_GH}
			6:	EditMap;
{$ELSE PATCH_GH}
  {$IFNDEF SDLMODE}
			6:	EditMap;
  {$ENDIF}
{$ENDIF PATCH_GH}
			7:	DesignDirBrowser;
		end;
	until N = -1;

{$IFDEF DEBUG}
	ErrorMessage_fork( 'DEBUG_MESSAGE: Main Loop fin' );
{$ENDIF DEBUG}
	{deallocate all dynamic resources.}
	DisposeRPGMenu( RPM );

{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: arena.pas(end)');
{$ENDIF DEBUG}
end.
