unit ArenaHQ;

{
	GearHead: Arena, a roguelike mecha CRPG
	Copyright (C) 2005 Joseph Hewitt

	This library is free software; you can redistribute it and/or modify it
	under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation; either version 2.1 of the License, or (at
	your option) any later version.

	The full text of the LGPL can be found in license.txt.

	This library is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
	General Public License for more details. 

	You should have received a copy of the GNU Lesser General Public License
	along with this library; if not, write to the Free Software Foundation,
	Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
}

interface

const
	NAV_StartingCash = 250000;	{ This is how much money a unit starts with. }


Procedure CreateNewUnit;
Procedure LoadUnit;
Procedure StartRPGCampaign;

Procedure DesignDirBrowser;

implementation

uses
{$IFDEF DEBUG}
	errmsg,
{$ENDIF DEBUG}
{$IFDEF PATCH_I18N}
	i18nmsg,
	version,
{$ENDIF PATCH_I18N}
{$IFDEF PATCH_GH}
	gears_base,
	gears,
	ui4gh,
	ability,arenaplay,damage,gearutil,ghchars,ghparser,
	locale,navigate,pcaction,randchar,randmaps,texutil,wmonster,
  {$IFDEF PATCH_CHEAT}
	menugear,
  {$ENDIF PATCH_CHEAT}
  {$IFDEF SDLMODE}
	sdlinfo,sdlgfx,sdlmap,sdlmenus
  {$ELSE SDLMODE}
	coninfo,congfx,conmap,conmenus,context
  {$ENDIF SDLMODE}
{$ELSE PATCH_GH}
	ability,arenaplay,damage,gears,gearutil,ghchars,ghparser,
	locale,navigate,pcaction,randchar,randmaps,texutil,wmonster,
  {$IFDEF PATCH_CHEAT}
	menugear,
  {$ENDIF PATCH_CHEAT}
  {$IFDEF SDLMODE}
	sdlinfo,sdlgfx,sdlmap,sdlmenus,
  {$ELSE}
	coninfo,congfx,conmap,conmenus,context,
  {$ENDIF}
	ui4gh
{$ENDIF PATCH_GH}
{$IFDEF PATCH_CHEAT}
	,backpack,ghweapon
{$ENDIF PATCH_CHEAT}
	;


{$IFDEF SDLMODE}
  {$IFDEF PATCH_GH}
var
	InfoGear: GearPtr;	{ Gear to appear in the INFO menu. }
	InfoMekMenu: RPGMenuPtr;


Procedure FHQRedraw;
var
	Mek: GearPtr;
	MekNum: LongInt;
begin
	Mek := NIL;
	if (NIL <> InfoMekMenu) then begin
		MekNum := RPMLocateByPosition(InfoMekMenu,InfoMekMenu^.selectitem)^.value;
		if (0 <= MekNum) then begin
			Mek := RetrieveGearSib( InfoGear, MekNum );
		end;
	end else if (NIL <> InfoGear) then begin
		Mek := InfoGear;
	end;
	if (NIL <> Mek) and (GG_DisposeGear < Mek^.G) then begin
		DisplayGearInfo( Mek );
	end;
end;
  {$ENDIF PATCH_GH}
{$ENDIF SDLMODE}


{$IFDEF PATCH_CHEAT}
Procedure DetachMekChar( U: GearPtr; var MList: GearPtr );
var
	Mek: GearPtr;
begin
	while NIL <> MList do begin
		Mek := MList;
		DelinkGear( MList, Mek );
		if Mek^.G = GG_Character then begin
			InsertSubCom( U, Mek );
		end else begin
			InsertInvCom( U, Mek );
		end;
	end;
end;
{$ENDIF PATCH_CHEAT}


Procedure SaveUnit( U: GearPtr );
	{ Save this unit to disk, in the "SaveGame" directory. }
var
	FName: String;		{ Filename for the character. }
	F: Text;		{ The file to write to. }
begin
{$IFDEF PATCH_GH}
	if (NIL = U) or (U^.G <= GG_DisposeGear) then Exit;
{$ENDIF PATCH_GH}
{$IFDEF PATCH_I18N}
	{ Output DEBUG info. }
	SetSAtt( U^.SA , Version_Running_TAG + ' <' + Version_all + '>' );
{$ENDIF PATCH_I18N}

{$IFDEF PATCH_I18N}
	FName := Save_Unit_Base + TextEncode(GearName(U) + Default_File_Ending);
{$ELSE PATCH_I18N}
	FName := Save_Unit_Base + GearName(U) + Default_File_Ending;
{$ENDIF PATCH_I18N}
	Assign( F , FName );
	Rewrite( F );
	WriteCGears( F , U );
	Close( F );
end;

Function FindMechasPilot( U , Mek: GearPtr ): GearPtr;
	{ Search unit U to locate whatever pilot is assigned to mecha Mek. }
	{ If no such pilot is found, clear Mek's PILOT attribute and }
	{ return Nil. }
var
	pc,mpc: GearPtr;
	name: String;
begin
{$IFDEF PATCH_GH}
	if (NIL = U) or (U^.G <= GG_DisposeGear) then Exit(NIL);
	if (NIL = Mek) or (Mek^.G <= GG_DisposeGear) then Exit(NIL);
{$ENDIF PATCH_GH}

	{ Begin by finding the pilot's name. }
	name := SAttValue( Mek^.SA , 'pilot' );

	{ Search through the unit's Sub looking for a character of }
	{ this name. }
	pc := U^.SubCom;
	mpc := Nil;
	while ( pc <> Nil ) and ( mpc = Nil ) do begin
		if pc^.G = GG_Character then begin
			if GearName( PC ) = name then mpc := pc;
		end;
		pc := pc^.Next;
	end;

	{ If the required pilot could not be found, }
	{ delete this mecha's PILOT attribute. }
	if mpc = Nil then begin
		SetSAtt( Mek^.SA , 'pilot <>' );
	end;

	FindMechasPilot := mpc;
end;

Function CreateHQPilotMenu( U: GearPtr ): RPGMenuPtr;
	{ Allocate and fill out a menu containing all the pilots }
	{ which belong to this unit. }
var
	RPM: RPGMenuPtr;
	P: GearPtr;
	N: Integer;
	msg: String;
begin
	RPM := CreateRPGMenu( MenuItem , MenuSelect , ZONE_HQPilots );

{$IFDEF PATCH_GH}
	if (NIL = U) or (U^.G <= GG_DisposeGear) then Exit(RPM);
{$ENDIF PATCH_GH}

	{ Add an entry for each pilot. }
	P := U^.SubCom;
	N := 1;
	while P <> Nil do begin
{$IFDEF PATCH_GH}
		if (GG_DisposeGear < P^.G) then begin
{$ENDIF PATCH_GH}
		msg := GearName( P );
		if FindPilotsMecha( U^.InvCom , P ) <> Nil then msg := msg + ' +';
		AddRPGMenuItem( RPM , msg , N );
		Inc( N );
{$IFDEF PATCH_GH}
		end;
{$ENDIF PATCH_GH}
		P := P^.Next;
	end;
{$IFDEF PATCH_CHEAT}
	if Cheat_MenuOrder_Edit then begin
		AddRPGMenuKey( RPM, KeyMap[ KMC_EditMenuOrder ].KCode, -128 );
	end;
	if Cheat_ArenaMode_PilotsMenu_AddMenuKey then begin
		AlphaKeyMenu( RPM );
	end;
{$ENDIF PATCH_CHEAT}

	{ Return the finished menu. }
	CreateHQPilotMenu := RPM;
end;

Function CreateHQMechaMenu( U: GearPtr ): RPGMenuPtr;
	{ Allocate and fill out a menu containing all the pilots }
	{ which belong to this unit. }
var
	RPM: RPGMenuPtr;
	P,Pilot: GearPtr;
	N: Integer;
	msg: String;
begin
	RPM := CreateRPGMenu( MenuItem , MenuSelect , ZONE_HQMecha );

{$IFDEF PATCH_GH}
	if (NIL = U) or (U^.G <= GG_DisposeGear) then Exit(RPM);
{$ENDIF PATCH_GH}

	{ Add an entry for each mek. }
	P := U^.InvCom;
	N := 1;
	while P <> Nil do begin
{$IFDEF PATCH_GH}
		if (GG_DisposeGear < P^.G) then begin
{$ENDIF PATCH_GH}
		{ Only add mechas to the menu - not items or salvage. }
		if P^.G = GG_Mecha then begin
			msg := GearName( P );
			Pilot := FindMechasPilot( U , P );
			if Pilot <> Nil then msg := msg + ' (' + GearName( Pilot ) + ')';
			AddRPGMenuItem( RPM , msg , N );
{$IFDEF DEBUG}
		end else begin
			msg := 'JUNK: ' + GearName( P );
			AddRPGMenuItem( RPM, msg, -1 );
{$ENDIF DEBUG}
		end;
		Inc( N );
{$IFDEF PATCH_GH}
		end;
{$ENDIF PATCH_GH}
		P := P^.Next;
	end;

{$IFDEF PATCH_CHEAT}
	if Cheat_MenuOrder_Edit then begin
		AddRPGMenuKey( RPM, KeyMap[ KMC_EditMenuOrder ].KCode, -128 );
	end;
	if Cheat_ArenaMode_MechaMenu_AddMenuKey then begin
		AlphaKeyMenu( RPM );
	end;
{$ENDIF PATCH_CHEAT}

	{ Return the finished menu. }
	CreateHQMechaMenu := RPM;
end;

Procedure UpdateHQDisplay( U: GearPtr );
	{ Redraw the pilot and mecha lists. }
var
	DSM: RPGMenuPtr;	{ Display Menu }
begin
	DSM := CreateHQPilotMenu( U );
{$IFDEF SDLMODE}
	if DSM^.NumItem > 0 then DisplayMenu( DSM , Nil )
{$ELSE}
	if DSM^.NumItem > 0 then DisplayMenu( DSM )
{$ENDIF}
	else ClrZone(ZONE_HQPilots);
	DisposeRPGMenu( DSM );

	DSM := CreateHQMechaMenu( U );
{$IFDEF SDLMODE}
	if DSM^.NumItem > 0 then DisplayMenu( DSM , Nil )
{$ELSE}
	if DSM^.NumItem > 0 then DisplayMenu( DSM )
{$ENDIF}
	else ClrZone(ZONE_HQMecha);
	DisposeRPGMenu( DSM );

	{ Display how many credits the unit has. }
	ClrZone( ZONE_Clock );
	CMessage( '$' + BStr( NAttValue( U^.NA , NAG_Experience , NAS_Credits ) ) , ZONE_Clock , PlayerBlue );

{$IFDEF PATCH_GH}
	ClrZone( ZONE_Menu );
{$ENDIF PATCH_GH}
end;

{$IFDEF PATCH_GH}
Procedure RedrawHQDisplay( U: GearPtr );
begin
	SetupHQDisplay;
	UpdateHQDisplay( U );
end;
{$ENDIF PATCH_GH}

procedure PurchaseGear( U,Part: GearPtr );
	{ The unit may or may not want to buy PART. }
	{ Show the price of this gear, and ask whether or not the }
	{ player wants to make this purchase. }
var
	YNMenu: RPGMenuPtr;
	Cost, ShopRk: LongInt;
begin
{$IFDEF PATCH_GH}
	if (NIL = U) or (U^.G <= GG_DisposeGear) then Exit;
	if (NIL = Part) or (Part^.G <= GG_DisposeGear) then Exit;
{$ENDIF PATCH_GH}

	Cost := GearValue( Part );
	ShopRk := SkillValue( U , 21 );

	if ShopRk > 10 then begin
		{ Every point of shopping skill that the unit has over 10 }
		{ gives a 2% discount to whatever is being purchased. }
		ShopRk := ( ShopRk - 10 ) * 2;
		if ShopRk > 40 then ShopRk := 40;

{$IFDEF PATCH_GH}
		Cost := ( Int64(Cost) * Int64(100 - ShopRk) ) div 100;
{$ELSE PATCH_GH}
		Cost := ( Cost * (100 - ShopRk ) ) div 100;
{$ENDIF PATCH_GH}
	end;
	if Cost < 1 then Cost := 1;

	YNMenu := CreateRPGMenu( MenuItem , MenuSelect , ZONE_Menu2 );
{$IFDEF PATCH_I18N}
	AddRPGMenuItem( YNMenu , ReplaceHash(I18N_MsgString('PURCHASEGEAR_BUY'), GearName(Part), BStr(Cost) ) , 1 );
	AddRPGMenuItem( YNMenu , I18N_MsgString('PurchaseGear','Search Again') , -1 );
{$ELSE PATCH_I18N}
	AddRPGMenuItem( YNMenu , 'Buy ' + GearName( Part ) + ' ($' + BStr( Cost ) + ')' , 1 );
	AddRPGMenuItem( YNMenu , 'Search Again' , -1 );
{$ENDIF PATCH_I18N}
	CMessage( 'COST: ' + BStr( Cost ) , ZONE_Menu1 , InfoHilight );

{$IFDEF SDLMODE}
	if SelectMenu( YNMenu , Nil ) = 1 then begin
{$ELSE}
	if SelectMenu( YNMenu ) = 1 then begin
{$ENDIF}
		if NAttValue( U^.NA , NAG_Experience , NAS_Credits ) >= Cost then begin
			{ Copy the gear, then stick it in inventory. }
			Part := CloneGear( Part );
			InsertInvCom( U , Part );

			{ Reduce the buyer's cash by the cost of the gear. }
			AddNAtt( U^.NA , NAG_Experience , NAS_Credits , -Cost );

			{ Update the display. }
			UpdateHQDisplay( U );

{$IFDEF PATCH_I18N}
			DialogMSG( ReplaceHash(I18N_MsgString('PurchaseGear','Purchased'),GearName(Part)) );
{$ELSE PATCH_I18N}
			DialogMSG( 'You have purchased ' + GearName( Part ) + '.' );
{$ENDIF PATCH_I18N}
		end else begin
			{ Not enough cash to buy... }
{$IFDEF PATCH_I18N}
			DialogMSG( ReplaceHash(I18N_MsgString('PurchaseGear','Donot Purchased'),GearName(Part)) );
{$ELSE PATCH_I18N}
			DialogMSG( 'You don''t have enough money to buy ' + GearName( Part ) + '.' );
{$ENDIF PATCH_I18N}
		end;

	end;

	DisposeRPGMenu( YNMenu );
end;

procedure SellGear( U,Part: GearPtr );
	{ The unit may or may not want to sell PART. }
	{ Shothe price of this gear, and ask whether or not the }
	{ player wants to make this purchase. }
var
	YNMenu: RPGMenuPtr;
	Cost, ShopRk: LongInt;
begin
{$IFDEF PATCH_GH}
	if (NIL = U) or (U^.G <= GG_DisposeGear) then Exit;
	if (NIL = Part) or (Part^.G <= GG_DisposeGear) then Exit;
{$ENDIF PATCH_GH}

{$IFDEF PATCH_GH}
	Cost := ( Int64(GearValue(Part)) * Int64(PercentDamaged(Part)) ) div 100;
{$ELSE PATCH_GH}
	Cost := ( GearValue( Part ) * PercentDamaged( Part ) ) div 100;
{$ENDIF PATCH_GH}
	if Destroyed( Part ) then Cost := Cost div 3;
	ShopRk := SkillValue( U , 21 );

	if ShopRk > 10 then begin
		{ Every point of shopping skill that the unit has }
		{ gives a 1% bonus to the money gained. }
		if ShopRk > 40 then ShopRk := 40;

{$IFDEF PATCH_GH}
		Cost := ( Int64(Cost) * Int64(20 + ShopRk) ) div 100;
{$ELSE PATCH_GH}
		Cost := ( Cost * (20 + ShopRk ) ) div 100;
{$ENDIF PATCH_GH}
	end;
	if Cost < 1 then Cost := 1;

	YNMenu := CreateRPGMenu( MenuItem , MenuSelect , ZONE_Menu2 );
{$IFDEF PATCH_I18N}
	AddRPGMenuItem( YNMenu , ReplaceHash(I18N_MsgString('SellGear','Sell'),GearName(Part),BStr(Cost)) , 1 );
	AddRPGMenuItem( YNMenu , I18N_MsgString('PurchaseGear','Search Again') , -1 );
{$ELSE PATCH_I18N}
	AddRPGMenuItem( YNMenu , 'Sell ' + GearName( Part ) + ' ($' + BStr( Cost ) + ')' , 1 );
	AddRPGMenuItem( YNMenu , 'Search Again' , -1 );
{$ENDIF PATCH_I18N}
	CMessage( 'VALUE: ' + BStr( Cost ) , ZONE_Menu1 , InfoHilight );

{$IFDEF SDLMODE}
	if SelectMenu( YNMenu , Nil ) = 1 then begin
{$ELSE}
	if SelectMenu( YNMenu ) = 1 then begin
{$ENDIF}
		{ Increase the buyer's cash by the price of the gear. }
		AddNAtt( U^.NA , NAG_Experience , NAS_Credits , Cost );

		{ Update the display. }
		UpdateHQDisplay( U );

{$IFDEF PATCH_I18N}
		DialogMSG( ReplaceHash(I18N_MsgString('SellGear','Sold'),GearName(Part),BStr(Cost)) );
{$ELSE PATCH_I18N}
		DialogMSG( 'You have sold ' + GearName( Part ) + ' for $' + BStr( Cost ) + '.' );
{$ENDIF PATCH_I18N}

		RemoveGear( Part^.Parent^.InvCom , Part );
	end;

	DisposeRPGMenu( YNMenu );
end;

Function RecurseFix( U,Part: GearPtr ): Integer;
	{ Recurse through the bits of the PART, looking for broken }
	{ things. }
var
	SPart: GearPtr;
	Roll,LowRoll: Integer;
begin
{$IFDEF PATCH_GH}
	if (NIL = U) or (U^.G <= GG_DisposeGear) then Exit(32766);
	if (NIL = Part) or (Part^.G <= GG_DisposeGear) then Exit(32766);
{$ENDIF PATCH_GH}

	LowRoll := PitFix( Part , U );

	SPart := Part^.SubCom;
	while SPart <> Nil do begin
		Roll := RecurseFix( U , SPart );
		if Roll < LowRoll then LowRoll := Roll;
		SPart := SPart^.Next;
	end;

	SPart := Part^.InvCom;
	while SPart <> Nil do begin
		Roll := RecurseFix( U , SPart );
		if Roll < LowRoll then LowRoll := Roll;
		SPart := SPart^.Next;
	end;

	RecurseFix := LowRoll;
end;

Procedure FixEntireUnit( U: GearPtr );
	{ Attempt to repair everything in the unit. }
var
	Part: GearPtr;
	C0,C1: LongInt;		{ Cash at start. }
	R,LowRoll: Integer;	{ The worst repair result generated. }
begin
{$IFDEF PATCH_GH}
	if (NIL = U) or (U^.G <= GG_DisposeGear) then Exit;
{$ENDIF PATCH_GH}

	C0 := NAttValue( U^.NA , NAG_Experience , NAS_Credits );
	LowRoll := 10;

	{ Administer medical treatment to all characters. }
	Part := U^.SubCom;
	while Part <> Nil do begin
{$IFDEF PATCH_GH}
		if (GG_DisposeGear < Part^.G) then begin
{$ENDIF PATCH_GH}
		R := RecurseFix( U , Part );
		if R < LowRoll then LowRoll := R;
{$IFDEF PATCH_GH}
		end;
{$ENDIF PATCH_GH}
		Part := Part^.Next;
	end;

	{ Administer repair to all assigned mecha. }
	Part := U^.InvCom;
	while Part <> Nil do begin
{$IFDEF PATCH_GH}
		if (GG_DisposeGear < Part^.G) then begin
{$ENDIF PATCH_GH}
		if ( Part^.G = GG_Mecha ) and ( FindMechasPilot( U , Part ) <> Nil ) then begin
			R := RecurseFix( U , Part );
			if R < LowRoll then LowRoll := R;
		end;
{$IFDEF PATCH_GH}
		end;
{$ENDIF PATCH_GH}
		Part := Part^.Next;
	end;

	C1 := NAttValue( U^.NA , NAG_Experience , NAS_Credits );
	if C1 < C0 then begin
{$IFDEF PATCH_I18N}
		DialogMSG( ReplaceHash(I18N_MsgString('FixEntireUnit','Recovery'),BStr( C0 - C1 )) );
{$ELSE PATCH_I18N}
		DialogMSG( 'Recovery from the combat cost $' + BStr( C0 - C1 ) + '.' );
{$ENDIF PATCH_I18N}
	end;
	if LowRoll < 1 then begin
{$IFDEF PATCH_I18N}
		DialogMSG( I18N_MsgString('FixEntireUnit','Some Problems') );
{$ELSE PATCH_I18N}
		DialogMSG( 'There have been some problems...' );
{$ENDIF PATCH_I18N}
	end;
end;

Procedure FixSingleGear( U,Mek: GearPtr );
	{ Attempt to repair everything in the unit. }
var
	C0,C1: LongInt;		{ Cash at start. }
	Roll: Integer;
begin
{$IFDEF PATCH_GH}
	if (NIL = U) or (U^.G <= GG_DisposeGear) then Exit;
	if (NIL = Mek) or (Mek^.G <= GG_DisposeGear) then Exit;
{$ENDIF PATCH_GH}

	C0 := NAttValue( U^.NA , NAG_Experience , NAS_Credits );

	Roll := RecurseFix( U , Mek );

	DisplayGearInfo( Mek );

	C1 := NAttValue( U^.NA , NAG_Experience , NAS_Credits );
	if C1 < C0 then begin
{$IFDEF PATCH_I18N}
		DialogMSG( ReplaceHash(I18N_MsgString('FixSingleGear','Restoring'),GearName(Mek),BStr( C0 - C1 )) );
{$ELSE PATCH_I18N}
		DialogMSG( 'Restoring ' + GearName( Mek ) + ' cost $' + BStr( C0 - C1 ) + '.' );
{$ENDIF PATCH_I18N}
	end;
	if Roll < 1 then begin
{$IFDEF PATCH_I18N}
		DialogMSG( I18N_MsgString('FixSingleGear','Some Problems') );
{$ELSE PATCH_I18N}
		DialogMSG( 'There have been some problems...' );
{$ENDIF PATCH_I18N}
	end;
end;

procedure AddPilotToUnit( U: GearPtr );
	{ Browse the disk for a character file. If one is selected, }
	{ display the character's stats and ask whether or not to hire }
	{ this character. If hired, add the character to the unit, }
	{ save the game, then delete the character's individual file. }
var
	PC,Temp: GearPtr;
	PCMenu,YNMenu: RPGMenuPtr;
	F: Text;
	FName: String;
begin
{$IFDEF PATCH_GH}
	if (NIL = U) or (U^.G <= GG_DisposeGear) then Exit;
{$ENDIF PATCH_GH}

	{ Create the YNMenu here. It'll be the same throughout the }
	{ hiring process. }
	YNMenu := CreateRPGMenu( MenuItem , MenuSelect , ZONE_Menu );
{$IFDEF PATCH_I18N}
	AddRPGMenuItem( YNMenu , I18N_MsgString('AddPilotToUnit','Hire Character') , 1 );
	AddRPGMenuItem( YNMenu , I18N_MsgString('AddPilotToUnit','Search Again') , -1 );

	DialogMSG( I18N_MsgString('AddPilotToUnit','Select Character'));
{$ELSE PATCH_I18N}
	AddRPGMenuItem( YNMenu , 'Hire Character' , 1 );
	AddRPGMenuItem( YNMenu , 'Search Again' , -1 );

	DialogMSG('Select character file.');
{$ENDIF PATCH_I18N}

	{ Keep querying for characters until cancel is selected. }
	repeat
		{ Create the PC menu. }
		PCMenu := CreateRPGMenu( MenuItem , MenuSelect , ZONE_Menu );
		BuildFileMenu( PCMenu , Save_Character_Base + Default_Search_Pattern );
		RPMSortAlpha( PCMenu );
{$IFDEF PATCH_I18N}
		AddRPGMenuItem( PCMenu , I18N_MsgString('AddPilotToUnit','Exit') , -1 );
{$ELSE PATCH_I18N}
		AddRPGMenuItem( PCMenu , '  Exit' , -1 );
{$ENDIF PATCH_I18N}

		{ Select a file, then dispose of the menu. }
		{ Don't need to worry about the menu being empty because }
		{ of the EXIT item. }
{$IFDEF SDLMODE}
		FName := SelectFile( PCMenu , Nil );
{$ELSE}
		FName := SelectFile( PCMenu );
{$ENDIF}
		DisposeRPGMenu( PCMenu );

		{ If a file was selected, load it and see if the player }
		{ wants to keep it. }
		if FName <> '' then begin
			{ Load the character file. }
{$IFDEF PATCH_I18N}
			Assign( F , Save_Game_Directory + TextEncode(FName) );
{$ELSE PATCH_I18N}
			Assign( F , Save_Game_Directory + FName );
{$ENDIF PATCH_I18N}
			reset(F);
			PC := ReadCGears(F);
			Close(F);

			{ ERROR CHECK - make sure the file that was loaded }
			{ is in fact a valid, singular character. }
{$IFDEF PATCH_GH}
			if (NIL <> PC) and (GG_DisposeGear < PC^.G) then begin
{$ELSE PATCH_GH}
			if ( PC <> Nil ) then begin
{$ENDIF PATCH_GH}

				{ Display the character's stats. }
				DisplayGearInfo( PC );

				{ Ask the player what to do with this character. }
{$IFDEF SDLMODE}
				if SelectMenu( YNMenu , Nil ) = 1 then begin
{$ELSE}
				if SelectMenu( YNMenu ) = 1 then begin
{$ENDIF}
					{ Add the character to the unit. }
					while PC <> Nil do begin
						Temp := PC;
						DelinkGear( PC , Temp );

						if Temp^.G = GG_Character then begin
							InsertSubCom( U , Temp );
						end else begin
							InsertInvCom( U , Temp );
						end;
					end;

					{ Saving the game is done before deleting }
					{ the character file so that if there's a }
					{ problem in saving, at least the original }
					{ character file will be intact. }
					SaveUnit( U );
{$IFDEF PATCH_I18N}
					Assign( F , Save_Game_Directory + TextEncode(FName) );
{$ELSE PATCH_I18N}
					Assign( F , Save_Game_Directory + FName );
{$ENDIF PATCH_I18N}
					Erase(F);

					UpdateHQDisplay( U );
				end else begin
					{ Just get rid of the character. }
					DisposeGear( PC );
				end;
				ClrZone( ZONE_Info );

			end else begin
				{ PC isn't a valid character. Get rid of it. }
{$IFDEF PATCH_I18N}
				DialogMSG( I18N_MsgString('AddPilotToUnit','Corrupt File') );
{$ELSE PATCH_I18N}
				DialogMSG( 'ERROR - Corrupt save file.' );
{$ENDIF PATCH_I18N}
				DisposeGear( PC );
			end;
		end;
	until FName = '';

	{ Get rid of the Yes/No menu. }
	DisposeRPGMenu( YNMenu );
end;

Function SelectOneGear( List: GearPtr ): GearPtr;
	{ Choose one of the sibling gears from LIST. }
var
	BrowseMenu: RPGMenuPtr;
	Part: GearPtr;
{$IFDEF PATCH_GH}
	N: LongInt;
{$ELSE PATCH_GH}
	N: Integer;
{$ENDIF PATCH_GH}
	msg: String;
begin
{$IFDEF PATCH_GH}
	ClrZone( ZONE_Menu );
{$ENDIF PATCH_GH}

	{ Create the menu. }
	BrowseMenu := CreateRPGMenu( MenuItem , MenuSelect , ZONE_Menu );

	{ Add each of the gears to the menu. }
	Part := List;
	N := 1;
	while Part <> Nil do begin
{$IFDEF PATCH_GH}
		if (GG_DisposeGear < Part^.G) then begin
{$ENDIF PATCH_GH}
		msg := SAttValue( Part^.SA , 'desig' );
		if msg <> '' then msg := msg + ' ' + GearName( Part )
		else msg := GearName( Part );
		AddRPGMenuItem( BrowseMenu , msg , N );
		Inc( N );
{$IFDEF PATCH_GH}
		end;
{$ENDIF PATCH_GH}
		Part := Part^.Next;
	end;
	RPMSortAlpha( BrowseMenu );
{$IFDEF PATCH_I18N}
	AddRPGMenuItem( BrowseMenu , I18N_MsgString('SelectOneGear','Cancel') , -1 );
{$ELSE PATCH_I18N}
	AddRPGMenuItem( BrowseMenu , '  Cancel' , -1 );
{$ENDIF PATCH_I18N}

	{ Select a gear. }
{$IFDEF SDLMODE}
	N := SelectMenu( BrowseMenu, Nil );
{$ELSE}
	N := SelectMenu( BrowseMenu );
{$ENDIF}
	DisposeRPGMenu( BrowseMenu );
	SelectOneGear := RetrieveGearSib( List , N );
end;

procedure BuyMechsForUnit( U: GearPtr );
	{ Create a list of mecha which are within this unit's price }
	{ range, then allow the user to browse the list and maybe }
	{ purchase some. }
var
	MekMenu: RPGMenuPtr;
	fname: String;
	m1,mek: GearPtr;	{ The start of the mecha file, }
			{ and the mek being considered for purchase. }
	F: Text;
begin
{$IFDEF PATCH_GH}
	if (NIL = U) or (U^.G <= GG_DisposeGear) then Exit;
{$ENDIF PATCH_GH}

	{ Create the mecha menu. }
	MekMenu := CreateRPGMenu( MenuItem , MenuSelect , ZONE_Menu );
	BuildFileMenu( MekMenu , Design_Directory + Default_Search_Pattern );
	RPMSortAlpha( MekMenu );
{$IFDEF PATCH_I18N}
	AddRPGMenuItem( MekMenu , I18N_MsgString('BuyMechsForUnit','Exit') , -1 );
{$ELSE PATCH_I18N}
	AddRPGMenuItem( MekMenu , '  Exit' , -1 );
{$ENDIF PATCH_I18N}

{$IFDEF PATCH_I18N}
	DialogMSG( I18N_MsgString('BuyMechsForUnit','Select Design') );
{$ELSE PATCH_I18N}
	DialogMSG( 'Select design file.' );
{$ENDIF PATCH_I18N}

	repeat
{$IFDEF PATCH_GH}
		ClrZone( ZONE_Menu );
{$ENDIF PATCH_GH}
		{ Prompt the user for a file selection. }
{$IFDEF SDLMODE}
		fname := SelectFile( MekMenu , Nil );
{$ELSE}
		fname := SelectFile( MekMenu );
{$ENDIF}

		if fname <> '' then begin
			{ Load this design file, then allow the player }
			{ to select any of the gears it contains. }
			Assign(F, Design_Directory + fname );
			reset(F);
{$IFDEF PATCH_GH}
			m1 := ReadGear(F, Design_Directory + fname);
{$ELSE PATCH_GH}
			m1 := ReadGear(F);
{$ENDIF PATCH_GH}
			Close(F);

			{ Error check- make sure something was actually loaded. }
{$IFDEF PATCH_GH}
			if (NIL <> m1) and (GG_DisposeGear < m1^.G) then begin
{$ELSE PATCH_GH}
			if ( m1 <> Nil ) then begin
{$ENDIF PATCH_GH}

				{ If there were multiple designs in this file, }
				{ allow the player to browse through them. }
				{ If there was only one design, leap straight to it. }
				if M1^.Next = Nil then Mek := M1
				else Mek := SelectOneGear( M1 );

				{ Check to make sure that Mek isn't Nil. }
{$IFDEF PATCH_GH}
				if (NIL <> Mek) and (GG_DisposeGear < Mek^.G) then begin
{$ELSE PATCH_GH}
				if Mek <> Nil then begin
{$ENDIF PATCH_GH}

{$IFDEF PATCH_GH}
					ClrZone( ZONE_Menu );
{$ENDIF PATCH_GH}
					DisplayGearInfo( Mek );

					PurchaseGear( U , Mek );

					{ Update the display. }
					UpdateHQDisplay( U );
				end;

				DisposeGear( m1 );
			end else begin
{$IFDEF PATCH_I18N}
				DialogMsg( I18N_MsgString('BuyMechsForUnit','Corrupt File') );
{$ELSE PATCH_I18N}
				DialogMsg( 'ERROR - Corrupt design file.' );
{$ENDIF PATCH_I18N}
			end;
		end;
	until fname = '';

	{ Get rid of dynamic resources. }
	DisposeRPGMenu( MekMenu );
end;

procedure ExamineUnitMecha( U: GearPtr );
	{ Allow the player to browse through the unit's mechas; }
	{ selecting a mecha will bring up its info display and }
	{ a sub-menu allowing the mek to be repaired, sold, or }
	{ assigned to a pilot. }
	Procedure GetPilotForMek( M: GearPtr );
		{ Select a pilot for this mecha, then associate the two. }
	var
		PMenu: RPGMenuPtr;
{$IFDEF PATCH_GH}
		N: LongInt;
{$ELSE PATCH_GH}
		N: Integer;
{$ENDIF PATCH_GH}
	begin
{$IFDEF PATCH_GH}
		if (NIL = M) or (M^.G <= GG_DisposeGear) then Exit;
{$ENDIF PATCH_GH}

{$IFDEF PATCH_I18N}
		CMessage( I18N_MsgString('ExamineUnitMecha','SELECT CHARACTER'), ZONE_Menu1, InfoHilight );
		DialogMSG( ReplaceHash(I18N_MsgString('ExamineUnitMecha','Select a Pilot'),GearName(M)) );
{$ELSE PATCH_I18N}
		CMessage( 'SELECT CHARACTER' , ZONE_Menu1 , InfoHilight );
		DialogMSG( 'Select a pilot for ' + GearName( M ) + '.' );
{$ENDIF PATCH_I18N}
		PMenu := CreateHQPilotMenu( U );
		if PMenu^.NumItem > 0 then begin
{$IFDEF SDLMODE}
  {$IFDEF PATCH_GH}
			if Cheat_DisplayGearInfo then begin
				InfoMekMenu := PMenu;
				InfoGear    := U^.SubCom;
			end;
			N := SelectMenu( PMenu, @FHQRedraw );
			InfoGear    := NIL;
			InfoMekMenu := NIL;
  {$ELSE PATCH_GH}
			N := SelectMenu( PMenu , Nil );
  {$ENDIF PATCH_GH}
{$ELSE}
			N := SelectMenu( PMenu );
{$ENDIF}
			if N <> -1 then begin
				AssociatePilotMek( U^.InvCom , RetrieveGearSib( U^.SubCom , N ) , M );
			end;
		end;
		DisposeRPGMenu( PMenu );

		{ Update the display. }
		UpdateHQDisplay( U );
	end;

{$IFDEF PATCH_CHEAT}
	Procedure CallRealBackpack( U, PC, Mek: GearPtr );
	var
		MList: GearPtr;
	begin
		MList := U^.InvCom;
		LastGear(MList)^.Next := U^.SubCom;
		U^.SubCom := NIL;
		U^.InvCom := NIL;
		RealBackpack( NIL, MList, PC, Mek, False );
		DetachMekChar( U, MList );
	end;

	Procedure CallMechaPartEditor( U, PC, Mek: GearPtr );
	var
		MList: GearPtr;
	begin
		MList := U^.InvCom;
		LastGear(MList)^.Next := U^.SubCom;
		U^.SubCom := NIL;
		U^.InvCom := NIL;
		MechaPartEditor( NIL, MList, PC, Mek );
		DetachMekChar( U, MList );
	end;
{$ENDIF PATCH_CHEAT}

var
	MekMenu,OpMenu: RPGMenuPtr;
	Mek: GearPtr;
{$IFDEF PATCH_GH}
	MN: LongInt;
	N: Integer;
{$ELSE PATCH_GH}
	MN,N: Integer;
{$ENDIF PATCH_GH}
{$IFDEF PATCH_GH}
	PC: GearPtr;
{$ENDIF PATCH_GH}
begin
{$IFDEF PATCH_GH}
	if (NIL = U) or (U^.G <= GG_DisposeGear) then Exit;
{$ENDIF PATCH_GH}

	{ Create the needed menus. }
	MekMenu := CreateHQMechaMenu( U );
	OpMenu := CreateRPGMenu( MenuItem , MenuSelect , ZONE_Menu2 );
{$IFDEF PATCH_CHEAT}
	if Cheat_ArenaMode_FieldHQInHQ then begin
		AddRPGMenuItem( OpMenu, MsgString('FHQ_GoBackpack'), 4 );
		AddRPGMenuItem( OpMenu, MsgString('FHQ_Rename'), 5 );
		AddRPGMenuItem( OpMenu, MsgString('FHQ_PartEditor'), 6 );
  {$IFDEF SDLMODE}
		AddRPGMenuItem( OpMenu, MsgString('FHQ_EditColor'), 7 );
  {$ENDIF SDLMODE}
	end;
{$ENDIF PATCH_CHEAT}
{$IFDEF PATCH_I18N}
	AddRPGMenuItem( OpMenu , I18N_MsgString('ExamineUnitMecha','Assign Pilot') , 1 );
	AddRPGMenuItem( OpMenu , I18N_MsgString('ExamineUnitMecha','Sell') , -2 );
	AddRPGMenuItem( OpMenu , I18N_MsgString('ExamineUnitMecha','Repair') , 3 );	
	AddRPGMenuItem( OpMenu , I18N_MsgString('ExamineUnitMecha','Exit') , -1 );
{$ELSE PATCH_I18N}
	AddRPGMenuItem( OpMenu , 'Assign Pilot' , 1 );
	AddRPGMenuItem( OpMenu , 'Sell this Mecha' , -2 );
	AddRPGMenuItem( OpMenu , 'Repair Mecha' , 3 );	
	AddRPGMenuItem( OpMenu , 'Exit' , -1 );
{$ENDIF PATCH_I18N}
{$IFDEF PATCH_CHEAT}
	if Cheat_ArenaMode_MechaHQ_AddMenuKey then begin
		AlphaKeyMenu( OpMenu );
	end;
{$ENDIF PATCH_CHEAT}

	{ Error check- this unit better have some meks purchased already. }
	if MekMenu^.NumItem > 0 then begin
		MN := 1;
		repeat
{$IFDEF PATCH_GH}
			RedrawHQDisplay( U );
{$ENDIF PATCH_GH}

{$IFDEF PATCH_I18N}
			CMessage( I18N_MsgString('ExamineUnitMecha','SELECT MECHA TO EXAMINE'), ZONE_Menu1, InfoHilight );
{$ELSE PATCH_I18N}
			CMessage( 'SELECT  MECHA  TO  EXAMINE' , ZONE_Menu1 , MenuSelect );
{$ENDIF PATCH_I18N}
{$IFNDEF SDLMODE}
			DrawZoneBorder( ZONE_Menu2 , PlayerBlue );
{$ENDIF}

			{ MN stands for Mek Number. }
			SetItemByValue( MekMenu , MN );
{$IFDEF SDLMODE}
  {$IFDEF PATCH_GH}
			if Cheat_DisplayGearInfo then begin
				InfoMekMenu := MekMenu;
				InfoGear    := U^.InvCom;
			end;
			MN := SelectMenu( MekMenu, @FHQRedraw );
			InfoGear    := NIL;
			InfoMekMenu := NIL;
  {$ELSE PATCH_GH}
			MN := SelectMenu( MekMenu , Nil );
  {$ENDIF PATCH_GH}
{$ELSE}
			MN := SelectMenu( MekMenu );
{$ENDIF}

			{ If a mek was selected, go to the options menu. }
{$IFDEF PATCH_CHEAT}
			if -1 < MN then begin
{$ELSE PATCH_CHEAT}
			if MN <> -1 then begin
{$ENDIF PATCH_CHEAT}
				{ Find out what mek the player selected, }
				{ and display its info. }
				Mek := RetrieveGearSib( U^.InvCom , MN );
{$IFDEF SDLMODE}
  {$IFDEF PATCH_GH}
				InfoGear := Mek;
  {$ENDIF PATCH_GH}
{$ENDIF SDLMODE}
{$IFDEF PATCH_GH}
{$ELSE PATCH_GH}
				DisplayGearInfo( Mek );

				{ Restore the display. }
				UpdateHQDisplay( U );
{$ENDIF PATCH_GH}

				{ Bring up the options menu. }
{$IFDEF PATCH_CHEAT}
				SetItemByValue( OpMenu, 4 );
{$ELSE PATCH_CHEAT}
				SetItemByValue( OpMenu , 1 );
{$ENDIF PATCH_CHEAT}
				repeat
{$IFDEF PATCH_GH}
					PC := FindMechasPilot( U , Mek );
					RedrawHQDisplay( U );
					DisplayGearInfo( Mek );
{$ENDIF PATCH_GH}
					ClrZone( ZONE_Menu1 );
					CMessage( GearName( Mek ) , ZONE_Menu1 , InfoHilight );
{$IFDEF SDLMODE}
					N := SelectMenu( OpMenu , Nil );
{$ELSE}
					N := SelectMenu( OpMenu );
{$ENDIF}
{$IFDEF PATCH_CHEAT}
					Case N of
						1: GetPilotForMek( Mek );
						-2: SellGear( U , Mek );
						3: FixSingleGear( U , Mek );
						4: CallRealBackpack( U, PC, Mek );
						5: Rename_Mecha( NIL, Mek );
						6: CallMechaPartEditor( U, PC, Mek );
  {$IFDEF SDLMODE}
						7: SelectColors( Mek, @FHQRedraw );
  {$ENDIF SDLMODE}
					end;
{$ELSE PATCH_CHEAT}
					if N = 1 then GetPilotForMek( Mek )
					else if N = -2 then SellGear( U , Mek )
					else if N = 3 then FixSingleGear( U , Mek );
{$ENDIF PATCH_CHEAT}
				until N < 0;

				{ Refresh the mecha menu. }
				DisposeRPGMenu( MekMenu );
				MekMenu := CreateHQMechaMenu( U );

{$IFDEF PATCH_CHEAT}
			end else if -128 = MN then begin
				Mek := RetrieveGearSib( U^.InvCom, RPMLocateByPosition( MekMenu, MekMenu^.SelectItem )^.value );
				SwapMenu( ZONE_HQMecha, Mek );
				DisposeRPGMenu( MekMenu );
				MekMenu := CreateHQMechaMenu( U );
{$ENDIF PATCH_CHEAT}
			end;

{$IFDEF SDLMODE}
  {$IFDEF PATCH_GH}
			InfoGear := NIL;
  {$ENDIF PATCH_GH}
{$ENDIF SDLMODE}

		until ( MN = -1 ) or ( MekMenu^.NumItem = 0 );

		{ Restore the display. }
		UpdateHQDisplay( U );
	end else begin
{$IFDEF PATCH_I18N}
		DialogMSG( I18N_MsgString('ExamineUnitMecha','No Meks') );
{$ELSE PATCH_I18N}
		DialogMSG( 'Your unit does not currently have any meks.' );
{$ENDIF PATCH_I18N}
	end;

	{ Free dynamic resources. }
	DisposeRPGMenu( MekMenu );
	DisposeRPGMenu( OpMenu );
end;

procedure ExamineUnitPilots( U: GearPtr );
	{ Allow the player to browse through the unit's characters; }
	{ selecting a char will bring up its info display and a }
	{ sub-menu allowing the pilot to be removed from the unit, }
	{ treated for injuries / status conditions, assigned a mecha }
	{ to use in combat, or trained. }
	Procedure GetMekForPilot( P: GearPtr );
		{ Select a pilot for this mecha, then associate the two. }
	var
		MekMenu: RPGMenuPtr;
{$IFDEF PATCH_GH}
		N: LongInt;
{$ELSE PATCH_GH}
		N: Integer;
{$ENDIF PATCH_GH}
	begin
{$IFDEF PATCH_GH}
		if (NIL = P) or (P^.G <= GG_DisposeGear) then Exit;
{$ENDIF PATCH_GH}
{$IFDEF PATCH_GH}
		RedrawHQDisplay( U );
{$ENDIF PATCH_GH}

{$IFDEF PATCH_I18N}
		CMessage( I18N_MsgString('ExamineUnitPilots','SELECT MECHA'), ZONE_Menu1, InfoHilight );
		DialogMSG( ReplaceHash(I18N_MsgString('ExamineUnitPilots','Select a Mecha'),GearName(P)) );
{$ELSE PATCH_I18N}
		CMessage( 'SELECT MECHA' , ZONE_Menu1 , InfoHilight );
		DialogMSG( 'Select a mecha for ' + GearName( P ) + '.' );
{$ENDIF PATCH_I18N}
		MekMenu := CreateHQMechaMenu( U );
		if MekMenu^.NumItem > 0 then begin
{$IFDEF SDLMODE}
  {$IFDEF PATCH_GH}
			InfoMekMenu := MekMenu;
			InfoGear    := U^.InvCom;
			N := SelectMenu( MekMenu, @FHQRedraw );
			InfoGear    := NIL;
			InfoMekMenu := NIL;
  {$ELSE PATCH_GH}
			N := SelectMenu( MekMenu , Nil );
  {$ENDIF PATCH_GH}
{$ELSE}
			N := SelectMenu( MekMenu );
{$ENDIF}
			if N <> -1 then begin
				AssociatePilotMek( U^.InvCom , P , RetrieveGearSib( U^.InvCom , N ) );
			end;
		end;
		DisposeRPGMenu( MekMenu );

		{ Update the display. }
		UpdateHQDisplay( U );
	end;

	Procedure QuitUnit( PC: GearPtr );
		{ This character wants to quit. Make it so. }
	begin
{$IFDEF PATCH_GH}
		if (NIL = PC) or (PC^.G <= GG_DisposeGear) then Exit;
{$ENDIF PATCH_GH}
		DelinkGear( U^.SubCom , PC );
		SaveChar( PC );
		SaveUnit( U );
		DisposeGear( PC );
	end;

	Procedure ViewBiography( PC: GearPtr );
		{ Display the biography text which was generated for }
		{ this character. }
	var
		msg: String;
	begin
{$IFDEF PATCH_GH}
		if (NIL = PC) or (PC^.G <= GG_DisposeGear) then Exit;
{$ENDIF PATCH_GH}
		msg := SAttValue( PC^.SA , 'Bio1' );
{$IFDEF PATCH_I18N}
		CMessage( I18N_MsgString('ExamineUnitPilots','BIOGRAPHY'), ZONE_Menu1, InfoHilight );
{$ELSE PATCH_I18N}
		CMessage( 'BIOGRAPHY' , ZONE_Menu1 , InfoHilight );
{$ENDIF PATCH_I18N}
		GameMsg( msg , ZONE_Menu2 , InfoGreen );

		{ Wait for a keypress before exiting. }
{$IFDEF PATCH_GH}
		EndOfGameMoreKey;
{$ELSE PATCH_GH}
		RPGKey;
{$ENDIF PATCH_GH}
	end;

{$IFDEF PATCH_CHEAT}
	Procedure CallRealBackpack( U, PC: GearPtr );
	var
		MList: GearPtr;
	begin
		MList := U^.SubCom;
		LastGear(MList)^.Next := U^.InvCom;
		U^.SubCom := NIL;
		U^.InvCom := NIL;
		RealBackpack( NIL, MList, PC, PC, True );
		DetachMekChar( U, MList );
	end;
{$ENDIF PATCH_CHEAT}

var
	PCMenu,OpMenu: RPGMenuPtr;
	PC: GearPtr;
{$IFDEF PATCH_GH}
	PN: LongInt;
	N: Integer;
{$ELSE PATCH_GH}
	PN,N: Integer;
{$ENDIF PATCH_GH}
begin
{$IFDEF PATCH_GH}
	if (NIL = U) or (U^.G <= GG_DisposeGear) then Exit;
{$ENDIF PATCH_GH}

	{ Create the needed menus. }
	PCMenu := CreateHQPilotMenu( U );
	OpMenu := CreateRPGMenu( MenuItem , MenuSelect , ZONE_Menu2 );
{$IFDEF PATCH_I18N}
  {$IFDEF PATCH_CHEAT}
	if Cheat_ArenaMode_InventoryInHQ then begin
		AddRPGMenuItem( OpMenu , I18N_MsgString('GameOptionMenu','Inventory') , 4 );
	end;
  {$ENDIF PATCH_CHEAT}
	AddRPGMenuItem( OpMenu , I18N_MsgString('ExamineUnitPilots','View Biography') , 3 );
	AddRPGMenuItem( OpMenu , I18N_MsgString('ExamineUnitPilots','Assign') , 1 );
	AddRPGMenuItem( OpMenu , I18N_MsgString('ExamineUnitPilots','Training') , 2 );
	AddRPGMenuItem( OpMenu , I18N_MsgString('ExamineUnitPilots','Quit') , -2 );
	AddRPGMenuItem( OpMenu , I18N_MsgString('ExamineUnitPilots','Exit') , -1 );
{$ELSE PATCH_I18N}
	AddRPGMenuItem( OpMenu , 'View Biography' , 3 );
	AddRPGMenuItem( OpMenu , 'Assign Mecha for Pilot' , 1 );
	AddRPGMenuItem( OpMenu , 'Do Training' , 2 );
	AddRPGMenuItem( OpMenu , 'Quit This Team' , -2 );
	AddRPGMenuItem( OpMenu , 'Exit' , -1 );
{$ENDIF PATCH_I18N}
{$IFDEF PATCH_CHEAT}
	if Cheat_ArenaMode_PilotsHQ_AddMenuKey then begin
		AlphaKeyMenu( OpMenu );
	end;
{$ENDIF PATCH_CHEAT}

	{ Error check- this unit better have some chars hired already. }
	if PCMenu^.NumItem > 0 then begin
		PN := 1;
		repeat
{$IFDEF PATCH_GH}
			RedrawHQDisplay( U );
{$ENDIF PATCH_GH}

{$IFDEF PATCH_I18N}
			CMessage( I18N_MsgString('ExamineUnitPilots','SELECT CHARACTER TO EXAMINE'), ZONE_Menu1, InfoHilight );
{$ELSE PATCH_I18N}
			CMessage( 'SELECT  CHARACTER  TO  EXAMINE' , ZONE_Menu1 , MenuSelect );
{$ENDIF PATCH_I18N}
{$IFNDEF SDLMODE}
			DrawZoneBorder( ZONE_Menu2 , PlayerBlue );
{$ENDIF}

			{ PN stands for PC Number. }
			SetItemByValue( PCMenu , PN );
{$IFDEF SDLMODE}
  {$IFDEF PATCH_GH}
			if Cheat_DisplayGearInfo then begin
				InfoMekMenu := PCMenu;
				InfoGear    := U^.SubCom;
			end;
			PN := SelectMenu( PCMenu, @FHQRedraw );
			InfoGear    := NIL;
			InfoMekMenu := NIL;
  {$ELSE PATCH_GH}
			PN := SelectMenu( PCMenu , Nil );
  {$ENDIF PATCH_GH}
{$ELSE}
			PN := SelectMenu( PCMenu );
{$ENDIF}

			{ If a char was selected, go to the options menu. }
{$IFDEF PATCH_CHEAT}
			if -1 < PN then begin
{$ELSE PATCH_CHEAT}
			if PN <> -1 then begin
{$ENDIF PATCH_CHEAT}
				{ Find out what PC the player selected, }
				{ and display its info. }
				PC := RetrieveGearSib( U^.SubCom , PN );
				DisplayGearInfo( PC );

				{ Restore the display. }
				UpdateHQDisplay( U );
				ClrZone( ZONE_Menu1 );

				{ Bring up the options menu. }
{$IFDEF PATCH_CHEAT}
				SetItemByValue( OpMenu , 4 );
{$ELSE PATCH_CHEAT}
				SetItemByValue( OpMenu , 3 );
{$ENDIF PATCH_CHEAT}
				repeat
					CMessage( GearName( PC ) , ZONE_Menu1 , InfoHilight );
{$IFDEF PATCH_GH}
					DisplayGearInfo( PC , NIL );
					CharacterDisplay( PC , NIL );
{$ENDIF PATCH_GH}
{$IFDEF SDLMODE}
					N := SelectMenu( OpMenu , Nil );
{$ELSE}
					N := SelectMenu( OpMenu );
{$ENDIF}
					Case N of
						-2: QuitUnit( PC );
						1: GetMekForPilot( PC );
						2: DoTraining( Nil , PC );
						3: ViewBiography( PC );
{$IFDEF PATCH_CHEAT}
						4: CallRealBackpack( U, PC );
{$ENDIF PATCH_CHEAT}
					end;
				until N < 0;

				{ Refresh the pilots menu. }
				DisposeRPGMenu( PCMenu );
				PCMenu := CreateHQPilotMenu( U );

{$IFDEF PATCH_CHEAT}
			end else if -128 = PN then begin
				PC := RetrieveGearSib( U^.SubCom, RPMLocateByPosition( PCMenu, PCMenu^.SelectItem )^.value );
				SwapMenu( ZONE_HQPilots, PC );
				DisposeRPGMenu( PCMenu );
				PCMenu := CreateHQPilotMenu( U );
{$ENDIF PATCH_CHEAT}
			end;

		until ( PN = -1 ) or ( PCMenu^.NumItem = 0 );

		{ Restore the display. }
		UpdateHQDisplay( U );
	end else begin
{$IFDEF PATCH_I18N}
		DialogMSG( I18N_MsgString('ExamineUnitPilots','No Characters') );
{$ELSE PATCH_I18N}
		DialogMSG( 'Your unit does not currently have any characters.' );
{$ENDIF PATCH_I18N}
	end;

	{ Free dynamic resources. }
	DisposeRPGMenu( PCMenu );
	DisposeRPGMenu( OpMenu );
end;

procedure EnterCombat( HQCamp: CampaignPtr );
	{ This is the HQ combat wrapper. Prompt for mission difficulcy, }
	{ then select the Meks/Pilots who will be doing the mission. }
	{ Extract meks/pilots from the unit. }
	{ Deploy them on the map. }
	{ Select enemy forces based upon difficulcy level selected. }
	{ Call the combat procedure. }
	{ Disassemble the gameboard meks list. }
	{ Strip all location, scenario, weaponinfo NAtts. }
	{ Decide the fate of all characters and mechs; delete dead chars. }
	{ Insert surviving PCs and salvage into the unit. }
	{ Deallocate NPCs and wasted meks. }
	{ Save the game. }
{$IFDEF PATCH_GH}
const
	TPV_MAX = 2147483647;
	TPV_MIN = -2147483648;
{$ENDIF PATCH_GH}
var
	ECM: RPGMenuPtr;	{ Enter Combat Menu }
	Diff: Integer;		{ Difficulcy Level }
	Outcome: Integer;	{ Who won the battle? }
	Mek: GearPtr;		{ Mecha Pointer of Many Uses }
	Pilot: GearPtr;
	MList: GearPtr;		{ The list of meks which will take part }
{$IFDEF PATCH_GH}
	N: LongInt;		{ A menu input code }
{$ELSE PATCH_GH}
	N: Integer;		{ A menu input code }
{$ENDIF PATCH_GH}
	msg: String;
{$IFDEF PATCH_GH}
	TPV: Int64;
{$ELSE PATCH_GH}
	TPV: LongInt;
{$ENDIF PATCH_GH}
	SA: SAttPtr;
	XPV: Integer;
begin
	{ Create the difficulcy selector menu. }
	ECM := CreateRPGMenu( MenuItem , MenuSelect , ZONE_Menu2 );
{$IFDEF PATCH_I18N}
	CMessage( I18N_MsgString('EnterCombat','SELECT DIFFICULCY LEVEL'), ZONE_Menu1, InfoHilight );
	AddRPGMenuItem( ECM , I18N_MsgString('EnterCombat','Easy') , 1 );
	AddRPGMenuItem( ECM , I18N_MsgString('EnterCombat','Regular') , 3 );
	AddRPGMenuItem( ECM , I18N_MsgString('EnterCombat','Hard') , 6 );
	AddRPGMenuItem( ECM , I18N_MsgString('EnterCombat','Suicidal') , 10 );
{$ELSE PATCH_I18N}
	CMessage( 'SELECT DIFFICULCY LEVEL' , ZONE_Menu1 , InfoGreen );
	AddRPGMenuItem( ECM , 'Easy' , 1 );
	AddRPGMenuItem( ECM , 'Regular' , 3 );
	AddRPGMenuItem( ECM , 'Hard' , 6 );
	AddRPGMenuItem( ECM , 'Suicidal' , 10 );
{$ENDIF PATCH_I18N}

	{ Input the difficulcy level, and dispose of the menu right away. }
{$IFDEF SDLMODE}
	Diff := SelectMenu( ECM , Nil );
{$ELSE}
	Diff := SelectMenu( ECM );
{$ENDIF}
	DisposeRPGMenu( ECM );
	ClrZone( ZONE_Menu1 );

	{ If the selection was not cancelled, continue with the procedure. }
	if Diff = -1 then exit;

	{ Select the list of mechas to use on this mission. }
{$IFDEF PATCH_I18N}
	CMessage( I18N_MsgString('EnterCombat','SELECT MECHA'), ZONE_Menu1, InfoHilight );
{$ELSE PATCH_I18N}
	CMessage( 'SELECT MECHA' , ZONE_Menu1 , InfoGreen );
{$ENDIF PATCH_I18N}
	MList := Nil;
	repeat
		{ Create the mecha menu. This has to be re-created with }
		{ each iteration, since there are mecha which will be }
		{ extracted from the primary list. }
		ECM := CreateRPGMenu( MenuItem , MenuSelect , ZONE_Menu2 );
		Mek := HQCamp^.Source^.InvCom;
		N := 1;
		while Mek <> Nil do begin
{$IFDEF PATCH_GH}
			if (GG_DisposeGear < Mek^.G) then begin
				if ( Mek^.G = GG_Mecha ) and ( FindMechasPilot( HQCamp^.Source , Mek ) <> Nil ) then begin
					msg := GearName( Mek ) + ' (' + GearName( FindMechasPilot( HQCamp^.Source , Mek ) ) + ')';
					AddRPGMenuItem( ECM , msg , N );
				end;
				Inc( N );
			end;
			Mek := Mek^.Next;
{$ELSE PATCH_GH}
			if ( Mek^.G = GG_Mecha ) and ( FindMechasPilot( HQCamp^.Source , Mek ) <> Nil ) then begin
				msg := GearName( Mek ) + ' (' + GearName( FindMechasPilot( HQCamp^.Source , Mek ) ) + ')';
				AddRPGMenuItem( ECM , msg , N );
			end;
			Mek := Mek^.Next;
			Inc( N );
{$ENDIF PATCH_GH}
		end;

		{ Get input from the menu, if there are any mechas left. }
		if ECM^.NumItem > 0 then begin
{$IFDEF SDLMODE}
			N := SelectMenu( ECM , Nil );
{$ELSE}
			N := SelectMenu( ECM );
{$ENDIF}
			if N > -1 then begin
				Mek := RetrieveGearSib( HQCamp^.Source^.InvCom , N );
				DelinkGear( HQCamp^.Source^.InvCom , Mek );
				Mek^.Next := MList;
				MList := Mek;
			end;
		end else N := -1;

		DisposeRPGMenu( ECM );
	until N = -1;

	{ If no mechas were selected for the mission, exit. }
	if MList = Nil then exit;

	{ Generate a random scenario. }
	HQCamp^.GB := RandomMap( Nil );

	{ Deploy the chosen mechas, along with their pilots, into the }
	{ scenario. }
	TPV := 0;
	while MList <> Nil do begin
		Mek := MList;
		MList := MList^.Next;
		Mek^.Next := Nil;

		TPV := TPV + GearValue( Mek );
		Pilot := FindMechasPilot( HQCamp^.Source , Mek );
		DelinkGear( HQCamp^.Source^.SubCom , Pilot );
		DeployMek( HQCamp^.GB , Mek , Pilot , NAV_DefPlayerTeam );
	end;
{$IFDEF PATCH_GH}
	if TPV < TPV_MIN then begin
		TPV := TPV_MIN;
	end else if TPV_MAX < TPV then begin
		TPV := TPV_MAX;
	end;
{$ENDIF PATCH_GH}

	{ Add a number of random enemies to the scenario. }
	{ Generate a shopping list of mecha found in the Design/ drawer. }
	{ Meks with Point Values larger than the value provided will be }
	{ filtered out. }
	SA := GenerateMechaList( TPV div 2 );

	{ Determine how many points of mecha to buy. This is determined by the }
	{ point value of the player meks (TPV) and the difficulcy level }
	{ selected (Diff). Yes, I'm reassigning TPV to now represent the enemy }
	{ point value... bad programming style. }
	TPV := ( TPV * Diff ) div 2;
{$IFDEF PATCH_GH}
	if TPV < TPV_MIN then begin
		TPV := TPV_MIN;
	end else if TPV_MAX < TPV then begin
		TPV := TPV_MAX;
	end;
{$ENDIF PATCH_GH}

	{ Call the SelectEnemyForces procedure from ArenaPlay. This will }
	{ choose mecha designs from the list generated & give pilots to them. }
	SelectEnemyForces( HQCamp^.GB , SA , TPV );

	{ Get rid of the mecha shopping list, since we don't need it any more. }
	DisposeSAtt( SA );

	{ Call the combat procedure. }
	Outcome := CombatMain( HQCamp );
	rpgkey;

	{ Determine the base number of XPs to give survivors. }
	if Outcome > 0 then XPV := 20 + ( Diff * 5 )
	else if Outcome = 0 then XPV := 0
	else XPV := 7 + ( Diff * 3 );

	{ Disassemble the gameboard's mecha list, sticking all the player }
	{ meks and characters back into their proper slots. }
	MList := HQCamp^.GB^.Meks;
	HQCamp^.GB^.Meks := Nil;

	{ Process each mek in turn. }
	{ While sorting through all the meks and pilots that took part }
	{ in this battle, also give out experience to the player's characters. }
	while MList <> Nil do begin
		Mek := MList;
		DelinkGear( MList , Mek );

		if Mek^.G = GG_Mecha then begin
			if NAttValue( Mek^.NA , NAG_Location , NAS_Team ) = NAV_DefPlayerTeam then begin
				repeat
					Pilot := ExtractPilot( Mek );
					if Pilot <> Nil then begin

						if NotDestroyed( Pilot ) then begin
							StripNAtt( Pilot , -1 );
							StripNAtt( Pilot , -2 );
							StripNAtt( Pilot , -3 );
							StripNAtt( Pilot , -5 );
							StripNAtt( Pilot , NAG_EpisodeData );
{$IFDEF PATCH_CHEAT}
							if Cheat_ArenaMode_AllRecoveryInHQ then begin
								StripNAtt( Pilot, NAG_StatusEffect );
								StripNAtt( Pilot, NAG_Condition );
							end;
{$ENDIF PATCH_CHEAT}
							InsertSubCom( HQCamp^.Source , Pilot );

							{ Give XP for successful mission. }
							if NotDestroyed( Mek ) then begin
								DoleExperience( Pilot , XPV );
							end else begin
								DoleExperience( Pilot , XPV div 2 );
							end;
						end else begin
							{ The pilot died. Perform a decent burial/deallocation. }
							DisposeGear( Pilot );

							{ Set PILOT to be equal to MEK, since we don't want the loop to exit right now. }
							Pilot := Mek;
						end;
					end;
				until Pilot = Nil;

				if Destroyed( Mek ) and ( Outcome < 1 ) then begin
					{ If the mek was destroyed, and the player didn't win the game, }
					{ this mek is captured and lost. }
					DisposeGear( Mek );
				end else if NotDestroyed( Mek ) or ( PercentDamaged( Mek ) > 50 ) then begin
					StripNAtt( Mek , -1 );
					StripNAtt( Mek , -2 );
					StripNAtt( Mek , -3 );
					StripNAtt( Mek , -5 );
					StripNAtt( Mek , NAG_EpisodeData );
{$IFDEF PATCH_CHEAT}
					if Cheat_ArenaMode_AllRecoveryInHQ then begin
						StripNAtt( Mek, NAG_StatusEffect );
						StripNAtt( Mek, NAG_Condition );
					end;
{$ENDIF PATCH_CHEAT}

					InsertInvCom( HQCamp^.Source , Mek );
				end else begin
					DisposeGear( Mek );
				end;
			end else if Outcome = 1 then begin
				{ The player won the game, so he may take }
				{ this mecha as salvage. }
				if OnTheMap( Mek ) and (( PercentDamaged( Mek ) > 75 ) or NotDestroyed( Mek ) ) then begin
					{ Remove the enemy pilot, of course. }
					repeat
						Pilot := ExtractPilot( Mek );
						if Pilot <> Nil then begin
							DisposeGear( Pilot );
							{ Set PILOT to be equal to MEK, since we don't want the loop to exit right now. }
							Pilot := Mek;
						end;
					until Pilot = Nil;

					StripNAtt( Mek , -1 );
					StripNAtt( Mek , -2 );
					StripNAtt( Mek , -3 );
					StripNAtt( Mek , -5 );
					StripNAtt( Mek , NAG_EpisodeData );
{$IFDEF PATCH_CHEAT}
					if Cheat_ArenaMode_AllRecoveryInHQ then begin
						StripNAtt( Mek, NAG_StatusEffect );
						StripNAtt( Mek, NAG_Condition );
					end;
{$ENDIF PATCH_CHEAT}

					InsertInvCom( HQCamp^.Source , Mek );
				end else DisposeGear( Mek );
			end else DisposeGear( Mek );

		end else if Mek^.G = GG_Character then begin
			if NAttValue( Mek^.NA , NAG_Location , NAS_Team ) = NAV_DefPlayerTeam then begin
				if NotDestroyed( Mek ) then begin
					StripNAtt( Mek , -1 );
					StripNAtt( Mek , -2 );
					StripNAtt( Mek , -3 );
					StripNAtt( Mek , -5 );
					StripNAtt( Mek , NAG_EpisodeData );
{$IFDEF PATCH_CHEAT}
					if Cheat_ArenaMode_AllRecoveryInHQ then begin
						StripNAtt( Mek, NAG_StatusEffect );
						StripNAtt( Mek, NAG_Condition );
					end;
{$ENDIF PATCH_CHEAT}
					InsertSubCom( HQCamp^.Source , Mek );

					{ Give experience, which is reduced if the pilot had to eject. }
					DoleExperience( Mek , XPV div 2 );
				end else DisposeGear( Mek );

			end else DisposeGear( Mek );
		end else begin
			DisposeGear( Mek );
		end;
	end;

	{ Now that the meks are out, dispose of the scenario itself. }
	DisposeMap( HQCamp^.GB );

	{ Pay the unit for their actions. }
	if Outcome > 0 then TPV := TPV div 50
	else if Outcome = 0 then TPV := 0
	else TPV := TPV div 150;
	AddNAtt( HQCamp^.Source^.NA , NAG_Experience , NAS_Credits , TPV );

	{ Save the game, and update the display. }
	SaveUnit( HQCamp^.Source );

	{ Repair all meks and treat all wounded pilots. }
	SetupHQDisplay;
{$IFDEF PATCH_I18N}
	DialogMSG( ReplaceHash(I18N_MsgString('ExamineUnitPilots','Earned'),BStr(TPV)) );
{$ELSE PATCH_I18N}
	DialogMSG( 'You earned $' + BStr(TPV) + ' for this mission.' );
{$ENDIF PATCH_I18N}
	FixEntireUnit( HQCamp^.Source );
end;

procedure HQMain( HQCamp: CampaignPtr );
	{ This is the central headquarters procedure. From here }
	{ everything else can be branched to. }
var
	RPM: RPGMenuPtr;
	n: Integer;
begin
	{ Create the HQ Menu }
	RPM := CreateRPGMenu( MenuItem , MenuSelect , ZONE_Menu );
{$IFDEF PATCH_I18N}
	AddRPGMenuItem( RPM , I18N_MsgString('HQMain','Examine Characters') , 5 );
	AddRPGMenuItem( RPM , I18N_MsgString('HQMain','Examine Mecha') , 1 );
	AddRPGMenuItem( RPM , I18N_MsgString('HQMain','Purchase Hardware') , 2 );
	AddRPGMenuItem( RPM , I18N_MsgString('HQMain','Hire Character') , 3 );
	AddRPGMenuItem( RPM , I18N_MsgString('HQMain','Create New Character') , 4 );
	AddRPGMenuItem( RPM , I18N_MsgString('HQMain','Enter Combat') , 6 );
  {$IFDEF PATCH_GH}
	AddRPGMenuItem( RPM , I18N_MsgString('HQMain','Display Log') , 7 );
  {$ENDIF PATCH_GH}
	AddRPGMenuItem( RPM , I18N_MsgString('HQMain','Exit') , 0 );
{$ELSE PATCH_I18N}
	AddRPGMenuItem( RPM , 'Examine Characters' , 5 );
	AddRPGMenuItem( RPM , 'Examine Mecha' , 1 );
	AddRPGMenuItem( RPM , 'Purchase Hardware' , 2 );
	AddRPGMenuItem( RPM , 'Hire Character' , 3 );
	AddRPGMenuItem( RPM , 'Create New Character' , 4 );
	AddRPGMenuItem( RPM , 'Enter Combat' , 6 );
  {$IFDEF PATCH_GH}
	AddRPGMenuItem( RPM , 'Display Log' , 7 );
  {$ENDIF PATCH_GH}
	AddRPGMenuItem( RPM , 'Exit to Main' , 0 );
{$ENDIF PATCH_I18N}
{$IFDEF PATCH_GH}
	AddRPGMenuKey( RPM, KeyMap[ KMC_History ].KCode, 7 );
	AddRPGMenuKey( RPM, KeyMap[ KMC_QuitGame ].KCode, 0 );
{$ENDIF PATCH_GH}
{$IFDEF PATCH_CHEAT}
	if Cheat_ArenaMode_MainMenu_AddMenuKey then begin
		AlphaKeyMenu( RPM );
	end;
{$ENDIF PATCH_CHEAT}
	RPM^.mode := RPMNoCancel;

	{ Set up the display. }
	SetupHQDisplay;

	{ Keep processing until an EXIT is encountered. }
	repeat
		UpdateHQDisplay( HQCamp^.Source );
{$IFDEF SDLMODE}
		N := SelectMenu( RPM , Nil );
{$ELSE}
		N := SelectMenu( RPM );
{$ENDIF}
{$IFDEF PATCH_GH}
		UpdateHQDisplay( HQCamp^.Source );
{$ENDIF PATCH_GH}

		case N of
			5: ExamineUnitPilots( HQCamp^.Source );
			1: ExamineUnitMecha( HQCamp^.Source );
			2: BuyMechsForUnit( HQCamp^.Source );
			3: AddPilotToUnit( HQCamp^.Source );
			4: GenerateNewPC;
			6: EnterCombat( HQCamp );
{$IFDEF PATCH_GH}
			7: MoreText( Console_History , MoreHighFirstLine( Console_History ) );
{$ENDIF PATCH_GH}
			0: SaveUnit( HQCamp^.Source );
		end;
{$IFDEF PATCH_GH}
		RedrawHQDisplay( HQCamp^.Source );
{$ENDIF PATCH_GH}
	until N <= 0;

	{ Free all dynamic resources. }
	DisposeRPGMenu( RPM );
	DisposeCampaign( HQCamp );
end;

Procedure CreateNewUnit;
	{ Start a new unit from scratch. Give it however much starting }
	{ cash and head on up to the HQMain procedure. }
var
	HQCamp: CampaignPtr;
	Name: String;
begin
	HQCamp := NewCampaign;
	HQCamp^.Source := NewGear( Nil );
	HQCamp^.Source^.G := GG_Unit;
	Name := 'New Unit';
	SetNAtt( HQCamp^.Source^.NA , NAG_Experience , NAS_Credits , NAV_StartingCash );
{$IFDEF PATCH_I18N}
	{ Output DEBUG info. }
	SetSAtt( HQCamp^.Source^.SA , Version_Generate_TAG + ' <' + Version_all + '>' );
{$ENDIF PATCH_I18N}

{$IFDEF SDLMODE}
  {$IFDEF PATCH_I18N}
	Name := GetStringFromUser( I18N_MsgString('CreateNewUnit','Enter a Name') , Nil );
  {$ELSE PATCH_I18N}
	Name := GetStringFromUser( 'enter a name for your new unit' , Nil );
  {$ENDIF PATCH_I18N}
{$ELSE SDLMODE}
  {$IFDEF PATCH_I18N}
	Name := GetStringFromUser( I18N_MsgString('CreateNewUnit','Enter a Name') );
  {$ELSE PATCH_I18N}
	Name := GetStringFromUser( 'enter a name for your new unit' );
  {$ENDIF PATCH_I18N}
{$ENDIF SDLMODE}
	if Name <> '' then begin
{$IFDEF DEBUG}
		ErrorMessage_fork('CreateNewUnit: "' + name + '".' );
{$ENDIF DEBUG}
		SetSAtt( HQCamp^.Source^.SA , 'name <'+name+'>');
		SaveUnit( HQCamp^.Source );
		HQMain( HQCamp );

	end else DisposeCampaign( HQCamp );
end;

Procedure LoadUnit;
	{ Select a previously saved unit from the menu. If no unit is }
	{ found, jump to the CreateNewUnit procedure above. }
var
	RPM: RPGMenuPtr;
	uname: String;		{ Unit Name }
	HQCamp: CampaignPtr;
	F: Text;		{ A File }
begin
	{ Create a menu listing all the units in the SaveGame directory. }
	RPM := CreateRPGMenu( MenuItem , MenuSelect , ZONE_Menu );
	BuildFileMenu( RPM , Save_Unit_Base + Default_Search_Pattern );

	{ If any units are found, allow the player to load one. }
	{ Otherwise, go straight to the NEW UNIT procedure. }
	if RPM^.NumItem > 0 then begin
		RPMSortAlpha( RPM );
{$IFDEF PATCH_I18N}
		DialogMSG( I18N_MsgString('LoadUnit','Select') );
{$ELSE PATCH_I18N}
		DialogMSG('Select unit file to load.');
{$ENDIF PATCH_I18N}
{$IFDEF SDLMODE}
		uname := SelectFile( RPM , Nil );
{$ELSE}
		uname := SelectFile( RPM );
{$ENDIF}
		if uname <> '' then begin
{$IFDEF DEBUG}
			ErrorMessage_fork('LoadUnit: "' + uname + '".' );
{$ENDIF DEBUG}
			HQCamp := NewCampaign;
{$IFDEF PATCH_I18N}
			Assign(F, Save_Game_Directory + TextEncode(uname) );
{$ELSE PATCH_I18N}
			Assign(F, Save_Game_Directory + uname );
{$ENDIF PATCH_I18N}
			reset(F);
			HQCamp^.Source := ReadCGears(F);
			Close(F);
			HQMain( HQCamp );
		end;
	end else CreateNewUnit;

	DisposeRPGMenu( RPM );
end;

Procedure EnterCampaign( PC: GearPtr );
	{ Actually start this character in a campaign. }
var
	RPM: RPGMenuPtr;
	uname: String;
	TCamp: CampaignPtr;
	Part: GearPtr;
	F: Text;
begin
	{ Allocate the campaign structure, and load the adventure }
	{ from disk. }
	TCamp := NewCampaign;
	RPM := CreateRPGMenu( MenuItem , MenuSelect , ZONE_Menu );
	BuildFileMenu( RPM , Adventure_File_Base + Default_Search_Pattern );

	if RPM^.NumItem > 1 then begin
		RPMSortAlpha( RPM );
		DialogMsg( MsgString( 'SelectCampaignFile' ) );

{$IFDEF SDLMODE}
		uname := SelectFile( RPM , Nil );
{$ELSE}
		uname := SelectFile( RPM );
{$ENDIF}
{$IFDEF PATCH_GH}
{$ELSE PATCH_GH}
		DisposeRPGMenu( RPM );
{$ENDIF PATCH_GH}
	end else if RPM^.NumItem = 1 then begin
		uname := RPM^.FirstItem^.msg;
	end else begin
		uname := '';
	end;
{$IFDEF PATCH_GH}
	DisposeRPGMenu( RPM );
{$ELSE PATCH_GH}
{$ENDIF PATCH_GH}

	if uname <> '' then begin
		Assign( F , Series_Directory + uname );
		Reset( F );
{$IFDEF PATCH_GH}
		TCamp^.Source := ReadGear( F, Series_Directory + uname );
{$ELSE PATCH_GH}
		TCamp^.Source := ReadGear( F );
{$ENDIF PATCH_GH}
		Close( F );
	end;

{$IFDEF PATCH_GH}
	if (NIL <> PC)
	and (NIL <> TCamp^.Source) and (GG_DisposeGear < TCamp^.Source^.G) then begin
{$ELSE PATCH_GH}
	if ( PC <> Nil ) and ( TCamp^.Source <> Nil ) then begin
{$ENDIF PATCH_GH}
		Part := PC;
		while Part <> Nil do begin
			if ( Part^.G = GG_Character ) and ( Part^.SubCom = Nil ) then begin
				ExpandCharacter( Part );
			end;
			Part := Part^.Next;
		end;

		Navigator( TCamp , TCamp^.Source^.SubCom , PC );
	end;

	DisposeCampaign( TCamp );
	DisposeGear( PC );
end;

Procedure StartRPGCampaign;
	{ Load & run the teaser adventure. }
var
	RPM: RPGMenuPtr;
	uname: String;
	PC: GearPtr;
	F: Text;
begin
	PC := Nil;

	{ Create a menu listing all the units in the SaveGame directory. }
	RPM := CreateRPGMenu( MenuItem , MenuSelect , ZONE_Menu );
	BuildFileMenu( RPM , Save_Character_Base + Default_Search_Pattern );

	if RPM^.NumItem > 0 then begin
		RPMSortAlpha( RPM );
		AddRPGMenuItem( RPM , MsgString( 'STARTRPG_NewChar' ) , -2 );
{$IFDEF PATCH_I18N}
		DialogMSG( I18N_MsgString('StartRPGCampaign','Select') );
{$ELSE PATCH_I18N}
		DialogMSG('Select character file.');
{$ENDIF PATCH_I18N}
{$IFDEF SDLMODE}
		uname := SelectFile( RPM , Nil );
{$ELSE}
		uname := SelectFile( RPM );
{$ENDIF}
{$IFDEF DEBUG}
		ErrorMessage_fork('StartRPGCampaign: "' + uname + '".' );
{$ENDIF DEBUG}
		if uname = MsgString( 'STARTRPG_NewChar' ) then begin
			EnterCampaign( CharacterCreator );
		end else if uname <> '' then begin
{$IFDEF PATCH_I18N}
			Assign(F, Save_Game_Directory + TextEncode(uname) );
{$ELSE PATCH_I18N}
			Assign(F, Save_Game_Directory + uname );
{$ENDIF PATCH_I18N}
			reset(F);
			PC := ReadCGears(F);
			Close(F);

{$IFDEF PATCH_I18N}
			{ Output DEBUG info. }
			SetSAtt( PC^.SA , Version_Start_TAG + ' <' + Version_all + '>' );
{$ENDIF PATCH_I18N}

			{ Erase character upon entry. }
{$IFDEF PATCH_I18N}
			Assign( F , Save_Game_Directory + TextEncode(uName) );
{$ELSE PATCH_I18N}
			Assign( F , Save_Game_Directory + uName );
{$ENDIF PATCH_I18N}
			Erase(F);

			EnterCampaign( PC );
		end;

	end else begin
		{ The menu was empty... make a new PC! }
		EnterCampaign( CharacterCreator );

	end;

	DisposeRPGMenu( RPM );
end;

Procedure ViewMechaDesign( Part: GearPtr );
	{ Take a look at an individual mecha. }
var
	A: Char;
	msg: String;
begin
{$IFDEF PATCH_GH}
	if (NIL = Part) or (Part^.G <= GG_DisposeGear) then Exit;
{$ENDIF PATCH_GH}

{$IFDEF SDLMODE}
  {$IFDEF PATCH_I18N}
	msg := FormatDescString( Part );
  {$ELSE PATCH_I18N}
	msg := SAttValue( Part^.SA , 'DESC' );
  {$ENDIF PATCH_I18N}
	if ( msg <> '' ) or ( Part^.G <> GG_Mecha ) then begin
		repeat
			RedrawOpening;
			DisplayGearInfo( Part );
  {$IFDEF PATCH_I18N}
			NFVCMessage( msg , ZONE_Menu , InfoGreen );
  {$ELSE PATCH_I18N}
			NFCMessage( msg , ZONE_Menu , InfoGreen );
  {$ENDIF PATCH_I18N}
			GHFlip;
			A := RPGKey;
		until ( A = ' ' ) or ( A = #27 ) or ( A = RPK_MouseButton );
	end;
  {$IFDEF PATCH_GH}
  {$ELSE PATCH_GH}
	msg := MechaDescription( Part );
  {$ENDIF PATCH_GH}
	if Part^.G = GG_Mecha then begin
  {$IFDEF PATCH_GH}
		msg := MechaDescription( Part );
  {$ELSE PATCH_GH}
  {$ENDIF PATCH_GH}
		repeat
			RedrawOpening;
			DisplayGearInfo( Part );
  {$IFDEF PATCH_I18N}
			NFVCMessage( msg , ZONE_Menu , InfoGreen );
  {$ELSE PATCH_I18N}
			NFCMessage( msg , ZONE_Menu , InfoGreen );
  {$ENDIF PATCH_I18N}
			GHFlip;
			A := RPGKey;
		until ( A = ' ' ) or ( A = #27 ) or ( A = RPK_MouseButton );
	end;
{$ELSE SDLMODE}
	DisplayGearInfo( Part );
  {$IFDEF PATCH_I18N}
	msg := FormatDescString( Part );
  {$ELSE PATCH_I18N}
	msg := SAttValue( Part^.SA , 'DESC' );
  {$ENDIF PATCH_I18N}
	if ( msg <> '' ) or ( Part^.G <> GG_Mecha ) then begin
		GameMsg( msg , ZONE_Menu , InfoGreen );
		EndOfGameMoreKey;
	end;
	if Part^.G = GG_Mecha then begin
		GameMsg( MechaDescription( Part ) , ZONE_Menu , InfoGreen );
		EndOfGameMoreKey;
	end;
	ClrZone( ZONE_Menu );
	ClrZone( ZONE_Info );
{$ENDIF SDLMODE}
end;

Procedure BrowseDesignFile( List: GearPtr );
	{ Choose one of the sibling gears from LIST and display its properties. }
	{ NOTE: This procedure must be called from the DesignDirBrowser, which must }
	{ be called directly from the arena opening menu, so that the OpeningDisplay }
	{ procedure is properly initialized. }
var
	BrowseMenu: RPGMenuPtr;
	Part: GearPtr;
	N: Integer;
begin
	{ Create the menu. }
	BrowseMenu := CreateRPGMenu( MenuItem , MenuSelect , ZONE_Menu );

	{ Add each of the gears to the menu. }
	Part := List;
	N := 1;
	while Part <> Nil do begin
{$IFDEF PATCH_GH}
		if (GG_DisposeGear < Part^.G) then begin
{$ENDIF PATCH_GH}
		AddRPGMenuItem( BrowseMenu , FullGearName( Part ) , N );
		Inc( N );
{$IFDEF PATCH_GH}
		end;
{$ENDIF PATCH_GH}
		Part := Part^.Next;
	end;
	RPMSortAlpha( BrowseMenu );
	AddRPGMenuItem( BrowseMenu , '  Cancel' , -1 );

	repeat
		{ Select a gear. }
{$IFDEF SDLMODE}
		N := SelectMenu( BrowseMenu, @RedrawOpening );
{$ELSE}
		N := SelectMenu( BrowseMenu );
{$ENDIF}
		if N > -1 then begin
			Part := RetrieveGearSib( List , N );
			ViewMechaDesign( Part );
		end;
	until N = -1;

	DisposeRPGMenu( BrowseMenu );
end;


Procedure DesignDirBrowser;
	{ Browse the mecha files on disk. }
	{ NOTE: This procedure must be called from the Arena opening menu, so that }
	{ the RedrawOpening procedure is properly initialized. }
var
	MekMenu: RPGMenuPtr;
	fname: String;
	part: GearPtr;
begin
	MekMenu := CreateRPGMenu( MenuItem , MenuSelect , ZONE_Menu );
	BuildFileMenu( MekMenu , Design_Directory + Default_Search_Pattern );
	RPMSortAlpha( MekMenu );
	AddRPGMenuItem( MekMenu , '  Exit' , -1 );

	repeat
{$IFDEF SDLMODE}
		fname := SelectFile( MekMenu , @RedrawOpening );
{$ELSE}
		fname := SelectFile( MekMenu );
{$ENDIF}

		if fname <> '' then begin
			part := LoadFile( fname , Design_Directory );
			if Part <> Nil then begin
				if Part^.Next = Nil then begin
					{ Only one mecha in this file. Just view it. }
					ViewMechaDesign( Part );
				end else begin
					{ Multiple mecha in this file. Better write another }
					{ procedure... }
					BrowseDesignFile( Part );
				end;
				DisposeGear( Part );
			end;
		end;
	until fname = '';
	DisposeRPGMenu( MekMenu );
end;



initialization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: arenahq.pp');
{$ENDIF DEBUG}
{$IFDEF SDLMODE}
  {$IFDEF PATCH_GH}
	InfoGear := NIL;
	InfoMekMenu := NIL;
  {$ENDIF PATCH_GH}
{$ENDIF SDLMODE}
end;

finalization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: arenahq.pp(finalization)');
{$ENDIF DEBUG}
end;

end.
